// NetBIOS-Demo / Thomas Hornschuh / c't 4/95 / Borland C++
#include <windows.h>

#define INCL_NETBIOS

extern "C" {
#include <lan.h>
}

#include <mem.h>
#include <string.h>

struct DemoMessage {
  DWORD dwTime;
  long nCounter;
  int x, y;
};


NCB ncbSend;
NCB ncbRecv;
BOOL fSendIsPending=FALSE;
int TheNumber;

DemoMessage RecvMessage;
HWND hWnd;                 // Fensterhandle fr CallBack

char TheName[]="XYZDEMO";  // NetBIOS-Name dieses Programms

long nCounter=0;

// fr andere Compiler ggf. in DEF-Datei eintragen
extern"C" void FAR PASCAL NETBIOSCALL();

void CallNetBios(struct ncb far *pncb) // Kapsel um NETBIOSCALL
{
  asm {
    mov bx, word ptr pncb       // Pointer auf NCB in ES:AX
    mov ax, word ptr pncb+2
    mov es,ax
  }
  NETBIOSCALL();
}

void _interrupt NetBIOSCallBack() 
{
BYTE RetCode;
long pncb;
  asm {
    mov RetCode,al
    mov ax,bx
    mov word ptr pncb,ax
    mov ax,es
    mov word ptr pncb+2,ax
    }
  PostMessage(hWnd,WM_USER,WPARAM(RetCode),LPARAM(pncb));
}

BOOL AddNetBIOSName(LPCSTR pName,BOOL fGroupName,int &nNum)
{
NCB ncb;
    memset(&ncb,0,sizeof(NCB));
    ncb.ncb_command=fGroupName?NCBADDGRNAME:NCBADDNAME;
    memset(&ncb.ncb_name,' ',NCBNAMSZ); // Mit Blanks fuellen
    // Nur Namen ohne Nullbyte kopieren
    strncpy(ncb.ncb_name,pName,lstrlen(pName)); 
    CallNetBios(&ncb);
    nNum=ncb.ncb_num;
    return ncb.ncb_retcode==NRC_GOODRET;
}

BOOL DeleteNetBIOSName(LPCSTR pName,int nNum)
{
NCB ncb;
    memset(&ncb,0,sizeof(NCB));
    ncb.ncb_command=NCBDELNAME;
    memset(&ncb.ncb_name,' ',NCBNAMSZ); // Mit Blanks fuellen
    // Nur Namen ohne Nullbyte kopieren
    strncpy(ncb.ncb_name,pName,lstrlen(pName)); 
    ncb.ncb_num=nNum;
    CallNetBios(&ncb);
    nNum=ncb.ncb_num;
    return ncb.ncb_retcode==NRC_GOODRET;
}
  
BOOL SendDatagramm( NCB &ncb,int nNum,void FAR *pData,int szData,
                    LPCSTR pName)
{
    memset(&ncb,0,sizeof(NCB));
    ncb.ncb_command=ASYNCH|NCBDGSEND;
    ncb.ncb_num=nNum;
    ncb.ncb_buffer=(char FAR*)pData;
    ncb.ncb_length=szData;
    memset(&ncb.ncb_callname,' ',NCBNAMSZ); // Mit Blanks fuellen
    // Nur Namen ohne Nullbyte kopieren
    strncpy(ncb.ncb_callname,pName,lstrlen(pName)); 
    ncb.ncb_post=long(NetBIOSCallBack);

    CallNetBios(&ncb);
    return ncb.ncb_retcode==NRC_GOODRET;
}
  
BOOL RecvDatagramm(NCB &ncb,int nNum,void FAR *pData,int szData)
{
    memset(&ncb,0,sizeof(NCB));
    ncb.ncb_command=ASYNCH|NCBDGRECV;
    ncb.ncb_num=nNum;
    ncb.ncb_buffer=(char FAR*)pData;
    ncb.ncb_length=szData; 
    memset(&ncb.ncb_callname,' ',NCBNAMSZ); // Mit Blanks fuellen
    ncb.ncb_post=long(NetBIOSCallBack);

    CallNetBios(&ncb);
    return ncb.ncb_retcode==NRC_GOODRET;
}

void CancelNCB(NCB &ncbCancel)
{
  NCB ncb;
  memset(&ncb,0,sizeof(NCB));
  ncb.ncb_command=NCBCANCEL;
  ncb.ncb_buffer=(char FAR *)&ncbCancel;
  CallNetBios(&ncb);
}

LRESULT FAR PASCAL _export WinProc( HWND hWnd, UINT msg,
                                    WPARAM wParam,LPARAM lParam)
{
   switch (msg) {
     case WM_CREATE:
       if (AddNetBIOSName(TheName,TRUE,TheNumber))
         RecvDatagramm( ncbRecv,TheNumber,&RecvMessage,
                        sizeof(RecvMessage)); // Start Receive
       return 0;
     case WM_USER:
       if (lParam==long(&ncbSend))
            fSendIsPending=FALSE; // Semaphore zuruecksetzen
       else { // Nachricht war fuer Empfangs-NCB
         if (wParam==NRC_GOODRET)
         {
	   HDC hDC;
	   char Buffer[64];
	   wsprintf( Buffer,"Message id: %ld, Time: %ld",
                     RecvMessage.nCounter,RecvMessage.dwTime);
	   hDC=GetDC(hWnd);
	   TextOut( hDC,RecvMessage.x,RecvMessage.y,Buffer,
                    lstrlen(Buffer));
	   ReleaseDC(hWnd,hDC);
         }
         // Starte neues Receive
         RecvDatagramm( ncbRecv,TheNumber,&RecvMessage,
                        sizeof(RecvMessage)); // Start Receive
       }
       break;
     case WM_LBUTTONDOWN:
       if (!fSendIsPending) {
         DemoMessage Msg;

         fSendIsPending=TRUE;
         Msg.nCounter=nCounter++;
         Msg.dwTime=GetTickCount();
         Msg.x=LOWORD(lParam);
         Msg.y=HIWORD(lParam);
         SendDatagramm(ncbSend,TheNumber,&Msg,sizeof(Msg),TheName);
       }
       break;
     case WM_CLOSE:
       CancelNCB(ncbSend); // sehr wichtig
       CancelNCB(ncbRecv);
       DeleteNetBIOSName(TheName,TheNumber);
       PostQuitMessage(0);
       break;
   }
   return DefWindowProc(hWnd,msg,wParam,lParam);
}

void DoRegister(HINSTANCE hInst)
{
WNDCLASS c;
  c.style=NULL;         c.lpfnWndProc=WinProc;
  c.cbClsExtra=0;       c.cbWndExtra=0;
  c.hInstance=hInst;
  c.hIcon=LoadIcon(hInst,IDI_APPLICATION);
  c.hCursor=LoadCursor(NULL,IDC_ARROW);
  c.hbrBackground=(HBRUSH)COLOR_WINDOW+1;
  c.lpszMenuName=NULL;
  c.lpszClassName="IPCDemoWndClass";
  RegisterClass(&c);
};

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
		   LPSTR lpCmdLine, int nCmdShow)
{
MSG msg;
   if (!hPrevInstance) DoRegister(hInstance);
   hWnd=CreateWindow("IPCDemoWndClass","NETBIOS Demo",
		WS_OVERLAPPEDWINDOW,CW_USEDEFAULT,
		CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
		NULL,NULL,hInstance,NULL);

   ShowWindow(hWnd,nCmdShow);
   while (GetMessage(&msg,0,0,0)) {
     TranslateMessage(&msg);
     DispatchMessage(&msg);
   }
   return msg.wParam;
}
