Program Drehung3D;
{==========================================================}
{ Programm zur Demonstration von 3-dimensionalen Drehungen }
{----------------------------------------------------------}
{ Ein Dodekaeder wird in Schritten von 1 gedreht.         }
{ Es werden die zwei Bildschirmseiten der VGA ausgenutzt,  }
{ um eine kontinuirliche Drehung erscheinen zu lassen.     }
{ Mit den Cursortaten kann die Drehachse selbst um die     }
{ Bildschirmvertikale bzw. Horizontale gedreht werden      }
{ Sprache: Turbo-Pascal                                    }
{ U. Sternberg und P. Losso                                }
{==========================================================}
uses Graph,Crt;
type Matrix=array[1..3,1..3] of real;
     Vektor=array[1..3] of real;
const Grad=Pi/360; { zur Umrechnung von Winkeln in Grad in das Bogenma }
{ Definition der Eckpunkte des Dodekaeders }
const Dodekaeder:array[1..20,1..3] of real=
  ((0.52573,0.38197,0.85065),(-0.20081,0.61803,0.85065),
   (-0.64984, 0., 0.85065),(-0.20081,-0.618034,0.85065),
   (0.52573,-0.38197,0.85065),(0.85065,0.618034,0.20081),
   (-0.32492, 1., 0.20081),(-1.05146, 0., 0.20081),
   (-0.32492, -1., 0.20081),(0.85065,-0.61803,0.20081),
   (0.32492, 1., -0.20081),(-0.85065, 0.61803, -0.20081),
   (-0.85065, -0.61803, -0.20081),(0.32492, -1., -0.20081),
   (1.05146, 0., -0.20081),(0.20081, 0.61803, -0.85065),
   (-0.52573, 0.38197, -0.85065),(-0.52573, -0.38197, -0.85065),
   (0.20081, -0.61803, -0.85065),(0.64984, 0., -0.85065));
{ Definition der Kanten des Dodekaeders als Indizes der verbundenen Ecken }
const VonBis: array[1..30,1..2] of integer=
  ((1,2),(2,3),(3,4),(4,5),(5,1),(5,10),(10,15),(15,6),(1,6),(6,11),(11,7),
   (7,2),(7,12),(12,8),(8,3),(8,13),(13,9),(9,4),(10,14),(14,9),(15,20),
   (20,16),(16,11),(16,17),(17,12),(17,18),(18,13),(18,19),(19,14),(19,20));
{ zwei orthogonale Drehachsen zur Drehung mit den Cursortasten }
const DrehachseX: Vektor=(1,0,0);  { x-Achse }
const DrehachseY: Vektor=(0,1,0);  { y-Achse }
var DrehachseEVektor:Vektor;       { Einheitsvektor in Richtung der Drehachse }
    DodekaederPunkt:Vektor;        { Vektor zu einer Dodekaederecke }
{ Variablen zur Umrechnung von 3D-Koordinaten in 2D-Pixelkoordinaten }
    PixelUmrechnungX:real;         { Umrechnungsfaktor 3D-Koord. in Pixel X }
    PixelUmrechnungY:real;         { Umrechnungsfaktor 3D-Koord. in Pixel Y }
    BildMitteX:real;
    BildMitteY:real;
    XAspectRatio:word;             { Pixelbreite }
    YAspectRatio:word;             { Pixelhhe }
{-----------DefiniereDrehmatrix------------------------------}
  Procedure DefiniereDrehmatrix3D(Drehachse:Vektor;theta:real;
                                  var Drehmatrix3D:Matrix);
{ Berechnung der 3D-Drehmatrix fr die Drehung um die Drehachse mit dem }
{ Winkel theta (im Bogenma) }
    var alpha,beta:integer;           { Laufindize fr die Komponenten x,y,z }
        SinusTheta,CosinusTheta:real;
        W_Element,V_Element:real;     { Elemente der W- und V-Matrix }
    begin
    CosinusTheta:=Cos(theta);
    SinusTheta:=Sin(theta);
    for alpha:=1 to 3 do { Hauptdiagonalelemente berechnen }
        Drehmatrix3D[alpha,alpha]:=CosinusTheta+
                                   Sqr(Drehachse[alpha])*(1-CosinusTheta);
    { obere rechte Ecke der W-Matrix }
    Drehmatrix3D[1,2]:=Drehachse[3]*SinusTheta;
    Drehmatrix3D[1,3]:=-Drehachse[2]*SinusTheta;
    Drehmatrix3D[2,3]:=Drehachse[1]*SinusTheta;
    for alpha:=1 to 2 do for beta:=alpha+1 to 3 do
      begin
      W_Element:=Drehmatrix3D[alpha,beta];
      V_Element:=Drehachse[alpha]*Drehachse[beta]*(1-CosinusTheta);
      { Nichtdiagonalelemente der obreren rechten Ecke von D }
      Drehmatrix3D[alpha,beta]:=V_Element+W_Element;
      { Nichtdiagonalelemente der linken unteren Ecke von D }
      Drehmatrix3D[beta,alpha]:=V_Element-W_Element;
      end; { for alpha }
   end;    { DefiniereDrehmatrix }
{------------Drehung------------------------------------}
   Procedure Drehung(Drehmatrix:Matrix;var Punkt:Vektor);
   { Transformation eines Punkts im Raum durch eine Drehung }
   var PunktNeu:array[1..3] of real; { Koordinaten nach der Drehung }
       alpha,beta:integer;
       Summe:real;
     begin
     for alpha:=1 to 3 do
       begin
       Summe:=0;
       for beta:=1 to 3 do Summe:=Summe+Drehmatrix[alpha,beta]*Punkt[beta];
       PunktNeu[alpha]:=Summe;
       end; { for alpha }
     for alpha:=1 to 3 do Punkt[alpha]:=PunktNeu[alpha];
     end;   { Drehung }
{------------DodekaederBild---------------------------}
   Procedure DodekaederBild;
     var KantenIndex:integer;
         VonPixelX,VonPixelY:integer;   { 2D-x-Koordinaten in Bildschirm-Pixeln }
         NachPixelX,NachPixelY:integer; { 2D-y-Koordinaten in Bildschirm-Pixeln }
    begin
{ Dodekaeder als Kantennetz zeichnen }
    SetColor(Yellow);   { gelbe Linien }
    for KantenIndex:=1 to 30 do
      begin
      VonPixelX:=Trunc(Dodekaeder[VonBis[KantenIndex,1],1]*PixelUmrechnungX+
                 BildMitteX);
      VonPixelY:=Trunc(Dodekaeder[VonBis[KantenIndex,1],2]*PixelUmrechnungY+
                 BildMitteY);
      NachPixelX:=Trunc(Dodekaeder[VonBis[KantenIndex,2],1]*PixelUmrechnungX+
                  BildMitteX);
      NachPixelY:=Trunc(Dodekaeder[VonBis[KantenIndex,2],2]*PixelUmrechnungY+
                  BildMitteY);
      Line(VonPixelX,VonPixelY,NachPixelX,NachPixelY);
      end; { for Kantenindex:=1 }
{ Drehachse Einzeichnen }
    SetColor(Green);
    VonPixelX:=Trunc(BildMitteX);
    VonPixelY:=Trunc(BildMitteY);
    NachPixelX:=Trunc(DrehachseEVektor[1]*PixelUmrechnungX*0.5+BildMitteX);
    NachPixelY:=Trunc(DrehachseEVektor[2]*PixelUmrechnungY*0.5+BildMitteY);
    Line(VonPixelX,VonPixelY,NachPixelX,NachPixelY);
    end;   { DodekaederBild }
{ Vareiablen zu Drehung3D }
var DrehmatrixE:Matrix;      { Drehmatrix zum Einheitsvektor }
    DrehmatrixX:Matrix;      { Drehmatrix fr x-Achse }
    DrehmatrixY:Matrix;      { Drehmatrix fr y-Achse }
    alpha,beta:integer;      { Laufindizes fr die Komponenten x,y,z }
    EckenIndex:integer;      { Laufindex fr die Ecken des Dodekaeder }
    grDriver:integer;        { Grafiktreiber }
    grMode:integer;          { Grafikmodus }
    ErrCode:integer;         { Fehlercode fr die Grafik }
    DrehWinkel:real;         { Drehwinkel in Grad }
    DrehwinkelXY:real;       { Drehwinkel fr die x-y-Drehung }
    SeitenSchalter:Boolean;  { Umschalter fr die sichtbare Bildschirmseite }
    Taste:char;              { gedrckte Taste }
  begin     { Drehung 3D }
{ Anfangswerte fr die Drehachse }
  for alpha:=1 to 3 do DrehachseEVektor[alpha]:=1/Sqrt(3);
{ Drehmatrizen mit Startwert des Einheitsvektors ausrechnen }
  DrehWinkel:=1*Grad;
  DefiniereDrehmatrix3D(DrehachseEVektor,DrehWinkel,DrehmatrixE);
{ Grafik starten }
  grDriver := Detect;
  InitGraph(grDriver, grMode,'c:\bp\bgi');
{ An Stelle von 'c:\bp\bgi' mu hier eventuell der richtige Pfad zu den
  BGI-Treibern eingetragen werden }
  ErrCode := GraphResult;
  if ErrCode<>grOk then
     begin
     Writeln(' Fehler in der Grafik: ',GraphErrorMsg(ErrCode));
     exit;
     end; { if ErrCode<>grOk }
  if grDriver<>VGA then
     begin
     CloseGraph;
     Writeln(' Das Programm ist nur mit VGA-Grafik lauffhig ');
     exit;
     end; { if grDriver<>VGA }
  SetGraphMode(VGAmed); { VGAmed-Modus einschalten - 2 Bildschirmseiten }
  GetAspectRatio(XAspectRatio,YAspectRatio); { Pixel-Verhltnis ermitteln }
{ Gre des Dodekaeders ist 80% vom Bildschirm }
  PixelUmrechnungX:=0.4*GetMaxX*XAspectRatio/YAspectRatio;
  BildMitteX:=0.5*GetMaxX;
  PixelUmrechnungY:=-0.4*GetMaxY; { Pixel-y-Achse zeigt von oben nach unten }
  BildMitteY:=0.5*GetMaxY;
  SeitenSchalter:=True; { Umschalten der Bildschirmseiten in jedem Zyklus }
  SetBkColor(Blue);     { Hintergrund blau }
  repeat                { Schleife fr kontinuierliche Drehung bis <Esc> }
    SeitenSchalter:=not SeitenSchalter;
    if SeitenSchalter then
      begin
      SetActivePage(0); { auf Seite 0 zeichnen }
      SetVisualPage(1); { Seite 1 sichtbar machen }
      end
      else
      begin
      SetActivePage(1); { auf Seite 1 zeichnen }
      SetVisualPage(0); { Seite 0 sichtbar machen }
      end;
    ClearDevice;        { Bildschirm lschen }
    DodekaederBild;     { Dodekaeder zeichnen }
{ Neue Dodekaederkoordinaten durch Drehung berechnen }
    for Eckenindex:=1 to 20 do
      begin
      for alpha:=1 to 3 do DodekaederPunkt[alpha]:=Dodekaeder[Eckenindex,alpha];
      Drehung(DrehmatrixE,DodekaederPunkt);
      for alpha:=1 to 3 do Dodekaeder[Eckenindex,alpha]:=DodekaederPunkt[alpha];
      end;              { for Eckenindex }
    Taste:=#1;          { beliebiger Anfangswert }
    while (KeyPressed) do Taste:=ReadKey; { Tastaturpuffer leeren }
    if Taste=#0 then Taste:=ReadKey;      { 2xRedKey fr die Pfeiltasten }
    if (Taste=#77) or (Taste=#80)         { Taste 'rechts' oder Taste 'unten' ? }
      then DrehwinkelXY:=-5*DrehWinkel    { Drehrichtung negativ }
      else DrehwinkelXY:=5*DrehWinkel;    { Drehrichtung positiv }
    if (Taste=#72) or (Taste=#80) then    { Drehung um die x-Achse }
      begin
      DefiniereDrehmatrix3D(DrehachseX,DrehwinkelXY,DrehmatrixX);
{ Drehung der Drehachse selbst um die x-Achse }
      Drehung(DrehMatrixX,DrehachseEVektor);
      end;           { if (Taste=#75) }
    if (Taste=#75) or (Taste=#77) then    { Drehung um die y-Achse }
      begin
      DefiniereDrehmatrix3D(DrehachseY,DrehwinkelXY,DrehmatrixY);
{ Drehung der Drehachse selbst um die y-Achse }
      Drehung(DrehMatrixY,DrehachseEVektor);
      end;           { if (Taste=#72) }
{ Neue Drehmatrix aus gedrehtem Einheitsvektor ausrechnen }
    DefiniereDrehmatrix3D(DrehachseEVektor,Drehwinkel,DrehmatrixE);
    until Taste=#27; { ESC-Taste gedrckt }
  CloseGraph;        { Grafik schlieen }
  end.               { Drehung 3D }
