//PPC-Code. Schalter fr PEF: Export all Globals

#include <CodeFragments.h>
#include "globals.h"

#define QUITE_WHITE 65000
#define QUITE_BLACK 500
#define FRAC_ONE 65536L

#pragma options align=mac68k

globals **g;

void trap (short byteCount,Ptr textAddr,long numerPt,long denomPt);
enum
{ trapProcInfo = kPascalStackBased
       | STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(short)))
       | STACK_ROUTINE_PARAMETER(2, SIZE_CODE(sizeof(Ptr)))
       | STACK_ROUTINE_PARAMETER(3, SIZE_CODE(sizeof(long)))
       | STACK_ROUTINE_PARAMETER(4, SIZE_CODE(sizeof(long)))
};
RoutineDescriptor trp=BUILD_ROUTINE_DESCRIPTOR(trapProcInfo,&trap);

void trap (short byteCount,Ptr textAddr,long numerPt,long denomPt)
{
  short size, font, mode;
  Style face;
  Fixed sp, ch, stretch;
  RGBColor myColor;
  int x, y, b, counter;
  short myWidth, myTop, myBottom;
  GWorldPtr oldWorld;
  GDHandle oldGDHandle;
  PixMapHandle myPixMap, oldPixMap;
  unsigned char *bitmapStart, *cellStart;
  unsigned int myRowBytes;
  Point oldPoint;
  FontInfo fInfo, gInfo;
  Rect myRect;  
  PenState oldPenState;
  RGBColor fore, back;

  GetGWorld(&oldWorld,&oldGDHandle);
  oldPixMap = GetGWorldPixMap(oldWorld);
  GetForeColor(&fore);
  GetBackColor(&back);
  HLock((Handle)g);
  if( ((**oldPixMap).cmpSize < 4) // Genug Farben?
      || (fore.red > QUITE_BLACK)
      || (fore.green > QUITE_BLACK)
      || (fore.blue > QUITE_BLACK) //Schwarz?
      || (back.red < QUITE_WHITE)
      || (back.green < QUITE_WHITE)
      || (back.blue < QUITE_WHITE) //Wei?
      || ((oldWorld->txMode!=srcOr) && (oldWorld->txMode!=srcCopy))
      || !RealFont(  (oldWorld->txFont==applFont) ?
             LMGetApFontID() : oldWorld->txFont, 4*oldWorld->txSize)
      )
    CallUniversalProc((**g).oldProcUPP, trapProcInfo, byteCount,
                                        textAddr, numerPt, denomPt);
  else
  {  
    size = oldWorld->txSize;   font = oldWorld->txFont;
    face = oldWorld->txFace;   mode = oldWorld->txMode;
    sp = oldWorld->spExtra;    ch = oldWorld ->chExtra;
    oldPoint = oldWorld->pnLoc;
    myWidth = StdTxMeas(byteCount, textAddr, (Point*)&numerPt,
             (Point*)&denomPt, &fInfo); //In fInfo wird geschrieben!
    if (myWidth > WIDTH)
      myWidth = WIDTH; //stauchen, damit auf Breite
  
    LockPixels((**g).gWorld->portPixMap);
    SetGWorld((**g).gWorld,NIL);
    myRect = (**g).gWorld->portRect;
    GlobalToLocal(&topLeft(myRect));
    GlobalToLocal(&botRight(myRect));
    EraseRect(&myRect);
  
    if (size == 0)
      size = 12;
    size*= 4;       TextSize(size);   TextFont(font);
    TextFace(face); SpaceExtra(4*sp); CharExtra(4*ch);
    if (byteCount > 1)
    {
      stretch = ((4*myWidth - StdTxMeas(byteCount,textAddr,(Point*)
         &numerPt,(Point*)&denomPt,&gInfo))*FRAC_ONE)/(byteCount-1);
      SpaceExtra(stretch);
      CharExtra(stretch);
    }
    
    myBottom = 3*HEIGHT/4+fInfo.descent;
    if (myBottom > HEIGHT)
      myBottom = HEIGHT;
    myTop = 3*HEIGHT/4-fInfo.ascent;
    if (myTop < 0)
      myTop = 0;
    
    MoveTo(0,3*HEIGHT-5); //Platz fr Unterlnge = 1*HEIGHT
    CallUniversalProc((**g).oldProcUPP, trapProcInfo,
                             byteCount, textAddr, numerPt, denomPt);
    
    myPixMap = GetGWorldPixMap((**g).gWorld);
    bitmapStart = (unsigned char*) GetPixBaseAddr(myPixMap);
    if(0 != 3 & (unsigned long) bitmapStart)
      return; //nicht aligned
    myRowBytes = (0x3FFF) & (**myPixMap).rowBytes;
    
    for(x=0;x<myWidth;x++) //myWidth darf nie > WIDTH werden!
    {
      for(y=myTop; y<myBottom; y++)
      {
        counter = 16;
        cellStart = bitmapStart + 4*y*myRowBytes + x/2;
        for(b=0;b<4;b++)
        {
          counter -= (**g).numberOfSetBits[0xF &
              ( ((x&1) == 0) ?
              *(cellStart+b*myRowBytes)>>4:*(cellStart+b*myRowBytes)
              )
              ];
        } //counter = 0: schwarz, counter = 16: wei
        (**g).smoothedBits[x][y] = (**g).gammaCurve[counter];  
      }
    }
    
    SetGWorld(oldWorld,oldGDHandle);
    UnlockPixels((**g).gWorld->portPixMap);
    
    if(mode == srcCopy)
    {
      myRect.bottom = oldPoint.v+fInfo.descent;
      myRect.top = oldPoint.v-fInfo.ascent;
      myRect.left = oldPoint.h;
      myRect.right = oldPoint.h+myWidth;
      EraseRect(&myRect);
    }
    GetPenState(&oldPenState);
    PenNormal();
    PenMode(patCopy);
    for(x=0;x<myWidth;x++)
       for(y=myTop; y<myBottom; y++)
         if((**g).smoothedBits[x][y] != 255)
        {
          myColor.red = myColor.green = myColor.blue =
                     ((unsigned short) (**g).smoothedBits[x][y])<<8;
         SetCPixel(oldPoint.h+x,oldPoint.v+y-3*(HEIGHT/4),&myColor);
        }
    SetPenState(&oldPenState);
    oldWorld->pnLoc.h+=myWidth;
  }
  HUnlock((Handle)g);
}

void invr (Rect *myRect);
enum
{ irProcInfo = kPascalStackBased
       | STACK_ROUTINE_PARAMETER(1, SIZE_CODE(sizeof(Ptr)))
};
RoutineDescriptor ir = BUILD_ROUTINE_DESCRIPTOR(irProcInfo, &invr);

void invr (Rect *myRect)
{
  Point pt;
  RGBColor myColor;
  GrafPtr thePort;
  
  GetPort(&thePort);
  for(pt.h=myRect->left; pt.h<myRect->right; pt.h++)
    for(pt.v=myRect->top; pt.v<myRect->bottom; pt.v++)
      if(PtInRgn(pt,thePort->clipRgn)) //um es abzukrzen
      {
        GetCPixel(pt.h,pt.v,&myColor);
        myColor.red = 0xFFFFU-myColor.red;
        myColor.green = 0xFFFFU-myColor.green;
        myColor.blue = 0xFFFFU-myColor.blue;
        SetCPixel(pt.h,pt.v,&myColor);
      }
}