/* allgemeine Funktionen zur Druckerwahl/-einstellung */
/* Thomas Hornschuh, c't 8/95, VC++ 1.51 */
#include <windows.h>
#include <commdlg.h>
#include <string.h>

/* Oeffnet einen Devicekontext auf den Standardrucker, sofern ein 
   entsprechender Eintrag in der WIN.INI vorhanden ist */
HDC OpenStandardPrinter(void) {
char IniString[128];
char *pszDriver,*pszDevice,*pszPort;

  GetProfileString( "windows","device","",IniString,
                    sizeof(IniString));
  if (IniString[0]!='\0') { // nicht leer, Teile separieren
    pszDevice=strtok(IniString,",");
    pszDriver=strtok(NULL,",");
    pszPort=strtok(NULL,",");
    if (pszDriver && pszDevice && pszPort) // alle gueltig
      return CreateDC(pszDriver,pszDevice,pszPort,NULL);
  }
  return 0;
}

/* Zeigt Druckdialog der CommDlg.dll an, oeffnet zu den Einstellungen
   des Benutzers passenden DC. Der Parameter Flags dient der Feinein-
   stellung des Dialoges. Moeglichen Werte siehe PRINTDLG-Struktur in
   der SDK-Referenz. Hauptsaechlich sind die Flags nuetzlich, um nicht
   benoetigte Elemente der Dialogbox abzuschalten. */
HDC OpenPrinterInteractive(HWND hWndParent,DWORD Flags) {
PRINTDLG pd;
  /* Alle Strukturmember auf 0 setzen*/
  memset(&pd, 0, sizeof(PRINTDLG));
  /* Die wichtigsten initalisieren. */
  pd.lStructSize = sizeof(PRINTDLG);
  pd.hwndOwner = hWndParent;
  pd.Flags = Flags | PD_RETURNDC | PD_NOPAGENUMS | PD_NOSELECTION |
             PD_HIDEPRINTTOFILE;

  if (PrintDlg(&pd)) { // Dialog anzeigen
    /* DevMode und DevNames brauchen wir nicht */
    if (pd.hDevMode != NULL)  GlobalFree(pd.hDevMode);
    if (pd.hDevNames != NULL) GlobalFree(pd.hDevNames);
    return pd.hDC;
  } else 
    return NULL;
} /* OpenPrinterInteractive */

/* Initalisiert zwei globale Speicherobjekte (hDevMode und hDevNames)
   mit Druckereinstellungen. hDevMode ist ein Handle auf eine DEVMODE-
   Struktur, hDevNames ist ein Handle auf eine DEVNAMES-Struktur 
   (beide in der SDK-Referenz beschrieben).
   Ist fShowDialog TRUE, wird der Printer Setup Dialog angezeigt, bei
   FALSE ermittelt die Funktion einfach die Einstellungen des Stan-
   darddruckers.
   hDevMode und hDevNames als Ein- UND Ausgabeparameter verwendet. 
   Sind sie eingangs nicht NULL, werden sie zur Initalisierung des 
   Dialoges verwendet. Bei Aufruf mit fShowDialog=FALSE muessen sie 
   NULL sein.
   Die Funktion gibt bei Erfolg TRUE zurueck, sonst FALSE.
   FALSE wird auch zurueckgegeben, wenn der Benutzer den Abbruch-
   button gedrueckt hat. */
BOOL GetPrinterSettings(HWND hWndParent, BOOL fShowDialog,
            HGLOBAL &hDevMode, HGLOBAL &hDevNames)
{
PRINTDLG pd;
  /* Alle Strukturmember auf 0 setzen*/
  memset(&pd, 0, sizeof(PRINTDLG));
  /* Die wichtigsten initalisieren. */
  pd.lStructSize = sizeof(PRINTDLG);
  pd.hwndOwner = hWndParent;   pd.Flags = PD_PRINTSETUP;
  pd.hDevMode=hDevMode;        pd.hDevNames=hDevNames;

  if (!fShowDialog) pd.Flags|=PD_RETURNDEFAULT; 
  if (PrintDlg(&pd)) {
    hDevMode=pd.hDevMode;      hDevNames=pd.hDevNames;
    return TRUE;
  } else
    return FALSE;
}

/* Zeigt den vollen Druckdialog der CommDlg.dll an, eroeffnet einen zu
   den Einstellungen des Benutzers passenden DC. 
   - In hDevMode und hDevNames koennen Voreinstellungen fuer den 
   Drucker uebergeben werden. Ueblicherweise wurden sie vorher mit 
   GetPrinterSettings ermittelt oder sie sind einfach NULL, dann 
   uebernimmt das System die Einstellungen des Standarddruckers.            
   Rieckgabe wie bei GetPrinterSettings.
   - Flags dient der Feineinstellung des Dialogs. Moegli-
   che Werte siehe PRINTDLG in der SDK-Referenz beschrieben. 
   - nFromPage und nToPage dienen der Initalisierung und der Rueckgabe
   der Seitennummern. nMinPage und nMaxPage spezifzieren zulaessigen 
   Eingabebereich fuer Seitennummern. */
HDC OpenPrinterInteractiveEx(HWND hWndParent, HGLOBAL &hDevMode,
              HGLOBAL &hDevNames,
          int nMinPage,int nMaxPage, int &nFromPage,int &nToPage,
          DWORD &Flags) {
PRINTDLG pd;
  /* Alle Strukturmember auf 0 setzen*/
  memset(&pd, 0, sizeof(PRINTDLG));
  /* Die wichtigsten initalisieren. */
  pd.lStructSize = sizeof(PRINTDLG);
  pd.hwndOwner = hWndParent;
  pd.Flags = Flags|PD_RETURNDC;
  pd.nMinPage=nMinPage;        pd.nMaxPage=nMaxPage;
  pd.nFromPage=nMinPage;       pd.nToPage=nMaxPage;
  pd.hDevMode=hDevMode;        pd.hDevNames=hDevNames;

  if (PrintDlg(&pd)) {
    nFromPage=pd.nFromPage;    nToPage=pd.nToPage;
    Flags=pd.Flags;
    hDevMode=pd.hDevMode;      hDevNames=pd.hDevNames;
    return pd.hDC;
  } else
    return NULL;
}

/* ffnet Drucker mit vorher (GetPrinterSettings oder OpenPrinter-
   InterActive(Ex) bestimmten Einstellungen */
HDC OpenPrinter(HGLOBAL hDevNames,HGLOBAL hDevMode) {
void FAR *pDevMode;
DEVNAMES FAR *pDevNames;
LPSTR pDevStr;
HDC hDC;
  pDevNames=(DEVNAMES FAR*)GlobalLock(hDevNames);
  pDevMode=GlobalLock(hDevMode);
  if (pDevNames) {
    pDevStr=(LPSTR)pDevNames;
    hDC=CreateDC(pDevStr+pDevNames->wDriverOffset,
                 pDevStr+pDevNames->wDeviceOffset,
         pDevStr+pDevNames->wOutputOffset,
         pDevMode);
  } else
    hDC=NULL;
  GlobalUnlock(hDevMode);
  GlobalUnlock(hDevNames);
  return hDC;
}
                             
/* setzt fuer Textdruck recht passenden Mappingmode */
void SetTypoMapping(HDC hDC) {
int LogX,LogY;
 LogX=GetDeviceCaps(hDC,LOGPIXELSX);
 LogY=GetDeviceCaps(hDC,LOGPIXELSY);

 SetMapMode(hDC,MM_ANISOTROPIC);
 SetWindowExt(hDC,720,720); // 720 Einheiten = ein Zoll
 SetWindowOrg(hDC,0,0);
 SetViewportExt(hDC,LogX,LogY); // Anzahl Pixel auf 1 Zoll 
 SetViewportOrg(hDC,0,0);
}
