#define INCL_DOS
#define INCL_WIN
#include <os2.h>                /* System Include File      */
#include <stdio.h>
#include "msg.h"

MRESULT EXPENTRY wndProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
char *querywmessage(unsigned msg);

char  *type="sent   to";        /* sent vs. posted              */

int main()
  {
  HAB   hab;                    /* Handle Anchor Block          */
  QMSG  qmsg;                   /* Message Queue                */
  HMQ   hmq;                    /* Handle to Queue              */
  ULONG flCreate;               /* Frame creation flags         */
  HWND  hwndFrame, hwndClient;
  char  classname[]="display Messages";

  setbuf(stdout, 0);
  printf("[WinInitialize]\n");
  hab=WinInitialize(0);

  printf("[WinCreateMsgQueue]\n");
  hmq=WinCreateMsgQueue(hab, 0);

  printf("[WinRegisterClass]\n");
  WinRegisterClass(hab,
                   (PSZ)classname,
                   (PFNWP)wndProc,
                   CS_SIZEREDRAW,
                   0);

  flCreate  = FCF_MINMAX | FCF_SIZEBORDER | FCF_SYSMENU
            | FCF_TITLEBAR | FCF_SHELLPOSITION | FCF_TASKLIST
            | FCF_MENU | FCF_ICON;

  printf("[WinCreateStdWindow]\n");
  hwndFrame = WinCreateStdWindow(HWND_DESKTOP,
                                 WS_VISIBLE,
                                 &flCreate,
                                 (PSZ)classname,
                                 (PSZ)"Message Programm",
                                 0,
                                 0,
                                 ID_FRAMEWND,
                                 (PHWND) &hwndClient);
  printf("[WinCreateStdWindow beendet mit: frame=%x, client=%x]\n", hwndFrame, hwndClient);

  /* Message Loop */
  printf("[Eintritt in die Message loop]\n");
  if (hwndFrame)
     {
     while (WinGetMsg(hab, (PQMSG) &qmsg, 0,0,0))
         {
         type="posted to";
         WinDispatchMsg(hab, (PQMSG) &qmsg);
         type="sent   to";
         }
     printf("[Message loop beendet]\n");
     }

  /* Destroy the window */
  printf("[WinDestroyWindow]\n");
  WinDestroyWindow(hwndFrame);

  /* Destroy the message queue */
  printf("[WinDestroyMsgQueue]\n");
  WinDestroyMsgQueue(hmq);

  /* Terminate and release resources */
  printf("[WinTerminate]\n");
  WinTerminate( hab );
  return(0);
  }


MRESULT EXPENTRY wndProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  printf("%25s (%08x) %s window: %08x\n%37sParam1: %x Param2: %x\n",
          querywmessage(msg), msg, type, hwnd, "", mp1, mp2);
  switch (msg)
     {
     case WM_ERASEBACKGROUND:
        return (MRESULT)TRUE;
     default:
        return(WinDefWindowProc(hwnd,msg,mp1,mp2));
     }
  }

char *querywmessage(unsigned msg)
  {
  switch(msg)
     {
     case 0x0000: return "WM_NULL";
     case 0x0001: return "WM_CREATE";
     case 0x0002: return "WM_DESTROY";
     case 0x0004: return "WM_ENABLE";
     case 0x0005: return "WM_SHOW";
     case 0x0006: return "WM_MOVE";
     case 0x0007: return "WM_SIZE";
     case 0x0008: return "WM_ADJUSTWINDOWPOS";
     case 0x0009: return "WM_CALCVALIDRECTS";
     case 0x000a: return "WM_SETWINDOWPARAMS";
     case 0x000b: return "WM_QUERYWINDOWPARAMS";
     case 0x000c: return "WM_HITTEST";
     case 0x000d: return "WM_ACTIVATE";
     case 0x000f: return "WM_SETFOCUS";
     case 0x0010: return "WM_SETSELECTION";
     case 0x0011: return "WM_PPAINT";
     case 0x0012: return "WM_PSETFOCUS";
     case 0x0013: return "WM_PSYSCOLORCHANGE";
     case 0x0014: return "WM_PSIZE";
     case 0x0015: return "WM_PACTIVATE";
     case 0x0016: return "WM_PCONTROL";
     case 0x0020: return "WM_COMMAND";
     case 0x0021: return "WM_SYSCOMMAND";
     case 0x0022: return "WM_HELP";
     case 0x0023: return "WM_PAINT";
     case 0x0024: return "WM_TIMER";
     case 0x0025: return "WM_SEM1";
     case 0x0026: return "WM_SEM2";
     case 0x0027: return "WM_SEM3";
     case 0x0028: return "WM_SEM4";
     case 0x0029: return "WM_CLOSE";
     case 0x002a: return "WM_QUIT";
     case 0x002b: return "WM_SYSCOLORCHANGE";
     case 0x002d: return "WM_SYSVALUECHANGED";
     case 0x002e: return "WM_APPTERMINATENOTIFY";
     case 0x002f: return "WM_PRESPARAMCHANGED";
     case 0x0030: return "WM_CONTROL";
     case 0x0031: return "WM_VSCROLL";
     case 0x0032: return "WM_HSCROLL";
     case 0x0033: return "WM_INITMENU";
     case 0x0034: return "WM_MENUSELECT";
     case 0x0035: return "WM_MENUEND";
     case 0x0036: return "WM_DRAWITEM";
     case 0x0037: return "WM_MEASUREITEM";
     case 0x0038: return "WM_CONTROLPOINTER";
     case 0x003a: return "WM_QUERYDLGCODE";
     case 0x003b: return "WM_INITDLG";
     case 0x003c: return "WM_SUBSTITUTESTRING";
     case 0x003d: return "WM_MATCHMNEMONIC";
     case 0x003e: return "WM_SAVEAPPLICATION";
     case 0x0F00: return "WM_HELPBASE";
     case 0x0FFF: return "WM_HELPTOP";
     case 0x1000: return "WM_USER";
     case 0x0079: return "WM_MOUSELAST / WM_BUTTONCLICKLAST / WM_BUTTON3DBLCLK";
     case 0x0070: return "WM_MOUSEMOVE";
     case 0x0071: return "WM_BUTTON1DOWN";
     case 0x0072: return "WM_BUTTON1UP";
     case 0x0073: return "WM_BUTTON1DBLCLK";
     case 0x0074: return "WM_BUTTON2DOWN";
     case 0x0075: return "WM_BUTTON2UP";
     case 0x0076: return "WM_BUTTON2DBLCLK";
     case 0x0077: return "WM_BUTTON3DOWN";
     case 0x0078: return "WM_BUTTON3UP";
     case 0x007D: return "WM_MOUSEMAP";
     case 0x0410: return "WM_EXTMOUSEFIRST / WM_CHORD";
     case 0x0411: return "WM_BUTTON1MOTIONSTART";
     case 0x0412: return "WM_BUTTON1MOTIONEND";
     case 0x0413: return "WM_BUTTON1CLICK";
     case 0x0414: return "WM_BUTTON2MOTIONSTART";
     case 0x0415: return "WM_BUTTON2MOTIONEND";
     case 0x0416: return "WM_BUTTON2CLICK";
     case 0x0417: return "WM_BUTTON3MOTIONSTART";
     case 0x0418: return "WM_BUTTON3MOTIONEND";
     case 0x0419: return "WM_BUTTON3CLICK";
     case 0x0428: return "WM_ENDSELECT / WM_MOUSETRANSLATELAST";
     case 0x0420: return "WM_BEGINDRAG";
     case 0x0421: return "WM_ENDDRAG";
     case 0x0422: return "WM_SINGLESELECT";
     case 0x0423: return "WM_OPEN";
     case 0x0424: return "WM_CONTEXTMENU";
     case 0x0425: return "WM_CONTEXTHELP";
     case 0x0426: return "WM_TEXTEDIT";
     case 0x0427: return "WM_BEGINSELECT";
     case 0x04C0: return "WM_PENFIRST";
     case 0x04FF: return "WM_PENLAST";
     case 0x0500: return "WM_MMPMFIRST";
     case 0x05FF: return "WM_MMPMLAST";
     case 0x007a: return "WM_CHAR";
     case 0x007b: return "WM_VIOCHAR";
     case 0x007c: return "WM_JOURNALNOTIFY";
     case 0x0040: return "WM_FLASHWINDOW";
     case 0x0041: return "WM_FORMATFRAME";
     case 0x0042: return "WM_UPDATEFRAME";
     case 0x0043: return "WM_FOCUSCHANGE";
     case 0x0044: return "WM_SETBORDERSIZE";
     case 0x0045: return "WM_TRACKFRAME";
     case 0x0046: return "WM_MINMAXFRAME";
     case 0x0047: return "WM_SETICON";
     case 0x0048: return "WM_QUERYICON";
     case 0x0049: return "WM_SETACCELTABLE";
     case 0x004a: return "WM_QUERYACCELTABLE";
     case 0x004b: return "WM_TRANSLATEACCEL";
     case 0x004c: return "WM_QUERYTRACKINFO";
     case 0x004d: return "WM_QUERYBORDERSIZE";
     case 0x004e: return "WM_NEXTMENU";
     case 0x004f: return "WM_ERASEBACKGROUND";
     case 0x0050: return "WM_QUERYFRAMEINFO";
     case 0x0051: return "WM_QUERYFOCUSCHAIN";
     case 0x0052: return "WM_OWNERPOSCHANGE";
     case 0x0053: return "WM_CALCFRAMERECT";
     case 0x0055: return "WM_WINDOWPOSCHANGED";
     case 0x0056: return "WM_ADJUSTFRAMEPOS";
     case 0x0059: return "WM_QUERYFRAMECTLCOUNT";
     case 0x005B: return "WM_QUERYHELPINFO";
     case 0x005C: return "WM_SETHELPINFO";
     case 0x005D: return "WM_ERROR";
     case 0x005E: return "WM_REALIZEPALETTE";
     case 0x0060: return "WM_RENDERFMT";
     case 0x0061: return "WM_RENDERALLFMTS";
     case 0x0062: return "WM_DESTROYCLIPBOARD";
     case 0x0063: return "WM_PAINTCLIPBOARD";
     case 0x0064: return "WM_SIZECLIPBOARD";
     case 0x0065: return "WM_HSCROLLCLIPBOARD";
     case 0x0066: return "WM_VSCROLLCLIPBOARD";
     case 0x0067: return "WM_DRAWCLIPBOARD";
     case 0x00A0: return "WM_DDE_FIRST / WM_DDE_INITIATE";
     case 0x00A1: return "WM_DDE_REQUEST";
     case 0x00A2: return "WM_DDE_ACK";
     case 0x00A3: return "WM_DDE_DATA";
     case 0x00A4: return "WM_DDE_ADVISE";
     case 0x00A5: return "WM_DDE_UNADVISE";
     case 0x00A6: return "WM_DDE_POKE";
     case 0x00A7: return "WM_DDE_EXECUTE";
     case 0x00A8: return "WM_DDE_TERMINATE";
     case 0x00A9: return "WM_DDE_INITIATEACK";
     case 0x00AF: return "WM_DDE_LAST";
     case 0x00b0: return "WM_QUERYCONVERTPOS / WM_DBCSFIRST";
     case 0x00cf: return "WM_DBCSLAST";
     default:     return "?";
     }
  }
