#define INCL_DOS
#define INCL_PM
#include <os2.h>

#include "editor.h"

Editor::Editor() : name("")
   {
   initDefaultAction(actionlist);
   current_id=500;

   memset(&mfont, 0, sizeof(FATTRS));
   mfont.usRecordLength  = sizeof(FATTRS);
   strcpy(mfont.szFacename,"Courier");
   mfont.lMaxBaselineExt = 20;
   mfont.lAveCharWidth   = 8;

   memset(&pfont, 0, sizeof(FATTRS));
   pfont.usRecordLength  = sizeof(FATTRS);
   strcpy(pfont.szFacename,"System Proportional");
   pfont.lMaxBaselineExt = 20;
   pfont.lAveCharWidth   = 8;
   }

char *Editor::queryHelptext(unsigned id)
  {
  Action *action=actionlist[id];
  if (action)
     return (char *)action->helptext;
  else
    return "";
  }

void Editor::updateStatusline(int force)
  {
  if (updateStatus || force)
     {
     char buffer[256];
     char *s1="geaendert", *s2="nicht geaendert";
     sprintf(buffer, "Zeile %u (von %u), Spalte %i, %s", curline+1, maxline, curcol,
                      modified ? "gendert" : "nicht gendert");
     setStatusText(buffer);
     }
  updateStatus=FALSE;
  }

int Editor::addToolbarButton(ActionFnPtr p, char *s1, char *s2,
                             int id, HMODULE h, unsigned r)
  {
  if (id==0) id=++current_id;
  Action *action=new Action(p,s1,s2,id,h,r);
  WinPostMsg(toolbar, WM_USER+1,(MPARAM)action,0);
  actionlist.append(action);
  return id;
  }

void Editor::loadini()
  {
  ULONG sz;

  sz=sizeof(pfont);
  PrfQueryProfileData(HINI_USERPROFILE, "c't Editor", "FontM",
                      &mfont, &sz);
  sz=sizeof(pfont);
  PrfQueryProfileData(HINI_USERPROFILE, "c't Editor", "FontP",
                      &mfont, &sz);
  sz=sizeof(indent);
  PrfQueryProfileData(HINI_USERPROFILE, "c't Editor", "Indent",
                      &indent, &sz);
  sz=sizeof(showToolbar);
  PrfQueryProfileData(HINI_USERPROFILE, "c't Editor", "Toolbar",
                      &showToolbar, &sz);
  sz=sizeof(quickmark);
  PrfQueryProfileData(HINI_USERPROFILE, "c't Editor", "Quickmark",
                      &quickmark, &sz);
  }

void Editor::saveini()
  {
  PrfWriteProfileData(HINI_USERPROFILE, "c't Editor", "FontM",
                      &mfont, sizeof(mfont));
  PrfWriteProfileData(HINI_USERPROFILE, "c't Editor", "FontP",
                      &mfont, sizeof(pfont));
  PrfWriteProfileData(HINI_USERPROFILE, "c't Editor", "Indent",
                      &indent, sizeof(indent));
  PrfWriteProfileData(HINI_USERPROFILE, "c't Editor", "Toolbar",
                      &showToolbar, sizeof(showToolbar));
  PrfWriteProfileData(HINI_USERPROFILE, "c't Editor", "Quickmark",
                      &quickmark, sizeof(quickmark));
  }
