#define INCL_DOS
#define INCL_PM
#include <os2.h>
#include <stdlib.h>
#include <ctype.h>
#include "debug.h"
#include "Editor.h"
#include "ctedit.h"
#include "statbar.h"
#include "mle.h"

PFNWP pfn;

extern "C" MRESULT EXPENTRY extMleProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  int line;
  IPT pos;
  HWND hwndParent;
  MRESULT ret;
  BOOL indent, quickmark;
  ULONG style;
  BOOL vk_down;
  int vk;
  int curcol;
  int curline;
  int maxline;

  hwndParent=WinQueryWindow(hwnd, QW_PARENT);
  Editor *edit=(Editor *)WinQueryWindowPtr(hwndParent, QWL_USER);
  HWND hwndMLE=edit->queryMle();
  style=WinQueryWindowULong(hwnd, QWL_USER);

  switch(msg)
     {
     case ED_AUTOINDENT:
          WinSetWindowBits(hwnd, QWL_USER, (ULONG)mp1 ? 0xffff : 0, EXTMLE_AUTOINDENT);
          break;
     case ED_QUICKCUTPASTE:
          WinSetWindowBits(hwnd, QWL_USER, (ULONG)mp1 ? 0xffff : 0, EXTMLE_QUICKCUTPASTE);
          break;

     case WM_ACTIVATE:
     case WM_BUTTON1DOWN:
             ret=(*pfn)(hwnd, msg, mp1, mp2);
             pos=(IPT)WinSendMsg(hwndMLE, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL, 0);
             edit->setMaxLine((ULONG)WinSendMsg(hwndMLE, MLM_QUERYLINECOUNT, 0, 0));
             edit->setCurLine(line=(ULONG)WinSendMsg(hwndMLE, MLM_LINEFROMCHAR, (MPARAM)-1, 0));
             edit->setCurColumn(pos-(ULONG)WinSendMsg(hwnd, MLM_CHARFROMLINE, (MPARAM)line, 0));
             edit->setModified((BOOL)WinSendMsg(hwndMLE, MLM_QUERYCHANGED, 0 ,0));
             edit->updateStatusline();
             return ret;

     case WM_CHAR:
          indent=style&EXTMLE_AUTOINDENT;

          vk_down=(SHORT1FROMMP(mp1)&KC_VIRTUALKEY) && ((SHORT1FROMMP(mp1) & KC_KEYUP) != KC_KEYUP);
          vk=SHORT2FROMMP(mp2);
          if (indent && vk_down)
             {
             if (vk==VK_NEWLINE)
                {
                 char *buffer;
                 MRESULT ret;
                 IPT ipt, cpos;
                 int col, bytes;
                 int pline, count;
                 char *p, i;

                 line=  (int)WinSendMsg(hwnd, MLM_LINEFROMCHAR, (MPARAM)-1, 0);
                 pline= (int)WinSendMsg(hwnd, MLM_LINEFROMCHAR, (MPARAM)(line-1), 0);
                 pos = (IPT)WinSendMsg(hwnd, MLM_CHARFROMLINE, (MPARAM)line, 0);
                 cpos=(IPT)WinSendMsg(hwnd, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL, 0);

                 buffer=(char *)malloc(4096);
                 WinSendMsg(hwnd, MLM_SETIMPORTEXPORT, MPFROMP((PBYTE)buffer), (MPARAM)(4096));
                 count=cpos-pos;
                 WinSendMsg(hwnd, MLM_EXPORT, &pos, &cpos);
                 /*mprintf("Buffer: %s", buffer);*/

                 for (col=0; buffer[col]; col++)
                   if (buffer[col]!=' ')
                      break;

                 pos = (IPT)WinSendMsg(hwnd, MLM_CHARFROMLINE, (MPARAM)line, 0);
                 ret=(*pfn)(hwnd, msg, mp1, mp2);

                 cpos=(IPT)WinSendMsg(hwnd, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL, 0);
                 if (col<0)
                    col=0;

                 buffer=(char *)malloc(col+1);
                 memset(buffer, ' ', col);
                 buffer[col]=0;
                 ipt=-1;

                 for (i=0; i<col; i++)
                    ret=(*pfn)(hwnd, WM_CHAR, (MPARAM)0x39011007,
                                                            (MPARAM)0x100020);
                 return ret;
                 }
             }
             hwndParent=WinQueryWindow(hwnd, QW_PARENT);
             /*
             WinPostMsg((HWND)WinSendMsg(hwndParent, UM_QUERYSTATUSBAR, 0,0),
                        STB_CHANGESTATUS, 0,0);
             */
             pos=(IPT)WinSendMsg(hwndMLE, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL, 0);
             edit->setMaxLine(maxline=(ULONG)WinSendMsg(hwndMLE, MLM_QUERYLINECOUNT, 0, 0));
             edit->setCurLine(curline=line=(ULONG)WinSendMsg(hwndMLE, MLM_LINEFROMCHAR, (MPARAM)-1, 0));
             edit->setCurColumn(curcol=(pos-(ULONG)WinSendMsg(hwnd, MLM_CHARFROMLINE, (MPARAM)line, 0)));
             edit->setModified((BOOL)WinSendMsg(hwndMLE, MLM_QUERYCHANGED, 0 ,0));
             edit->updateStatusline();
             curcol++;

             if (vk_down)
                {
                if (curline<=0)
                   {
                   if (vk==VK_UP || vk==VK_PAGEUP || (curcol<=1 && vk==VK_LEFT))
                      return 0;
                   }
                else if (curline>=(maxline-1))
                   {
                   if (vk==VK_DOWN || vk==VK_PAGEDOWN|| (vk==VK_RIGHT && (pos==(int)WinSendMsg(hwndMLE, MLM_QUERYTEXTLENGTH, 0,0))))
                      return 0;
                   }
                }
             break;
     case WM_ENDSELECT:
             quickmark=style&EXTMLE_QUICKCUTPASTE;
             if (quickmark)
                 {
                 ret=(*pfn)(hwnd, msg, mp1, mp2);
                 WinSendMsg(hwnd,MLM_COPY,0,0);
                 return ret;
                 }
             break;
     case WM_BUTTON3CLICK:
             quickmark=style&EXTMLE_QUICKCUTPASTE;
             if (quickmark)
                 WinSendMsg(hwnd,MLM_PASTE,0,0);
             break;
     case WM_BUTTON2CLICK:
             {
             char *buffer;
             MRESULT ret;
             IPT ipt, cpos;
             int col, bytes;
             int pline, count;
             char *p, *pp, i;
             char word[256];
             int left;

             (*pfn)(hwnd, WM_BUTTON1DOWN, mp1, mp2);
             (*pfn)(hwnd, WM_BUTTON1UP, mp1, mp2);

             line= (int)WinSendMsg(hwnd, MLM_LINEFROMCHAR, (MPARAM)-1, 0);
             pos = (IPT)WinSendMsg(hwnd, MLM_CHARFROMLINE, (MPARAM)line, 0);
             cpos=(IPT)WinSendMsg(hwnd, MLM_QUERYSEL, (MPARAM)MLFQS_CURSORSEL, 0);
             count=cpos-pos;
             left=pos;
             /*mprintf("Spalte: %i", count);*/

             buffer=(char *)malloc(4096);
             cpos=100;
             WinSendMsg(hwnd, MLM_SETIMPORTEXPORT, MPFROMP((PBYTE)buffer), (MPARAM)(4096));
             WinSendMsg(hwnd, MLM_EXPORT, &pos, &cpos);
             p=buffer+count;
             left+=count;
             /*mprintf("buffer: %s", p);*/
             while (p>buffer && isalpha(*p))
                {
                p--;
                left--;
                }
             if (p>buffer)
                {
                left++;
                p++;
                }
             /*mprintf("p: %s", p);*/
             for (pp=word; isalpha(*p); p++, pp++)
                *pp=*p;
             *pp++=0;
             /*mprintf("Wort: %s", word);*/
             WinSendMsg(hwnd, MLM_SETSEL,
                (MPARAM)left, (MPARAM)(left+strlen(word)));
             }
     default:
        return (*pfn)(hwnd, msg, mp1, mp2);
     }
  return (*pfn)(hwnd, msg, mp1, mp2);
  }
