#define INCL_DOS
#define INCL_WIN
#include <os2.h>
#include <stdio.h>
#ifdef __WATCOMC__
 #include <io.h>
#endif

#include "debug.h"
#include "edit.h"
#include "action.h"
#include "editor.h"
#include "menu.h"
#include "mle.h"
#include "ctedit.h"
#include "srchdlg.h"
#include "generic.h"

#define BLOCKSIZE 64000

MRESULT EXPENTRY SearchDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

inline void MsgBox(char *headline, char *text)
  {
  WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, (PSZ)text, (PSZ)headline, 0,
               MB_OK|MB_MOVEABLE);
  }

BOOL fileDlg(HWND hwnd, char *name, int attr)
  {
  static FILEDLG fild;
  ULONG drive, dummy;
  char *def;

  def="*.*";
  *name=0;
  memset((void *)&fild, 0, sizeof(FILEDLG));
  fild.cbSize=sizeof(FILEDLG);
  fild.fl=attr|FDS_CENTER|FDS_HELPBUTTON;

  DosQueryCurrentDisk(&drive, &dummy);

  fild.pszIDrive="C:";
//fild.pszIDrive[0]=(char)64+drive;

  strcpy(fild.szFullFile,def);
  WinFileDlg(HWND_DESKTOP, hwnd, &fild);
  if (fild.lReturn==DID_OK)
     {
     strcpy(name, fild.szFullFile);
     return TRUE;
     }
  return FALSE;
  }

BOOL fontDlg(HWND hwnd, FATTRS *fAttrs, BOOL monospaced)
  {
  FONTDLG fntd;

  HWND hwndFontDlg;
  CHAR szFamilyname[FACESIZE];
  /*FNTS_FIXEDWIDTHONLY
  FNTS_PROPORTIONALONLY*/

  memset(&fntd, 0, sizeof(FONTDLG));
  memcpy(&fntd.fAttrs, fAttrs, sizeof(FATTRS));

  fntd.cbSize=sizeof(FONTDLG);
  fntd.fl=FNTS_HELPBUTTON|FNTS_CENTER;
  fntd.fl|=monospaced ? FNTS_FIXEDWIDTHONLY :FNTS_PROPORTIONALONLY;
  fntd.clrFore=CLR_BLACK;
  fntd.clrBack=SYSCLR_WINDOW;
  fntd.fxPointSize=MAKEFIXED(8,0);
  fntd.hpsScreen=WinGetPS(hwnd);
  fntd.usWeight=5;
  fntd.usWidth=5;
  szFamilyname[0]=0;
  strcpy(szFamilyname, fAttrs->szFacename);
  fntd.pszFamilyname=szFamilyname;
  fntd.usFamilyBufLen=FACESIZE;
  fntd.pszTitle="Schriftart";
  fntd.pszPreview="c't - Beipieltext";

  hwndFontDlg=WinFontDlg(HWND_DESKTOP, hwnd, &fntd);

  WinReleasePS(fntd.hpsScreen);
  if ( hwndFontDlg && fntd.lReturn==DID_OK)
     {
     memcpy(fAttrs, &fntd.fAttrs, sizeof(FATTRS));
     return TRUE;
     }
  return FALSE;
  }

BOOL loadMLE(HWND hwnd, char *name)
  {
  FILE *fp;
  char *buffer;
  ULONG offset=0, count;
  IPT ipt;

  buffer=new char[BLOCKSIZE];

  fp=fopen(name, "r");
  if (!fp)
     return FALSE;

  memset(buffer, 0, BLOCKSIZE);
  ipt=(IPT)WinSendMsg(hwnd, MLM_QUERYTEXTLENGTH,0,(MPARAM)-1);
  WinSetWindowText(hwnd, "");

  WinSendMsg(hwnd, MLM_SETIMPORTEXPORT, buffer, (MPARAM)(BLOCKSIZE));

  count=(int)WinSendMsg(hwnd, MLM_QUERYTEXTLENGTH,0,(MPARAM)-1);
  WinSendMsg(hwnd, MLM_FORMAT, (MPARAM)MLFIE_NOTRANS, 0);
  WinSendMsg(hwnd, MLM_DELETE, 0, (MPARAM)count);

  while (count=fread(buffer, 1, BLOCKSIZE, fp))
     WinSendMsg(hwnd, MLM_IMPORT, (MPARAM)&offset, (MPARAM)count);
  fclose(fp);

  delete buffer;
  WinPostMsg(hwnd, MLM_SETCHANGED, (MPARAM)FALSE, 0);
  return TRUE;
  }

BOOL saveMLE(HWND hwnd, char *name)
  {
  FILE *fp;
  char *buffer=new char[BLOCKSIZE];
  ULONG offset=0, count=-1, written;

  unlink(name);
  fp=fopen(name, "wb");
  if (!fp)
     return FALSE;

  memset(buffer, 0, BLOCKSIZE);
  WinSendMsg(hwnd, MLM_FORMAT, (MPARAM)MLFIE_CFTEXT, 0);

  WinSendMsg(hwnd, MLM_SETIMPORTEXPORT, (MPARAM)buffer, (MPARAM)BLOCKSIZE);
  count=(int)WinSendMsg(hwnd, MLM_QUERYTEXTLENGTH,0, (MPARAM)-1);
  while (written=(ULONG)WinSendMsg(hwnd, MLM_EXPORT, (MPARAM)&offset, (MPARAM)&count))
     fwrite(buffer, written, 1, fp);
  fclose(fp);
  delete buffer;
  WinPostMsg(hwnd, MLM_SETCHANGED, (MPARAM)FALSE, 0);
  return TRUE;
  }

void load(HWND hwnd, char *name)
  {
  if (fileDlg(hwnd, name, FDS_OPEN_DIALOG))
     {
     if (!loadMLE(hwnd, name))
        MsgBox("Error", "Cannot load file");
     }
  }

void saveas(HWND hwnd, char *name)
  {
  if (fileDlg(hwnd, name, FDS_SAVEAS_DIALOG|FDS_ENABLEFILELB))
     {
     FILE *fp=fopen(name, "r");
     if (fp)
        {
        fclose(fp);

        if (WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
            (PSZ)"Achtung, die Datei existiert schon. Soll die "
                 "Datei berschrieben werden?", "Achtung",
                 0, MB_OKCANCEL) !=MBID_OK)
           return;
        }
     }
  if (!saveMLE(hwnd, name))
     MsgBox("Error", "Cannot save file");
  }

void save(HWND hwnd, char *name)
  {
  if (!*name)
     saveas(hwnd, name);
  else
     saveMLE(hwnd, name);
  }

int _System action(HWND hwnd)
  {
  return 0;
  }

int _System action_new(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  WinSetWindowText(hwndMle, "");
  return 0;
  }

int _System action_open(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  char buffer[CCHMAXPATH];
  load(hwndMle, buffer);
  edit->setName(buffer);
  WinPostMsg(edit->queryFrame(), UM_CHANGENAME, (MPARAM)buffer, 0);

  return 0;
  }

int _System action_save(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  char buffer[CCHMAXPATH];
  save(hwndMle, edit->queryName());

  return 0;
  }

int _System action_saveas(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  char buffer[CCHMAXPATH];
  save(hwndMle,"");
  WinPostMsg(edit->queryFrame(), UM_CHANGENAME, (MPARAM)buffer, 0);

  return 0;
  }

int _System action_quit(HWND hwnd)
  {
  WinPostQueueMsg(HMQ_CURRENT, WM_QUIT, 0, 0);
  return 0;
  }

int _System action_undo(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  WinSendMsg(hwndMle,MLM_UNDO,0,0);
  return 0;
  }

int _System action_cut(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  WinSendMsg(hwndMle,MLM_CUT,0,0);
  return 0;
  }

int _System action_copy(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  WinSendMsg(hwndMle,MLM_COPY,0,0);
  return 0;
  }

int _System action_paste(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  WinSendMsg(hwndMle,MLM_PASTE,0,0);
  return 0;
  }

int _System action_delete(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  WinSendMsg(hwndMle,MLM_CLEAR,0,0);
  return 0;
  }

int _System action_search(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();
  HWND hwndDlg;

  if (WinDlgBox(HWND_DESKTOP, hwnd, SearchDlgProc, 0, ID_DLG_SEARCH, edit))
     MsgBox("Suchen", "Der Suchbegriff wurde nicht gefunden");
/*
  hwndDlg=WinLoadDlg(HWND_DESKTOP, hwnd, SearchDlgProc, 0, ID_DLG_SEARCH, edit);
  WinProcessDlg(hwndDlg);
  WinDestroyWindow(hwndDlg);
*/
  return 0;
  }

int _System action_markall(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  int count=(int)WinSendMsg(hwndMle, MLM_QUERYFORMATTEXTLENGTH,0,(MPARAM)-1);
  WinSendMsg(hwndMle, MLM_SETSEL, 0, (MPARAM)count);
  return 0;
  }

int _System action_fontmset(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  WinSendMsg(hwndMle, MLM_SETFONT, (MPARAM)&edit->queryMonoFont(), 0);
  return 0;
  }

int _System action_fontmqset(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  fontDlg(hwnd, &edit->queryMonoFont(), TRUE);
  WinSendMsg(hwndMle, MLM_SETFONT, (MPARAM)&edit->queryMonoFont(), 0);
  return 0;
  }

int _System action_fontpset(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  WinSendMsg(hwndMle, MLM_SETFONT, (MPARAM)&edit->queryPropFont(), 0);
  return 0;
  }

int _System action_fontpqset(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  fontDlg(hwnd,&edit->queryPropFont(), FALSE);
  WinSendMsg(hwndMle, MLM_SETFONT, (MPARAM)&edit->queryPropFont(), 0);
  return 0;
  }

int _System action_color(HWND hwnd)
  {
  HOBJECT h=WinQueryObject("<WP_LORESCLRPAL>");
  WinSetObjectData(h, "OPEN=DEFAULT");
  return 0;
  }

int _System action_wwon(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  WinSendMsg(hwndMle, MLM_SETWRAP, (MPARAM)1, 0);
  return 0;
  }

int _System action_wwoff(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  WinSendMsg(hwndMle, MLM_SETWRAP, (MPARAM)0, 0);
  return 0;
  }

int _System action_toolbar(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndToolbar=edit->queryToolbar();
  SWP swp;

/*
  BOOL v=WinIsWindowVisible(hwndToolbar);
  WinShowWindow(hwndToolbar, !v);
*/
  WinQueryWindowPos(hwndToolbar, &swp);
  if (swp.cy>0)
     WinSetWindowPos(hwndToolbar, 0, swp.x, swp.y, swp.cy, 0, SWP_SIZE);
  else
     WinSetWindowPos(hwndToolbar, 0, swp.x, swp.y, swp.cx, 50, SWP_SIZE);

  WinQueryWindowPos(edit->queryFrame(), &swp);
  WinSetWindowPos(edit->queryFrame(), 0, swp.x, swp.y, swp.cx, swp.cy, SWP_SIZE|SWP_MOVE|SWP_NOADJUST);
  WinInvalidateRect(edit->queryFrame(), 0, TRUE);
  WinUpdateWindow(edit->queryFrame());
  WinSendMsg(edit->queryFrame(), WM_UPDATEFRAME,
  (MPARAM)( FCF_MINMAX | FCF_SIZEBORDER | FCF_SYSMENU
  | FCF_TITLEBAR | FCF_SHELLPOSITION | FCF_TASKLIST
  | FCF_MENU | FCF_ICON),0);



  return 0;
  }

int _System action_indent(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();
  BOOL b=edit->queryIndent();

  WinPostMsg(hwndMle, ED_AUTOINDENT, (MPARAM)!b, 0);
  edit->setIndent(!b);
  return 0;
  }

int _System action_qcut(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();
  BOOL b=edit->queryQuickmark();

  WinPostMsg(hwndMle, ED_QUICKCUTPASTE, (MPARAM)!b, 0);
  edit->setQuickmark(!b);
  return 0;
  }

int _System action_savesettings(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  edit->saveini();
  return 0;
  }

int _System action_about(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  MsgBox("Produktinformation", "c't Editor");
  return 0;
  }

int _System action_print(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  MsgBox("Funktion nicht vorhanden", "Das Drucken kommt in einer der nchsten Folgen ;-)");
  return 0;
  }

int _System action_fonttoggle(HWND hwnd)
  {
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  HWND hwndMle=edit->queryMle();

  if (edit->queryFonttype())
     WinSendMsg(hwndMle, MLM_SETFONT, (MPARAM)&edit->queryPropFont(), 0);
  else
     WinSendMsg(hwndMle, MLM_SETFONT, (MPARAM)&edit->queryMonoFont(), 0);
  edit->setFonttype(!edit->queryFonttype());

  return 0;
  }

ActionInit DefaultAction[] =
  {
  (ActionFnPtr)action_new,       "~Neu",            "Einen neuen Text bearbeiten",  ID_MENUITEM_NEW, 0, 0,
  (ActionFnPtr)action_open,      "~ffnen",         "Eine neue Datei laden",        ID_MENUITEM_OPEN, 0, 0,
  (ActionFnPtr)action_save,      "~Speichern",      "Die aktuelle Datei speichern", ID_MENUITEM_SAVE, 0, 0,
  (ActionFnPtr)action_saveas,    "Speichern unter", "Die aktuelle Datei unter einem neuen Namen speichern", ID_MENUITEM_SAVEAS, 0,0,
  (ActionFnPtr)action_quit,      "Beenden",         "Editor beenden", ID_MENUITEM_QUIT, 0,0,
  (ActionFnPtr)action_print,     "Drucken",         "Datei drucken", ID_MENUITEM_PRINT, 0,0,
  (ActionFnPtr)action_undo,      "~Widerrufen",     "Letzte nderung rckgngig machen", ID_MENUITEM_UNDO, 0,0,
  (ActionFnPtr)action_cut,       "Ausschneiden",    "Markierten Text ausschneiden und ins Clipboard kopieren ", ID_MENUITEM_CUT, 0,0,
  (ActionFnPtr)action_copy,      "Kopieren",        "Markierten Text ins Clipboard kopieren", ID_MENUITEM_COPY,0,0,
  (ActionFnPtr)action_paste,     "Einfgen",        "Text aus dem Clipboard einfgen", ID_MENUITEM_INSERT, 0,0,
  (ActionFnPtr)action_delete,    "Lschen",         "Markierten Text lschen", ID_MENUITEM_DELETE, 0,0,
  (ActionFnPtr)action_markall,   "Alles markieren", "Den gesamten Text markieren", ID_MENUITEM_MARKALL, 0,0,
  (ActionFnPtr)action_search,    "Suchen",          "Einen String im text suchen", ID_MENUITEM_SEARCH, 0,0,
  (ActionFnPtr)action_fontmset,  "Schriftart(mono) setzen", "Zur monospaced Schriftart wechseln", ID_MENUITEM_FONTMSET, 0,0,
  (ActionFnPtr)action_fontmqset, "Schriftart(mono) whlen", "Monospaced Schriftart auswhlen", ID_MENUITEM_FONTMCHANGE, 0,0,
  (ActionFnPtr)action_fontpset,  "Schriftart(prop) setzen", "Zur proportionalen Schriftart wechseln", ID_MENUITEM_FONTPSET, 0,0,
  (ActionFnPtr)action_fontpqset, "Schriftart(prop) whlen", "Proportionale Schriftart auswhlen", ID_MENUITEM_FONTPCHANGE, 0,0,
  (ActionFnPtr)action_fonttoggle,"Schriftart wechseln", "Schriftart wechseln (monospaced <-> proportional)", ID_MENUITEM_FONTTOGGLE, 0,0,
  (ActionFnPtr)action_color,     "Farbpalette",     "WPS Objekt \"Farbpalette\" ffnen", ID_MENUITEM_COLOR,0,0,
  (ActionFnPtr)action_wwon,      "Umbruch (an)",    "Zeilenumbruch einschalten", ID_MENUITEM_WWON, 0,0,
  (ActionFnPtr)action_wwoff,     "Umbruch (aus)",   "Zeilenumbruch ausschalten", ID_MENUITEM_WWOFF, 0,0,
  (ActionFnPtr)action_toolbar,   "Toolbar (an)",    "Toolbar sichtbar/unsichtbar machen", ID_MENUITEM_TOOLBAR, 0,0,
  (ActionFnPtr)action_indent,    "Autoindent",      "Automatisches Einrcken", ID_MENUITEM_INDENT, 0,0,
  (ActionFnPtr)action_qcut,      "Quick cut'n paste","Schnelles Markieren und Clipboard-Kopieren", ID_MENUITEM_QUICKMARK,0,0,
  (ActionFnPtr)action_savesettings,"Einstellungen speichern", "Aktuelle Einstellungen speichern", ID_MENUITEM_OPTIONSAVE, 0,0,
  (ActionFnPtr)action_about,     "Produktinformation", "Produktinformation", ID_MENUITEM_HELPABOUT, 0,0,
  0,"","",0,0,0
  };

void initDefaultAction(ActionList& list)
  {
  for (int i=0; DefaultAction[i].action; i++)
     list.append(new Action(DefaultAction[i]));
  }

MRESULT EXPENTRY SearchDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  HWND h;
  HWND hwndMle=0;
  Editor *edit=(Editor *)WinQueryWindowPtr(hwnd, QWL_USER);
  if (edit)
     hwndMle=edit->queryMle();

  switch (msg)
     {
     case WM_INITDLG:
        //dprintf("WM_INITDLG");
        WinSetFocus(WinWindowFromID(hwnd, IDS_SEARCH), TRUE);
        WinSetWindowPtr(hwnd, QWL_USER, (void *)mp2);
        break;
     case WM_COMMAND:
        switch(SHORT1FROMMP(mp1))
           {
           HWND hwndEntry;
           char search[128];
           char replace[128];
           MLE_SEARCHDATA mlesrch;
           BOOL rc;
           BOOL changeAll, caseSensitive;
           ULONG style;

           case IDS_CANCEL:
                 WinDismissDlg(hwnd, FALSE);
                 break;
           case IDS_SEARCH:
           case IDS_CHANGE:
              hwndEntry = WinWindowFromID(hwnd, IDS_FIND);
              WinQueryWindowText(hwndEntry,
                                 sizeof(search),
                                 search);

              hwndEntry = WinWindowFromID(hwnd, IDS_REPLACE);
              WinQueryWindowText(hwndEntry,
                                 sizeof(replace),
                                 replace);

              /* Fill the MLE_SEARCHDATA data structure                          */
              mlesrch.cb         = sizeof(mlesrch);  /* Structure size           */
              mlesrch.pchFind    = search;           /* Search string            */
              mlesrch.pchReplace = SHORT1FROMMP(mp1)==IDS_SEARCH ?
                                      0 : replace;
              mlesrch.cchFind    = strlen(search);   /* Not used                 */
              mlesrch.cchReplace = strlen(replace);  /* Not used                 */
              mlesrch.iptStart   = -1;               /* Start at cursor position */
              mlesrch.iptStop    = -1;               /* Stop at end of file      */

              caseSensitive=
                  (BOOL)WinSendMsg(WinWindowFromID(hwnd, IDS_CASESENSITIVE),
                             BM_QUERYCHECK, 0,0);
              changeAll=
                  (BOOL)WinSendMsg(WinWindowFromID(hwnd, IDS_CHANGEALL),
                             BM_QUERYCHECK, 0,0);
              /* Start the search operation */
              style=MLFSEARCH_SELECTMATCH;
              if (changeAll && SHORT1FROMMP(mp1)==IDS_CHANGE)
                 style|=MLFSEARCH_CHANGEALL;
              if (caseSensitive)
                 style|=MLFSEARCH_CASESENSITIVE;
              rc=(BOOL)WinSendMsg(hwndMle,
                         MLM_SEARCH,
                         MPFROMLONG(style),
                         MPFROMP(&mlesrch));

              if (!rc)
                 WinDismissDlg(hwnd, TRUE);
              return FALSE;
              }
        break;
     }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
  }
