// Qbist.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
//neu
#include "mydefs.h"
#include "resource.h"
#include "tiffdlg.h"
#include "progdlg.h"
//Ende neu
#include "Qbistdoc.h"

#include "Qbist.h"

#include "mainfrm.h"


#include "Qbistvw.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//neu
transform* transformList[] = {&projection, &shift, &shiftBack, &rotate, &rotate2, &multiply, &sine, &conditional, &complement};

POINT position[] = {{1,1},{0,0},{1,0},{2,0},{2,1},{2,2},{1,2},{0,2},{0,1}};

BOOL isReady = FALSE;

BOOL hasDoc = FALSE;
CQbistDoc* pgDoc = NULL;

//Ende neu

/////////////////////////////////////////////////////////////////////////////
// CQbistApp

BEGIN_MESSAGE_MAP(CQbistApp, CWinApp)
	//{{AFX_MSG_MAP(CQbistApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CQbistApp construction

CQbistApp::CQbistApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CQbistApp object

CQbistApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CQbistApp initialization

BOOL CQbistApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	Enable3dControls();

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CQbistDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CQbistView));
	AddDocTemplate(pDocTemplate);

	// Enable DDE Execute open
	EnableShellOpen();
	RegisterShellFileTypes();
  
	// simple command line parsing
	if (m_lpCmdLine[0] == '\0')
	{
		// create a new (empty) document
		OnFileNew();
	}
	else
	{
		// open an existing document
		OpenDocumentFile(m_lpCmdLine);
	}

	// Enable drag/drop open
	m_pMainWnd->DragAcceptFiles();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CQbistApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

//neu:

unsigned short myRand (void)
{
	static unsigned short seed;
	long myTime;

	time(&myTime);
	return seed = 1237*seed+359+(myTime & 17);
}

void projection (myVector *source, myVector *control, myVector *dest)
{
	float scalarProd;
	
	scalarProd = source->x*control->x+source->y*control->y+source->z*control->z;
	dest->x = scalarProd*source->x;
	dest->y = scalarProd*source->y;
	dest->z = scalarProd*source->z;
}

void shift (myVector *source, myVector *control, myVector *dest)
{
	dest->x = source->x+control->x;
	if (dest->x >= 1.0)
		dest->x -= 1.0F;
	dest->y = source->y+control->y;
	if (dest->y >= 1.0)
		dest->y -= 1.0F;
	dest->z = source->z+control->z;
	if (dest->z >= 1.0)
		dest->z -= 1.0F;
}

void shiftBack (myVector *source, myVector *control, myVector *dest)
{
	dest->x = source->x-control->x;
	if (dest->x <= 0.0)
		dest->x += 1.0F;
	dest->y = source->y-control->y;
	if (dest->y <= 0.0)
		dest->y += 1.0F;
	dest->z = source->z-control->z;
	if (dest->z <= 0.0)
		dest->z += 1.0F;
}

void rotate (myVector *source, myVector *control, myVector *dest)
{
	dest->x = source->y;
	dest->y = source->z;
	dest->z = source->x;
}

void rotate2 (myVector *source, myVector *control, myVector *dest)
{
	dest->x = source->z;
	dest->y = source->x;
	dest->z = source->y;
}

void multiply (myVector *source, myVector *control, myVector *dest)
{
	dest->x = source->x*control->x;
	dest->y = source->y*control->y;
	dest->z = source->z*control->z;
}

void sine (myVector *source, myVector *control, myVector *dest)
{
	dest->x = 0.5F+0.5F*sin(20.0F*source->x*control->x);
	dest->y = 0.5F+0.5F*sin(20.0F*source->y*control->y);
	dest->z = 0.5F+0.5F*sin(20.0F*source->z*control->z);
}

void conditional (myVector *source, myVector *control, myVector *dest)
{
	if(control->x+control->y+control->z >0.5)
	{
		dest->x = source->x;
		dest->y = source->y;
		dest->z = source->z;
	}
	else
	{
		dest->x = control->x;
		dest->y = control->y;
		dest->z = control->z;
	}
}

void complement (myVector *source, myVector *control, myVector *dest)
{
	dest->x = 1.0F-source->x;
	dest->y = 1.0F-source->y;
	dest->z = 1.0F-source->z;
}
 
void myDraw(CQbistDoc* pDoc, CDC* pDC, BOOL fromStart)
{
	//beim Aufruf mit fromStart == TRUE mu pDoc gltig sein!!!
	static unsigned short gx, gy, gVariation;
	
	static myVector reg [NUM_REGISTERS];

	hasDoc = TRUE;
	pgDoc = pDoc;

	if(fromStart)
	{
		gx = gy = 1;	//kleiner Rand
		gVariation = 0;
		isReady = FALSE;
	}
	
	if(isReady) return;

	CRect myWinRect;
	pDC->GetWindow()->GetClientRect(&myWinRect);

	int picWidth = myWinRect.Width()/3;
	int picHeight = myWinRect.Height()/3;

	int k,j,i;

	for(k=0; k<PIXELS_PER_RUN; k++)
	{
		for(j=0; j<NUM_REGISTERS; j++)
		{
			reg[j].x = ((float)gx)/(float)(picWidth-1);
			reg[j].y = ((float)gy)/(float)(picHeight-1);
			reg[j].z = ((float)j)/(float)NUM_REGISTERS;
		}

		for(i=0;i<NUM_TRANSFORMS; i++)
		{
			transformList[pDoc->transformSequence[gVariation][i]]
				(&(reg[pDoc->source[gVariation][i]]),
				 &(reg[pDoc->control[gVariation][i]]),
				 &(reg[pDoc->dest[gVariation][i]]));
		}

		COLORREF myColor = RGB((BYTE)(0xFE * reg[0].x),(BYTE)(0xFE * reg[0].y),(BYTE)(0xFE * reg[0].z) );

		pDC->SetPixel(position[gVariation].x*picWidth+gx,
				position[gVariation].y*picHeight+gy,myColor);
		
		gy++;

		if(gy >= picHeight)
		{
			gy=1; //um einen kleinen Rand zu haben
			gx++;
			if(gx >= picWidth)
			{
				gx=1;
				
				CString pString((TCHAR) gVariation+48);
				pDC->TextOut(position[gVariation].x*picWidth,position[gVariation].y*picHeight,pString);
				gVariation++;
				if(gVariation>=9)
				{
					isReady = TRUE;
					return; //nicht mehr PIXELS_PER_RUN fertigmachen!!! Sonst Crash!!
				}
			}
		}
	
	}	 
}

/////////////////////////////////////////////////////////////////////////////
// CQbistApp commands


//neu
BOOL CQbistApp::OnIdle(LONG lCount) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(hasDoc && (NULL != pgDoc))

		pgDoc->UpdateAllViews(NULL, 0L, (CObject*) COOKIE);
	return !isReady || CWinApp::OnIdle(lCount);
}
