// Eine Templateklasse fr eine Menge gleichartiger Manipulatoren

#include <iostream.h>

// -------- gemeinsamer Teil fr alle Manipulatoren ---------------
template<class Arg>
class OM {
public:
  typedef ostream& (*Fkt)(ostream&, Arg);
  OM(Fkt ff, Arg aa) : f(ff), a(aa) {}
  friend ostream& operator<<(ostream& os, const OM<Arg>& om) {
    return om.f(os, om.a);
  }
private:
  const Fkt f;
  const Arg a;
};

template<class Arg>
class App {
public:
  App(OM<Arg>::Fkt ff) : f(ff) {}
  OM<Arg> operator()(Arg n) const { return OM<Arg>(f, n); }
private:
  const OM<Arg>::Fkt f;
};

// -------- Definition des space-Manipulators ---------------------
ostream& spaces(ostream& os, int n) {
  for (int i=0; i<n; i++)
    os << ' ';
  return os;
}

const App<int> space(spaces);

int main() {
  cout << "0123456\n";
  cout << '#' << space(5) << '#' << endl;
  return 0;
}
