/* BABYLON:                                */
/* Unterst"utzung mehrsprachiger Programme */
/* --------------------------------------- */
/* Autor: Harald Amschler, f"ur c't        */
/* V1.00: 01. August  1995                 */

#define TITLE  "BABYLON V1.00 (01.08.1995)\n" \
	       "Author: Harald Amschler\n\n"
#define MAXTOP 1024   // max. Anzahl Themen (topics)
#define MAXLEN 16384  // max. Stringl"ange
#include <stdio.h>
#include <string.h>

typedef unsigned short int word;

FILE *src;           // Source
char *fn = NULL;     // Filename
char buf[MAXLEN+1];  // Stringpuffer

char *fgett(char *b, int max, FILE *f)  // "Get Topic"
{
  char *p = b;
   int l,more,c;

  *p = 0;
  do  // Zeilen mit "\" am Ende als eine einzige lesen
  {
    more = 0;
    do
      if (fgets(p,max,f)==NULL)
	if (p==b) return NULL; else return b;
    while (*p==';');  // Kommentarzeilen ignorieren
    if ((l = strlen(p))!=0)  // Ende testen
    {
      p += l-1;  // auf letztes Zeichen
      c = 0;
      while (l!=0 && c==0 && (*p=='\n' || *p==' ' ||
	    (*p=='\"' && more) || (*p=='\\' && !more)))
      {
	if (*p=='\\') more = 1;
	if (*p=='\"')  // Stringfortsetzung:
	{
	  while ((c = fgetc(f))==' ' || c==9);
	  if (c!='\"' && c!=EOF) ungetc(c,f);
	}
	*(p--) = 0;  // Zeichen l"oschen
	l--;
      }
      max -= l;
      p++;
    }
  } while (more);
  return b;
}

int ProcessSourceFile(int lang)
{
    char *c;
     int i,t = 0;
    word o = 0;
  struct { char *def,*top; word ofs; } tp[MAXTOP];
    FILE *hdr,*bin;

  do
  {
    do  // Thema im Format "TOPIC:<CR>" suchen:
      if (fgett(buf,MAXLEN,src)==NULL)
	goto goon;  // Ende
    while (strlen(buf)<2 || buf[strlen(buf)-1]!=':');
    buf[strlen(buf)-1] = 0;   // ":" abschneiden
    tp[t].def = strdup(buf);  // und duplizieren.
    for (i = 0; i<lang; i++)  // lang-ten String lesen
    {
      if (fgett(buf,MAXLEN,src)==NULL)
      {
	printf("!!! No String found for topic %s!",tp[t].def);
	return 1;
      }
      if (strlen(buf)>1 && buf[strlen(buf)-1]==':')
      {
	printf("!!! Next topic \"%s\" encountered while "
	       "searching for topic string!\n",buf);
	return 1;
      }
    }
    if (buf[0]=='\"' && buf[strlen(buf)-1]=='\"')
    {
      buf[strlen(buf)-1] = 0;  // Hochkommas entfernen
      c = buf;
      while (*(++c))  // Steuerzeichen umsetzen:
      {
	if (*c=='\\')
	{
	  switch (*(c+1))
	  {
	    case 'n' : *c = 0x0A; break;  // new line
	    case 'r' : *c = 0x0D; break;  // return
	    case '\\':            break;  // Backslash \
	    case '\"': *c = '\"'; break;  // Hochkomma "
	    default:
	      continue;  // weiter mit while
	  }
	  memmove(c+1,c+2,strlen(c));  // nach links
	}
      }
      tp[t].top = strdup(buf+1);
    }
    else
      tp[t].top = strdup(buf);
    tp[t].ofs = o;             // Offset merken
    printf("Topic %6i: %s\nString %4hXH: %s\n\n",
	   t+1,tp[t].def,o,tp[t].top);
    o += strlen(tp[t].top)+1;  // n"achster Offset
    t++;                       // n"achstes Thema
  } while (t<MAXTOP);
goon:
  c = fn+strlen(fn)-3;
  strcpy(c,"H");
  printf("\nWRITING HEADERFILE %s  : %i topics ",fn,t);
  if ((hdr = fopen(fn,"wt"))==NULL)
  {
    printf("!!! Error opening file !!!\n");
    return 1;
  }
  fprintf(hdr,"/* Headerfile %s created by BABYLON */"
	      "\n\n/* table entries: */\n",fn);
  for (i = 0; i<t; i++)
    fprintf(hdr,"#define %sNR %i\n",tp[i].def,i);
  fprintf(hdr,"\n/* macro calls: */\n");
  for (i = 0; i<t; i++)
    fprintf(hdr,"#define %s ResStr(%i)\n",tp[i].def,i);
  fclose(hdr);
  strcpy(c,"BIN");
  printf("OK.\n\nWRITING TOPICFILE  %s: %i bytes ",
	 fn,(int)o+t*sizeof(word));
  if ((bin = fopen(fn,"wb"))==NULL)
  {
    printf("!!! Error opening file !!!\n");
    return 1;
  }
  for (i = 0; i<t; i++)  // Tabelle schreiben:
  {
    o = t*sizeof(word)+tp[i].ofs;  // Offset berechnen
    fwrite(&o,sizeof(o),1,bin);
  }
  for (i = 0; i<t; i++)  // Strings schreiben:
    fwrite(tp[i].top,sizeof(char),strlen(tp[i].top)+1,bin);
  fclose(bin);
  printf("OK.\n");
  return 0;  // Erfolg
}

int main(int argc, char *argv[])
{
   int i,l = 1;
  char *c;

  printf(TITLE);
  if (argc<2 || argc>3)  // Benutzungshinweis
  {
    printf("Usage: BABYLON <sourcefile> [<language>]\n");
    return 0;
  }
  for (i = 1; i<argc; i++)  // Kommandozeile lesen
  {
    c = argv[i];
    if (strlen(c)==1)  // mu"s Sprachwahl sein:
    {
      l = *c-'0';
      if (l<1 || l>9) l = 1; else continue;
    }
    c += strlen(c)-1;  // Dateiextension suchen
    while (c>argv[i] && *c!='.') c--;
    if (stricmp(c,".BAB")==0 && fn==NULL)
      fn = strdup(argv[i]);
    else
    {
      printf("!!! Invalid sourcefile \"%s\" !!!\n",argv[i]);
      return 1;
    }
  }
  printf("Selected language: %i\n\n",l);
  if (fn==NULL)
  {
    printf("!!! Missing sourcefile !!!\n",fn);
    return 1;
  }
  if ((src = fopen(fn,"rt"))==NULL)
  {
    printf("!!! Sourcefile \"%s\" not found.\n",fn);
    return 1;
  }
  l = ProcessSourceFile(l);
  if (l==0)  // OK?
    printf("\nSuccess.\n");
  else
    printf("\n!!! Error occured.\n");
  fclose(src);
  return l;
}
