/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     dlist.c                                                          *
*  Aufgabe:   Implementierung der Listen Templates. Auer fr IBM              *
*             als Inline                                                       *
*                                                                              *
\******************************************************************************/
#include "common.h"
#ifdef __IBMCPP__
 #include "dlist.h"
#endif
#ifndef INLINE
  #define INLINE
#endif

/* Name     : Dlist<T>::clear
** Task     : Lschen der Liste
*/
#ifndef __EMX__
template<class T> /*INLINE*/ void Dlist<T>::clear()
  {
  Dlink *n;

  for (Dlink *p=list; p; p=n)
     {
     n=p->next;
     delete (Tlink<T>*)p;
     } /* endfor: p */
  list=0;
  cursor=0;
  elem=0;
  } /* Dlist<T>::clear */
#endif



/* Name     : Dlist<T>::get
** Task     : ein Element holen (und lschen)
** State    : under construction
*/
template<class T> INLINE T Dlist<T>::get()
  {
  Tlink<T>* lnk=(Tlink<T>*)Blist::_get();
  T i=lnk->info;
  delete lnk;
  return i;
  } /* Dlist<T>::get */



/* Name     : Dlist<T>::qsort
** Task     : Sortieren (intern)
*/
template<class T> INLINE void Dlist<T>::qsort(int (*f)(T& t1, T& t2), int l, int r)
  {
  T v, tmp;
  int i,j;

  if (r>l)
     {
     v=(*this)[r]; i=l; j=r;

     do {
        while ( (*f)( (*this)[i],v) <0) i++;
        while ( (*f)( (*this)[j],v) >0) j--;
        if (i<=j)
           { tmp=(*this)[i]; (*this)[i]=(*this)[j]; (*this)[j]=tmp;
             i++; j--; } /* endif: i<=j */
     } while (i<=j);

     qsort(f,l,j);
     qsort(f,i,r);
     } /* endif: r>l */
  } /* Dlist<T>::qsort */
