#define INCL_DOS
#define INCL_WIN
#include <os2.h>

typedef int (* APIENTRY FnPtr)();
typedef int (* APIENTRY ActionFnPtr)(HWND frame);
typedef void *PEditor;

FnPtr *vtable;

void APIENTRY EdInitialize(void *vtbl)
  {
  vtable=vtbl;
  }

void APIENTRY ctEditInit(void *p)
  {
  EdInitialize(p);
  }

PEditor APIENTRY EdHandleFromHwnd(HWND hwnd)
  {
  return WinQueryWindowPtr(hwnd, QWL_USER);
  }

void APIENTRY EdSetColor(void *e, int color)
  {
  (*vtable[0])(e, color);
  }

void APIENTRY EdLoadFile(void *e, char *filename)
  {
  (*vtable[4])(e, filename);
  }

ActionFnPtr APIENTRY EdAddToolbarButton(void *e, ActionFnPtr p, char *s1, char *s2,
           int *id, HMODULE h, unsigned r)
  {
  return (ActionFnPtr)((vtable[1])(e, p, s1, s2, id, h, r));
  }

int APIENTRY EdAddContextMenu(void *e, int id, ActionFnPtr p, char *s1, char *s2)
  {
  return (int)((vtable[2])(e, id, p, s1, s2));
  }

ActionFnPtr APIENTRY EdAddMenuItem(void *e, int mainmenu, ActionFnPtr p, char *s1, char *s2,
           int *id, HMODULE h, unsigned r)
  {
  return (ActionFnPtr)((vtable[3])(e, mainmenu, p, s1, s2, id, h, r));
  }

void APIENTRY EdSaveFile(PEditor e)
  {
  (*vtable[6])(e);
  }

void APIENTRY EdSaveFileAs(PEditor e, char *name)
  {
  (*vtable[7])(e, name);
  }

int  APIENTRY EdGetText(PEditor e, char *buffer, int length)
  {
  return (*vtable[8])(e, buffer, length);
  }

int  APIENTRY EdGetTextOffset(PEditor e, char *buffer, int length, int offset)
  {
  return (*vtable[9])(e, buffer, length, offset);
  }

int  APIENTRY EdGetTextLine(PEditor e, char *buffer, int length, int line)
  {
  return (*vtable[10])(e, buffer, length, line);
  }

void APIENTRY EdSaveIni(PEditor e)
  {
  (*vtable[11])(e);
  }

void APIENTRY EdAddText(PEditor e, char *text)
  {
  (*vtable[12])(e, text);
  }

void APIENTRY EdAddTextOffset(PEditor e, char *text, int offset)
  {
  (*vtable[13])(e, text, offset);
  }

void APIENTRY EdAddLine(PEditor e, char *text, int line)
  {
  (*vtable[14])(e, text, line);
  }

BOOL APIENTRY EdIsChanged(PEditor e)
  {
  return (*vtable[15])(e);
  }

void APIENTRY EdClear(PEditor e)
  {
  (*vtable[16])(e);
  }

void APIENTRY EdClearAll(PEditor e)
  {
  (*vtable[17])(e);
  }

void APIENTRY EdCopy(PEditor e)
  {
  (*vtable[18])(e);
  }

void APIENTRY EdCut(PEditor e)
  {
  (*vtable[19])(e);
  }

void APIENTRY EdPaste(PEditor e)
  {
  (*vtable[20])(e);
  }

void APIENTRY EdInsert(PEditor e, char *text)
  {
  (*vtable[21])(e);
  }

void APIENTRY EdDelete(PEditor e)
  {
  (*vtable[22])(e);
  }

void APIENTRY EdUndo(PEditor e)
  {
  (*vtable[23])(e);
  }

void APIENTRY EdMarkall(PEditor e)
  {
  (*vtable[24])(e);
  }

void APIENTRY EdDisableUpdate(PEditor e)
  {
  (*vtable[25])(e);
  }

void APIENTRY EdEnableUpdate(PEditor e)
  {
  (*vtable[26])(e);
  }

void APIENTRY EdSetWordWrap(PEditor e, BOOL b)
  {
  (*vtable[27])(e,b);
  }

BOOL APIENTRY EdQueryWordWrap(PEditor e)
  {
  return (*vtable[28])(e);
  }

void APIENTRY EdSetReadOnly(PEditor e, BOOL b)
  {
  (*vtable[29])(e, b);
  }

BOOL APIENTRY EdQueryReadOnly(PEditor e)
  {
  return (*vtable[30])(e);
  }

void APIENTRY EdSetChangedFlag(PEditor e, BOOL b)
  {
  (*vtable[31])(e,b);
  }

void APIENTRY EdResetChangedFlag(PEditor e)
  {
  (*vtable[32])(e);
  }

void APIENTRY EdRemoveLine(PEditor e, int line)
  {
  (*vtable[33])(e, line);
  }

int  APIENTRY EdQueryNrOfLines(PEditor e)
  {
  return (*vtable[34])(e);
  }

void APIENTRY EdSetText(PEditor e, char *text)
  {
  (*vtable[35])(e, text);
  }

int  APIENTRY EdQueryTextLength(PEditor e)
  {
  return (*vtable[36])(e);
  }

int  APIENTRY EdQueryCurrentLine(PEditor e)
  {
  return (*vtable[37])(e);
  }

int  APIENTRY EdQueryCurrentCol(PEditor e)
  {
  return (*vtable[38])(e);
  }

int  APIENTRY EdQueryCurrentCurPos(PEditor e)
  {
  return (*vtable[39])(e);
  }

void APIENTRY EdSetCurrentLine(PEditor e, int line)
  {
  (*vtable[40])(e, line);
  }

void APIENTRY EdSetCurrentCol(PEditor e, int col)
  {
  (*vtable[41])(e, col);
  }

void APIENTRY EdSetCurrentColPos(PEditor e, int pos)
  {
  (*vtable[42])(e, pos);
  }

void APIENTRY EdSetStatusText(PEditor e, char *text)
  {
  (*vtable[43])(e, text);
  }

BOOL APIENTRY EdQueryIndent(PEditor e)
  {
  return (*vtable[44])(e);
  }

void APIENTRY EdSetIndent(PEditor e, BOOL b)
  {
  (*vtable[45])(e, b);
  }

BOOL APIENTRY EdQueryQuickmark(PEditor e)
  {
  return (*vtable[46])(e);
  }

void APIENTRY EdSetQuickmark(PEditor e, BOOL b)
  {
  (*vtable[47])(e, b);
  }

BOOL APIENTRY EdQueryToolbar(PEditor e)
  {
  return (*vtable[48])(e);
  }

void APIENTRY EdSetToolbar(PEditor e, BOOL b)
  {
  (*vtable[49])(e, b);
  }

BOOL APIENTRY EdDoAction(PEditor e, int i)
  {
  return (*vtable[50])(e, i);
  }

BOOL APIENTRY EdSearch(PEditor e, char *s)
  {
  return (*vtable[51])(e, s);
  }

void APIENTRY EdSetConditionalMenu(PEditor e, int submenuid, int defaultid)
  {
  (*vtable[52])(e,submenuid, defaultid);
  }

void APIENTRY EdSetMenuChecked(PEditor e, int id, BOOL b)
  {
  (*vtable[53])(e, id, b);
  }

int  APIENTRY EdQueryBkColor(PEditor e)
  {
  return (*vtable[54])(e);
  }

void APIENTRY EdSetBkColor(PEditor e, int color)
  {
  (*vtable[55])(e, color);
  }

int  APIENTRY EdQueryFgColor(PEditor e)
  {
  return (*vtable[56])(e);
  }

void APIENTRY EdSetFgColor(PEditor e, int color)
  {
  (*vtable[57])(e, color);
  }

void APIENTRY EdSetFontName(PEditor e, char *name)
  {
  (*vtable[58])(e, name);
  }

void APIENTRY EdSetFontSize(PEditor e, int size)
  {
  (*vtable[59])(e,size);
  }

void APIENTRY EdSetFontType(PEditor e, int type)
  {
  (*vtable[60])(e,type);
  }
