/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     action.cpp                                                       *
*  Aufgabe:   Alle Aktionen (Men oder Toolbar) werden in einer List           *
*             "verwaltet", und knnen so (potentiell) berschrieben,           *
*             redefiniert werden.                                              *
*                                                                              *
\******************************************************************************/
#include "common.h"
#pragma hdrstop
#include "debug.h"
#include "action.h"
#include "editor.h"

#ifdef __EMX__
//  Dlist<PAction> alist;
#endif

/* Name     : ActionList::append
** Aufgabe  : Eine neue Aktion hinzufgen
** Parameter: Action *p                 - Zeiger auf Action (nicht lschen!)
*/
void ActionList::append(ActionBase *p)
  {
  alist.lock();                         /* Liste schtzen */
#ifdef DEBUG
  int e=alist.elements();
#endif
  alist.append(p);                      /* Anfgen */
#ifdef DEBUG
  ensure (e+1==alist.elements());
#endif
  alist.unlock();                       /* Liste freigeben */
  } /* ActionList::append */



/* Name     : nothing
** Aufgabe  : keine :-)
** Parameter: Editor *frame             - Zeiger auf Editorobjekt
** Rckgabe : 0
*/
int APIENTRY nothing(Editor *frame)
  {
  return 0;
  } /* nothing */


ActionBase::ActionBase(char *s1, char *s2, unsigned i, HMODULE h, unsigned r)
       : entry(s1), helptext(s2), id(i), hmod(h), resid(r)
  {
  async=FALSE;
  }

int ActionBase::action(Editor *e)
  {
  DosBeep(1000,100);
  return 0;
  };

/* Name     : ActionBase::~ActionBase
** Aufgabe  : keine (vielleicht in Zukunft)
*/
ActionBase::~ActionBase()
  {
  } /* ActionBase::~ActionBase */

Action::Action(ActionFnPtr p, char *s1, char *s2, int i, HMODULE h, unsigned r)
        : do_action(p), ActionBase(s1,s2,i,h,r)
  {
  }

/* Name     : Action::~Action
** Aufgabe  : keine (vielleicht in Zukunft)
*/
Action::~Action()
  {
  } /* Action::~Action */

int Action::action(Editor *edit)
  {
  if (async)
     {
     editor=edit;
     run();
     return 0;
     }
  else
     return do_action(edit);
  }

int ActionMember::action(Editor *edit)
  {
  if (async)
     {
     editor=edit;
     run();
     return 0;
     }
  else
     return (edit->*do_action)();
  }


/* Name     : ActionMember::~ActionMember
** Aufgabe  : keine (vielleicht in Zukunft)
*/
ActionMember::~ActionMember()
  {
  } /* ActionMember::~ActionMember */

extern ActionBase *DefaultAction[];

/* Name     : ActionList::operator[]
** Aufgabe  : Zugriff auf ein Element durch berladen von operator[]
** Parameter: int id                    - Die ID der Aktion
** Rckgabe : Das Element
*/
ActionBase& ActionList::operator[](int id)
  {
  static Action defaultAction((ActionFnPtr)nothing, "", "", -1);
  ensure(id>=0);


  ActionBase *ret=&defaultAction;           /* init */

  for (int i=0; DefaultAction[i]->id; i++)
     if (DefaultAction[i]->id==id)
        return *DefaultAction[i];

  alist.lock();                            /* Liste schtzen */
  /* Liste durchgehen */
  for (void *p=alist; p; p=alist.next(p))
     {
     ensure(validread(alist(p)));
     if (alist(p)->id==id)
        {
        ret=alist(p);
        break;
        } /* endif: (*alist)(p)->id==id */
     } /* endfor: p */
  alist.unlock();                       /* Liste freigeben */

  ensure(validread(ret));
  return *ret;                          /* Rckgabe */
  } /* ActionList::operator[] */

ActionBase *ActionList::queryAction(int id)
  {
  ensure(id>=0);

  ActionBase *ret=0;           /* init */


  alist.lock();                            /* Liste schtzen */
  /* Liste durchgehen */
  for (void *p=alist; p; p=alist.next(p))
     {
     ensure(validread(alist(p)));
     if (alist(p)->id==id)
        {
        ret=alist(p);
        break;
        } /* endif: (*alist)(p)->id==id */
     } /* endfor: p */
  alist.unlock();                       /* Liste freigeben */

  if (!ret)
     {
     for (int i=0; DefaultAction[i]->id; i++)
        if (DefaultAction[i]->id==id)
           return DefaultAction[i];
     } /* endif: !ret */

  return ret;                          /* Rckgabe */
  }


/* Name     : ActionList::clear
** Aufgabe  : Die Aktionslist lschen (alle Elemente!)
*/
void ActionList::clear()
  {
  ensure(1);
#ifndef __EMX__
  alist.clear();
  ensure(alist.elements()==0);
#endif
  } /* ActionList::clear */



/* Name     : ActionList::ActionList
** Aufgabe  : Bei GCC Liste dynamisch erzeugen
*/
ActionList::ActionList()
  {
  } /* ActionList::ActionList */



/* Name     : ActionList::~ActionList
** Aufgabe  : Bei GCC Liste deleten
*/
ActionList::~ActionList()
  {
  } /* ActionList::~ActionList */

void ActionList::remove(int offset)
  {
  int elem=alist.elements();

  alist.lock();
  for (int i=0; i<alist.elements(); i++)
     {
     if (alist[i]->id>=offset)
        {
        alist.remove(i);
        elem--; i--;
        }
     }
  alist.unlock();
  }
