/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     thread.cpp                                                       *
*  Aufgabe:   Multi-Threading per Vererbung (s. Artikel)                       *
*                                                                              *
\******************************************************************************/
#include "common.h"
#include <stdlib.h>
//#include "debug.h"
#include "thread.h"
#include <process.h>

#ifndef __IBMCPP__
 #define _Optlink
#endif

typedef void (* _Optlink PFUNC)();

int threadsRunning=0;

Mutex Thread::mutex;                    // static member


/* Name     : startThread
** Aufgabe  : Dispatchen von X::threadEntry
*/
extern "C" void _Optlink startThread(void *p)
  {
  Thread *t=(Thread *)p;
  ensure(validread(p));
  threadsRunning++;
  t->threadEntry();
  --threadsRunning;
  } /* Thread::startThread */


/* Name     : Thread::run
** Aufgabe  : Thread starten (via startThread)
*/
void Thread::run()
  {
  TID tid;

  // Borland & Metaware haben den unused Parameter nicht
  #ifdef __BCPLUSPLUS__
   tid=_beginthread(startThread, 64000, this);
  #else
   tid=_beginthread(startThread, 0, 64000, this);
  #endif
  ensure(tid!=-1);
  } /* Thread::run */
