/*****************************************************************************/
/* program: system.c         * date: 29.11.94 * Autor: Hans Georg Frey       */
/*****************************************************************************/
/* Usage: Modul zur Umsetzung der Ein- und Ausgabe auf unterschiedlichen     */
/*    Betriebssystemen.                                                      */
/*                                                                           */
/****************** MODIFIED *************************************************/
/* date:*  By:   * what:                                             * Vers. */
/*****************************************************************************/
/*                                                                       1.0 */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
#include "backp.h"                             /*  Veraltetes Listing: *     */
#include "system.h"                            /******************************/
#include <ctype.h>
#include "errno.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef PC_DOS                          /* Das Programm wird auf PC Compiliert */

void n_clrscr()                        /* Fenster leeren */
{
  clrscr();
}
/******************************************************************************/
void write_str( register int x, register int y, char* s)
{                                      /* Text an Position ausgaben */
  gotoxy(x,y);
  while(*s)
    putchar(*s++);

} /* end of write_str */
/******************************************************************************/
void write_chr( register int x, register int y, char c)
{                                      /* Character an Position ausgeben */
  gotoxy(x,y);
    putchar(c);
} /* end of write_chr */
/******************************************************************************/
float NeuroZufall()
{                                      /* Zufallszahl berechnen */
  int i_temp;

  i_temp = random( 100 ) - 50;
  return( (float )i_temp/100 );
}
/******************************************************************************/
char n_GetKey()
{
  char c_Char;                         /* Tastaturpuffer leern und dann */
                                       /* abwarten bis Taste gedrueckt wird */
  while( kbhit() )
    c_Char = getch();
  c_Char = getch();
  return( c_Char );
}
/******************************************************************************/
float n_GetFloat()
{
  float d_float;

  scanf( "%f", &d_float );
  return( d_float );
}
/******************************************************************************/
int n_GetInt()
{
    int i_Int;

    scanf( "%d", &i_Int );
    return( i_Int );
}
/*******************************************************************************/
long n_GetLong()
{
  long l_Long;

  scanf( "%ld", &l_Long );
  return( l_Long );
}
/******************************************************************************/
char n_kbhit()
{
  char c;

  c = FALSE;
  if( kbhit() )
    c = TRUE;
   return( c );
}
/******************************************************************************/
void n_gotoxy( int line, int column )
{

  gotoxy( line, column );
}

#endif

/****************************************************************************/
/****************************************************************************/

#ifdef _OSK                  /* OS9 wird benutzt/ wird vom Compiler gesetzt */

  char tcapbuf[TCAPSLEN];
  char PC_;
  char *BC;
  char *UP;
  char *CL;
  char *CM;
  char *CR;
  char *NL;
  char *HO;
  short ospeed;
  int   column, line;

void DisplayInit()           /* Initialisierung der Termcap */
{

  register char *term_type, *temp;
  auto char tcbuf[1024];
  auto char *ptr;

 if(( term_type=getenv( "TERM" )) == NULL )
 {
   fprintf( stderr, "Environment Variable TERM not defined" );
   exit( 1 );
 }

 if( tgetent( tcbuf, term_type ) <= 0 )
 {
   fprintf( stderr, "Unknown terminal type %s!", term_type );
   exit( 1 );
 }

  ptr = tcapbuf;
  if( temp = tgetstr( "PC", &ptr ))
    PC_ = *temp;

  CL = tgetstr( "cl", &ptr );
  CM = tgetstr( "cm", &ptr );
  CR = tgetstr( "cr", &ptr );
  NL = tgetstr( "nl", &ptr );
  HO = tgetstr( "ho", &ptr );
  column = tgetnum( "co" );
  line   = tgetnum( "li" );
  putpad( CL );
  putpad( HO );

}
/**************************************************************************/
int tputc( char c )
{
  u_int32 i = 1;

  return _os_write( 1, &c, &i );
}
/***************************************************************************/
void putpad( char* str )
{
  tputs( str, 1, tputc );
}
/****************************************************************************/
void n_gotoxy( int line, int column )
{
  putpad( tgoto( CM, line, column ));
}
/****************************************************************************/
float NeuroZufall()
{
  return(( float) rand() /  (RAND_MAX*2) - 0.25 );
}

/****************************************************************************/
void write_str( register int x, register int y, char* s )
{
  u_int32 i = strlen( s );

  n_gotoxy( x, y );
  _os_write( 1, s, &i );
}
/****************************************************************************/
void n_clrscr( void )
{
  putpad( CL );
}
/****************************************************************************/
char n_GetKey( void )
{
  char buf[MAXLEN];
  u_int32 i = 1;

  buf[0]    = 0;
  if( _os_gs_ready( STDIN, &i ) != EOS_NOTRDY && ( i > 0 ))
    _os_read( STDIN, buf, &i );
  i = 1;
  _os_read( STDIN, buf, &i );
  return( buf[0] );
}
/******************************************************************************/
float n_GetFloat()
{
  float f_float;

  scanf( "%f", &f_float );
  getchar();
  return( f_float );
}
/******************************************************************************/
int n_GetInt()
{
    int i_Int;

    scanf( "%d", &i_Int );
    getchar();
    return( i_Int );
}
/*****************************************************************************/
long n_GetLong()
{
  return( (float )n_GetInt() ); /* Auf OS9 ist ein Int 32 Bit gross */
}
/*****************************************************************************/
char n_kbhit()
{
  char    c ;
  u_int32 i = 1;
  char    buf[MAXLEN];

  c = FALSE;
  if( _os_gs_ready( STDIN, &i ) != EOS_NOTRDY && ( i > 0 ))
  {
    _os_read( STDIN, buf, &i );
    c = TRUE;
  }
  return( c );
}

#endif
