# LOGIN.CMD: Internet via T-Online
# (c) Manfred Klee & c't 5/96

# Wenn das Modem nicht mit einem Befehl wie AT&D2
# so eingestellt werden kann, dass es bei einem 
# ON/OFF Uebergang auf der DTR Leitung auflegt, 
# dann sollte in diesem Skript die Befehlsfolge
# 
# set dtr off
# sleep 1
# set dtr on
#
# an jeder Stelle ersetzt werden durch
#
# output "+++"
# if ! [input 10 OK\n]
#   display "Modem antwortet nicht"\n
#  else
#   output "ath0"\n
# end

# Scriptparameter bitte passend einstellen!
$AnschlKennung = "123456789012"
$Kennwort = "12345678"
$Mitbenutzer = "0001"
$Modeminit = "ATZ"
$Anwahl = "ATDP01910"

echo off

# Debug-Handling initialisieren
if ![load %deb]
  %deb = 0
  save %deb
end

# Initialisierung Modem
display \nModem wird initialisiert\n
output $ModemInit\n
if ![input 2 OK\n]
  display \nModem antwortet nicht\n\7\7
  abort
end

# waehlen
display Anwahl\n 
output $Anwahl\n
input 5 \n

# Connectmeldung anzeigen
echo on
input 50 CONNECT
if ![input 30 \n]
  set dtr off
  sleep 1
  set dtr on
  display \nkein CONNECT\n\7\7
  abort
end
echo off

# Warten auf Aufforderung zur Eingabe der Dienstekennung
if ![input 20 \0]
  set dtr off
  sleep 1
  set dtr on
  display \nZentrale antwortet nicht wie erwartet\n\7\7
  abort
end

# Zentrale sofort mit Dienste- und Anschlusskennung ueberfallen
output .\r
output $AnschlKennung
display \nAnschlusskennung senden\n

# Warten auf ADE fuer Teilnehmer- oder Mitbenutzernummer
if ![input 10 \e[?25h]
  set dtr off
  sleep 1
  set dtr on
  display \nFehler.\n\7\7
  display \nZentrale antwortet nicht.\n
  abort
end

# Testen auf Freizuegigkeit.
# Wenn auch beim vierten output APF die Zentrale noch mit APF antwortet
# stand der Cursor im Feld fuer die 12-stellige Teilnehmernummer und wir
# wissen, dass der Anschluss freizuegig ist.
# Ansonsten war der Cursor im Feld fuer die 4-stellige Mitbenutzernummer und
# die Zentrale beginnt mit Aussendung der ADE fuer das Kennwort.
output \9
input 5 \e[?25h
output \9
input 5 \e[?25h
output \9
input 5 \e[?25h
output \9
input 5 H
if [expect 5 \e[?25h] # wenn also freizuegig
  # Den Rest des Feldes fuer die Teilnehmernummer ueberspringen
  output \n
else
  # Zurueck zum Feld fuer Mitbenutzernummer
  input 10 \e[?25h
  output \18
end

# Warten auf ADE fuer Mitbenutzernummer
input 10 \e[?25h

# Mitbenutzernummer senden
output $Mitbenutzer

# Warten auf ADE fuer Kennwort
input 10 \e[?25h

# Kennwort senden
display Kennwort senden\n
if len($Kennwort) < 8
  output $Kennwort\n
else
  output $Kennwort
end

# warten auf naechste ADE
if ![input 10 \e[?25h]
  set dtr off
  sleep 1
  set dtr on
  display \nFehler. Zugangsprozedur war nicht erfolgreich.\n\7\7
  display \nUeberpruefen Sie Ihre Teilnehmerdaten!\n
  abort
end

# Transparente Daten Vorwarnung abschalten
display Transparente Daten Vorwarnung abschalten\n
output *53\r

# warten auf naechste ADE
if ![input 10 \e[?25h]
  set dtr off
  sleep 1
  set dtr on
  display \nFehler.\n\7\7
  abort
end

# Internet-Uebergabeseite aufrufen
display Verbindung zum Internet wird hergestellt.\n
output *190144100\r

# warten auf ADE zur Bestaetigung der Zeittaktgebuehr
if ![input 10 \e[?25h]
  set dtr off
  sleep 1
  set dtr on
  display \nunbekannter Fehler\n\7\7
  abort
end

# Zeittakt bestaetigen
output 19

if %deb
  if ![input 5 SH015]
    set dtr off
    sleep 1
    set dtr on
    display \nVerbindungsaufbauwunsch zum Internet wird nicht bestaetigt\n\7\7
    abort
  end

  if ![input 35 Verbindung]
    set dtr off
    sleep 1
    set dtr on
    display \nInternetserver meldet sich nicht\n\7\7
    abort
  end

  if ![expect 1 " "]
    display Verbindungs
    echo on
    if ![input 2 \e]
    # dummy (input 2 \e) nur zur Ausgabe der AX6xx-Fehlermeldung
    end
    set dtr off
    sleep 1
    set dtr on
    display \nFehler beim Verbindungsaufbau\n\7\7
    abort
  end

end # if %deb

# Verbindungsaufbau zum ER abwarten
if ![input 30 OK]
  set dtr off
  sleep 1
  set dtr on
  display \nFehler bei Verbindungsaufbau\n\7\7
  display \nWahrscheinlich ist der Internetzugang ueberlastet.\n
  display \nWenn Sie es genau wissen wollen:
  display \nLogin-Script sofort noch einmal starten, um Fehler zu
lokalisieren.\n
  display \nAnsonsten warten Sie bitte eine Weile vor dem naechsten Versuch.\n
  %deb = 1
  save %deb
  abort
end

echo on

if ![input 5 \n]
  set dtr off
  sleep 1
  set dtr on
  display \nServer reagiert nicht mehr\n\7\7
  abort
end

# Zugangsart mitteilen
output WIN\r

# IP-Adresse holen
if ![input 10 YOURIP]
  set dtr off
  sleep 1
  set dtr on
  display \nServer reagiert nicht mehr\n\7\7
  abort
end

address 3

# alle Statusmeldungen des ER abwarten
if ![input 120 \n.\n]
  set dtr off
  sleep 1
  set dtr on
  display \nServer reagiert nicht mehr\n\7\7
  abort
end
if ![input 120 \n.\n]
  set dtr off
  sleep 1
  set dtr on
  display \nServer reagiert nicht mehr\n\7\7
  abort
end
output OK\r

# Verbindungsaufbau war erfolgreich
display \nVerbindung hergestellt.\n\7

if %deb
  %deb = 0
  save %deb
end

# Uebergang in SLIP-Modus und Skript verlassen
online

# Ende

