;*************************************************************************
;Programm Distort.ASM fr Framework-Modul *_FRM.ASM
;DSP-Verzerrer von Carsten Meyer (c) 5/96
;Simuliert Rhren/Ausgangsbertragerkennlinie
;
;Registerbelegung:
;r0			= linearer Universal-Pointer
;
;r6			= Variablen-Stack (*ISR.ASM)
;        n6	= Dauer-0 (RJ_ISR.ASM)
;
;Bedienpanel bei Stand-Alone-Betrieb mit EVM: Host-Port B (J7)
;
;PB7 PB6 PB5 PB4 PB3 PB2 PB1 PB0  oder SLIDER PortBits bei ROMEO
;------------------------###-###--Modifiers (beeinfl. Prog.lauf direkt)
;------------###-###-###----------Parameter-Setup-Nr. 0..7
;###-###-###----------------------Prozedur-Nr. (optional) 0..7
;###-###-###-###-###-###----------bertragen in LastPortBits
;
;Pull-Up-Widerstnde 10k an allen Pins von J7 nach +5V und ggf.
;Eingangschutzdioden nicht vergessen!
;*************************************************************************

;bedingte Assemblierung - diese Konstanten MSSEN gesetzt sein!
ROMEO	equ	0		;1 fr Romeo, 0 fr EVM
EVM		equ	!ROMEO	;immer das Gegenteil (nicht ndern)
DEBUG	equ 0       ;verwendet n7 als Zhler fr Restzyklen in *_FRM.ASM
EPROM	equ 0		;normal 0, 1 fr Boot aus EPROM ($C000)
					;(nur ntig bei Programmen mit mehr als 512 Worten)

	IF ROMEO
		include 'RJ_FRM.ASM'
	ELSE
		include 'EVM_FRM.ASM'
	ENDIF

;Pseudo-Konstanten fr Stand-Alone-Betrieb,
;bei ROMEO auch "Schieberegler" vom Host
;maximal 16 Worte:
			org x:SLIDER
Soften		ds	1		;Limiter-Softness
Steilheit	ds	1		;Limiter-Steilheit
SliderBits	ds	1		;Bedienpanel-Simulation (nicht bei EVM)
BegrEinsatz	ds	1		;Limiter-Einsatz

;Vier Werte fr Levelanzeige (IN/OUT) bei ROMEO kommen
;ab LEVEL0 von RJ_ISR.ASM
;weitere Variablen, die in ROMEO-Pegelanzeige erscheinen sollen
;(max. 12 Worte) folgen. Bei EVM normale Ablaufvariablen
			org	x:LEVEL
PosMaxInp	ds	1		;Speicher fr maximalen Eingangspegel
NegMaxInp	ds	1
PosLimit	ds	1		;Speicher fr Limiter-Wert
NegLimit	ds	1

;User-Ablaufvariablen. Unter $3F short-adressiert!
			org	x:VARS
PortBits		ds	1	;Panel-Abbild, bei ROMEO SliderBits-Kopie
ModBit0	equ 0
ModBit1	equ 1
LastPortBits	ds	1	;Merker fr Panel
ParamSet		ds	1	;aktiver Parameter-Satz, Index 0..7
						;(fr Standalone-Betrieb)
ProcNum			ds	1	;aktives Programm, Index 0..7
						;(optional, fr Standalone-Betrieb)

;*************************************************************************
;Hauptroutine, wird einmal pro eingetroffenem Sample-Paar aufgerufen
;*************************************************************************

;in der Hauptschleife aus *_FRM.ASM heraus aufgerufen

		org p:
process_stereo

Distort
		move	x:BegrEinsatz,a
		move	a,x1
		neg		a
		move	a,x0
		move	x:RX_BUFF_BASE,a	;links abholen
;Modifier Bit 0 (PB0) abfragen: Effekt eingeschaltet?
		jclr 	#ModBit0,x:PortBits,DistortEnd
Limit
		cmp		x1,a	x:Steilheit,y1	;a-x1
		jle		NotPosLim
		sub		x1,a
		move	a,y0
		mpy		y0,y1,a
		add		x1,a
NotPosLim
		cmp		x0,a
		jge		NotNegLim
		sub		x0,a
		move	a,y0
		mpy		y0,y1,a
		add		x0,a
NotNegLim

Softener
;Abrunden der Begrenzungs-Ecken durch negatives Kubik
		move	a,y0
		mpy		y0,y0,a					;Quadrat bilden
		move	a,y1
		mpy		-y0,y1,a 	x:Soften,x1	;Faktor
		move	a,x0
		mpy		x0,x1,a
		rep		#3         ;mach mehr draus
		asl		a
		add		y0,a

DistortEnd
		move	a,x:TX_BUFF_BASE			;links ablegen
		move	a,x:TX_BUFF_BASE+1			;rechts ablegen

;Bedienpanel, Schalter usw. abfragen, Parameter setzen

Panel
	IF ROMEO
;einmalige Regler-Behandlung
		jclr 	#SLIDER_NEW,x:FLAGS,PanelExit	;schon behandelt?
		bclr 	#SLIDER_NEW,x:FLAGS				;Nein: Flag lschen
;hier ggf. irgendwelche Aktionen, die nur einmalig
;bei Reglernderung auszufhren sind, einfgen

		move	x:SliderBits,a

;bei EVM:Bedienpanel abfragen und Bits maskieren
	ELSE
		movep	x:PBD,a         ;Schalter am Host-Port B
		neg 	a   #>$ff,x0    ;a invertieren (neg/dec!)
		dec		a
		and		x0,a1	n6,a2	;Port-Byte maskieren, Rest nullen
	ENDIF
		move	a1,x:PortBits
;in PortBits befinden sich gepackt SoundProc, ParamSet und Modifiers
		move	#>$ff-3,x0
		and		x0,a	n6,a0
		move	x:LastPortBits,x0
		cmp		x0,a
		jeq     <PanelExit  	;nderung seit letztem Durchlauf?
		move	a1,x:LastPortBits
		move	a,x1
		move	#>$07,x0
		asr		a
		asr		a               ;ausrichten auf Bit 0 bis 2
		and		x0,a            ;Setup-Schalter-Bits maskieren
		move	a1,x:ParamSet   ;fr Tabellen-Index 0..7
		move	x1,a
		rep		#5              ;ausrichten
		asr		a               ;Programmwahl-Schalter-Bits shiften
		and		x0,a			;und maskieren
		move	a1,x:ProcNum    ;0..7 (optional)
SetupParam
	IF EVM
;Parametersatz (Regler/SLIDER) fr Stand-alone-Betrieb aufsetzen
;bei ROMEO ohne Bedeutung, da Regler vom Host bermittelt werden
		move	n6,r0
		move	x:ParamSet,a
		rep	#4                      ;Index*16=Eintrag-Adresse
		asl		a
		move	#Distort_Params,x0	;Basisadresse hinzuadd.
		add		x0,a
		do	#16,EndParamLoop
		move	a1,n0
		nop
		movem 	p:(r0+n0),x0
		move	#SLIDER,n0
		nop
		move	x0,x:(r0+n0)
		move	(r0)+
EndParamLoop
	ENDIF
PanelExit
		rts

;*************************************************************************
;programmspezifische Initialisierungen
;*************************************************************************

;vor der Hauptschleife aus *_FRM.ASM heraus aufgerufen

user_init
	IF ROMEO
		move	x:SliderBits,a     	;Schalter am Host-Port B
	ELSE
		movep	#0,x:PBC			;Host I/F aus
		movep	#>$ff00,x:PBDDR		;H0..7 = PB0..7 als Eingnge
		movep	#>$ffff,x:PBD
		nop
		movep	x:PBD,a         	;Schalter am Host-Port B
	ENDIF
		neg		a
		move	a,x:LastPortBits	;Anfangs-Schalterstellung ungleich
		jsr		Panel
		move	#>0,a
		move	a,x:PortBits
		move 	a,n6
		move	a,r0
		rts

;*************************************************************************
;Subroutinen und Kleinkram
;*************************************************************************

;ROMEO-Indikator-LED
	IF ROMEO
LampeAn
		movep	x:PCD,a
		move	#>$010,x0
		or	x0,a
		movep	a,x:PCD			;PortBits anznden
		rts

LampeAus
		movep	x:PCD,a
		move	#>$fef,x0
		and	x0,a
		movep	a,x:PCD			;PortBits lschen
		rts
	ENDIF

;------------------------------------------------------------------------

;Parameterstze fr EVM-Betrieb, mit PB2 bis PB4 ausgewhlt
;im P:RAM, bequemerweise mit ROMEO ermittelt
;immer 16 Wrter lang!

Distort_Params
;PB4 PB3 PB2
; 0   0   0
Set1	dc  	0.8
		dc  	0.3
		dc		0
		dc		0.35
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0

;PB4 PB3 PB2
; 0   0   1
Set2	dc  	0.9
		dc  	0.1
		dc		0
		dc		0.3
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0
		dc		0

;------------------------------------------------------------------------

LastUsedAdr  equ	*
;Lnge ausgeben. Wenn >512, EPROM auf 1 setzen und ggf. Lngen in der
;EPROMBoot-Routine (siehe *_FRM.ASM) anpassen
		msg	"Ende bei PC=",LastUsedAdr," (dez.)"
		end
