;*************************************************************************
;
;Framework fr Romeo&Julia-Projekt
;I/O: SSI Interrupt mit 32 Bit Wortlnge bei ROMEO
;
;Registerbelegung:
;r6			= Variablen-STACK (RJ_ISR.ASM)
;n6			= Dauer-0 (RJ_ISR.ASM)
;
;*************************************************************************

;ab hier mglichst nichts mehr ndern
;Variablen-Platz zuteilen.
;Im Zweifel LST-File konsultieren, um berschneidungen zu vermeiden!

SLIDER	equ 	$0      ;Reserviert fr ROMEO-Regler-Parametersatz (16 Worte)
LEVEL0	equ		$10		;4 Worte fr TX/RX_BUFFer reserviert (I/O-Pegel)
LEVEL	equ		$14		;bis $1F fr Pegelanzeige
ISRV0	equ		$20     ;5 Worte fr ISR-Variablen reserviert
VARS	equ		$26     ;"schnelle" (<$3F) Laufzeit-Variablen
STACK   equ		$60     ;Variablen-Stack, u.a. fr ISR, wchst nach oben

START   EQU     $40
BOOT	EQU		$26		;Boot-Programm belegt Host-Vektoren (nicht benutzt)

;Steht im 128er Boot-EPROM (Base $8000) wg. Adrespiegelung auch an $C000
		org     p:$0
	IF EPROM
		jmp		BOOT
	ELSE
		jmp     START
	ENDIF

;Interrupt-Vektoren
		org     p:$000c
		jsr     ssi_rx_isr      ;SSI receive data
		jsr     ssi_rx_isr      ;SSI receive data with exception
		jsr     ssi_tx_isr      ;SSI transmit data
		jsr     ssi_tx_isr      ;SSI transmit with exception

;Host-Command-Vektoren
		org 	p:$24
		jsr 	HRegler			;fr SLIDER
		org 	p:$28
		jsr 	HLevel          ;fr Pegeldaten

;------------------------------------------------------------------------

;Booten aus EPROM. Evt. ntig, weil Boot-Loader im 56K nur 512 Worte ldt.
;Die werden gerade abgearbeitet, drfen deshalb nicht berschrieben werden
;Adressen und Lngen nderbar. Konvertierung mit SREC -B nicht vergessen!

	IF EPROM
		opt	now	;wg. berschriebenen Host-Interrupt-Bereich
DSPDest	equ		START	          	;Programmbeginn im P:RAM
ROMBase	equ		$8000				;EPROM-Anfang im EVM56K-Adressraum
ROMBoot	equ		$C000				;Boot-Startadresse des 56K
ROMLng	equ		$2000-DSPDest*3		;8 KBytes ROM = 2,6 KBytes DSP-Prog.
ROMAdr	equ		ROMBoot+DSPDest*3	;*3 wg. 3 Bytes/Wort im EPROM

		org p:BOOT
EPROMBoot
		ori 	#3,mr           ;mask interrupts
		movep   #$00F0,x:BCR    ;15 waits for EPROM
		move	#DSPDest,r0
		move	#(ROMAdr),r1
		move	#ROMLng,x0
		do		x0,BootLp1
		do		#3,BootLp2
		movem	p:(r1)+,a2
		rep	#8
		asr a
BootLp2	movem	a1,p:(r0)+
BootLp1
		jmp		START
		opt	w
	ENDIF

;------------------------------------------------------------------------

;Initialisierung laut Motorola
		org     p:START
Reset
		ori 	#3,mr           ;mask interrupts
		movec   #0,sp           ;clear hardware STACK pointer
		move    #0,omr          ;operating mode 0
		move    #STACK,r6		;initialise stack pointer
		move    #-1,m6          ;linear addressing
		movep   #0000,x:BCR     ;no Waitstates after bootstrap

;Codec- und SSI-Initialisierung
		include 'rj_init.asm'

;User-Initialisierung zuletzt:
		jsr		user_init

;*************************************************************************
;Hauptschleife
;*************************************************************************

loop_1
	IF DEBUG
		move	(r7)+			;Restzyklen fr Debug
	ENDIF
		jclr  	#SAMPLE_OK,x:FLAGS,loop_1	;Sample fertig?
		bclr 	#SAMPLE_OK,x:FLAGS
		jsr     process_stereo  ;Klangbearbeitung
	IF DEBUG
		move	r7,n7           ;Restzyklen in n7 sichern
		move	n6,r7			;Restzyklen auf 0
	ENDIF

;16 Pegelwerte ausgeben (pro Sample einer), wenn angefordert
		move    r0,x:(r6)+      ;Save r0 to the stack
		move    n0,x:(r6)+
		move 	x:LEVEL_IDX,r0
		move	#LEVEL0,n0      ;Offset
		jset 	#4,r0,LevExit	;wenn Index r2 >15, bergehen
		jclr 	#1,x:HSR,LevExit ;oder wenn HTDE nicht gesetzt
		movep	x:(r0+n0),x:HTX	;24-Bit-Wert an Host
		move	(r0)+
		move 	r0,x:LEVEL_IDX
LevExit move    x:-(r6),n0      ;Restore n0
		move    x:-(r6),r0      ;Restore r0
		jmp     loop_1

;Interrupt-Service-Routinen einbinden
		include 'rj_isr.asm'
