unit Fperfrmu;  { 05-OKT-96 as  (Arne Schpers) }
{ TFastTimer vs. TTimer. Beide Timer sind auf 1 msec gesetzt. }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes,
  Graphics, Controls, Forms, Dialogs, StdCtrls, ExtCtrls,
  mmSystem, Ftimer;

type
  TFPerfForm = class(TForm)
    lFastCount: TLabel; { Alle Eigenschaften auf den }
    lStdCount: TLabel;  { Standardvorgaben belassen }
    bStart: TButton;        { "Start", wechselt auf "Stop" }
    cActualizeLabels: TCheckBox;  {" Anzeige alle 1 ms..." }
    FastTimer1: TFastTimer;  { Interval: 1 }
    Timer1: TTimer;          { dito }
    procedure FastTimer1Timer(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure bStartClick(Sender: TObject);
  private
    StdCounter, FastCounter: LongInt;
    StartTime: LongInt;
    procedure ShowResult(Counter: LongInt; Lbl: TLabel);
  end;

var
  FPerfForm: TFPerfForm;

implementation

{$R *.DFM}

{ Ausgabe des Zhlerstands und der Event-Rate ber das
  jeweilige Label }
procedure TFPerfForm.ShowResult(Counter: LongInt; Lbl: TLabel);
begin
  Lbl.Caption := 'Zhler: '+IntToStr(Counter) +
     ', Events/sec: ' +
     IntToStr((Counter*1000) div (timeGetTime-StartTime));
end;

procedure TFPerfForm.FastTimer1Timer(Sender: TObject);
begin
  Inc(FastCounter);
  { Label bei jedem Timer-Event aktualisieren? }
  if cActualizeLabels.Checked
    then ShowResult(FastCounter,lFastCount);
  FastTimer1.Enabled := True;
end;

procedure TFPerfForm.Timer1Timer(Sender: TObject);
begin
  Inc(StdCounter);
  ShowResult(StdCounter,lStdCount);
  { Label nur 18 mal pro Sekunde aktualisieren? }
  if not cActualizeLabels.Checked
    then ShowResult(FastCounter,lFastCount);
end;

procedure TFPerfForm.bStartClick(Sender: TObject);
begin
  if bStart.Caption = 'Start' then
  begin
    bStart.Caption := 'Stop';
    FastCounter := 0; StdCounter := 0;
    StartTime := timeGetTime;
    Timer1.Interval := 1; FastTimer1.Interval := 1;
    Timer1.Enabled := True; FastTimer1.Enabled := True;
  end else
  begin
    bStart.Caption := 'Start';
    Timer1.Enabled := False;
    FastTimer1.Enabled := False;
  end;
end;

end.
