unit FTBouncu; { 03-OKT-96 as }
{ TFastTimer vs. PeekMessage-Schleife am Beispiel
  einer greren Zahl bewegter Objekte.
  Jedes Objekt hat eigene Bewegungsvektoren UND ein
  eigenes Zeitraster.
}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes,
  Graphics, Controls, Forms, Dialogs, StdCtrls,
  mmSystem, Menus, ExtCtrls, FTimer;

type { Ein bewegtes Objekt in einem eigenen Fensterchen }
  TBallWindow = class(TCustomControl)
  private
    XPos, YPos: Integer;   { aktuelle Position des Kltzchens }
    dX,dY: Integer;        { Bewegungsvektoren }
    BallColor: TColor;     { Ballfarbe }
    BallSizeX, BallSizeY: Integer;    { Ballgre }
    BallKind: Integer;     { Art der Figur }
    FBallBMP: TBitmap;     { Figur auf Hintergrund }
  protected
    { Pat die Objektgre an die Fenstergre an }
    procedure SetBounds(ALeft, ATop,
                 AWidth, AHeight: Integer); override;
    procedure Paint; override;
    procedure WMEraseBkGnd(var Msg: TWMEraseBkGnd);
                                 message WM_ERASEBKGND;
    { Wird via Timer bzw. PeekMessage-Schleife aufgerufen;
      if (NextMove < CurrentTime) -> nchste Bewegung }
    procedure CheckMove(CurrTime: LongInt);
  public
    NextMove: LongInt;  { Zeitpunkt der nchsten Bewegung }
    TimeStep: LongInt; { Pause zwischen Bewegungen in msec }
    constructor Create(AOwner: TComponent);
    destructor Destroy; override;
  end;

{ Menstruktur
+         -         ?     Timing     Speed++  Speed-- Time-Atom
                          PeekMessage                 1 msec
                          FastTimer (checked)         ...
                          OnIdle                      5 msec

mAddBalls mDelBalls mHelp mTiming mSpeedUp mSlowDown  mAtom
                          mPeekMessage                mTAtom1
                          mFastTimer                  ...
                          mIdleTiming                 mTAtom5
}

  TBState = (sPeek, sTimer, sIdle);  { die drei Mglichkeiten }

  TBounceForm = class(TForm)
    FastTimer1: TFastTimer; { 1 msec, Steuerung der Bewegung }
    CaptionTimer: TTimer; { 200 msec, aktualisiert Titelleiste }
    MainMenu1: TMainMenu;
    mAddBalls: TMenuItem;  { "+": mehr Objekte}
    mDelBalls: TMenuItem;  { "-": weniger Objekte }
    mHelp: TMenuItem;
    mTiming: TMenuItem;    { "Timing" }
    mPeekMessage: TMenuItem;{ "PeekMessage" -> menuTimingClick }
    mFastTimer: TMenuItem; { "FastTimer"    -> menuTimingClick }
    mIdleTiming: TMenuItem; { "OnIdle"      -> menuTimingClick }
    mSpeedUp: TMenuItem;   { "Speed++" : TimeStep(s) div 2 }
    mSlowDown: TMenuItem;  { "Speed--" : TimeStep(s) * 2 }
    mAtom: TMenuItem;      { "Time-Atom" }
    mTAtom1: TMenuItem;    { "1 msec" -> mTimeAtomClick }
    mTAtom2: TMenuItem;    { "2 msec" -> mTimeAtomClick }
    mTAtom3: TMenuItem;    { "3 msec" -> mTimeAtomClick }
    mTAtom4: TMenuItem;    { "4 msec" -> mTimeAtomClick }
    mTAtom5: TMenuItem;    { "5 msec" -> mTimeAtomClick }
    procedure mAddBallsClick(Sender: TObject);  { "+" }
    procedure mDelBallsClick(Sender: TObject);  { "-" }
    procedure mHelpClick(Sender: TObject);      { "?" }
    { "PeekMessage", "FastTimer", "OnIdle" }
    procedure menuTimingClick(Sender: TObject);
    procedure mSpeedUpClick(Sender: TObject);  { "Speed++" }
    procedure mSlowDownClick(Sender: TObject); { "Speed--" }
    procedure mTimeAtomClick(Sender: TObject); { "x msec" }

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject;
                             var CanClose: Boolean);
    procedure FastTimer1Timer(Sender: TObject); { 1 msec-Takt }
    procedure CaptionTimerTimer(Sender: TObject); { 0.2s-Takt }
  private
    BallWindows: TList;   { Items: TBallWindow }
    FRowSize: Integer;    { = Sqrt(BallWindows.Count) }
    TimeCount, StartTime: LongInt;
    CloseRequest: Boolean;  { fr die PeekMessage-Schleife }
  protected
    procedure SetRowSize(Value: Integer); { BallWindows ++/-- }
    procedure DoPeekMessageLoop;  { PeekMessage-Schleife }
    procedure ResetTimeStats;  { (Re-)Init der Zeiterfassung }
    procedure OnIdle(Sender: TObject; var Done: Boolean);
  public
    TimeAtom: Integer;   { minimaler Zeitschritt }
    TimeState: TBState;  { Auswahl zwischen den drei Methoden }
    property RowSize: Integer read FRowSize write SetRowSize;
  end;

var
  BounceForm: TBounceForm;
implementation

{$R *.DFM}

procedure TBounceForm.FormCreate(Sender: TObject);
begin
  TimeState := sTimer;
  Application.OnIdle := OnIdle;
  { Start mit Time-Atom = 5 msec }
  mTimeAtomClick(mAtom.Items[4]);
  FastTimer1.Interval := TimeAtom;
  BallWindows := TList.Create;
  RowSize := 1;  { 1 Objekt -> 1 Fenster }
end;

procedure TBounceForm.FormDestroy(Sender: TObject);
begin
  BallWindows.Destroy;  { Fenster rumen sich von selbst ab }
end;

{ XRef: FormCreate, Mens "+" und "-", FormResize }
procedure TBounceForm.SetRowSize(Value: Integer);
var x, TargetCount: Integer; NewWnd: TBallWindow;
    WndWidth, WndHeight, XPos, YPos: Integer;
begin
  if FRowSize <> Value then
  begin
    { berzhlige Fenster abrumen bzw. neue Fenster
      erzeugen (entweder/oder) }
    FRowSize := Value; TargetCount := FRowSize*FRowSize;
    for x := BallWindows.Count-1 downto TargetCount do
    begin  { berzhlige Fenster raus }
      TBallWindow(BallWindows.Items[x]).Free;
      BallWindows.Delete(x);
    end;
    for x := BallWindows.Count to TargetCount-1 do
    begin  { zustzliche Fenster dazu }
      NewWnd := TBallWindow.Create(Self);
      NewWnd.Parent := Self;
      BallWindows.Add(NewWnd);
      mSpeedUp.Enabled := True;
      mSlowDown.Enabled := True;
    end;
  end;
  { Alle Fensterchen gleichmig anordnen }
  WndWidth := ClientWidth div RowSize;
  WndHeight := ClientHeight div RowSize;
  XPos := 0; YPos := 0;
  for x := 0 to BallWindows.Count-1 do
  begin
    TBallWindow(BallWindows.Items[x]).SetBounds(
                                 XPos,YPos,WndWidth,WndHeight);
    Inc(XPos,WndWidth);
    if XPos+WndWidth > ClientWidth then
    begin  { nchste "Fensterzeile" }
      XPos := 0; Inc(YPos,WndHeight);
    end;
  end;
  { Zhler zurcksetzen (bei Resize und +/-) }
  ResetTimeStats;
end;

procedure TBounceForm.FormResize(Sender: TObject);
begin
  SetRowSize(RowSize); { Fensterchen gleichmig verteilen }
end;

{ Ausschlielich fr die Anzeige in der Titelleiste }
procedure TBounceForm.ResetTimeStats;
begin
  StartTime := timeGetTime; TimeCount := 0;
end;

{ Anzeige der Aktualisierungszyklen in der Titelleiste.
  Aufrufen ber einen Standard-Timer mit beliebigem
  Zeitraster (200 msec oder so) }
procedure TBounceForm.CaptionTimerTimer(Sender: TObject);
const
  TimeKind: Array[TBState]of PChar =
    ('MessageLoop','FastTimer','Idle');
  Plural: Array[False..True] of PChar = ('','e');
begin  { Manche Sachen gehen in C eben doch einfacher (seufz) }
  Caption := Format('%s: %d Objekt%s, %d Durchlufe/s',
  [TimeKind[TimeState],BallWindows.Count, Plural[RowSize>1],
  (TimeCount*1000) div (timeGetTime-StartTime+1)]);
end;

{ --------------- Menpunkte  ----------------------}
procedure TBounceForm.mAddBallsClick(Sender: TObject);
begin  { Men "+" }
  if RowSize < 8 then RowSize := RowSize+1;
end;

procedure TBounceForm.mDelBallsClick(Sender: TObject);
begin  { Men "-" }
  if RowSize > 1 then RowSize := RowSize-1;
end;

procedure TBounceForm.mHelpClick(Sender: TObject);
begin { Men "?" }
  ShowMessage('"Hilfestellung". Wesentlicher Punkt: ' +
      'PeekMessage-Schleife bleibt bei '+
      'jeder Art von modalen Dialogen stehen.');
end;

procedure TBounceForm.menuTimingClick(Sender: TObject);
var x: Integer;
begin
  { Keine Zustandsvernderung? Raus hier }
  if (Sender as TMenuItem).Checked then Exit;
  { Hkchen umsetzen }
  TimeState := TBState(mTiming.IndexOf(Sender as TMenuItem));
  for x := 0 to 2 do
    mTiming.Items[x].Checked := x = Ord(TimeState);

  FastTimer1.Enabled := False;
  ResetTimeStats;  { Zhler-Anzeige auf 0 zurck }
  case TimeState of
    sPeek:
      begin
        DoPeekMessageLoop;
        if CloseRequest then Close;
      end;
    sTimer: FastTimer1.Enabled := True;
    sIdle: ;
  end;
end;

{ Zeitraster aller Objekte / 2. Minimalwert ist 1 }
procedure TBounceForm.mSpeedUpClick(Sender: TObject);
var x: Integer; MoreSpeed: Boolean;
begin
  MoreSpeed := False;
  for x := 0 to BallWindows.Count-1 do
   with TBallWindow(BallWindows.Items[x]) do
     if TimeStep >= 2 then
     begin
       TimeStep := TimeStep div 2;
       MoreSpeed := True;
       Invalidate;
     end;
  mSpeedUp.Enabled := MoreSpeed;
  mSlowDown.Enabled := True;
end;

{ Zeitraster aller Objekte * 2. Objekte mit Raster 0
  bleiben unverndert (recht instruktiver Fehler) }
procedure TBounceForm.mSlowDownClick(Sender: TObject);
var x: Integer; LessSpeed: Boolean;
begin
  LessSpeed := False;
  for x := 0 to BallWindows.Count-1 do
    with TBallWindow(BallWindows.Items[x]) do
      if (TimeStep <> 0) and (TimeStep < 128) then
      begin
        TimeStep := TimeStep * 2;
        LessSpeed := True;
        Invalidate;
      end;
  mSpeedUp.Enabled := True;
  mSlowDown.Enabled := LessSpeed;
end;

procedure TBounceForm.mTimeAtomClick(Sender: TObject);
var x: Integer;
begin
  { Men "Time-Atom" abklappern und Hkchen setzen. Setzt
    voraus, da die Eintrge von 1 msec ... 5 msec durchlaufen }
  TimeAtom := mAtom.IndexOf(Sender as TMenuItem)+1;
  with mAtom do
    for x := 0 to Count-1 do
     Items[x].Checked := x = TimeAtom-1;
  ResetTimeStats;
end;

{ ------- FastTimer, PeekMessage- und Idle-Schleife ---------- }

procedure TBounceForm.FastTimer1Timer(Sender: TObject);
var x: Integer; CurrTime: LongInt; NewInterval: LongInt;
begin
{$IFDEF KAMIKAZE}
  FastTimer1.Enabled := True;  { Timer sofort wieder anwerfen }
  if FastTimer.PendingEvents > 0 then ... (rekursiver Einstieg)
  { Beim einfachen linearen Abradeln der Fensterliste wird
    das zwischenzeitliche Hinauswerfen von Fenstern nicht
    bercksichtigt & es kommt alles mgliche durcheinander. }
{$ENDIF}
  Inc(TimeCount);  { nur fr die Anzeige }
  { Smtliche Fenster der Reihe nach prfen lassen, ob die
    nchste Bewegung fllig ist (NextMove <= CurrTime) }
  CurrTime := timeGetTime;
  for x := 0 to BallWindows.Count-1 do
    TBallWindow(BallWindows.Items[x]).CheckMove(CurrTime);

  { Adaptive Zeitmessung }
  NewInterval := CurrTime+TimeAtom-timeGetTime;
  if NewInterval < 1 then NewInterval := 1;
  FastTimer1.Interval := NewInterval;
  { Timer bitte erst NACH Ausfhrung aller Aktionen wieder an }
  FastTimer1.Enabled := True;
end;

procedure TBounceForm.FormCloseQuery(Sender: TObject;
                                var CanClose: Boolean);
begin
  CloseRequest := True;
end;

procedure TBounceForm.DoPeekMessageLoop;
var x: Integer; CurrTime: LongInt;
begin
  { So lange nicht wieder per Men auf FastTimer
    zurckgewechselt oder das Schlieen des Fensters
    angefordert wird: }
  while (TimeState = sPeek) and not CloseRequest do
  begin
    Inc(TimeCount);  { nur fr die Anzeige }
    CurrTime := timeGetTime;
    for x := 0 to BallWindows.Count-1 do
      TBallWindow(BallWindows.Items[x]).CheckMove(CurrTime);

    { Warten auf das Ende der aktuellen Periode }
    repeat
       { PeekMessage und Ausfhrung, wenn etwas anliegt }
       Application.ProcessMessages;
    until timeGetTime >= CurrTime+TimeAtom;
  end;

  if CloseRequest then Close;
end;

procedure TBounceForm.OnIdle(Sender: TObject; var Done: Boolean);
var x: Integer; CurrTime: LongInt;
begin
  if TimeState <> sIdle then Exit;
  Done := False;  { Endlos-Wiederholung, bitte }
  Inc(TimeCount);  { nur fr die Anzeige }
  CurrTime := timeGetTime;
  for x := 0 to BallWindows.Count-1 do
    TBallWindow(BallWindows.Items[x]).CheckMove(CurrTime);
  { Wenn sich hier jetzt ein Zeitraster einstellen liee,
    wre die Welt schon fast perfekt. }
end;

{ --------------Objekt-Fensterchen -------------------- }

constructor TBallWindow.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  XPos := 0; YPos := 0;
  dX := Random(2)-1; dY := Random(2)-1;
  if (dX = 0) and (dY = 0) then dX := 1;
  BallColor := RGB(Random(256),Random(256),Random(256));
  FBallBMP := TBitmap.Create;
  BallKind := Random(4);
  TimeStep := Random(10);  { "+ 0" }
  Canvas.Brush.Style := bsClear;
end;

destructor TBallWindow.Destroy;
begin
  FBallBMP.Free;
  inherited Destroy;
end;

procedure TBallWindow.WMEraseBkGnd(var Msg: TWMEraseBkGnd);
begin { Abgeklemmt. Hintergrund wird in Paint gezeichnet }
  Msg.Result := 1;
end;

procedure TBallWindow.Paint;
begin
  with Canvas do
  begin
    TextOut(0,0,IntToStr(TimeStep));
    Draw(XPos,YPos,FBallBMP);
    { Objekt-Bitmap aus dem Update-Bereich raus }
    ExcludeClipRect(Handle,XPos,YPos,
                           XPos+BallSizeX,YPos+BallSizeY);
  end;
  { Hintergrund. Gezeichnet wird nur das echte Update-Rect
    minus dem zuvor ausgeclippten Objekt-Bitmap }
  FillRect(Canvas.Handle,          { ParentColor }
      Rect(0,0,Width,Height),Parent.Brush.Handle);
  { Gesamte Fensterflche wieder zum Zeichnen freigeben }
  SelectClipRgn(Canvas.Handle,0);
  { Zeitschrittweite in der linken oberen Ecke }
  Canvas.TextOut(0,0,IntToStr(TimeStep));
end;

procedure TBallWindow.CheckMove(CurrTime: LongInt);
var NewX, NewY: Integer; InvRect: TRect;
begin
  if CurrTime < NextMove then Exit;
  { Ungltiges Rechteck an alter Position des Objekt-BMPs }
  InvRect := Rect(XPos,YPos,XPos+BallSizeX,YPos+BallSizeY);
  InvalidateRect(Handle,@InvRect,False);
  { Neue Position, ggf. Umkehrung der Bewegungsrichtungen }
  NewX := XPos+dX;
  if (NewX < 0) or (NewX+BallSizeX > Width) then dX := -dX
       else XPos := NewX;
   NewY := YPos+dY;
   if (NewY < 0) or (NewY+BallSizeY > Height) then dY := -dY
     else YPos := NewY;
   { Ungltiges Rechteck an neuer Position des Objekt-BMPs }
  InvRect := Rect(XPos,YPos,XPos+BallSizeX,YPos+BallSizeY);
  InvalidateRect(Handle,@InvRect,False);
  Update;  { -> Paint }
  { Zeitpunkt der nchsten Bewegung }
  NextMove := CurrTime+TimeStep;
end;

{ XRef (indirekt): Zustzliche Objekte und Vernderung der
  Gre des Parent-Fensters }
procedure TBallWindow.SetBounds(ALeft, ATop,
                                AWidth, AHeight: Integer);
begin
  inherited SetBounds(ALeft,ATop,AWidth,AHeight);
  BallSizeX := AWidth div (Random(6)+3);   { minimal div 3, }
  BallSizeY := AHeight div (Random(6)+3);  { maximal div 8 }
  NextMove := 0;  { = sofort }
  if XPos+BallSizeX > AWidth then XPos := AWidth-BallSizeX;
  if YPos+BallSizeY > AHeight then YPos := AHeight-BallSizeY;
  with FBallBMP do
  begin
    Width := BallSizeX; Height := BallSizeY;
    FillRect(Canvas.Handle,Rect(0,0,Width,Height),
       Parent.Brush.Handle); { ParentColor }
    Canvas.Brush.Color := BallColor;
    Canvas.Pen.Style := psClear;
    case BallKind of
     0: Canvas.Ellipse(0,0,Width,Height);
     1: Canvas.Rectangle(0,0,Width,Height);
     2: Canvas.Polygon([Point(Width div 2,0),
                         Point(Width,Height),Point(0,Height)]);
     3: Canvas.Polygon([Point(0,0),
               Point(Random(Width+1),Height), Point(Width,0)]);
    end;
  end;
  Invalidate;  { gesamtes Fenster }
end;


end.
