{
  VIDEO13.PAS - Realisierung der Grundroutinen fr Mode 13h

  Borland Pascal 7.0

  Version 2.0

  Ansgar Scherp   ( Ansgar.Scherp@Informatik.Uni-Oldenburg.DE )
  Joachim Gelhaus ( J.Gelhaus@Flight.Gun.DE )

  Diese Routinen sind sowohl im Protected Mode als auch im Real Mode
  lauffhig.

  aus 'Patchwork' c't 4/97 S. 442

}

unit Video13;

interface

type
  TSprite = { Datenstruktuer eines Sprite }
    record
      breite,
      tiefe  : word;    { Breite und Tiefe des Sprite }
      data   : pointer; { Zeiger auf die eigentlichen Spritedaten }
    end;

  TPage =
    Pointer; { Neuer Datentyp; Zeiger auf eine virtuelle Seite }

  TPalette = { Datentyp : Palette }
    record
      r, g, b : Array[ 0.. 255 ] of byte;
    end;

const
  { Konstanten fr die Prozedure SetVideoMode }
  Mode13h : word = $13; { MCGA-Modus : 320x200x256 }
  Mode3h  : word = $3;  { Textmodus 80x25, Farbe }

const { die Eckpunkte es aktuellen Fensterrahmens;
        ( WindowX1, WindowY1 ) ist die linke obere Ecke und
        ( WindowX2, WindowY2) die rechte untere              }
  WindowX1 : integer =   0; WindowY1 : integer =   0;
  WindowX2 : integer = 319; WindowY2 : integer = 199;

var
  ActVPage   : TPage; { die gerade aktive Seite, auf die sich alle Routinen
                        automatisch beziehen. Siehe auch ActivePage. }
  VisualPage : TPage; { die visuelle Seite bei SegA000:0 }

{ setzt den Video Modus 320x200x256 und den Fensterrahmen auf den maximalen
  sichtbaren Bereich }
procedure InitVideo13h;

{ aktive Seite festlegen, d.h. die Seite festlegen, auf der alle folgenden
  Prozeduren/Funktionen angewendet werden sollen, d.h. alle folgenden
  Operationen beziehen sich auf die Seite 'page' }
procedure ActivePage( page : TPage );

{ Setzen eines Videomodus }
procedure SetVideoMode( mode : word );

{ festlegen eines Fensterrahmens, wobei ( x1, y1 ) die linke obere Ecke
  darstellt und ( x2, y2 ) die rechte untere }
procedure SetWindow( x1, y1, x2, y2 : integer );

{ auf den vertikalen Strahlrcklauf des Monitors warten; wird bentigt, um
  flssige Animationen programmieren zu knnen }
procedure WaitVerticalRetrace;

{ kopieren einer Bildschirmseite in eine andere; SrcPage und DstPage knnen
  dabei sowohl virtuelle Bildschirmseite, als auch reale ( sprich :
  visuelle ) Bildschirmseite sein. }
procedure CopyP2P( SrcPage, DstPage : TPage );
{ lschen einer Bildschirmseite; sowohl virtuell als auch visuell }
procedure ClearPage( DstPage : TPage );
{ initialisieren einer virtuellen Bildschirmseite; allozieren des
  bentigten Speichers }
procedure InitPage( var Page : TPage );
{ schlieen einer virtuellen Bildschirmseite; freigabe des von der
  virtuellen Seite bentigten Speichers }
procedure ClosePage( Page : TPage );

{ Prozedur zum Initialisieren eines Sprite; alloziert den fr das Sprite
  bentigte Speicher; Breite und Hhe knnen anschliessend nicht mehr
  gendert werden }
procedure InitSprite( var Sprite : TSprite; breite, tiefe : word);
{ Prozedur zum Entfernen eines Sprites aus dem Speicher }
procedure CloseSprite( var Sprite : TSprite );

{ Schreibt ein Sprite auf den Bildschirm unter Bercksichtigung des mit
  SetWindow festgelegten Fensterrahmens, d.h. das Sprite ist nur
  innerhalb des gewhlten Bildschirmausschnittes sichtbar.
  Das Sprite wird mit Byter fr Byte mit Hilfe von Schiebebefehlen
  kopiert. }
procedure PutSprite( x,y : integer; Sprite : TSprite );
{ Analog zu PutSprite, nur das hier ein Sprite vom Bildschirm gesichert
  werden kann }
procedure GetSprite( x, y : integer; sprite : TSprite );

{ Dient zum direkten Schreiben eines Pixels in ein Sprite }
procedure PutPixel2Sprite( Sprite : TSprite; x, y : integer; c : byte );

{ die Standard Put-/GetPixel-Routinen }
procedure PutPixel( x, y : word; c : byte );
function  GetPixel( x, y : word ) : byte;


{ Laden und speichern eines Sprite auf der Festplatte, Diskette etc. }
procedure LoadSprite( name : string; VAR sprite : TSprite);
procedure SaveSprite( name : string;     sprite : TSprite);

{ Setzen/holen eines Paletteneintrages }
procedure SetRGBColor( co, r, g, b : byte );
procedure GetRGBColor( co : integer; var r, g, b : byte );
{ Setzen/sichern einer Palette }
procedure SetPalette( var pal : TPalette );
procedure GetPalette( var pal : TPalette );
{ alle Farben auf schwarz setzen }
procedure SetZeroPalette;
{ Laden/speichern einer palette }
procedure LoadPalette( name : string; VAR pal : TPalette );
procedure SavePalette( name : string;     pal : TPalette );

implementation

procedure Video13hError( t : string );
begin
  SetVideoMode( Mode3h );
  write( ' VideoSystemFehler : ' );
  writeln( t );
  halt( 1 );
end;

procedure SetVideoMode( mode : word ); assembler;
asm
  { der Interrupt 10h wird von RTM.EXE unterstzt, d.h. die Bibliothek
    DPMI.TPP wird nicht bentigt und der Interrupt ist direkt ausfhrbar. }
  mov ax, mode;
  int  10h
end;

procedure SetRGBColor( co, r, g, b : byte );
begin
  port[ $3c8 ] := co;
  port[ $3c9 ] := r;
  port[ $3c9 ] := g;
  port[ $3c9 ] := b;
end;

procedure GetRGBColor( co : integer; var r, g, b : byte );
begin
  r := 0;
  g := 0;
  b := 0;
  port[ $3C8 ] := co + 1;
  r := port[ $3C9 ];
  g := port[ $3C9 ];
  b := port[ $3C9 ];
end;

procedure SetPalette( var pal : TPalette );
var
  a : byte;
begin
  for a := 0 to 255 do
    SetRGBcolor( a, pal.r[ a ], pal.g[ a ], pal.b[ a ] );
end;

procedure GetPalette( var pal : TPalette );
var
  a : byte;
begin
  for a := 0 to 255 do
    GetRGBcolor( a, pal.r[ a ], pal.g[ a ], pal.b[ a ] );
end;

procedure SetZeroPalette;
var
  a : byte;
begin
  for a := 0 to 255 do
    SetRGBColor( a, 0, 0, 0 );
end;


procedure SetWindow( x1, y1, x2, y2 : integer);
  var h : byte;
begin
  { liegt der neue Fensterrahmen ausserhalb des erlaubten Bereiches?
    Falls ja, wird er automatisch begrenzt. }
  if x1 <   0 then x1 := 0;  if x1 > 319 then x1 := 319;
  if y1 <   0 then y1 := 0;  if y1 > 199 then y1 := 199;
  if x2 <   0 then x2 := 0;  if x2 > 319 then x2 := 319;
  if y2 <   0 then y2 := 0;  if y2 > 199 then y2 := 199;
  { vertauscht die linke/rechte bzw. obere/untere Grenzen, falls ntig
    bzw. verkehrt angegeben  }
  if x1 >  x2 then begin h := x2; x2 := x1; x1 := h; end;
  if y1 >  y2 then begin h := y2; y2 := y1; y1 := h; end;
  { neuen Fensterrahmen in globalen Variablen WindowX1-2 und WindowY1-2
    speichern }
  WindowX1 := x1; WindowX2 := x2; WindowY1 := y1; WindowY2 := y2;
end;

procedure ActivePage( page : pointer );
begin ActVPage := page; end;

procedure WaitVerticalRetrace; assembler;
asm
  mov dx,3dah { erkennen des Retrace durch Auslesen des Ports 3DAh }
  @wait1: in al,dx; test al,8; jz @wait1;
  @wait2: in al,dx; test al,8; jnz @wait2
end;

procedure CopyP2P( SrcPage, DstPage : TPage ); assembler;
asm
  push ds
  les di, DstPage    { Ziel   : [ES:DI] }
  lds si, SrcPage    { Quelle : [DS:SI] }
  mov cx, 16000
  db  66h; rep movsw { movsd }
  pop ds
end;

procedure InitVideo13h;
begin
  SetVideoMode( Mode13h ); SetWindow(0,0,319,199);
  VisualPage := Ptr( SegA000, 0 );
end;

procedure ClearPage( DstPage : TPage ); assembler;
asm
  les di, DstPage   { Ziel : [ES:DI] }
  db 66h; xor ax,ax { xor eax, eax }
  mov cx, 16000
  db 66h; rep stosw { stosd }
end;

procedure InitPage( var Page : pointer );
begin GetMem( Page, 64000 ); end;

procedure ClosePage( Page : pointer );
begin FreeMem( Page, 64000 ); end;

procedure InitSprite( var Sprite : TSprite; breite, tiefe : word );
begin
  GetMem( Sprite.data, breite * tiefe );
  Sprite.breite := breite; Sprite.tiefe  := tiefe;
  { berschreiben des eventuell vorhandenen Datenmlls }
  FillChar( Sprite.data^, breite * tiefe, 0 );
end;

procedure CloseSprite( var Sprite : TSprite );
begin
  { wenn Spritbreite und - tiefe ungleich Null, versuchen Speicher zu
    dealozieren }
  if Sprite.breite * Sprite.tiefe > 0 then
    FreeMem( Sprite.data, Sprite.breite * Sprite.tiefe );
  Sprite.data   := nil;
  Sprite.breite := 0; Sprite.tiefe  := 0;
end;

{ PutSprite-Routine; benutzt ByteMove-Befehle, d.h. die Sprite-Routinen
  sind in keiner Weise auf Geschwindigkeit hin optimiert worden; zukuenftige
  Weiterentwicklungen : Word- oder DWordMove-Befehle }
procedure PutSprite( x,y : integer; Sprite : TSprite );
var
  breite,tiefe  : integer;
  ausgleich     : word;
  ltrag, otrag,
  rtrag, utrag  : integer; { bertrag links, rechts, oben, unten }
begin
  { betrge berechnen }
  inc( WindowX2 ); inc( WindowY2 ); { vereinfacht die Rechnung }
  if x < WindowX1 then      { linken bertrag ausserhalb des }
      ltrag := WindowX1 - x {  Fensterrahmens berechnen      }
    else
      ltrag := 0;
  if y < WindowY1 then { fr den oberen bertrag }
    otrag := WindowY1 - y else otrag := 0;
  if x + Sprite.breite > WindowX2 then { den rechte bertag berechnen }
    rtrag := x + Sprite.breite - WindowX2 else rtrag := 0;
  if y + Sprite.tiefe > WindowY2 then { den unteren bertrag berechnen }
    utrag := y + Sprite.tiefe - WindowY2 else utrag := 0;
  dec( WindowX2 ); dec( WindowY2 ); { und wieder alles zurcksetzen }
  { reale Breite und Tiefe des sichtbaren! Sprites ermitteln }
  { sichtbare Breite := Spritebreite - linker bertrag - rechter bertrag }
  breite := Sprite.breite - ltrag - rtrag;
  { sichtbare Tiefe := Spritetiefe- oberer bertrag - unterer bertrag }
  tiefe  := Sprite.tiefe  - otrag - utrag;
  { wenn sichtbare Breite oder Tiefe kleiner oder gleich Null, dann
     sofort die Prozedur beenden }
  if (breite <= 0) or (tiefe <= 0) then exit;
  { neue x und y position bestimmen; erster sichtbarer Pixel }
  x := x + ltrag; y := y + otrag;
  asm { eigentliche Spriteroutine }
    push ds
    { Berechung des 'Ausgleichs', d.h. Bildschirmbreite - Spritebreite }
    mov ax, 320; sub ax, breite; mov ausgleich, ax
    { [ES:DI] = erste Speicherstelle in der Zielseite }
    les di,ActVPage
    mov ax,y; mov bx,320; mul bx; add ax,x; add di,ax

    { [DS:SI] = erste Speicherstelle in den Spritedaten }
    lds si, Sprite.data { spritedata }
    mov ax, otrag { oberer bertrag }
    mov bx, Sprite.breite; mul bx; add si,ax

    mov dx,0 { anzahl an geschriebenen Zeilen }
    @@loop:
      add si, ltrag  { linker bertrag }
      mov cx, breite
      rep movsb { cx Bytes kopieren }
      add di, ausgleich
      add si, rtrag     { rechter bertrag }
      inc dx
      cmp dx, tiefe { alle Zeilen geschrieben? }
      jnz @@loop
    pop ds
  end;
end;

{ GetSprite-Routine; funktionsweise analog zu PutSprite }
procedure GetSprite( x, y : integer; sprite : TSprite );
var
  breite,tiefe  : integer;
  ausgleich     : word;
  ltrag, otrag,
  rtrag, utrag  : integer;
begin
  inc( WindowX2); inc( WindowY2 );
  if x < WindowX1 then
      ltrag := WindowX1 - x
    else
      ltrag := 0;
  if y < WindowY1 then
      otrag := WindowY1 - y
    else
      otrag := 0;
  if x + sprite.breite > WindowX2 then
      rtrag := x + sprite.breite - WindowX2
    else
      rtrag := 0;
  if y + sprite.tiefe  > WindowY2 then
      utrag := y + sprite.tiefe - WindowY2
    else
      utrag := 0;
  dec( WindowX2); dec( WindowY2 );
  breite := sprite.breite - ltrag - rtrag;
  tiefe  := sprite.tiefe  - otrag - utrag;
  if ( breite <= 0 ) or ( tiefe <= 0 ) then exit;
  x := x + ltrag;
  y := y + otrag;

  asm
    push ds

    mov ax, 320
    sub ax, breite
    mov ausgleich, ax

    lds si,ActVPage
    mov ax,y
    mov bx,320
    mul bx
    add ax,x
    add si,ax

    les di, sprite.data
    mov ax, otrag
    mov bx, sprite.breite
    mul bx
    add di,ax

    mov dx,0
    @@loop:

      add di, ltrag

      mov cx, breite

      rep movsb

      add si, ausgleich
      add di, rtrag

      inc dx
      cmp dx, tiefe
      jnz @@loop

    pop ds
  end;
end;


procedure PutPixel2Sprite( Sprite : TSprite; x, y : integer; c : byte );
begin
  { Koordinaten ausserhalb des Sprites? }
  if ( x > Sprite.breite - 1 ) or ( y > Sprite.tiefe - 1 ) or
     ( x < 0 ) or ( y < 0 ) then exit;
  asm
    mov ax,y; mov bx, Sprite.breite
    mul bx; add ax,x    { ax = Offset des gewnschten Pixels }
    mov cl,c            { Farbwert in Register laden }
    les di, Sprite.data { Speicheradresse der Spritedaten [ES:DI] }
    add di,ax           { Offset der Pixelposition hinzuaddieren }
    mov [es:di], cl     { Farbwert in die Speicherstelle schreiben }
  end;
end;

procedure PutPixel( x, y : word; c : byte); assembler;
asm
  mov ax,y
  mov bx,320
  mul bx
  add ax,x

  mov cl,c
  les di, ActVPage
  add di,ax

  mov [es:di],cl
end;

function GetPixel( x, y : word ) : byte;
var
  c : byte;
begin
  asm
    mov ax,y
    mov bx,320
    mul bx
    add ax,x

    les di,ActVPage
    add di,ax
    mov cl,[es:di]

    mov c,cl
  end;
  GetPixel := c;
end;

procedure LoadSprite( name : string; VAR sprite : TSprite);
var
  f : file;
  t : word; { tiefe }
begin
  if sprite.data <> NIL then
    Video13hError( 'Sprite ist bereits initialisiert.' );
  {$I-}
  Assign( f, name );
  Reset( f, 1 );
  {$I+}
  if IOResult <> 0 then
    Video13hError( 'Fehler beim Laden von "' + name + '" aufgetreten.' );
  {}
  Blockread( f, sprite.breite, 2 );
  Blockread( f, sprite.tiefe,  2 );
  GetMem( sprite.data, sprite.breite * sprite.tiefe );
  BlockRead( f, sprite.data^, sprite.breite * sprite.tiefe );
  Close( f );
end;

procedure SaveSprite( name : string; sprite : TSprite );
var
  f : file;
begin
  {$I-}
  Assign( f, name );
  Rewrite( f, 1 );
  {$I+}
  BlockWrite( f, sprite.breite, Sizeof( sprite.breite ) );
  BlockWrite( f, sprite.tiefe,  Sizeof( sprite.tiefe ) );
  BlockWrite( f, sprite.data^,  sprite.breite * sprite.tiefe );
  Close( f );
  if IOResult <> 0 then
    Video13hError( 'Fehler beim Speichern von "' + name + '" aufgetreten.' );
end;

procedure LoadPalette( name : string; VAR pal : TPalette );
var
  f : file;
  a : byte;
begin
  {$I-}
  Assign( f, name );
  Reset( f, 1 );
  for a := 0 to 255 do
    begin
      BlockRead( f, pal.r[ a ], 1 );
      BlockRead( f, pal.g[ a ], 1 );
      BlockRead( f, pal.b[ a ], 1 );
    end;
  if IOResult <> 0 then
    Video13hError('Fehler beim Laden von "' + name + '" aufgetreten.');
  Close( f );
  {$I+}
end;

procedure SavePalette(name:string; pal : TPalette );
var
  f : file;
  a : byte;
begin
  {$I-}
  Assign( f, name );
  Rewrite( f, 1 );
  for a := 0 to 255 do
    begin
      BlockWrite( f, pal.r[ a ], 1 );
      BlockWrite( f, pal.g[ a ], 1 );
      BlockWrite( f, pal.b[ a ], 1 );
    end;
  if IOResult <> 0 then
    Video13hError('Fehler beim Speichern von "' + name + '" aufgetreten.');
  Close( f );
  {$I+}
end;


begin
  ActVPage := ptr( SegA000, 0 ); { atkive Seite ist die sichtbare Seite }
end.