#include "Handshaker.h"

Handshaker::Handshaker(const Boolean portModem) {
	constructOk = false;
// open serial driver, "AOut"=modem out, "BOut"=printer, open output first!
	if (noErr!=OpenDriver(portModem ? "\p.AOut" :"\p.BOut", &theOutputRefNum))
		return;
	if (noErr!=OpenDriver(portModem ? "\p.AIn" :"\p.BIn", &theInputRefNum))
		return;
	theSerShkRec.fXOn	= 0;		// turn off XON/XOFF output flow control
	theSerShkRec.fCTS	= 0;		// turn off CTS/DTR flow control
	theSerShkRec.errs	= 0;		// clear error mask
	theSerShkRec.evts	= 0;		// clear event mask
	theSerShkRec.fInX	= 0;		// turn off XON/XOff input flow control
	theSerShkRec.fDTR	= 0;		// turn off DTR input flow control
	if (noErr!=Control(theOutputRefNum, 14, &theSerShkRec))	return;
	HSKout(false);
	constructOk = true;
}

Handshaker::~Handshaker(void) {
	if (noErr==KillIO(theInputRefNum))	// terminate all pending I/O
		if (noErr==KillIO(theOutputRefNum))
			if (noErr==CloseDriver(theInputRefNum))
				CloseDriver(theOutputRefNum);
}

Boolean Handshaker::Ok() {
	return constructOk;
}

void Handshaker::HSKout(const Boolean newLevel) {
	const	kAssertDTR = 17,	kNegateDTR = 18;
	currentLevel = newLevel;	// merken fr Toggle
	Control(theOutputRefNum, 
		newLevel ? kAssertDTR : kNegateDTR, &theSerShkRec);
}

void Handshaker::HSKtoggle(void) {
	HSKout(!currentLevel);
}

Boolean Handshaker::HSKin(void) {
	SerStaRec myRec;
	SerStatus(theInputRefNum,  &myRec);
	return (myRec.ctsHold == 0);
}