unit Hardwayu; { 10-MAI-97 as (Arne Schpers) }
{ Demonstriert, wie sich ein Programm auf die harte Tour
  im Hauptspeicher halten lt: WM_CLOSE wird abgeklemmt }
interface

{$IFDEF WIN32}
{$ERROR Geht nur fr 16-Bit-Programme!}
{$ENDIF}

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, StdCtrls, ExtCtrls, Dialogs;

type
  TForm1 = class(TForm)
    bStartMiniProg: TButton;  { Starten und Suchen }
    bFindMiniProg: TButton;   { Suchen }
    RadioGroup1: TRadioGroup; { "Close erlaubt" / "gesperrt" }
    procedure bFindMiniProgClick(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure bStartMiniProgClick(Sender: TObject);
    procedure Cleanup;        { Filter wieder raus }
    procedure SetEnableState; { Buttons/Radiogroup an/aus }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

type
 TWndProc = function(Wnd: HWnd; Msg: Word; wParam: Integer;
               lParam: LongInt): LongInt;
var
 CloseAllowed: Boolean; { ber Radiogroup1 gesetzt }
 TargetWindow: HWnd;   { Handle des Zielfensters }
 OrgWndProc: LongInt;  { tatschlich ein Zeiger }

 { Die eingesetzte Window-Prozedur }
function NewWndProc(Wnd: HWnd; Msg: Word; wParam: Integer;
  lParam: LongInt): LongInt; export;
begin  { eigenes Datensegment einsetzen }
  asm mov ax,SEG @data; mov ds,ax end;
  { Reaktion auf Programmende. Richtiger wre hier natrlich
    der Weg ber eine selbstgepostete Botschaft }
  if Msg = WM_DESTROY then Form1.Cleanup;

  if (Msg <> WM_CLOSE) or CloseAllowed
    then Result := TWndProc(OrgWndProc)(Wnd,Msg,wParam,lParam)
    else
    begin
        { Modal zum Fenster des anderen Programms }
      MessageBox(Wnd,'CLOSE? Nein danke.','Gesperrt',MB_OK);
      Result := 0;  { Botschaft schlicht bergangen }
    end;
end;

{ Miniprog starten (im selben Verzeichnis wie Hardway.exe) }
procedure TForm1.bStartMiniProgClick(Sender: TObject);
var Buf: Array[0..255] of Char;
begin
  WinExec(StrPCopy(Buf,ExtractFilePath(ParamStr(0))+
                   'Miniprog.exe'),SW_SHOWNORMAL);
  bFindMiniProgClick(Self);
end;

{ Fenster suchen und eigene Window-Prozedur voranstellen }
procedure TForm1.bFindMiniProgClick(Sender: TObject);
begin
  Cleanup; { Filter raus, falls vorhanden }
  TargetWindow := FindWindow(nil,'MiniProgForm');
  if TargetWindow <> 0 then
  begin
    RadioGroup1Click(Self);
    OrgWndProc := SetWindowLong(TargetWindow,
       GWL_WNDPROC,LongInt(@NewWndProc));
  end;
  SetEnableState; { Buttons/Radiogroup an/aus }
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  CloseAllowed := RadioGroup1.ItemIndex = 0;
end;

procedure TForm1.SetEnableState;
begin  { Buttons an/aus abhngig davon, ob MiniProg luft }
  bStartMiniProg.Enabled := TargetWindow = 0;
  bFindMiniProg.Enabled := TargetWindow = 0;
  RadioGroup1.Enabled := TargetWindow <> 0;
end;

procedure TForm1.Cleanup;  { Filter raus, falls vorhanden }
begin
  { Window-Prozedur eingesetzt? Gibt's das Fenster noch? }
  if (TargetWindow <> 0) and IsWindow(TargetWindow) then
    { -> eingesetzte Window-Prozedur wieder herausnehmen }
    SetWindowLong(TargetWindow,GWL_WNDPROC,OrgWndProc);
  TargetWindow := 0;  { Flag: "nicht eingehngt" }
  SetEnableState; { Buttons/Radiogroup an/aus }
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Cleanup;
end;

end.
