(* Programm zur Anwendung von Branch and Bound auf das Rucksackproblem *)
(* Vorsicht: Fehleingaben werden nicht abgefangen! *)
(* (C) 1997 TH Darmstadt *)
(* Armin Scholl, Gabriela Krispin, Robert Klein, Wolfgang Domschke *)
(* E-Mail: scholl@bwl.bwl.th-darmstadt.de *)
PROGRAM BranchAndBound;
CONST
  MaxAnz = 501;
  Eps = 0.0000001; {zur Sicherheit bei Real-Zahlen}

TYPE
  IntegerFeld = ARRAY[0..MaxAnz] of Integer;
  RealFeld = ARRAY[0..MaxAnz] of Real;
  PKnoten = ^Knoten;          {Zeiger auf Knotentyp}
  Knoten = RECORD             {Knoten des Baums mit:}
    x: IntegerFeld;             {Teilloesung}
    Gewinn, Gewicht: Integer;   {bisherig. Gewinn, Gewicht}
    Schranke: Real;             {obere Schranke}
    zulaessig: Boolean;         {zulaessige Loesung ?}
    Num: LongInt;               {Nummer des Knotens}
    Next: PKnoten;              {Naechster Knoten in Kandidatenliste}
    Vor: LongInt;               {Nummer des Vaterknotens im Baum}
    Ebene: LongInt;             {Ebene im Enumerationsbaum}
  END;

VAR
  Wahl, Auswahl, Reihenfolge, Kletter, Zusatz: Byte;  {Steuervariablen}
  LogTests, Heuristik: Boolean;  {log. Tests, Heuristik aktiv ?}
  Wurzel, Start, Letzte, Best, Temp: PKnoten;  {Zeiger auf Teilprobleme}
  MaxGewicht: Integer;           {Maximalgewicht des Koffers}
  n: Word;                       {Anzahl der Gegenstaende}
  p, w, Org: IntegerFeld;        {Gewinne, Gewichte, Originalnummer}
  rp: RealFeld;                  {relative Gewinne}
  ObereSchranke: Real;           {obere Schranke der Wurzel}
  KnotenAnz: LongInt;            {Groesse des Baums}
  Name: String;                  {Name der Problemdatei}
  Dat: Text;                     {Ausgabedatei}


(* Generieren von Probleminstanzen *)
PROCEDURE Generiere;
VAR i: Word;
BEGIN
  WRITE('Anzahl der Gegenstaende: '); READLN(n);
  WRITELN(Dat,'Zufaellig erzeugt mit ',n,' Gegenstaenden:');
  MaxGewicht:=200;
  FOR i:=1 TO n DO BEGIN
    p[i]:=RANDOM(100)+1;  w[i]:=RANDOM(100)+1;
    WRITELN(Dat,'Gegenstand ',i,' mit Gewinn ',p[i],
            ' und Gewicht ',w[i]);
  END;
END;

(* Einlesen einer Probleminstanz aus einer Datei *)
PROCEDURE LiesVonDatei;
VAR i: Word;
    Eingabe: Text;
BEGIN
  WRITE('Eingabedatei: '); READLN(name);
  WRITELN(Dat,'Probleminstanz: ',Name);
  ASSIGN(Eingabe,name); RESET(Eingabe);
  READLN(Eingabe,n); READLN(Eingabe,MaxGewicht);
  FOR i:=1 TO n DO
    READLN(Eingabe,p[i],w[i]);
  CLOSE(Eingabe);
END;

(* Anlegen und Initialisieren von Knoten *)
PROCEDURE Initialisiere(VAR K:PKnoten);
VAR i: Word;
BEGIN
  NEW(K);
  WITH K^ DO BEGIN
    FOR i:=1 TO n DO x[i]:=0; Gewinn:=0; Gewicht:=0;
    zulaessig:=FALSE; Next:=NIL; vor:=0; Ebene:=0;
  END;
END;

(* Ausgabe eines Knotens *)
PROCEDURE ZeigeKnoten(K:PKnoten);
VAR i, j: Word;
BEGIN
  WITH K^ DO BEGIN
    WRITE(Dat,'Nr. ',Num,': Ebene = ',Ebene,'  Vater = ',Vor);
    WRITELN(Dat,'  Gewinn = ',Gewinn,'  Gewicht = ',Gewicht);
    WRITE(Dat,'  Gepackt: {');
    FOR i:=1 TO n DO IF x[i]=1 THEN WRITE(Dat,' ',i);
    WRITE(Dat,' }  Verboten: {');
    FOR i:=1 TO n DO IF x[i]=2 THEN WRITE(Dat,' ',i);
    WRITE(Dat,' }');
    IF zulaessig THEN WRITE(Dat,'  -> zulaessig')
    ELSE IF Schranke < Eps THEN WRITE(Dat,'  -> unzulaessig')
    ELSE BEGIN
      WRITELN(Dat); WRITE(Dat,'  Schranke = ',Schranke:0:2,': {');
      FOR i:=1 TO n DO BEGIN
        j:=Org[i];
        IF x[j] < 0 THEN BEGIN WRITE(Dat,' ',j);
           IF x[j]>-w[j] THEN WRITE(Dat,'(',-x[j],')');
        END;
      END;
      WRITE(Dat,' }' );
    END;
  END;
END;

(* Sortierung nach abnehmenden relativen Gewinnen *)
PROCEDURE Sortiere;
VAR max: Real;
    i, j, besti, Temp: Word;
BEGIN
  FOR i:=1 TO n DO BEGIN
    rp[i]:=p[i]/w[i];  {relativer Gewinn}
    Org[i]:=i;         {Originalnummern der Gegenstaende}
  END;
  FOR j:=1 TO n-1 DO BEGIN
    max:=rp[j];
    besti:=j;
    FOR i:=j+1 TO n DO
    IF rp[i] > max THEN BEGIN besti:=i; max:=rp[i] END;
    IF besti > j THEN BEGIN
      rp[besti]:=rp[j]; rp[j]:=max;
      Temp:=Org[besti]; Org[besti]:=Org[j]; Org[j]:=Temp;
    END;
  END;
  WRITELN(Dat,'Sortierung nach relativen Gewinnen:');
  FOR i:=1 TO n DO WRITELN(Dat,i,rp[i]:7:2,Org[i]:4);
END;

(* Heuristik: Bestimmung einer zulaessigen Loesung *)
PROCEDURE ErzeugeLoesung(K:PKnoten);
VAR rest, wert: Integer;
    i, j: Word;
    Temp: PKnoten;
BEGIN
  NEW(Temp);          (* Anlegen eines Hilfsknotens *)
  Temp^:=K^;          (* Uebernahme der aktuellen Teilloesung *)
  WITH Temp^ DO BEGIN
    rest:=MaxGewicht - Gewicht;
    zulaessig:=TRUE;
    i:=1;
    (* Einplanen in Sortierreihenfolge solange moeglich *)
    WHILE (rest > 0) AND (i <= n) DO BEGIN
      j:=Org[i];
      IF (x[j] <= 0) AND (w[j] <= rest) THEN BEGIN
        x[j]:=1;
        Gewinn:=Gewinn+p[j];
        Gewicht:=Gewicht+w[j];
        rest:=rest-w[j];
      END;
      i:=i+1;
    END;

    (* Verbesserung der bisher besten Loesung ? *)
    IF Gewinn > Best^.Gewinn THEN BEGIN
      Best^:=Temp^;
      WRITELN(Dat,'Verbesserte Loesung durch Heuristik: ',Gewinn);
      WRITE(Gewinn,'*  ');
    END;
  END;
  DISPOSE(Temp);
END;

(* Obere Schranke f?r Teilproblem K *)
PROCEDURE BerechneSchranke(K:PKnoten);
VAR rest, wert, minw1, minw2, maxp: Integer;
    i, j, maxj: Word;
BEGIN
  WITH K^ DO BEGIN
    Schranke:=Gewinn + Eps;
    rest:=MaxGewicht - Gewicht;

    (* Logischer Test: "Zu gro" *)
    IF LogTests THEN
      FOR j:=1 TO n DO
      IF (x[j]<=0) AND (w[j] > rest) THEN x[j]:=2;

    (* Berechnung der oberen Schranke *)
    IF rest >= 0 THEN BEGIN
      zulaessig:=true;
      i:=1;
      WHILE (rest > 0) AND (i <= n) DO BEGIN
        j:=Org[i];
        IF x[j] <= 0 THEN BEGIN
          IF w[j] <= rest THEN
            wert:=w[j]
          ELSE BEGIN
            wert:=rest;
            zulaessig:=FALSE;
          END;
          x[j]:=-wert;
          Schranke:=Schranke+wert*rp[i];
          rest:=rest-wert;
        END;
        i:=i+1;
      END;

      (* Loesung zur oberen Schranke ist zulaessig ? *)
      IF zulaessig THEN BEGIN
        FOR j:=1 TO n DO
        IF x[j] < 0 THEN BEGIN
          Gewinn:=Gewinn+p[j]; Gewicht:=Gewicht+w[j]; x[j]:=1;
        END;
      END

      (* Logische Tests: "Nur noch einer" bzw. "Koffer voll" *)
      ELSE IF LogTests THEN BEGIN
        rest:=MaxGewicht - Gewicht;
        minw1:=MaxGewicht+1; minw2:=minw1;
        maxp:=0; maxj:=0;
        FOR j:=1 TO n DO
        IF (x[j]<=0) THEN BEGIN
          IF w[j] < minw1 THEN BEGIN
            minw2:=minw1; minw1:=w[j];
          END
          ELSE IF w[j]< minw2 THEN
            minw2:=w[j];
          IF (w[j] <= rest) AND (p[j] > maxp) THEN BEGIN
            maxp:=p[j]; maxj:=j;
          END;
        END;
        IF (minw1+minw2) > rest THEN BEGIN
          zulaessig:=TRUE;
          WRITE(Dat,'Zulaessig durch logische Tests: ');
          (* "Nur noch einer" *)
          IF maxj > 0 THEN BEGIN
            Gewinn:=Gewinn+maxp; Gewicht:=Gewicht+w[maxj]; x[maxj]:=1;
            WRITELN(Dat,'Ergaenze ',maxj);
          END
          (* "Koffer voll" *)
          ELSE
            WRITELN(Dat,'Koffer voll');
        END;
      END;

      (* Verbesserung der bisher besten Loesung *)
      IF zulaessig AND (Gewinn > Best^.Gewinn) THEN BEGIN
        Best^:=K^;
        WRITELN(Dat,'Verbesserte Loesung: ',Gewinn);
        WRITE(Gewinn,'  ');
      END
      (* Anwendung der Heuristik *)
      ELSE IF NOT(zulaessig) AND Heuristik THEN
        ErzeugeLoesung(K);

      (* Logischer Test: "Ganzzahlige Gewinne" *)
      IF LogTests THEN Schranke:=INT(Schranke);
    END
    ELSE BEGIN zulaessig:=FALSE; Schranke:=0 END;
  END;
END;

(* Einfuegen eines Knotens in Kandidatenliste *)
PROCEDURE Einfuegen(K:PKnoten);
VAR Temp: PKnoten;
BEGIN
  WITH K^ DO
  BEGIN
    (* Tiefensuche: Einfuegen am Anfang der Liste *)
    IF Kletter=1 THEN BEGIN next:=Start^.next; Start^.next:=K END;

    (* Breitensuche: Einfuegen am Ende der Liste *)
    IF Kletter=2 THEN BEGIN Letzte^.next:=K; Letzte:=K END;

    (* Beste Schranke: Sortiertes Einfuegen *)
    IF Kletter=3 THEN BEGIN
      KnotenAnz:=KnotenAnz+1; num:=KnotenAnz;
      BerechneSchranke(K);
      WRITE(Dat,'Erzeuge '); ZeigeKnoten(K); WRITELN(Dat);
      Temp:=Start;
      WHILE (Temp^.next<>NIL) AND (Temp^.next^.Schranke>Schranke) DO
        Temp:=Temp^.next;
      next:=Temp^.next; Temp^.next:=K;
    END;
  END;
END;

(* Verzweigen: Bilden von Teilproblemen *)
PROCEDURE Verzweige(Vater:Knoten);
VAR TP1, TP2: PKnoten;
    i, j, bestj: Word;
    max: Real;
BEGIN
  bestj:=0; max:=0;
  WITH Vater DO
  BEGIN
    CASE Auswahl OF
      1: FOR j:=1 TO n DO
           IF (x[j] <= 0) AND (w[j] > max) THEN
           BEGIN max:=w[j]; bestj:=j; END;
      2: FOR j:=1 TO n DO
           IF (x[j] <= 0) AND (p[j] > max) THEN
           BEGIN max:=p[j]; bestj:=j; END;
      3: FOR i:=1 TO n DO BEGIN
           j:=Org[i];
           IF (x[j] <= 0) AND (rp[i] > max) THEN
           BEGIN max:=rp[i]; bestj:=j; END;
         END;
      4: BEGIN
            j:=0; REPEAT j:=j+1 UNTIL (x[j]<0) AND (x[j]>-w[j]);
            bestj:=j;
         END;
    END;
  END;
  WRITELN(Dat,' -> verzweigen mit Gegenstand ',bestj,'.');
  IF (MemAvail < 4*SizeOf(Knoten)) THEN BEGIN
    WRITELN('Speicher zu klein!');
    HALT;
  END;
  NEW(TP1);
  WITH TP1^ DO BEGIN
    Gewinn:=Vater.Gewinn; Gewicht:=Vater.Gewicht; num:=0; Schranke:=0;
    zulaessig:=FALSE; x:=Vater.x; next:=NIL;
    vor:=Vater.Num; Ebene:=Vater.Ebene+1;
    FOR j:=1 TO n DO IF x[j]<0 THEN x[j]:=0;
    x[bestj]:=1; Gewinn:=Gewinn+p[bestj]; Gewicht:=Gewicht+w[bestj];
  END;
  NEW(TP2);
  WITH TP2^ DO BEGIN
    Gewinn:=Vater.Gewinn; Gewicht:=Vater.Gewicht; num:=0; Schranke:=0;
    zulaessig:=FALSE; x:=Vater.x; next:=NIL;
    vor:=Vater.Num; Ebene:=Vater.Ebene+1;
    FOR j:=1 TO n DO IF x[j]<0 THEN x[j]:=0;
    x[bestj]:=2;
  END;
  IF ((Kletter=1) AND (Reihenfolge = 1)) OR
     ((Kletter>1) AND (Reihenfolge = 2)) THEN
  BEGIN Einfuegen(TP2); Einfuegen(TP1) END
  ELSE BEGIN Einfuegen(TP1); Einfuegen(TP2) END;

END;

(* Klettern zu Knoten K *)
PROCEDURE Klettere(K:PKnoten);
BEGIN
  (* Wert von 60000 muss ggf. erhoeht werden *)
  IF (Kletter > 1) AND (MemAvail < 60000) THEN BEGIN
    WRITELN(Dat,'Speicher knapp: Umschalten auf Tiefensuche');
    WRITE('Speicher knapp!  '); Kletter:=1;
  END;
  WITH K^ DO BEGIN
    IF Kletter < 3 THEN BEGIN
      Num:=KnotenAnz; KnotenAnz:=KnotenAnz+1;
      BerechneSchranke(K); ZeigeKnoten(K);
    END
    ELSE BEGIN WRITE(Dat,'Bearbeite '); ZeigeKnoten(K) END;

    (* Verzweigen, falls nicht auslotbar *)
    IF (Schranke > Best^.Gewinn) AND NOT(zulaessig) THEN
      Verzweige(K^)
    ELSE WRITELN(Dat,' -> ausgelotet.');
    WRITELN(Dat);
  END;
END;


(* Hauptprogramm *)
BEGIN
  ASSIGN(Dat,'branch.out'); REWRITE(Dat);
  WRITELN('Branch and Bound fuer Schmugglerproblem'); WRITELN;
  WRITELN('(1) Einlesen von Datei');
  WRITELN('(2) Generieren eines zufaelligen Problems'); WRITELN;
  WRITE('Bitte waehlen Sie: '); READLN(Wahl);
  IF Wahl = 1 THEN LiesVonDatei
              ELSE BEGIN Generiere; Name:='Generiert' END;
  WRITE('Auswahlregel (1=Gewicht, 2=Gewinn, 3=rel. Gewinn, 4=Unvollstaendig): '); READLN(Auswahl);
  WRITE('Teilproblemreihenfolge (1=zuerst packen, 2=zuerst verbieten): '); READLN(Reihenfolge);
  WRITE('Kletterstrategie (1=Tiefensuche, 2=Breitensuche, 3=Beste Schranke): '); READLN(Kletter);
  WRITE('Logische Tests und Heuristik (1=ohne, 2=nur log. Tests, 3=beides): '); READLN(Zusatz);
  LogTests:=(Zusatz >= 2);
  Heuristik:=(Zusatz = 3);
  WRITELN(Dat,'Einstellung: ',Auswahl:3, Reihenfolge:3, Kletter:3, Zusatz:3);
  Sortiere;     {Sortieren der Gegenstaende}
  (* Initialisierungen *)
  KnotenAnz:=1; Initialisiere(Best); Initialisiere(Wurzel);
  Start:=Wurzel; Letzte:=Wurzel; Wurzel^.Num:=1;
  WRITELN('Problem ',Name,' mit ',n,' Gegenstaenden');
  WRITE('Zulaessige Loesung in der Wurzel: ');
  BerechneSchranke(Wurzel); ObereSchranke:=Wurzel^.Schranke;
  WRITELN;
  WRITELN('Obere Schranke: ',ObereSchranke:0:2);
  WRITE('Bisher beste Gewinne (* Heuristik): ');
  WRITELN(Dat); WRITELN(Dat,'Start von Branch and Bound');
  (* Optimale Loesung bereits in Wurzel ? *)
  IF Wurzel^.zulaessig THEN
    Best^:=Wurzel^
  (* Branch and Bound - Hauptschleife *)
  ELSE REPEAT
    Klettere(Start);      {Klettere zum ersten Knoten der Kandidatenliste}
    Temp:=Start^.Next;    {Gehe zum n"chsten Knoten der Liste}
    DISPOSE(Start);       {Loesche ersten Knoten}
    Start:=Temp;
  UNTIL (Start=NIL) OR    {Abbruch, wenn Kandidatenliste leer oder}
        (Best^.Gewinn >= ObereSchranke-Eps);
                          {theoretisch bestmoeglicher Gewinn erreicht}

  WHILE (Start<>NIL) DO BEGIN   {Aufraeumen der Kandidatenliste}
    Temp:=Start^.Next; DISPOSE(Start); Start:=Temp;
  END;

  WRITELN(Best^.Gewinn,' optimal.');
  WRITELN(Dat,'Optimale Loesung:'); ZeigeKnoten(Best); Dispose(Best);
  CLOSE(Dat);
END.
