unit DBMemTestU;  { 07-AUG-97 as (Arne Schpers) }
(* Heap-berwachung mit DBMem. Diese Unit mu im uses-Abschnitt der
   DPR-Datei an erster Stelle erscheinen:

   program DBMemTest;
   uses
     DBMem, Forms,
     DBMemTestU in 'DBMemTestU.pas' {Form1};
   ...   *)
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, DBMem, Dialogs, StdCtrls;
       // ^^ das Programm ruft Routinen wie DBMemCheckHeap
       // direkt auf - ansonsten wr's unntig.


type
  TForm1 = class(TForm)
    bCreateBMP: TButton;
    bCreateString: TButton;
    bHeapCheck: TButton;
    lHeapCount: TLabel;
    procedure bCreateBMPClick(Sender: TObject);
    procedure bCreateStringClick(Sender: TObject);
    procedure bHeapCheckClick(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ Erzeugt ein Bitmap zuflliger Gre, beschriftet und vergit es }
procedure TForm1.bCreateBMPClick(Sender: TObject);
var OrphanBMP: TBitmap;
begin
  OrphanBMP := TBitmap.Create;
  with OrphanBMP do
  begin
    Width := Random(200)+100; Height := Random(50)+50;
    Canvas.TextOut(0,0,Format('BMP, %d x %d',[Width,Height]));
  end;
  Canvas.Draw(0,100,OrphanBMP);
end;

{ Erzeugt ein Stringobjekt und vergit es danach }
procedure TForm1.bCreateStringClick(Sender: TObject);
var OrphanString: PString;
begin
  New(OrphanString);
  OrphanString^ := 'Vergessener String';
  OrphanString^ := OrphanString^+IntToStr(Random(10000));
end;

{ Gezielter Heap-Check - etwa bei der Suche nach bereits
  bekannten Fehlern }
var HeapCount: Integer;
function MemCheckCallback(Addr: Pointer; Size: Integer;
                       ClassType: TClass): Boolean;
var TestBMP: TBitmap;
begin
  Result := True; // False wre: "Check abbrechen"
  Inc(HeapCount);
  if ClassType = TBitmap then
  begin
    TestBMP := Addr;
    Form1.Canvas.Draw(0,0,TestBMP); // das geht problemlos
    ShowMessage(Format('Bitmap erwischt. Gre: %dx%d, Handle: %d',
      [TestBMP.Width,TestBMP.Height,TestBMP.Handle]));
  end;
end;

procedure TForm1.bHeapCheckClick(Sender: TObject);
begin
  HeapCount := 0;
  // Heap durchlaufen, mit Rckruf fr gefundene Bereiche
  DBMemCheckHeap(MemCheckCallback);
  lHeapCount.Caption := IntToStr(HeapCount)+' Bereiche';
end;


end.
