unit DBShareMem;  { 10-AUG-97 as (Arne Schpers) }
{ Um DBMem erweiterte Version der Standard-Unit ShareMem,
  Copyright (C) des Originals 1995, 97 Borland International }

interface
uses DBMemTypes;

function SysGetMem(Size: Integer): Pointer;
function SysFreeMem(P: Pointer): Integer;
function SysReallocMem(P: Pointer; Size: Integer): Pointer;
function GetHeapStatus: THeapStatus;
function GetAllocMemCount: Integer;
function GetAllocMemSize: Integer;

// An die DLL weitergereiche DBMem-Aufrufe
function DBMemNewRange: TDBMemRange;
procedure DBMemShowRange(Range: TDBMemRange);  // Anzeige
procedure DBMemShowStats;  // Statistik
  // Heap-Prfung
procedure DBMemCheckHeap(Callback: TDBCheckCallback);


implementation

const
  DelphiMM = 'DBDelphiMM.dll';  // anderer DLL-Name

function SysGetMem(Size: Integer): Pointer; external DelphiMM;
function SysFreeMem(P: Pointer): Integer; external DelphiMM;
function SysReallocMem(P: Pointer; Size: Integer): Pointer;
              external DelphiMM;
function GetHeapStatus: THeapStatus; external DelphiMM;
function GetAllocMemCount: Integer; external DelphiMM;
function GetAllocMemSize: Integer; external DelphiMM;

function DBMemNewRange: TDBMemRange; external DelphiMM;
procedure DBMemShowRange(Range: TDBMemRange); external DelphiMM;
procedure DBMemShowStats; external DelphiMM;
procedure DBMemCheckHeap(Callback: TDBCheckCallback);
  external DelphiMM;

const
  SharedMemoryManager: TMemoryManager = (
    GetMem: SysGetMem;
    FreeMem: SysFreeMem;
    ReallocMem: SysReallocMem);

initialization
{$IFDEF VER100}
  if not IsMemoryManagerSet then
{$ENDIF}  // gibt's erst ab Delphi 3.0
    SetMemoryManager(SharedMemoryManager);
end.
