procedure TEditForm.CursorDaten(Sender: TObject);

VAR Zch:         Char;
    Seite:       Integer;

    ASCIIStr:    String [40];
    CursorName:  String [10];

begin
  IF Editor.Modified THEN BEGIN
    Geaendert.Caption := 'Verndert ';
    Geaendert.Font.Color := clRed;
  END
  ELSE BEGIN
    Geaendert.Caption := 'Gesichert ';
    Geaendert.Font.Color := clGreen;
  END;

  IF IsoAnzeige THEN BEGIN

    IF Editor.GetTextLen > 0 THEN Zch := Editor.Text 
[Editor.SelStart]
    Else Zch := #0;

    ASCIIStr := ' Zeichen [' + IntToStr (ORD (Zch)) + ']:';

  END
  ELSE ASCIIStr := '';

  IF CursInsert THEN BEGIN
    CursorName := ' Einf: ';
    SetCaretBlinkTime (cInsertBlink);
  END
  ELSE BEGIN
    CursorName := ' ber: ';
    SetCaretBlinkTime (cOverBlink);
  END;
   Seite := (Editor.SelStart + 1) DIV ZeichenProSeite + 1;
   CursorLabel.Caption :=

   'Spa: ' + IntToStr ({Get}Column) +
   '  Zei: ' + IntToStr ({Get}Row) +
   '  Sei: ' + IntToStr (Seite) +

   ASCIIStr + CursorName +
   IntToStr (Editor.SelStart + 1) +
   '  Block: ' +
   IntToStr (Editor.SelLength) +
   '  Zchn: ' + IntToStr (Editor.GetTextLen) +
   '  Zln: ' + IntToStr (Editor.Lines.Count);

  (* Lineal *)

  WITH Editor.Paragraph DO
    Try
      LRFrame.FUpdating := TRUE;
      ErsteZeileEinrueckung.Left := Trunc (FirstIndent * RulerAdj) 
- 4 + GutterWid;
      LinkeEinrueckung.Left := Trunc ((LeftIndent + FirstIndent) * 
RulerAdj) - 4 + GutterWid;
      RechteEinrueckung.Left := Lineal.ClientWidth - 6 - Trunc 
((RightIndent + GutterWid) * RulerAdj);
      LRFrame.FontGroesse.Text := IntToStr 
(Editor.SelAttributes.Size);
      LRFrame.FontNamen.Text := Editor.SelAttributes.Name;
      LRFrame.SpeedFett.Down := fsBold in 
Editor.SelAttributes.Style;
      LRFrame.SpeedKursiv.Down := fsItalic in 
Editor.SelAttributes.Style;
      LRFrame.SpeedUnter.Down := fsUnderline in 
Editor.SelAttributes.Style;
      CASE ORD (Alignment) OF
        0: LRFrame.SpeedLinks.Down := TRUE;
        1: LRFrame.SpeedRechts.Down := TRUE;
        2: LRFrame.SpeedMitte.Down := TRUE;
      END (* CASE *);
    Finally
      LRFrame.FUpdating := FALSE;
    END;

end;
