/* 
 * Programm Fahrplan fuer den PDA Pilot
 * c't 10/97 Version 1.00 Andreas Linke 1997 
 */
#pragma pack(2)
/* Pilot API headers */
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

/* Resourcen */
#define fMain 1000       /* Hauptform */
#define pDirection 2010  /* Popup trigger Richtung */
#define lDirection 2020  /* Richtung Liste */
#define baselist 3000    /* 1. Liste Fahrplan */

/* lokale Funktionen */

/* Event Handler fuer diese Applikation */
static int ApplicationHandleEvent(EventType *e); 
static void settime(void); /* Ausgabe aktuelle Uhrzeit */
static void setlistitem(int hour,int minute, ListPtr lstptr);
/* loesche alle Fahrplan-Listen */
static void erasealllists(FormPtr frm, ListPtr lstptr); 

/* Pointer auf die gerade ausgewaehlte Fahrplan-Liste */
static ListPtr currentlst=NULL;

/*
 * Eintrittspunkt fuer Pilot-API
 */
DWord PilotMain(Word action, Ptr cmdPBP, Word launchFlags) 
{
/* 0 normaler Programmstart, !=0  spezielle Faelle (Alarm, Suche, etc.) */
if (action != 0) 
    return 0;

FrmGotoForm(fMain); /* lade Hauptform */
/* Endlosschleife zur Event-Verarbeitung */
while(1)
    {
    EventType e;
    EvtGetEvent(&e, 100); /* hole Event aus Queue mit Time-Out 100ms */
    if(e.eType==appStopEvent) /* Applikation beenden? */
        break;
    if(!SysHandleEvent(&e)) /* System Event (Hardware-Buttons etc.) */
        if(!ApplicationHandleEvent(&e)) /* Applikation spezifische Events */
            {
            /* Events fuer die gerade ausgewaehlte Liste */
            if(!currentlst || !LstHandleEvent(currentlst,&e))
                FrmHandleEvent(FrmGetActiveForm(), &e); /* aktives Form */
            }
    settime(); /* gib aktualisierte Uhrzeit im Fenster aus */
    }
return 0;
}

/* 
 * Event-Handling fuer dieses Programm
 * return true wenn Event behandlet wurde
 */
static int ApplicationHandleEvent(EventType *e)
{
FormPtr frm=FrmGetActiveForm();
ListPtr lstptr;
DateTimeType dt;
int lst;

switch(e->eType)
    {
    case frmLoadEvent:
        FrmSetActiveForm(FrmInitForm(e->data.frmLoad.formID));
        return 1;
    case frmOpenEvent:
        FrmDrawForm(frm);
        lstptr=(ListPtr)FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,lDirection));
        if(lstptr)
            erasealllists(frm,lstptr);
        return 1;
    case popSelectEvent:
        if(e->data.popSelect.controlID!=pDirection)
            return 0;
        /* es wurde eine Richtung ausgewaehlt */
        lstptr=(ListPtr)FrmGetObjectPtr(frm,
            FrmGetObjectIndex(frm,lDirection));
        lst=LstGetSelection(lstptr);
        /* loesche alle Listen */
        erasealllists(frm,lstptr);
        lstptr=(ListPtr)FrmGetObjectPtr(frm,
            FrmGetObjectIndex(frm,baselist+lst));
        /* und zeige die ausgewaehlte Liste */
        LstDrawList(lstptr);
        /* setze ausgewaehlten Listitem auf naechstmoegliche Abfahrtzeit */
        TimSecondsToDateTime(TimGetSeconds(),&dt);
        setlistitem(dt.hour,dt.minute,lstptr);
        /* setze currentlst fuer Event-Handling in PilotMain() */
        currentlst=lstptr; 
        return 0; /* gib Event weiter an FrmHandleEvent() */
    default:
    } /* Ende switch */
return 0; /* Event nicht behandelt */
}

/*
 * gib aktuelle Uhrzeit mittels WinDrawChars()
 * auf dem Bildschirm aus
 */
static void settime()
{
DateTimeType dt;
char s[10]; /* String zur Zwischenspeicherung */
char *p=s;
RectangleType r={{6,132},{46,13}}; /* Rahmen um die Uhrzeit */

/* hole aktuelle Uhrzeit */
TimSecondsToDateTime(TimGetSeconds(),&dt);
/* konstruiere String der Form HH.MM:SS, beachte fuehrende Nullen */
if(dt.hour>9) { *p++ = (dt.hour/10)+'0';dt.hour -= (dt.hour/10)*10; }
*p++ = dt.hour+'0';
*p++ = '.';
*p++ = (dt.minute/10)+'0';
dt.minute -= (dt.minute/10)*10; 
*p++ = dt.minute+'0';
*p++ = ':';
*p++ = (dt.second/10)+'0';
dt.second -= (dt.second/10)*10; 
*p++ = dt.second+'0';
*p++ =0; /* String-Ende wie in C ueblich */
/* gib Uhrzeit aus */
FntSetFont(boldFont);
WinDrawChars(s,StrLen(s),8,133);
WinDrawRectangleFrame(simpleFrame,&r);
}

/* 
 * loesche (disable) alle Listen
 * die List-Resourcen bleiben natuerlich erhalten,
 * werdem aber nicht mehr im aktuellen Form angezeigt
 * lstptr ist Pointer auf die Auswahlliste
 */
static void erasealllists(FormPtr frm,ListPtr lstptr)
{
int i;
int num=LstGetNumberOfItems(lstptr);
for(i=0;i<num;i++)
    {
    ListPtr lstptr=(ListPtr)FrmGetObjectPtr(frm,
        FrmGetObjectIndex(frm,baselist+i));
    LstEraseList(lstptr);
    }
currentlst=NULL;
}

/*
 * waehle aus der aktuellen Fahrplanliste lstptr den Item aus,
 * der am naechsten nach der aktuellen Uhrzeit (hour,minute) folgt
 * die Uhrzeiten in der Liste haben das Format HH.MM
 */
static void setlistitem(int hour,int minute, ListPtr lstptr)
{
int i;
int num=LstGetNumberOfItems(lstptr);
for(i=0;i<num;i++)
    {
    char s[40]; /* Zwischenspeicher fuer Uhrzeit aus Liste */
    char *p;
    int h,m;
    StrCopy(s,LstGetSelectionText(lstptr,i));
    p=StrChr(s,'.');
    if(p==NULL)
        continue; /* keine gueltige Zeit */
    /* schneide String in zwei Teile,
       s zeigt auf die Stunden, p auf die Minuten */
    *p++=0; 
    h=StrAToI(s);
    m=StrAToI(p);
    /* Uhrzeit des Listitems nach aktueller Uhrzeit? */
    if(h>hour)
        {
        LstSetSelection(lstptr,i);
        break;
        }
    if(h==hour && m>minute)
        {
        LstSetSelection(lstptr,i);
        break;
        }
    }
}

