

// includes
#include <windows.h>
#include <string.h>
#include <ostream.h>


BOOL RemoveSvc (VOID)
{
	BOOL			removed;
	SC_HANDLE		hManager;
	SC_HANDLE		hService;
	SERVICE_STATUS	svcStatus;
	DWORD			dwCount;

	removed = FALSE;
	// open service control manager with full access right
	hManager = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
	if (NULL != hManager) {
		// open existing service
		hService = OpenService(hManager, "CleanSvc", SERVICE_ALL_ACCESS);
		if (NULL != hService) {
			// get the status of the service
			if (QueryServiceStatus(hService, &svcStatus)) {
				// and see if the service is stopped
				if (SERVICE_STOPPED != svcStatus.dwCurrentState) {
					// if not stop the service
					ControlService(hService, SERVICE_CONTROL_STOP, &svcStatus);
				}
				dwCount = 0;
				do {
					if (SERVICE_STOPPED == svcStatus.dwCurrentState) {
						// delete the service
						if (DeleteService(hService)) {
							removed = TRUE;
							break;
						}
					}
					// wait 10 seconds for the service to stop
					Sleep(10000);
					if (!QueryServiceStatus(hService, &svcStatus)) {
						// something went wrong
						break;
					}
					dwCount++;
				} while (10 > dwCount);
			}
			// close service handle
			CloseServiceHandle(hService);
		}
		// close service control manager
		CloseServiceHandle(hManager);
	}
	return removed;
} /* RemoveSvc */


BOOL InstallSvc (CHAR *svcExePath)
{
	BOOL		installed;
	HKEY		hKey;
	SC_HANDLE	hManager;
	SC_HANDLE	hService;

	installed = FALSE;
	// open the service control manager with full access right
	hManager = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
	if (NULL != hManager) {
		// create the service
		hService = CreateService(hManager,
								"CleanSvc",						// name of the service
								"Directory Cleanup Service",	// description
								SERVICE_ALL_ACCESS,				// accessmode
								SERVICE_WIN32_OWN_PROCESS,		// type of service
								SERVICE_AUTO_START,				// startmode
								SERVICE_ERROR_NORMAL,			// error treatment
								svcExePath,						// full path and name of the exe
								NULL,							// no load order enty						
								NULL,							// no tag requested
								NULL,							// no dependencies
								".\\Administrator",				// Administrator account
								"");							// dummy user password
		if (NULL != hService) {
			// close service handle
			CloseServiceHandle(hService);
			// create the parameters registry tree
			if (ERROR_SUCCESS == RegCreateKey(HKEY_LOCAL_MACHINE,
						"SYSTEM\\CurrentControlSet\\Services\\CleanSvc\\Parameters\\Directories",
						&hKey)) {
				RegCloseKey(hKey);
			}
			installed = TRUE;
		}
		// close service control manager
		CloseServiceHandle(hManager);
	}
	return installed;
} /* InstallSvc */



VOID ShowUsage (VOID)
{
	cout << "\r\n - Copyright (C) 1997 by Robert Knabe\r\n\r\n"; 
	cout << " - Usage :\r\n";
	cout << "       To install CleanSvc : InstSvc FullServiceExePath\r\n";
	cout << "       To remove CleanSvc  : InstSvc remove\r\n\r\n";
	cout << "   Use Regedt32 to specify the directories the service should\r\n";
	cout << "   work in. Open the key HKEY_LOCAL_MACHINE\\SYSTEM\\ \r\n";
	cout << "   CurrentControlSet\\Services\\CleanSvc\\Parameters\\Directories.\r\n";
	cout << "   To this key add values of any name and types REG_EXPAND_SZ or\r\n";
	cout << "   REG_SZ. For each value enter a command line of the form:\r\n";
	cout << "       dir age [/F] [/P] [/D] [/E] [/K] [/L:logfile]\r\n\r\n";
	cout << "   Explanation :\r\n";
	cout << "       dir        : Full path to the directory (not deleted).\r\n";
	cout << "       age        : Number of days the files are kept (1..365).\r\n\r\n";
	cout << "   Options :\r\n";
	cout << "       /F         : Use this switch on drives using a filesystem\r\n";
	cout << "                    like FAT that only keeps track of the files\r\n";
	cout << "                    creation dates and not of the last access times.\r\n";
	cout << "       /P         : Preserve directories.\r\n";
	cout << "       /D         : Log the name of all deleted files.\r\n";
	cout << "       /E         : Log the names of files that could not be\r\n";
	cout << "                    deleted due to security attributes.\r\n";
	cout << "       /K         : Log the names of all kept files.\r\n";
	cout << "       /L:logfile : Specifies the name and full path of a logfile.\r\n\r\n\r\n";
} /* ShowUsage */


INT main (INT argc, CHAR *argv[])
{
	INT		retCode;
	CHAR	tmpStr[MAX_PATH];

	retCode = 1;
	if (2 != argc) {
		ShowUsage();
	}
	else {
		strcpy(tmpStr, argv[1]);
		_strupr(tmpStr);
		cout << "\r\n - Copyright (C) 1997 by Robert Knabe\r\n\r\n"; 
		if (0 == strcmp("REMOVE", tmpStr)) {
			if (RemoveSvc()) {
				cout << " - CleanSvc removed.\r\n\r\n";
				retCode = 0;
			}
			else {
				cout << " - Error removing CleanSvc.\r\n\r\n";
			}
		}
		else {
			if (InstallSvc(argv[1])) {
				cout << " - CleanSvc installed.\r\n";
				cout << "   Now set the directories to work on using REGEDT32 and\r\n";
				cout << "   the startup parameters via the Control Panel.\r\n";
				cout << "   See the file CleanSvc.doc for details or call InstSvc\r\n";
				cout << "   without any parameters.\r\n";
				retCode = 0;
			}
			else {
				cout << "\r\n - Error installing CleanSvc.\r\n\r\n";
			}
		}
	}
	return retCode;
} /* main */
