


#ifndef CTagDir_h
#define CTagDir_h 1


// includes
#include <windows.h>
#include "CLogStrm.hpp"


// class to do the directory processing
class CTagDir
{

	public:

		CTagDir (const CHAR* cmdLine);
		~CTagDir (VOID);
		BOOL StartSearch (const INT threadPriority = THREAD_PRIORITY_NORMAL);
		BOOL StopSearch (VOID);
		VOID Search (VOID);

	private:

		BOOL	nonNTFS;
		BOOL	preserveDirs;
		CHAR	fullPath[MAX_PATH];
		ULONG	minSecondsAge;
		ULONG	logFlags;
		CHAR	logFileName[MAX_PATH];
		DWORD	idThread;
		HANDLE	hThread;
		HANDLE	hEvent;

		static DWORD SearchThread (const CTagDir* tag);

		VOID SearchDir (const CHAR* fullPath,
						const ULONG minSecondsAge,
						const ULONG logFlags,
						const BOOL nonNTFS,
						const BOOL preserveDirs,
						CLogStream& logStream) const;
		CTagDir (const CTagDir& sourceTag);
		CTagDir& operator= (const CTagDir& sourceTag);

}; /* class CTagDir */


#endif