Option Explicit

' Name: ImportWizard
' 
' Autor: Ralf Hskes (fr c't 14/97)
' Email: ralf.hueskes@jabadoo.de
' Homepage: http://www.jabadoo.de/about/hueskes.html
'
' Handhabung: Der Wizard wird ber die Funktion Main gestartet.

' Deklaration der globalen Statusvariablen

Dim Page ' Aktuelle Dialogseite
Dim DatabaseName ' Aktuelle Datenbank
Dim TableName ' Aktuelle Tabelle


' ***** 
' ***** Hauptfunktion (Start des Wizards)
' ***** 

Sub Main
	Page = 1
	Dlg.Load()
	UpdateDatabaseNames
	Dlg.Show()
End Sub


' ***** 
' ***** Datenbank-Zugriffe
' ***** 

' verfgbare Datenbanken auslesen, Namen in ListBox 1 eintragen
' (Dialogseite 1)

Sub UpdateDatabaseNames
	Dim I
	DatabaseName = ""
	TableName = ""
	Dlg.ListBox1.Clear()
	Dlg.ListBox2.Clear()
	
	' Auslesen der verfgbaren Datenbanknamen
	For I = 1 to Application.DataDefinedDatabaseNumber() 
		Dlg.ListBox1.AddItem(Application.DataDefinedDatabase(I))
	Next I
	
	UpdateButtons
End Sub

' Anwender hat Datenbankname angeklickt (Dialogseite 1)

Sub DatabaseSelected
	UpdateTableNames
End Sub

' Tabellennamen auslesen, Namen in ListBox 2 eintragen 
' (Dialogseite 1)

Sub UpdateTableNames
	Dim I
	
	' Name der aktuellen Datenbank in globaler Variable ablegen
	DatabaseName = Dlg.ListBox1.List(Dlg.ListBox1.ListIndex())

	TableName = ""
	Dlg.ListBox2.Clear()
	
	' Auslesen der verfgbaren Datenbanken
	For I = 1 to Application.DataTableNumber(DatabaseName) 
		Dlg.ListBox2.AddItem( _
			Application.DataGetTableName(DatabaseName, I))
	Next I
	
	UpdateButtons
End Sub

' Anwender hat Tabellenname angeklickt (Dialogseite 1)

Sub TableSelected
	' Name der aktuellen Tabelle in globaler Variable ablegen
	TableName = Dlg.ListBox2.List(Dlg.ListBox2.ListIndex())
	UpdateButtons
End Sub

' Feldnamen auslesen und in Listbox 1 eintragen (Dialogseite 2)

Sub UpdateFieldNames
	Dim I
	Dlg.ListBox1.Clear()
	Dlg.ListBox2.Clear()
	
	' ffnen der Datenbankverbindung
	Application.OpenDatabaseConnection(DatabaseName)
	
	' ffnen der Tabelle
	Application.OpenTableConnection(TableName)

	' Feldnamen in Listbox 1 einfgen
	For I = 1 to Application.DataColumnNumber()
		Dlg.ListBox1.AddItem(Application.DataColumnName(I))
	Next I
	
	' Schlieen der Datenbankverbindung
	Application.CloseDatabaseConnection(DatabaseName)
	
	' ersten Eintrag der Listbox selektieren
	If Dlg.ListBox1.ListCount() > 0 Then
		Dlg.ListBox1.Selected(0) = True
	End If
	
	UpdateButtons
End Sub

' ausgewhle Tabelle in Textdokument importieren (Dialogseite 2)

Sub DoImport
	Dim I, S
	
	' ffnen der Datenbankverbindung
	Application.OpenDatabaseConnection(DatabaseName)

	' ffnen der Tabelle
	Application.OpenTableConnection(TableName)
	
	' Beginn der Ausgabe (falls Datensatz vorhanden)
	If Application.DataFirstRecord() Then
	
		' Schleife ber alle Datenstze
		Do 
		
			' Schleife ber alle Felder im aktuellen Datensatz
			For I = 1 To Dlg.ListBox2.ListCount()

			   ' Auslesen der aktuellen Daten
			   S = Application.DataColumn(Dlg.ListBox2.List(I-1))
				
			   ' Einfgen des Daten in Textdokument
			   Selection.Insert(S & ", ")
			Next I 
			
			' Einfgen eines Zeilenumbruches in Textdokument
			Selection.InsertLinebreak()
			
		Loop While Application.DataNextRecord()
	End If
	
	' Schlieen der Datenbank
	Application.CloseDatabaseConnection(DatabaseName)
End Sub


' ***** 
' ***** Hilfsfunktionen fr Dialog
' ***** 

' Element in Listbox 1 angeklickt

Sub ListBox1_Clicked
	If Page = 1 Then
		DatabaseSelected
	End If
End Sub

' Element in Listbox 2 angeklickt

Sub ListBox2_Clicked
	If Page = 1 Then
		TableSelected
	End If
End Sub

' Schalter zum Verschieben von Element in Listbox 2 gedrckt

Sub AddField_Clicked
	Dim I
	I = Dlg.ListBox1.ListIndex()
	
	' Einfgen des Elementes in Listbox 2
	Dlg.ListBox2.AddItem(Dlg.ListBox1.List(I))
	
	' Lschen des Elemtentes aus Listbox 1
	Dlg.ListBox1.RemoveItem(I)
	
	' Selektion setzen
	If Dlg.ListBox1.ListCount() > 0 Then
		Dlg.ListBox1.Selected(0) = True
	End if
	Dlg.ListBox2.Selected(0) = True
	
	UpdateButtons
End Sub

' Schalter zum Verschieben von Element in Listbox 1 gedrckt

Sub RemoveField_Clicked
	Dim I
	I = Dlg.ListBox2.ListIndex()
	
	' Einfgen des Elementes in Listbox 1
	Dlg.ListBox1.AddItem(Dlg.ListBox2.List(I))

	' Lschen des Elemtentes aus Listbox 2
	Dlg.ListBox2.RemoveItem(I)

	' Selektion setzen (fr beide Listboxen)
	If Dlg.ListBox2.ListCount() > 0 Then
		Dlg.ListBox2.Selected(0) = True
	End if
	Dlg.ListBox1.Selected(0) = True

	UpdateButtons
End Sub

' Schalter zum Wechsel zur nchsten Dialogseite gedrckt

Sub Next_Clicked
	If Page = 1 Then
		Page = 2

		' Anpassen der Beschriftungen
		Dlg.Label1.Caption = "Verfgbare Felder:"
		Dlg.Label2.Caption = "Ausgewhlte Felder:"
		Dlg.Caption = "ImportWizard - Schritt 2"
		
		' Aktualisieren der Daten
		UpdateFieldNames
		UpdateButtons
	Else
		Ok_Clicked
	End If
End Sub

' Schalter zum Wechsel zur vorherigen Dialogseite gedrckt

Sub Prev_Clicked
	Page = 1
	
	' Anpassen der Beschriftungen
	Dlg.Label1.Caption = "Datenbanken:"
	Dlg.Label2.Caption = "Tabellen:"
	Dlg.Caption = "ImportWizard - Schritt 1"
	
	' Aktualisieren der Daten
	UpdateDatabaseNames
	UpdateButtons
End Sub

' Ok-Schalter gedrckt

Sub Ok_Clicked
	DoImport
	Dlg.Hide()
	Dlg.UnLoad()
End Sub

' Abbrechen-Schalter gedrckt

Sub Cancel_Clicked
	Dlg.Hide()
	Dlg.UnLoad()
End Sub

' Hilfsfunktion: Status der Schaltflchen aktualisieren

Sub UpdateButtons

	' Schalter "Weiter" ein- bzw. ausschalten
	Dlg.Next.Enabled = _
		((Page = 1) AND (TableName <> "")) OR _
		((Page = 2) And 	(Dlg.ListBox2.ListCount() > 0))

	' Schalter "Zurck" ein- bzw. ausschalten
	Dlg.Prev.Enabled = _
		(Page = 2)

	' Schalter "Ok" ein- bzw. ausschalten
	Dlg.Ok.Enabled = _
		((Page = 2) And (Dlg.ListBox2.ListCount() > 0))

	' Schalter ">" ein- bzw. ausblenden und ein- bzw. ausschalten
	Dlg.AddField.Visible = _
		(Page = 2)
	Dlg.AddField.Enabled = _
		(Dlg.ListBox1.ListCount() > 0)

	' Schalter "<" ein- bzw. ausblenden und ein bzw. ausschalten
	Dlg.RemoveField.Visible = _
		(Page = 2)
	Dlg.RemoveField.Enabled = _
		(Dlg.ListBox2.ListCount() > 0)
		
End Sub
