#!/usr/bin/perl

#----------------#
# Glob.Variable: #
#----------------#

$argumente	= $ARGV[0];
$adressat	= "a.schroeter\@hermes.de";
$ordrcookie	= "SCHLECKI_BESTELLUNG";
$usercookie	= "SCHLECKI_BESUCHER";
$datatab	= "items.csv";
$hoptplfile	= "hopper_tpl.html";
$hoprowfile	= "hopper_row.html";
$ordtplfile	= "order_tpl.html";
$ordrowfile	= "order_row.html";

$insstr = "";

#----------------#
# Hauptprogramm: #
#----------------#

if ($argumente) {
	@parameter = split(/:/,$argumente);
	if ($parameter[0] eq "showHopper") {
		&showHopper;
	} elsif ($parameter[0] eq "showOrder") {
		&showOrder;
	} elsif ($parameter[0] eq "sendOrder") {
		&sendOrder;
	} else {
		die "Content-type: text/html\n\nFEHLER: Argument fehlerhaft: $parameter[0]\n";
	}
}

#----------------#
# Unterroutinen: #
#----------------#

sub showHopper {
	open (FILE, $hoprowfile) || die "Content-type: text/html\n\nFehler beim Lesen der Datei $hoprowfile<BR>\n";
	while (<FILE>) { $rowtpl .= $_; }
	close (FILE);
	$ordsum = 0;
	$cookie = &getCookie($ordrcookie);
	if ($cookie ne "") {
		@cokarr=split(/;/, $cookie);
		open (FILE, $datatab) || die "Content-type: text/html\n\nFehler beim Lesen der Datei $datatab";
		while (<FILE>) {
			@tempvalue=split(/;/, $_);
			foreach $a (@cokarr){
				@namarr=split(/:/, $a);
				if ($namarr[0] eq $tempvalue[0]){
					$newrow = $rowtpl;
					$newrow =~ s/P_PCS_NAM/$tempvalue[0]/g;
					$newrow =~ s/<!--PRODUCT-->/$tempvalue[1]/g;
					$newrow =~ s/<!--PRICEPU-->/$tempvalue[2]/g;
					$newrow =~ s/P_PCS_VAL/$namarr[1]/g;
					&HiASCII2LoASCII($newrow);
					$insstr .= $newrow;
				}
			}
		}
		close (FILE);
	} else {
		$insstr = "<TR>\n\t<TD>&nbsp;</TD>\n<TD COLSPAN=\"3\"><CODE>Ihr Warenkorb ist leer!</CODE></TD>\n</TR>";
	}
	
	open (FILE, $hoptplfile) || die "Content-type: text/html\n\nFehler beim Lesen der Datei $hoptplfile\n";
	while (<FILE>) { $tplstr .= $_; }
	close(FILE);
	$buttons = "<INPUT NAME=\"BT_ORDER\" TYPE=\"BUTTON\" VALUE=\"Bestellung aufgeben\" onClick=\"saveForm();window.location = 'persdat.html';\">";
	$tplstr =~ s/<!--INS-->/$insstr/;
	if ($cookie ne "") { $tplstr =~ s/<!--BT_ORDER-->/$buttons/; }
	# --- HTML-Seite anzeigen ---
	print "Content-type: text/html\n\n" . $tplstr;
}
	
sub showOrder {
	$ordsum = 0;
	open (FILE, $ordrowfile) || die "Content-type: text/html\n\nFehler beim Lesen der Datei $hoprowfile<BR>\n";
	while (<FILE>) { $rowtpl .= $_; }
	close (FILE);
	$ordsum = 0;
	$cookie = &getCookie($ordrcookie);
	if ($cookie ne "") {
		@cokarr=split(/;/, $cookie);
		open (FILE, $datatab) || die "Content-type: text/html\n\nFehler beim Lesen der Datei $datatab";
		while (<FILE>) {
			@tempvalue=split(/;/, $_);
			foreach $a (@cokarr){
				@namarr=split(/:/, $a);
				if ($namarr[0] eq $tempvalue[0]){
					$tmpsum = ($tempvalue[2] * $namarr[1]);
					$ordsum += $tmpsum;
					$newrow = $rowtpl;
					$newrow =~ s/<!--PRODUCT-->/$tempvalue[1]/g;
					$newrow =~ s/<!--PRICEPU-->/$tempvalue[2]/g;
					$newrow =~ s/<!--P_PCS_VAL-->/$namarr[1]/g;
					$newrow =~ s/<!--P_SUM_P_U-->/$tmpsum/g;
					&HiASCII2LoASCII($newrow);
					$insstr .= $newrow;
				}
			}
		}
		close (FILE);
	} else {
		$insstr = "<TR>\n\t<TD COLSPAN=\"2\"><CODE>Ihr Warenkorb ist leer!</CODE></TD>\n</TR>";
	}
	$cookie = &getCookie($usercookie);
	if ($cookie ne "") {
		@cokarr=split(/;/, $cookie);
		$name1 = $cokarr[0];
		$addr1 = $cokarr[1];
		$addr2 = $cokarr[2];
		$email = $cokarr[3];
	}
	
	open (FILE, $ordtplfile) || die "Content-type: text/html\n\nFehler beim Lesen der Datei $hoptplfile\n";
	while (<FILE>) { $tplstr .= $_; }
	close(FILE);
	$tplstr =~ s/<!--INS-->/$insstr/;
	$tplstr =~ s/<!--NAME1-->/$name1/;
	$tplstr =~ s/<!--ADDR1-->/$addr1/;
	$tplstr =~ s/<!--ADDR2-->/$addr2/;
	$tplstr =~ s/<!--EMAIL-->/$email/;
	$tplstr =~ s/<!--P_SUM_ORD-->/$ordsum/g;
	# --- HTML-Seite anzeigen ---
	print "Content-type: text/html\n\n" . $tplstr;
}

sub sendOrder {
	$ordsum = 0;
	$cookie = &getCookie($usercookie);
	if ($cookie ne "") {
		@cokarr=split(/;/, $cookie);
		$name1 = $cokarr[0];
		$addr1 = $cokarr[1];
		$addr2 = $cokarr[2];
		$email = $cokarr[3];
	}
	$cookie = &getCookie($ordrcookie);
	if ($cookie ne "") {
		@cokarr=split(/;/, $cookie);
		open (FILE, $datatab) || die "Content-type: text/html\n\nFehler beim Lesen der Datei $datatab";
		while (<FILE>) {
			@tempvalue=split(/;/, $_);
			foreach $a (@cokarr){
				@namarr=split(/:/, $a);
				if ($namarr[0] eq $tempvalue[0]){
					$tmpsum = ($tempvalue[2] * $namarr[1]);
					$ordsum += $tmpsum;
					$insstr .= $namarr[1] . " Stueck " . $tempvalue[1] . " zu je DM ". $tempvalue[2] . " (Summe: DM " . $tmpsum . ")\n";
				}
			}
		}
		close (FILE);
		$insstr .= "\nGesamtsumme: DM $ordsum";
	} else {
		$insstr = "Keine Artikel zur Bestellung gekennzeichnet!";
	}
	$mailstring = $insstr;
	&HiASCII2LoASCII($mailstring);
	open(MAIL,"|mail $email,$adressat");
	print MAIL "BESTELLUNG\n\n";
	print MAIL $name1 . "\n";
	print MAIL $addr1 . "\n";
	print MAIL $addr2 . "\n";
	print MAIL $email . "\n\n";
	print MAIL "bestellt\n\n";
	print MAIL $mailstring;
	close(MAIL);
	# --- HTML-Seite anzeigen ---
	print "Content-type: text/html\n\n";
	open(HTMLFILE,"./danke.html"); while(<HTMLFILE>) { print; } close(HTMLFILE); exit;	
}

sub getCookie {
	local(@rawCookies) = split (/; /,$ENV{'HTTP_COOKIE'});
	local(%cookies);
	foreach(@rawCookies){
		($key, $val) = split (/=/,$_);
		$cookies{$key} = $val;
	} 
	$cokval=$cookies{$_[0]};
	$cokval =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$str2del = $ordrcookie . "="; 	# Sonderaktion, extra fuer
	$cokval =~ s/$str2del//;		# den Internot Explorer
	return $cokval;
} 

sub HiASCII2LoASCII {
	$_[0] =~ s//Ae/g;		# Umlaute umwandeln
	$_[0] =~ s//ae/g;
	$_[0] =~ s//Oe/g;
	$_[0] =~ s//oe/g;
	$_[0] =~ s//Ue/g;
	$_[0] =~ s//ue/g;
	$_[0] =~ s//ss/g;
	$_[0] =~ s//e/g;
}

sub HiASCII2HTML{
	$_[0] =~ s//&Auml;/g;		# Umlaute umwandeln
	$_[0] =~ s//&auml;/g;
	$_[0] =~ s//&Ouml;/g;
	$_[0] =~ s//&ouml;/g;
	$_[0] =~ s//&Uuml;/g;
	$_[0] =~ s//&uuml;/g;
	$_[0] =~ s//&szlig;/g;
	$_[0] =~ s//&eacute;/g;
}
