program EPROM_Simulator_Treiber;

 (* Original 11.06.91 Tilmann Reh                               *)
 (* gendert fr serielle Schnittstelle von C. Meyer 12/97      *)

 (* Programm zum Ansteuern des EPROM-Simulators REH-ESIM 08/16. *)
 (* Geschrieben fr Turbo-Pascal 5.5 (prinzipiell ab V4.0).     *)


 (* Binrdateien und Intel-HEX knnen bearbeitet werden.        *)
 (* Unterscheidung anhand des Dateityps (.HEX); ist kein Typ    *)
 (* angegeben, so wird .HEX angenommen.                         *)

 (* Der Datenpuffer von 64k kann leider nicht sauber deklariert *)
 (* werden, da Turbo-Pascal Variablengren intern als Word-    *)
 (* Variablen handhabt. Deswegen wird ein um genau 1 Byte zu    *)
 (* kleines Array deklariert und spter 'berfahren'. Dies ist  *)
 (* mglich, da es a) die letzte bzw. einzige Variable auf dem  *)
 (* Heap ist und b) der Heap segmentweise verwaltet wird.       *)

 {$R-}
 (* Array-Bereichs-Check ausschalten! *)

  uses
    dos;

  const
    signon = ^m^j'ESIM 08/16 COM1-Treiber V1.1  CM 12/97'^m^j;


 {Serielle Schnittstelle}
  type
    ParTyp = (n, e, o);       (* Parities *)
    DBitTyp = 5..8;         (* Datenbits *)
    SBitTyp = 1..2;         (* Stopbits *)

  const
    combase = $3f8;             (* $3F8 = COM1, $2F8 = COM2 *)
    waitcts: boolean = true;   (* 8250 Flow controls *)
    waitdsr: boolean = false;
    setdtr: boolean = true;
    setrts: boolean = true;

 {8250 Registerbelegung}
    Intmask = 1;
    Intstat = 2;
    LineCtrl = 3;
    ModemCtrl = 4;
    Linestat = 5;
    Modemstat = 6;

 {Modem Status Register}
    DCD = $80;
    RI = $40;
    DSR = $20;
    CTS = $10;
    DDCD = $8;
    TERI = $4;
    DDSR = $2;
    DCTS = $1;

 {Modem Control Register}
    Loop = $10;
    OUT2 = $8;
    OUT1 = $4;
    RTS = $2;
    DTR = $1;

 {Line Status Register}
    TEMT = $40;
    THRE = $20;
    BI = $10;
    FE = $8;
    PE = $4;
    OE = $2;
    DR = $1;


 {ESIM-Variablen}
  type
    simbuftyp = array[0..65534] of byte;

  var
    filnam, filext: string;
    simbuf: ^simbuftyp;
    laenge: longint;


 (* Untersuchen eines Dateinamens auf Angabe einer Extension,   *)
 (* gefundene Extension wird (Upcase) in FILEXT gespeichert.    *)

  function extension (s: string): boolean;
    var
      i, j: integer;
  begin
    extension := false;
    filext := '';
    for i := length(s) downto 2 do
      begin
        if s[i] = '\' then
          exit;
        if s[i] = '.' then
          begin
            extension := true;
            filext := copy(s, succ(i), 255);
            for j := 1 to length(filext) do
              filext[j] := upcase(filext[j]);
            exit;
          end;
      end;
  end;


 (* Binrdatei ffnen und in Puffer SIMBUF lesen.               *)
 (* Lesen in zwei Abschnitten, da sonst nur max. 65535 Byte     *)
 (* gelesen werden knnen (Lngenangabe durch WORD).            *)

  procedure getbinfile;
    var
      binfil:
      file;
      n: word;
  begin
    assign(binfil, filnam);
   {$I-}
    reset(binfil, 1);
 {$I+}
    if ioresult <> 0 then
      begin
        writeln('Fehler beim ffnen von ', filnam);
        halt;
      end;
    blockread(binfil, simbuf^[0], 32768, n);
    laenge := n;
    if n = 32768 then
      begin
        blockread(binfil, simbuf^[32768], 32768, n);
        inc(laenge, n);
      end;
    close(binfil);
  end;


 (* HEX-Datei ffnen und in Puffer SIMBUF lesen. Untersttzt    *)
 (* werden nur unsegmentierte Dateien.                          *)

  procedure gethexfile;
    var
      hexfil: text;
      s: string;
      anz, typ, chk, i, n: byte;
      zeile, adr: word;
      ende: boolean;

    function gethex (ziffern: byte): word;
      var
        st: string;
        x, y: word;
    begin
      st := '$' + copy(s, n, ziffern);
      val(st, x, y);
      if y <> 0 then
        writeln(zeile, ': Fehler in HEX-Daten!');
      inc(n, ziffern);
      chk := chk + lo(x) + hi(x);
      gethex := x;
    end;

  begin
    assign(hexfil, filnam);
   {$I-}
    reset(hexfil);
 {$I+}
    if ioresult <> 0 then
      begin
        writeln('Fehler beim ffnen von ', filnam);
        halt;
      end;
    ende := false;
    zeile := 0;
    laenge := 0;
    while not ende do
      begin
        if eof(hexfil) then
          begin
            writeln('Fehler: kein EOF-Record!');
            close(hexfil);
            exit;
          end;
        readln(hexfil, s);
        inc(zeile);
        if s[1] = ':' then
          begin
            n := 2;
            chk := 0;
            anz := gethex(2);
            adr := gethex(4);
            typ := gethex(2);
            case typ of
              0:
                begin
                  for i := 1 to anz do
                    begin
                      simbuf^[adr] := gethex(2);
                      inc(adr);
                    end;
                  if adr > laenge then
                    laenge := adr;
                end;
              1:
                ende := true;
              2, 3:
                writeln(zeile, ': Fehler - Segmentierte Datei!');
              else
                writeln(zeile, ': Fehler - unbekannter Datentyp!');
            end;
            i := gethex(2);
            if chk <> 0 then
              writeln(zeile, ': Fehler - Checksumme!');
          end;
      end;
    close(hexfil);
  end;


 (* Puffer SIMBUF zum Simulator senden. Ausgabe ber Serial-    *)
 (* Interrupt, da BDOS nicht unmanipuliert ausgibt.             *)
 (* Aus Geschwindigkeitsgrnden keine Fehlerberprfung bei     *)
 (* bertragung. Wer will, kann leicht weitere Abfrage einfgen.*)

  procedure initcom (Baud: real; DataBits: DBitTyp; StopBits: SBitTyp; parit: ParTyp);
    var
      divisor: integer;
      local: byte;
      Baudrate: real;

  begin
    divisor := round(115200.0 / Baud);
    Baudrate := 115200.0 / divisor;
    port[combase + LineCtrl] := $80;                    (* Divisor Latch enable *)
    port[combase] := lo(divisor);                   (* Baudrate             *)
    port[combase + 1] := hi(divisor);                   (*          setzen      *)
    local := 0;
    case DataBits of
      8:
        local := 3;
      7:
        local := 2;
      6:
        local := 1;
    end;                        (* sonst Default (5 DB) *)
    if (StopBits = 2) then
      local := local or 4;
    case parit of
      e:
        local := local or $18;  (* even Par. *)
      o:
        local := local or $08;  (*  odd Par. *)
      n:
    end;                        (* sonst Default ( no Par.) *)
    port[combase + LineCtrl] := local; (* bertragungsparm. setzen *)
    port[combase + Intmask] := 0;      (* Kein Interrupt  *)
    port[combase + ModemCtrl] := $03;  (* DTR/RTS on, IRQ dis. (OUT2=0) *)
    local := port[combase];            (* alte "Reste" entfernen *)
  end;


  function Outbyte (outwert: byte): byte;
 (* Byte in OutWert ausgeben. Liefert ggf. Fehlercode *)
    var
      timeoutcnt: longint;
      sendresult: byte;
      label senderr;

  begin
    timeoutcnt := 1000000;  (* rund eine Sekunde *)
    sendresult := 0;        (* kein Fehler *)
    while ((port[combase + Linestat] and THRE) = 0) do
 (* warten bis Platz im Transmitter Holding Register *)
      begin
        dec(timeoutcnt);
        if timeoutcnt = 0 then
          begin
            sendresult := 1;
            goto senderr;
          end;
      end;
    Timeoutcnt := 1000000;
    if waitDSR then
      while ((port[combase + Modemstat] and DSR) = 0) do
 (* warten bis DSR *)
        begin
          dec(timeoutcnt);
          if timeoutcnt = 0 then
            begin
              sendresult := 2;
              goto senderr;
            end;
        end;
    Timeoutcnt := 1000000;
    if waitCTS then
      while ((port[combase + Modemstat] and CTS) = 0) do
 (* warten bis CTS  *)
        begin
          dec(timeoutcnt);
          if timeoutcnt = 0 then
            begin
              sendresult := 3;
              goto senderr;
            end;
        end;
    if setRTS then
      port[combase + ModemCtrl] := port[combase + ModemCtrl] or RTS;
 (* Zeichen -> COMn *)
    port[combase] := outwert;
    if setRTS then
      port[combase + ModemCtrl] := port[combase + ModemCtrl] and not RTS;
    senderr:
    outbyte := sendresult;
  end;


  function write_esim: boolean;
    var
      r: registers;
      count: word;
      errcode: byte;
  begin
    initcom(57600, 8, 1, n);
    for count := 0 to pred(laenge) do
      begin
        if outbyte(simbuf^[count]) <> 0 then
          begin
            writeln(count, ': Fehler - Timeout, Schnittstelle nicht bereit!');
            write_esim:=false;
            exit;
          end;
      end;
    write_esim:=true;
  end;


(*---------------------------- MAIN ---------------------------*)

begin
  writeln(signon);
  new(simbuf);
  simbuf^[0] := $FF;
  fillchar(simbuf^[1], 65535, $FF);
  if paramcount > 0 then
    filnam := paramstr(1)
  else
    begin
      write('Dateiname: ');
      readln(filnam);
      if filnam = '' then
        halt;
    end;
  if extension(filnam) then
    if filext = 'HEX' then
      gethexfile
    else
      getbinfile
  else
    begin
      filnam := filnam + '.HEX';
      gethexfile;
    end;
  if write_esim then
    begin
      writeln(filnam, ' zum Simulator bertragen.');
      writeln('Lnge ', laenge, ' Bytes.');
    end;
end.