unit MiniServMain;  // 18-DEC-97 as
// Minimalistischer COM-Server als alternative Zwischenablage

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;  // nur zur Darstellung
    Label1: TLabel;  // "COM-Objekte"
    lObjCount: TLabel;
  private
    FTextBuffer: String;
    FID: Integer;  // durch IDToList fortlaufend erhht
    FObjList: TList;  // IDs der COM-Objekte
  protected
    procedure SetTextBuffer(Value: String);
  public
    procedure Shutdown;
    property TextBuffer: String read FTextBuffer write SetTextBuffer;
    function IDToList: Integer;  // ID als Ergebnis
    procedure DeleteIDFromList(ID: Integer); // raus aus der Liste
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}

procedure TForm1.SetTextBuffer(Value: String);
begin
  Memo1.SetTextBuf(PChar(Value));
  FTextBuffer := Value;
end;

procedure TForm1.Shutdown;
begin  // gewaltsames Ende
  PostQuitMessage(0);
end;

function TForm1.IDToList: Integer;  // ID als Ergebnis
begin
  if FObjList = nil then FObjList := TList.Create;
  Inc(FID); FObjList.Add(Pointer(FID));
  Result := FID;
  lObjCount.Caption := IntToStr(FObjList.Count);
end;

procedure TForm1.DeleteIDFromList(ID: Integer);
begin
  if FObjList = nil then Exit;
  FObjList.Remove(Pointer(ID));
  lObjCount.Caption := IntToStr(FObjList.Count);
end;

end.
