// MyChild.cpp : implementation file
//

#include "stdafx.h"
#include "MFCGame.h"
#include "MyChild.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMyChild

CMyChild::CMyChild()
{
	int i;
	__int64 f;

	SetMode(3);
	m_anf=2;
	m_spiel=TRUE;
	m_dran=m_anf;
	memset(m_feld,0,16);
	f=1;
	c_fac[0]=0;
	for(i=1; i<=16; i++)
	{
		c_fac[i]=f;
		f=f*(i+1);
	}
}

CMyChild::~CMyChild()
{
}

BEGIN_MESSAGE_MAP(CMyChild, CWnd)
	//{{AFX_MSG_MAP(CMyChild)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	ON_COMMAND(ID_OPT_O, OnOptO)
	ON_UPDATE_COMMAND_UI(ID_OPT_O, OnUpdateOptO)
	ON_COMMAND(ID_OPT_X, OnOptX)
	ON_UPDATE_COMMAND_UI(ID_OPT_X, OnUpdateOptX)
	ON_COMMAND(ID_GAME_SUGG, OnGameSugg)
	ON_UPDATE_COMMAND_UI(ID_GAME_SUGG, OnUpdateGameSugg)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_COMMAND(ID_OPT_3, OnOpt3)
	ON_UPDATE_COMMAND_UI(ID_OPT_3, OnUpdateOpt3)
	ON_COMMAND(ID_OPT_4, OnOpt4)
	ON_UPDATE_COMMAND_UI(ID_OPT_4, OnUpdateOpt4)
	//}}AFX_MSG_MAP
	ON_UPDATE_COMMAND_UI(ID_NACHRICHT, OnUpdateNachricht)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyChild message handlers

void CMyChild::OnFileNew() 
{
	SetMode(m_quad);
	m_spiel=TRUE;
	m_dran=m_anf;
	memset(m_feld,0,16);
	Invalidate();
}

void CMyChild::OnOptO() 
{
	m_anf=1;
}

void CMyChild::OnUpdateOptO(CCmdUI* pCmdUI) 
{
	pCmdUI->SetRadio(m_anf==1);
}

void CMyChild::OnOptX() 
{
	m_anf=2;
}

void CMyChild::OnUpdateOptX(CCmdUI* pCmdUI) 
{
	pCmdUI->SetRadio(m_anf==2);
}

void CMyChild::OnUpdateNachricht(CCmdUI* pCmdUI)
{
	CString s;
  
	if(m_spiel)
	{
		if(m_dran==1)
			s="O ist dran";
		else
			s="X ist dran";
	}
	else
	{
		if(m_dran==0)
			s="Unentschieden";
		else
		{
			if(m_dran==1)
				s="O hat gewonnen";
			else
				s="X hat gewonnen";
		}
	}
	pCmdUI->SetText(s);
}

void CMyChild::OnGameSugg() 
{
	CWaitCursor wcur;
	int zug;

	zug=CalcSugg(m_feld,m_dran,0);
	if(zug>=0)
		SetXO(zug);
}

void CMyChild::OnUpdateGameSugg(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_spiel);
}

void CMyChild::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	RECT rcp;
	RECT rc;
	int mins;
	int abstand;
	int x1,x2,y1,y2;
	int d;
	int i;
	CPen pen_black(PS_SOLID,0,GetSysColor(COLOR_WINDOWTEXT));
	CPen pen_blue(PS_SOLID,0,0xFF0000);
	CPen pen_red(PS_SOLID,0,0xFF);
	CBrush brush_red(0xFF);
	CBrush brush_white(GetSysColor(COLOR_WINDOW));
	CPen *oldpen;
	CBrush *oldbrush;
	int x,y;

	// den Hintergrund mit der Hintergrundfarbe malen
	rcp=dc.m_ps.rcPaint;
	dc.FillSolidRect(&rcp,GetSysColor(COLOR_WINDOW));

	// wie gro ist das Fenster ?
	GetClientRect(&rc);
	mins=min(rc.bottom,rc.right);
	abstand=(mins-20)/m_quad;

	// Linien fr das Spiel zeichnen
	x1=(rc.right-mins+20)/2;
	x2=rc.right-x1;
	y1=(rc.bottom-mins+20)/2;
	y2=rc.bottom-y1;
	oldpen=dc.SelectObject(&pen_black);
	for(i=1; i<m_quad; i++)
	{
		dc.MoveTo(x1,y1+abstand*i);
		dc.LineTo(x2,y1+abstand*i);
		dc.MoveTo(x1+abstand*i,y1);
		dc.LineTo(x1+abstand*i,y2);
	}
	dc.SelectObject(oldpen);

	// Xe und Os zeichnen
	for(x=0; x<m_quad; x++)
	{
		for(y=0; y<m_quad; y++)
		{
			switch(m_feld[y*m_quad+x])
			{
				case 1:
					// O
					oldpen=dc.SelectObject(&pen_red);
					oldbrush=dc.SelectObject(&brush_red);
					d=(abstand*100)/500;
					dc.Ellipse(x1+3+abstand*x,
							   y1+3+abstand*y,
							   x1-3+abstand*(x+1),
							   y1-3+abstand*(y+1));
					dc.SelectObject(&brush_white);
					dc.Ellipse(x1+d+abstand*x,
							   y1+d+abstand*y,
							   x1-d+abstand*(x+1),
							   y1-d+abstand*(y+1));
					dc.SelectObject(oldpen);
					dc.SelectObject(oldbrush);
					break;

				case 2:
					// X
					d=(abstand*100)/500;
					oldpen=dc.SelectObject(&pen_blue);
					for(i=0; i<d; i++)
					{
						dc.MoveTo(x1+3+abstand*x+i, y1+3+abstand*y);
						dc.LineTo(x1-3-d+abstand*(x+1)+i, y1-3+abstand*(y+1));
						dc.MoveTo(x1-3-d+abstand*(x+1)+i, y1+3+abstand*y);
						dc.LineTo(x1+3+abstand*x+i, y1-3+abstand*(y+1));
					}
					dc.SelectObject(oldpen);
					break;
			}
		}
	}
}

void CMyChild::OnLButtonDown(UINT nFlags, CPoint p)
{
	SetXO(-1, p);
}

void CMyChild::OnOpt3() 
{
	if(m_quad!=3)
	{
		m_quad=3;
		OnFileNew();
	}
}

void CMyChild::OnUpdateOpt3(CCmdUI* pCmdUI) 
{
	pCmdUI->SetRadio(m_quad==3);
}

void CMyChild::OnOpt4() 
{
	if(m_quad!=4)
	{
		m_quad=4;
		OnFileNew();
	}
}

void CMyChild::OnUpdateOpt4(CCmdUI* pCmdUI) 
{
	pCmdUI->SetRadio(m_quad==4);
}

void CMyChild::SetXO(int mode, CPoint p)
{
	RECT rc;
	int x1,x2,y1,y2;
	int x,y;
	int xs,xe,ys,ye;
	int mins,abstand;
	BOOL treffer;

	// Spiel aktiv ?
	if(!m_spiel)
		return;
	// wie gro ist das Fenster ?
	GetClientRect(&rc);
	// Wo sind die Felder ?
	mins=min(rc.bottom,rc.right);
	abstand=(mins-20)/m_quad;
	x1=(rc.right-mins+20)/2;
	x2=rc.right-x1;
	y1=(rc.bottom-mins+20)/2;
	y2=rc.bottom-y1;
	treffer=FALSE;
	for(x=0; x<m_quad; x++)
	{
		for(y=0; y<m_quad; y++)
		{
			xs=x1+x*abstand;
			xe=x1+(x+1)*abstand;
			ys=y1+y*abstand;
			ye=y1+(y+1)*abstand;
			if(mode>=0)
			{
				if(mode==(y*m_quad+x))
				{
					treffer=TRUE;
					break;
				}
			}
			else
			{
				if(p.x>=xs && p.x<xe && p.y>=ys && p.y<ye)
				{
					treffer=TRUE;
					break;
				}
			}
		}
		if(treffer)
			break;
	}
	if(!treffer)
		return;
  
	// Treffer
	if(m_feld[x+y*m_quad])
		return;
	m_feld[x+y*m_quad]=m_dran;
	m_dran=3-m_dran;
	rc.top=ys;
	rc.left=xs;
	rc.right=xe;
	rc.bottom=ye;
	InvalidateRect(&rc,0);
	switch(CalcStatus(m_feld))
	{
		case 1: // O hat gewonnen
			m_dran=1;
			m_spiel=FALSE;
			break;

		case 2: // X hat gewonnen
			m_dran=2;
			m_spiel=FALSE;
			break;

		case 3: // Unentschieden
			m_dran=0;
			m_spiel=FALSE;
			break;
	}
}

/////////////////////////////////////////////////////////////////////////////
// Status- und Spielberechnungen

void CMyChild::SetMode(int quad)
{
	ASSERT(quad==3||quad==4);

	m_quad=quad;
	m_qq=quad*quad;
	if(quad==3)
	{
		m_anzc=8;
		m_maxr=9;
	}
	else
	{
		m_anzc=10;
		m_maxr=3;
	}
}

int CMyChild::CalcSugg(FELD feld,int dran,int rl)
{
	int i,s;
	int leer;
	int zug;
	FELD feld2;
	__int64 maxbal;

	leer=0;
	zug=-1;
	maxbal=0x8000000000000000;
	for(i=0; i<m_qq; i++)
	{
		if(!feld[i])
			leer++;
	}
	for(i=0; i<m_qq; i++)
	{
		if(!rl)
			m_bal=0;
		if(!feld[i])
		{
			memcpy(feld2,feld,16);
			feld2[i]=dran;
			switch(s=CalcStatus(feld2))
			{
				case 0:
					if(rl<m_maxr)
						CalcSugg(feld2,3-dran,rl+1);
					break;

				case 1:
				case 2:
					if(m_dran==dran)
					{
						if(s==dran)
							m_bal+=c_fac[leer];
						else
							m_bal-=c_fac[leer];
					}
					else
					{
						if(s!=dran)
							m_bal+=c_fac[leer];
						else
							m_bal-=c_fac[leer];
					}
					break;
			}
			if(rl==0)
			{
				if(maxbal<m_bal)
				{
					maxbal=m_bal;
					zug=i;
				}
			}
		}
	}
	return zug;
}

const int c3_cs[]=
{
	0, 1, 2,
	3, 4, 5,
	6, 7, 8,
	0, 3, 6,
	1, 4, 7,
	2, 5, 8,
	0, 4, 8,
	2, 4, 6
};

const int c4_cs[]=
{
	 0,  1,  2,  3,
	 4,  5,  6,  7,
	 8,  9, 10, 11,
	12, 13, 14, 15,
	 0,  4,  8, 12,
	 1,  5,  9, 13,
	 2,  6, 10, 14,
	 3,  7, 11, 15,
	 0,  5, 10, 15,
	 3,  6,  9, 12
};

// Rckgabewert
//
// 0 = noch alles offen
// 1 = O hat gewonnen
// 2 = X hat gewonnen
// 3 = unentschieden
int CMyChild::CalcStatus(FELD &feld)
{
	int i, j, v, w;
	BOOL nochance;
	const int *cs;

	if(m_quad==3)
		cs=c3_cs;
	else
		cs=c4_cs;
	for(i=0; i<m_anzc; i++)
	{
		v=feld[cs[i*m_quad]];
		if(v)
		{
			for(j=1; j<m_quad; j++)
			{
				if(v!=feld[cs[i*m_quad+j]])
					break;
			}
			if(j>=m_quad)
				return v;
		}
	}
	for(i=0; i<m_anzc; i++)
	{
		v=0;
		nochance=FALSE;
		for(j=0; j<m_quad; j++)
			if(w=feld[cs[i*m_quad+j]])
			{
				if(v==0||v==w)
					v=w;
				else
				{
					nochance=TRUE;
					break;
				}
			}
		if(!nochance)
			return 0;
	}
	return 3;
}

