/*
    ImageComponent
    (C) 1998 Jens von Pilgrim, heise-Verlag

*/

import java.awt.*;

public class ImageComponent extends Canvas {

    public ImageComponent () {
        this(null);
    }

    public ImageComponent (Image img) {
        m_Image = img;
    }

    public void setImage (Image img ) {
        m_Image = img;
        repaint();
    }

    public void paint(Graphics g) {
        Dimension dim = getSize();
        if ((m_Image == null)  || (width==-1) || (height==-1) ) {
            g.setColor(new Color(255,255,255));
            g.clearRect(0,0,0,0);
            g.setColor(new Color(255,0,0));
            g.drawLine(0,0,dim.width, dim.height);
            g.drawLine(dim.width,0,0,dim.height);
        }
        else {
         g.drawImage(m_Image, 0,0, null);
        }
    }

    Image m_Image;
}
