Attribute VB_Name = "modMain"
Option Explicit
Private m_hSayCloseNow As Long
Private m_sDebugInfo As String
Private m_CriticalSection As CRITICAL_SECTION

Public Sub ThreadProc(ByVal FileName As String)

  Dim sFileName As String, hFile As Long, lSize As Long
  Dim lCount As Long, lTemp As Long
  Dim sBuffer As String, lStringSize As Long, sTemp As String
  Dim tVersion As OSVERSIONINFO, tMemory As MEMORYSTATUS, hActiveWnd As Long
  
  sFileName = Space(255)
  lSize = GetModuleFileName(0&, sFileName, Len(sFileName))
  If lSize > 0 Then
    sFileName = Left$(sFileName, lSize)
    For lTemp = Len(sFileName) To 1 Step -1
      If Mid$(sFileName, lTemp, 1) = "\" Then
        sFileName = Left$(sFileName, lTemp)
        sFileName = sFileName & "debug.log"
        Exit For
      End If
    Next
  End If
      
  lCount = 0
  If Len(sFileName) > 0 Then

    hFile = FreeFile
    Open sFileName For Output As hFile
  End If
    
  ' schreibe hier allgemeine Systeminformationen
  Print #hFile, "c't runtime watch - gestartet "; Format$(Now, "ddddd ttttt")
  
  ' *** Name des Rechners ***
  sBuffer = Space(255)
  lStringSize = Len(sBuffer)
  GetComputerName sBuffer, lStringSize
  sBuffer = Left$(sBuffer, lStringSize)
  Print #hFile, "Computername: " & sBuffer
  
  ' *** Name des Anwenders ***
  sBuffer = Space(255)
  lStringSize = Len(sBuffer)
  GetUserName sBuffer, lStringSize
  sBuffer = Left$(sBuffer, lStringSize)
  Print #hFile, "Logged user: " & sBuffer
  
  ' *** Startzeit des Betriebssystems ***
  Print #hFile, "Betriebssystem gestartet: "; Format$(DateAdd("s", -(GetTickCount() / 1000), Now), "General Date")
  
  ' *** Versionsinformationen ***
  tVersion.dwOSVersionInfoSize = Len(tVersion)
  GetVersionEx tVersion
  Select Case tVersion.dwPlatformId
    Case 0: sTemp = "Win32s"
    Case 1: sTemp = "Windows 95"
    Case 2: sTemp = "Windows NT"
  End Select
  sTemp = sTemp & " " & CStr(tVersion.dwMajorVersion) & "." & CStr(tVersion.dwMinorVersion) & "." & CStr(LOWORD(tVersion.dwBuildNumber))
  If InStr(tVersion.szCSDVersion, Chr$(0)) > 0 Then
    sTemp = sTemp & " (" & Left$(tVersion.szCSDVersion, InStr(tVersion.szCSDVersion, Chr$(0)) - 1) & ")"
  End If
  Print #hFile, "Version: "; sTemp
    
  ' *** Speicherinformationen ***
  tMemory.dwLength = Len(tMemory)
  GlobalMemoryStatus tMemory
  Print #hFile, "Speicher: PhysTotal="; tMemory.dwTotalPhys / 1024; " PhysAvail="; tMemory.dwAvailPhys / 1024; " VirtTotal="; tMemory.dwTotalVirtual / 1024; " VirtAvail="; tMemory.dwAvailVirtual / 1024
  Print #hFile, "Thread-Prioritt (-2 bis 2): "; GetThreadPriority(GetCurrentThread())
  
  ' *** und Abschlu ***
  Print #hFile, String(60, "-")
      
  Do
    sTemp = Format$(Now, "ttttt") & " DebugInfo: " & m_sDebugInfo
    
    ' schreibe hier Informationen ber den Zustand des Speichers und alles weiter
    hActiveWnd = GetForegroundWindow()
    If IsWindow(hActiveWnd) <> 0 Then
      sBuffer = Space(GetWindowTextLength(hActiveWnd) + 1)
      lStringSize = GetWindowText(hActiveWnd, sBuffer, Len(sBuffer))
      sTemp = sTemp & ", ActWnd: " & Left$(sBuffer, lStringSize)
    Else
      sTemp = sTemp & ", ActWnd: kein "
    End If
    
    tMemory.dwLength = Len(tMemory)
    GlobalMemoryStatus tMemory
    sTemp = sTemp & ", Speicher: PhysAvail=" & CStr(tMemory.dwAvailPhys / 1024) & " VirtAvail=" & CStr(tMemory.dwAvailVirtual / 1024)
    
    If hFile <> 0 Then
      Print #hFile, sTemp
    End If
    
    lCount = lCount + 1
    If WaitForSingleObject(m_hSayCloseNow, 200) = WAIT_OBJECT_0 Then Exit Do
    frmMain.FormMsg CStr(lCount) & " geschriebene Log-Informationen"
  Loop
  
  If hFile <> 0 Then Close #hFile
    
  ExitThread lCount
  
End Sub

Public Property Let DebugInfo(ByVal sNewValue As String)
  EnterCriticalSection m_CriticalSection
  m_sDebugInfo = sNewValue
  LeaveCriticalSection m_CriticalSection
End Property

Public Property Get DebugInfo() As String
  DebugInfo = m_sDebugInfo
End Property

Function HIWORD(lang&) As Long
  On Error Resume Next
  Dim dw As Long
  dw& = IIf(lang >= 0&, lang \ &H10000, &HFFFF& + lang \ &H10001) And &HFFFF&
  If (dw& >= &H8000&) Then dw& = dw& - &H10000
  HIWORD = CInt(dw&)
End Function

Function LOWORD(lang&) As Long
  On Error Resume Next
  Dim dw&
  dw& = lang And &HFFFF&
  If (dw& >= &H8000&) Then dw& = dw& - &H10000
  LOWORD = CInt(dw&)
End Function

Public Sub Main()

  Dim hThread As Long, tSecurity As SECURITY_ATTRIBUTES, lpExitCode As Long, lpThreadId As Long
  Dim sFileName As String
  
  InitializeCriticalSection m_CriticalSection
  
  ' Thread und Ereignis erstellen
  hThread = CreateThread(vbNull, 0, AddressOf ThreadProc, ByVal sFileName, 0, lpThreadId)
  If hThread = 0 Then
    MsgBox "Thread konnte nicht erstellt werden: " & Err.LastDllError
  Else
    SetThreadPriority hThread, THREAD_PRIORITY_HIGHEST
  End If
  m_hSayCloseNow = CreateEvent(tSecurity, 1, 0, vbNullString)
  If m_hSayCloseNow = 0 Then
    MsgBox "Das Ereignis konnte nicht erstellt werden"
  End If

  frmMain.Show 1
  
  ' Aufrumarbeiten:
  SetEvent m_hSayCloseNow
  WaitForSingleObject hThread, INFINITE
  GetExitCodeThread hThread, lpExitCode
  MsgBox "Es wurden " & lpExitCode & " Informationen in die Log-Datei geschrieben."
  
  CloseHandle m_hSayCloseNow
  CloseHandle hThread

  DeleteCriticalSection m_CriticalSection
  
End Sub
