import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;

/**
 * Eine Adapterklasse, die unser Datenmodell an ein JTextfield anpasst.
 */
public class CountFieldAdapter implements ListDataListener {

  JTextField textField;
  EditableListModel model;

  public CountFieldAdapter(EditableListModel model, JTextField textField) {
    this.textField = textField;
    this.model = model;
    // beim Modell anmelden
    model.addListDataListener(this);
  }

  // bei jeder nderung das Textfeld aktualisieren
  public void intervalAdded(ListDataEvent e) {
    textField.setText(Integer.toString(model.getSize()));
  }

  public void intervalRemoved(ListDataEvent e) {
    textField.setText(Integer.toString(model.getSize()));   
  }

  public void contentsChanged(ListDataEvent e) {
    textField.setText(Integer.toString(model.getSize()));   
  }
}


