import com.sun.java.swing.*;
import java.awt.Component;

/** 
 * Eine Drop-Down Box, die neben Strings auch Icons anzeigt.
 */
public class ImageDropDownBox extends JComboBox {
  ImageIcon images[];

  public ImageDropDownBox(ImageIcon icon[]) {
    super(icon);
    final JLabel label = new JLabel();  // dies ist die Renderer-Komponente
    this.images = icon;

    // der neue Renderer
    ListCellRenderer myRenderer = new ListCellRenderer() {
      public Component getListCellRendererComponent(
            JList list,
            Object value,            // value to display
            int index,               // cell index
            boolean isSelected,      // is the cell selected
            boolean cellHasFocus)    // the list and the cell have the focus
      {
        label.setText( ((ImageIcon)value).getDescription());
        label.setIcon( (ImageIcon) value);
        return label;         
      }
    };
    setRenderer(myRenderer);
    setEditable(false);  // Werte drfen nicht editiert werden
  }
  
  // Werte drfen nicht verndert werden
  public void setEditable(boolean editable) {
    super.setEditable(false);
  }
}

