import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.table.*;
import java.util.*;

/** Datenmodell fr den JTable, speichert Name und Lieblingsspeise
  * der Kunden, Lieblingsspeise wird hierbei als Integer gespeichert
  */

public class RestaurantModel extends AbstractTableModel {

  Vector data[] = { new Vector(), new Vector() };

  static String columnNames[] = { "Name", "Lieblingsspeise"};
   
  // berschreiben der abstrakten Methoden aus AbstractTableModel

  public int getColumnCount() { return 2; }

  public int getRowCount() { return data[0].size(); }

  public String getColumnName(int column) { return columnNames[column]; }

  public Object getValueAt(int row, int col) { 
    return data[col].elementAt(row);
  }      

  public void setValueAt(Object value, int row, int col) { 
    data[col].setElementAt(value,row);
    fireTableCellUpdated(row, col);
  }      

  public boolean isCellEditable(int rowIndex, int columnIndex) {
    return true;
  }

  // Einen Datensatz hinzufgen
  public void addRow() {
    data[0].addElement("Neuer Kunde");
    data[1].addElement(new Integer(0));
    fireTableRowsInserted(getRowCount()-1, getRowCount()-1);
  }
}


