unit DXWaveUtils;  // Einlesen von Audiodateien, 20-JUL-98 as
{ Diese Datei stellt eine minimalistische Implementation der
  von Microsoft im Zusammenhang mit DirectX fter verwendeten
  Utility-Datei Wave.C dar - natrlich in Delphi-Manier
}
interface
uses Windows, SysUtils, Classes, MMSystem;

const
  WAVE_Format_ADPCM = 2;  // diese Deklaration fehlt in MMSystem
type  // was alles beim Einlesen schiefgehen kann
  TIOCBErrCode = (ad2OK, ad2NotOpen, ad2FileNotFound, ad2NoRIFF,
    ad2NoWAVERIFF, ad2FileCorrupt, ad2BadFmtChunk, ad2NoFmtChunk,
    ad2UnknownFormat, ad2UnsupportedFormat);

  TWaveIOCB = record
    Stream: TStream;
    dwDataOffset,  // Start WAVE-Daten relativ zum Dateianfang
    dwDataBytes,   // Anzahl WAVE-Bytes
    dwDataSamples: LongInt;  // Anzahl WAVE-Samples
    ErrCode: TIOCBErrCode;
    WaveFormat: TWaveFormatEx;
  end;

// ffnet eine WAV-Datei und bereitet Leseoperationen mit
// WaveReadFile vor. Liefert im Fehlerfall FALSE, IOCB.ErrCode
// ist dann <> 0
function WaveOpenFile(FName: String;
                      var IOCB: TWaveIOCB): Boolean;
// dito, nur mit einem Stream anstelle eines Dateinamens.
// Der Stream wird bernommen
function WaveOpenStream(Stream: TStream; var IOCB: TWaveIOCB): Boolean;

// Position in IOCB.Stream auf den Beginn des 'data'-Chunks
function WaveStartDataRead(var IOCB: TWaveIOCB): Boolean;
// Liest maximal BytesToRead aus IOCB.Stream in DestBuf^.
// Ergebnis = Zahl der gelesenen Bytes
function WaveReadFile(var IOCB: TWaveIOCB; BytesToRead: Integer;
                      DestBuf: Pointer): Integer;
function WaveCloseReadFile(var IOCB: TWaveIOCB): Boolean;

implementation

// ffnet eine WAV-Datei und bereitet Leseoperationen mit
// WaveStartDataRead, WaveReadFile vor
function WaveOpenFile(FName: String;
                      var IOCB: TWaveIOCB): Boolean;
var Stream: TFileStream;
begin
  try
    Stream := TFileStream.Create(FName, fmOpenRead or fmShareDenyWrite);
    Result := WaveOpenStream(Stream,IOCB);
  except
    IOCB.ErrCode := ad2FileNotFound;
    Result := False;
  end;
end;

// dito, nur mit einem Stream anstelle eines Dateinamens.
// Der Stream wird bernommen
function WaveOpenStream(Stream: TStream; var IOCB: TWaveIOCB): Boolean;
var dw, BytesToGo: LongInt;
 ck: record  // Chunk-Info
       ckid: FOURCC;    // Art
       ckSize: LongInt; // Gre der folgenden Daten in Bytes
     end;

  procedure SetErrCode(Code: TIOCBErrCode);
  begin // Cleanup bei Fehlern
    with IOCB do
    begin
      ErrCode := Code; Stream.Free; Stream := nil;
    end;
  end;

begin  // WaveOpenStream
  FillChar(IOCB,SizeOf(IOCB),0); Result := False;
  IOCB.Stream := Stream; 
  // Dateistruktur: 'RIFF', Gesamtgre, danach 'WAVE'
  with IOCB do
  begin
    if (Stream = nil) or (Stream.Size = 0) then
    begin
      SetErrCode(ad2NotOpen); Exit;
    end;
    Stream.Seek(0,0); Stream.Read(ck,SizeOf(ck));  // ID + Size
    if ck.ckid <> mmioStringToFourCC('RIFF',0) then
    begin
      SetErrcode(ad2NoRIFF); Exit;
    end;
    if ck.ckSize <> Stream.Size-SizeOf(ck) then
    begin
      SetErrCode(ad2FileCorrupt); Exit;
    end;
    Stream.Read(ck,4);
    if ck.ckid <> mmioStringToFourCC('WAVE',0) then
    begin
      SetErrCode(ad2NoWAVERIFF); Exit;
    end;

    repeat  // nach 'WAVE' mu irgendwann ein 'fmt ' kommen
      Stream.Read(ck,8); BytesToGo := ck.ckSize;
      if ck.ckid = mmioStringToFourCC('fmt ',0) then
      begin
        if WaveFormat.wFormatTag = 0 then
        begin  // PCM-Header optional ein cbSize-Feld haben
          dw := ck.cksize;
          if dw > SizeOf(TWaveFormatEx)
             then dw := SizeOf(TWaveFormatEx);
          Stream.Read(WaveFormat, dw);
          BytesToGo := ck.ckSize-dw;
        end; // else ist's ein weiterer fmt-Chunk - ignore
      end else if ck.ckid = mmioStringToFourCC('fact',0) then
      begin
        if (IOCB.dwDataSamples = 0) and // 1. 'fact'-Chunk
          (IOCB.WaveFormat.wFormatTag = Wave_Format_ADPCM) then
        begin // 'fact': Einizige Info ist Sample-Zahl. Kann
              // bei PCM-Dateien gesetzt sein, mu aber nicht
          Stream.Read(IOCB.dwDataSamples, SizeOf(LongInt));
          Dec(BytesToGo,SizeOf(LongInt));
        end; // else ist's ein weiterer fact-Chunk - ignore
      end else if ck.ckid = mmioStringToFourCC('data',0) then
      begin // 'data': Datengre und Startposition
        dwDataBytes  := ck.cksize;
        dwDataOffset := Stream.Position;
        Break;  // OK, wir haben alles
      end;
      // alle anderen Sub-Chunks werden schlicht bersprungen
      Stream.Seek(BytesToGo,soFromCurrent);
    until Stream.Position = 2048; // sollte nun wirklich reichen

    case WaveFormat.wFormatTag of
      0: ;  // ohne den 'fmt '-Chunk geht's auf keinen Fall
      Wave_Format_PCM:
        begin  // steht meistens nicht drin, nachholen
          with WaveFormat do
            dwDataSamples := dwDataBytes div
              (nAvgBytesPerSec div nSamplesPerSec);
          Result := True;
          ErrCode := ad2OK;
        end;
      Wave_Format_ADPCM:
          SetErrCode(ad2UnsupportedFormat);
       else
         SetErrCode(ad2FileCorrupt);  // "kenn' ich nicht"
    end; // case
  end;  // with IOCB
end;

// Position von IOCB.Stream auf den Beginn des 'data'-Chunks
function WaveStartDataRead(var IOCB: TWaveIOCB): Boolean;
begin
  with IOCB do
    if Stream = nil then
    begin
      Result := False; ErrCode := ad2NotOpen; Exit;
    end else
    begin
      Stream.Seek(dwDataOffset,soFromBeginning);
      Result := True;
    end;
end;

// Liest maximal BytesToRead aus IOCB.Stream in DestBuf^.
// Ergebnis = Zahl der gelesenen Bytes (nicht: Samples)
function WaveReadFile(var IOCB: TWaveIOCB; BytesToRead: Integer;
                      DestBuf: Pointer): Integer;
var MaxBytes: LongInt;
begin
  with IOCB do
    if Stream = nil then
    begin
      Result := -1; ErrCode := ad2NotOpen; Exit;
    end else
    begin  // Begrenzung auf das Ende des 'data'-Chunks
      MaxBytes := dwDataBytes-(Stream.Position-dwDataOffset);
      if BytesToRead > MaxBytes then BytesToRead := MaxBytes;
      Result := Stream.Read(DestBuf^,BytesToRead);
    end;
end;

function WaveCloseReadFile(var IOCB: TWaveIOCB): Boolean;
begin
  Result := IOCB.Stream <> nil;  // True, wenn offen
  IOCB.Stream.Free;
  FillChar(IOCB,SizeOf(IOCB),0);
end;

end.
