unit DX5SoundDemoU; // 10-AUG-98 as (Arne Schpers)
{ Statische und Stream-Soundpuffer mit Positionsrckmeldung;
  setzt die DirectX-Header von Erik Unger voraus.
  DirectX-Minimalversion ist 5; mit NT 4.0 geht's also nicht. }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls,  
  DSound,  // Erik Ungers umgesetzte DirectX-Header
  DXWaveUtils,  // Laden und WAV-Dateien  la WAVE.C
  DXSoundAS;  // TDSoundBuffer, Hintergrund-Thread etc.

type
  TDSDemoForm = class(TForm)
    bCreateSoundObject: TButton;
    GroupBox1: TGroupBox;
    bPlayMultiFromList: TButton;
    ListBox1: TListBox;
    bClearBox: TButton;
    rSelectSound: TRadioGroup;
    GroupBox2: TGroupBox;
    bPlayStream: TButton;
    bStopStream: TButton;
    VolumeBar: TScrollBar;
    Label2: TLabel;
    lVolume: TLabel;
    lStreamPos: TLabel;
    GroupBox3: TGroupBox;
    bPlayLooping: TButton;
    bStopLooping: TButton;
    LoopBar: TScrollBar;
    GroupBox4: TGroupBox;
    bPlayStatic: TButton;
    procedure bCreateSoundObjectClick(Sender: TObject);
    procedure bPlayStaticClick(Sender: TObject);
    procedure bPlayLoopingClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure bClearBoxClick(Sender: TObject);
    procedure bStopLoopingClick(Sender: TObject);
    procedure bPlayMultiFromListClick(Sender: TObject);
    procedure bPlayStreamClick(Sender: TObject);
    procedure bStopStreamClick(Sender: TObject);
    procedure VolumeBarChange(Sender: TObject);
  protected
    procedure ReloadAudioData(Sender: TObject);
    procedure ListSoundEvent(Sender: TObject);
    procedure LoopSoundEvent(Sender: TObject);
    procedure StreamSoundEvent(Sender: TObject);
    procedure MaxEventsExceeded(Sender: TObject);
  public
    StaticSound: TDSoundBuffer;
    LoopSound: TDSoundBuffer;
    JumpList: TList;
    StreamSound: TDSoundStreamBuffer;
  end;

var DSDemoForm: TDSDemoForm;

implementation

{$R *.DFM}

procedure TDSDemoForm.FormCreate(Sender: TObject);
var x: Integer;
begin
  for x := 0 to ComponentCount-1  do
    if Components[x] is TWinControl then
      TWinControl(Components[x]).Enabled := False;  // alle Buttons aus
  bCreateSoundObject.Enabled := True;
  JumpList := TList.Create;  // Liste fr kopierte Sounds
end;

procedure TDSDemoForm.FormDestroy(Sender: TObject);
begin
  // fakultativ, erschlgt auch die Puffer in JumpList
  DirectSoundUninitialize;
  JumpList.Free;
end;

// Gibt im Fehlerfall die Meldung von DirectSound aus und
// liefert False. ErrorString ist eine Routine von Unger.
function ErrCheck(Action: String; Res: HResult): Boolean;
begin
  Result := SUCCEEDED(Res);
  if not Result then ShowMessage(
     Format('%s: %s',[Action,ErrorString(Res)]));
end;

// Initialisierung von DirectSound
procedure TDSDemoForm.bCreateSoundObjectClick(Sender: TObject);
var x: Integer; Res: HResult; 
begin
  // 1. IDirectSound-Variable DirectSound in DXSoundAS anlegen
  if not DirectSoundInitialize(Self) then
  begin
    ShowMessage('Fehler beim Anlegen des DirectSound-Objekts.');
    Exit;
  end;

  // Debug-Demonstration: Reaktion auf zu viele Notifications
  OnMaxEventsExceeded := MaxEventsExceeded;

  // 2. Kooperationsebene: Formatnderungen ja, direkte Schreib-
  // aktionen in den primren Puffer nein
  Res := DirectSound.SetCooperativeLevel(Handle,DSSCL_PRIORITY);
  if not ErrCheck('Setzen der Kooperationsebene',Res) then Exit;

  // 3. Versuch, das Format des primren Soundpuffers
  // auf Stereo, 16 Bit, 22 KHz zu setzen.
  Res := DirectSoundSetPrimaryFormat(2,16,22050);
  ErrCheck('Primres Format setzen (unkritisch)',Res);

  // DirectSound-Objekt steht: Alle Elemente an
  for x := 0 to ComponentCount-1 do
    if Components[x] is TWinControl then
      TWinControl(Components[x]).Enabled := True;
  bCreateSoundObject.Enabled := False;
  // Soundpuffer anlegen
  StaticSound := TDSoundBuffer.Create(Self);  // JUMP
  StaticSound.OnBufferLost := ReloadAudioData;
  LoopSound := TDSoundBuffer.Create(Self);    // WALK
  LoopSound.OnBufferLost := ReloadAudioData;
  StreamSound := TDSoundStreamBuffer.Create(Self);  // CHAINSW
  StreamSound.OnBufferLost := ReloadAudioData;
  ReloadAudioData(Self);
  LoopSound.OnEvent := LoopSoundEvent;
  StreamSound.OnEvent := StreamSoundEvent;
  // Lautstrke fr StreamSound: 0..-20 dB = 0..1/10
  VolumeBar.Max := 2000; VolumeBar.Min := 0;
  VolumeBar.Position := 1000;
end;

procedure TDSDemoForm.MaxEventsExceeded(Sender: TObject);
begin
  bStopLoopingClick(Self);  // macht 50 Notifications frei
  ShowMessage('MaxEventsExceeded: LoopSound stopped');
end;

// Eine weitere Manier von DirectX: Zusammenfassen der
// Ladeoperationen auf einen Punkt im Programm. XRefs:
// OnBufferLost aller Pufferobjekte, bCreateDirectSoundObject
procedure TDSDemoForm.ReloadAudioData(Sender: TObject);
var Path: String; x: Integer; Caps: TDSBCaps;

  function LoadSound(FName: String; Buf: TDSoundBuffer;
                     Flags: Integer): Boolean;
  begin
    Result := True;
    // Positionskontrolle zu den Flags dazu
    Flags := Flags or DSBCAPS_CTRLPOSITIONNOTIFY or
      DSBCAPS_GETCURRENTPOSITION2;
    try
      Buf.LoadFromFile(FName,Flags);
    except
      on E: Exception do
      begin
        ShowMessage(E.Message); Result := False;
      end;
    end;
  end;

begin
  Path := ExtractFilePath(ParamStr(0));  // EXE-Verzeichnis
  LoadSound(Path+'jump.wav',StaticSound,0);

  if LoadSound(Path+'walk.wav',LoopSound,0) then
  begin
  // eine Spielerei & in der Praxis nicht so empfehlenswert,
  // weil maximal 64 Events zur Verfgung stehen: Positions-
  // rckmeldungen ber eine Bildlaufleiste fr LoopSound.
  // Hier absichtlich auf eine bldsinnig hohe Zahl gesetzt.
    Caps.dwSize := SizeOf(Caps);
    if SUCCEEDED(LoopSound.BufferObject.GetCaps(Caps)) then
    begin
      LoopBar.Max := Caps.dwBufferBytes;
      for x := 0 to 49 do
        if LoopSound.AddNotification(Caps.dwBufferBytes*x
          div 50) = -1 then
      begin
        ShowMessage('Das scheint DirectX 3 zu sein. Sorry...');
        bPlayMultiFromList.Enabled := False;
        Break;
      end;
    end;
  end;
  // Stream-Sound mit drei Rckmeldungen: Mitte, Ende, Stop
  if LoadSound(Path+'chainsw.wav',StreamSound,
    DSBCAPS_CTRLVOLUME) then
  with StreamSound do
    if SUCCEEDED(BufferObject.GetCaps(Caps)) then
    begin
      if bPlayMultiFromList.Enabled then  // else ist's DX3 (NT)
      begin
        AddNotification(Caps.dwBufferBytes div 2 -1);
        AddNotification(Caps.dwBufferBytes -1);
        // das mu lt. DirectX-Spec die letzte Notification sein
        AddNotification(DSBPN_OFFSETSTOP);
      end else
        bPlayStream.Enabled := False;
    end;
end;

// Statischer Sound, bei jedem Klick von Anfang an neu abspielen
procedure TDSDemoForm.bPlayStaticClick(Sender: TObject);
begin
  StaticSound.BufferObject.SetCurrentPosition(0);
  StaticSound.Play(0);
end;

// Statischer Sound, als Schleife abgespielt, mit Position
procedure TDSDemoForm.bPlayLoopingClick(Sender: TObject);
begin
  LoopSound.BufferObject.SetCurrentPosition(0);
  LoopSound.Play(DSBPLAY_LOOPING);
  bPlayLooping.Enabled := False;
end;

// Positionsanzeige fr LoopSound ber Events
procedure TDSDemoForm.LoopSoundEvent(Sender: TObject);
var Dummy, Pos: Integer;
begin
  LoopSound.BufferObject.GetCurrentPosition(Pos, Dummy);
  LoopBar.Position := Pos;
end;

procedure TDSDemoForm.bStopLoopingClick(Sender: TObject);
begin
  LoopSound.Stop;
  bPlayLooping.Enabled := True;
end;

// Kopie eines statischen Sounds -> JumpList. Objekt wird
// nach Ende des Abspielens wieder gelscht
procedure TDSDemoForm.bPlayMultiFromListClick(Sender: TObject);
var NewSound: TDSoundBuffer; OrgBuffer: IDirectSoundBuffer;
begin
  NewSound := TDSoundBuffer.Create(Self);
  Listbox1.Items.Add('New Sound: #'+IntToStr(JumpList.Count));
  JumpList.Add(NewSound);
  with NewSound do
  begin  // Soundpuffer "Jump" oder "Walk"
    if rSelectSound.ItemIndex = 0
     then OrgBuffer := StaticSound.BufferObject
     else OrgBuffer := LoopSound.BufferObject;
    DirectSound.DuplicateSoundBuffer(OrgBuffer, BufferObject);
    // Notifications - funktioniert nur, wenn das Original auch
    // mit DSBCAPS_POSITIONNOTIFY angelegt wurde
    OnEvent := ListSoundEvent;
    // Nach Abspielen wieder lschen
    AddNotification(DSBPN_OFFSETSTOP);
    Play(0);
  end;
end;

// Rckmeldung fr die kopierten Sounds
procedure TDSDemoForm.ListSoundEvent(Sender: TObject);
var JumpIndex: Integer;
begin
  JumpIndex := JumpList.IndexOf(Sender);
  if JumpIndex <> -1 then // Vorsicht ist die Mutter...
  begin
    JumpList.Delete(JumpIndex);
    Sender.Free;
    ListBox1.Items.Add('Free #'+IntToStr(JumpIndex));
    ListBox1.Items.Add('JumpList: '+IntToStr(JumpList.Count));
  end;
end;

procedure TDSDemoForm.bClearBoxClick(Sender: TObject);
begin
  Listbox1.Clear;
end;

// Streaming
procedure TDSDemoForm.bPlayStreamClick(Sender: TObject);
begin
  StreamSound.Rewind; StreamSound.Play(DSBPLAY_LOOPING);
  bPlayStream.Enabled := False;
end;

procedure TDSDemoForm.bStopStreamClick(Sender: TObject);
begin
  StreamSound.Stop;  // -> Event #2
end;

// Rckmeldung des Stream-Sounds: Nachladen einer Pufferhlfte
// bzw. Ende
procedure TDSDemoForm.StreamSoundEvent(Sender: TObject);
begin
  with Sender as TDSoundStreamBuffer do
  begin
    if EventNo = 3 then ListBox1.Items.Add('!');
    if (EventNo = 0) or (EventNo = 1) then
    begin
      LoadNextChunk;
      lStreamPos.Caption := 'Load: '+IntToStr(EventNo);
    end else
    begin
      lStreamPos.Caption := 'Stopped';
      bPlayStream.Enabled := True;
    end;
  end;
end;

// Lautstrkeregelung fr den Stream-Sound
procedure TDSDemoForm.VolumeBarChange(Sender: TObject);
var Res: HResult;
begin
  lVolume.Caption := IntToStr(-VolumeBar.Position);
  with StreamSound do
    if BufferObject <> nil then
    begin
      Res := BufferObject.SetVolume(-VolumeBar.Position);
      if FAILED(Res)
        then ShowMessage('SetVolume: '+ErrorString(Res));
    end;
end;

end.



