Unit CRT32; { c't 23/98 Andreas Stiller vollstndige Fassung }
{$H-,J+}

Interface
uses windows;

{$define with_textDRV}
const setDRVonWindow:boolean=true; { setzt bei Window-Funktion TextDriver }

const
  BW40          = 0;            { 40x25 B/W on Color Adapter , not supported}
  CO40          = 1;            { 40x25 Color on Color Adapter }
  BW80          = 2;            { 80x25 B/W on Color Adapter, not supported}
  CO80          = 3;            { 80x25 Color on Color Adapter }
  Mono          = 7;            { 80x25 on Monochrome Adapter, not supported}
  Font8x8       = 256;          { Add-in for ROM font }

{ Mode constants for 3.0 compatibility }

  C40           = CO40;
  C80           = CO80;

{ Foreground and background color constants }

  Black         = 0;
  Blue          = 1;
  Green         = 2;
  Cyan          = 3;
  Red           = 4;
  Magenta       = 5;
  Brown         = 6;
  LightGray     = 7;

{ Foreground color constants }

  DarkGray      = 8;
  LightBlue     = 9;
  LightGreen    = 10;
  LightCyan     = 11;
  LightRed      = 12;
  LightMagenta  = 13;
  Yellow        = 14;
  White         = 15;

{ Add-in for blinking }

  Blink         = 128;

var

{ Interface variables }
  CheckBreak: Boolean;    { Enable Ctrl-Break: dummy  }
  CheckEOF: Boolean;      { Enable Ctrl-Z: dummy  }
  DirectVideo: Boolean;   { Enable direct video addressing:dummy }
  CheckSnow: Boolean;     { Enable snow filtering:dummy }
  LastMode: Word;         { Current text mode }
  TextAttr: Byte;         { Current text attribute }
  WindMin: Word;          { Window upper left coordinates }
  WindMax: Word;          { Window lower right coordinates }

  NormAttr:Word;           { lokal in crt.asm definiert}
  CRTMode: Word;
(*
  CrtMode:byte;		   {EQU	(BYTE PTR 49H) }
  CrtWidth:byte;           {EQU	(BYTE PTR 4AH) }
  Cursor:byte;		   {EQU	(WORD PTR 50H) }
  CrtInfo:byte;		   {EQU	(BYTE PTR 87H) }
  CrtRows:byte;		   {EQU	(BYTE PTR 84H) }
 *)
  LAscii:char;
  Type byteset=set of byte;

var hConsoleInput,hConsoleOutput:Hwnd;

{$ifdef with_TextDRV}
var MyTextDrv:text;
{$endif}

procedure AssignCrt(var F: Text);
function  KeyPressed: Boolean;
function  ReadKey: Char;
procedure TextMode(Mode: Integer);
procedure Window(X1,Y1,X2,Y2: Byte);
procedure GotoXY(X,Y: Byte);
function  WhereX: Byte;
function  WhereY: Byte;
procedure ClrScr;
procedure ClrEol;
procedure InsLine;
procedure DelLine;
procedure TextColor(Color: Byte);
procedure TextBackground(Color: Byte);
procedure LowVideo;
procedure HighVideo;
procedure NormVideo;
procedure Delay(MS: Word);
procedure Sound(Hz: Word);
procedure NoSound;

{ eingefgt }
Procedure ShowConsoleInfo;
Function Port(adr:word):byte;
Function PortW(adr:word):word;
Procedure SetPort(w:byte; adr:word);
Procedure SetPortW(w:word; adr:word);
Procedure SetTextAttr (attr:Byte);

Procedure settranslate (tr:boolean); { Windows  (850)=> 437 deutsch}
Procedure settabs(ts:byteset);   { Tabs setzen }

Implementation
uses sysutils;
const Defaultwindmax:word =$184F;
const CO40Coord    :TCOORD=(x:40;y:25);
const CO80Coord    :TCOORD=(x:80;y:25);
const Font8x8Coord :TCOORD=(x:80;y:43);

var PCONSOLE_SCREEN_BUFFER_INFO:  TConsoleScreenBufferInfo;
var PCONSOLE_CURSOR_INFO:TConsoleCursorInfo;
var CRTCoord:Tcoord;
var tabset:byteset;
const exectabs: boolean=false;
const translate:boolean=false;

Procedure SetTextAttr (attr:Byte);
begin
 TextAttr:=attr;
 PCONSOLE_SCREEN_BUFFER_INFO.wattributes:=TextAttr;
 SetConsoleTextAttribute(hConsoleOutput,TextAttr);
end;

Procedure Textcolor (Color:Byte);
begin
 if color >= $10 then color:=(color and $F) or $80;
 setTextAttr ((Textattr and $70) or Color);
end;

Procedure Textbackground (Color:Byte);
 begin
  SetTextAttr((Textattr and $8F) or ((Color and 7) shl 4));
 end;

Procedure HighVideo;
 begin
    SetTextAttr (TextAttr or 8)
 end;

procedure LowVideo;
 begin
    SetTextAttr (TextAttr and $F7)
 end;

procedure NormVideo;
 begin
   SetTextAttr (NormAttr);
 end;


function CoordToStr (k:Tcoord):string;
begin
 CoordToStr:='['+intToStr(k.x)+','+inttoStr(k.y)+']';
end;

var AbsMaxwinsize:Tcoord;
var ScreenSize:longint;
var MaxscreenSize:longint;

Procedure ShowConsoleInfo;
 begin
 Writeln ('In:',hConsoleInput, ',out:',hConsoleOutput);
 Writeln ('AbsMaxwinsize=',CoordToStr(AbsMaxwinsize));
 With PCONSOLE_SCREEN_BUFFER_INFO do
 begin
  Writeln ('AktMaxWinSize=',CoordToStr(dwMaximumWindowSize));
  Writeln ('AktWinSize   =',CoordToStr(dwSize));
  Writeln ('Cursorpos    =',CoordToStr(dwCursorPosition));
  Writeln ('Attributes   =',wAttributes);
  with srWindow do Writeln ('Window       =',Left,',',Top,',',Right,',',Bottom);
 end;
 With pConsole_Cursor_Info do
 begin
  Writeln ('Cursorsize   =',dwSize);
  Writeln ('Cursorvisible=',bVisible);
 end;
 Writeln (Screensize);
end;

var Consoleok:boolean;

Procedure GetConsoleInfo;
begin
 Screensize:=2000; {Default}
 hConsoleinput:=getStdHandle(STD_INPUT_HANDLE);
 hConsoleoutput:=getStdHandle(STD_OUTPUT_HANDLE);

 AbsMaxwinsize:=GetLargestConsoleWindowSize(hConsoleoutPut);
 with AbsMaxWinsize do MaxScreenSize:=(x+1)*(y+1);
 Consoleok:= GetConsoleScreenBufferInfo(hConsoleoutput, PCONSOLE_SCREEN_BUFFER_INFO );

 If not consoleok then exit;
 If Consoleok then if not GetConsoleCursorInfo(hConsoleOutput, pConsole_Cursor_Info)
   then halt (7);

 with PCONSOLE_SCREEN_BUFFER_INFO.srWindow do Screensize:=(bottom-top+1)*(right-left+1);

end;


Function Port(adr:Word):byte; register;
asm
 mov dx,adr
 in al,dx
 mov @result,al
end;

Function PortW(adr:Word):word; register;
asm
 mov dx,adr
 in ax,dx
 mov @result,ax
end;

Procedure SetPort(w:byte;adr:Word); register // ist eh default
                                             // Reihenfolge eax, edx, ebx
asm
 out dx,al   // Register sind bereits korrekt gesetzt
end;

Procedure SetPortW(w:word;adr:Word); register // ist eh default
                                             // Reihenfolge eax, edx, ebx
asm
 out dx,ax   // Register sind bereits korrekt gesetzt
end;


procedure Delay(MS: Word);        begin sleep (ms) end;

procedure Sound(Hz: Word);
var tw:word;
begin
 If Win32Platform=Ver_PlatForm_Win32_NT then windows.beep (Hz, -1) {falls NT}
 else
  begin
  tw:=round(1.19315e6/Hz);
  setport ($43,$B6);    //
  setport(lo(tw),$42);  //
  setport(hi(tw),$42);  //
  setport(port($61) or 3,$61);
  end;
end;

Procedure Nosound;
begin
 If Win32Platform=Ver_PlatForm_Win32_NT then windows.beep (0, 0) {falls NT}
 else
  begin
  setport (port($61) and not 3,$61);
  end;
end;


{ ****************** Tastatur-Routinen ******************* }

Function Keypressed: boolean;
var lpBuffer:TInputRecord;
var lpNumber:integer;
var accept:boolean;
const CTRLtaste:set of Byte=[16,17,18,20];

begin
accept:=false;
peekConsoleInput(hConsoleInput,lpBuffer,1,lpNumber);
If (lpNumber > 0)
  then
  begin
  if (lpBuffer.eventtype=Key_event) then with lpbuffer.keyevent do
      begin
      if bKeydown and not (wVirtualKeyCode in Ctrltaste) then
       begin
       Lascii:=AsciiChar;
       if (dwControlKeystate and Left_Alt_Pressed)  >  0 then Lascii:=#0;
       accept:=true
       end
  end;
  if not accept then ReadconsoleInput(hConsoleInput,lpBuffer,1,lpNumber);
  end;
keypressed:=accept;
end;

Function AKeypressed: boolean; { liefert true bei press & release }
var lpNumber:integer;
begin
GetNumberOfConsoleInputEvents(hConsoleInput,lpNumber);
Akeypressed:=lpNumber > 0;
end;


Function Readkey:char;
var lpBuffer:TInputRecord;
var lpNumber:integer;
const Is0:boolean=false;
{ Tottasten ^ und  , ALT+Taste, Fknt- und Cursor-Tasten werden als
  0 + ScanCode bergeben
   CRT unter DOS bergibt ALT+Taste ber die Landestabelle,
   hier mte man bei Bedarf weitere Anpassungen (Tabellen) einbauen
   bislang eingebaut ist:
   Cursor
   Fnkt
   ALT-Ziffer (Y/Z vertauscht) , Alt-Buchstabe, ALT-Fnkt.
   CLTL-Ziffer, CTRL-Buchstabe, CRTL-Fktn
 }

const CRTLCursor:array[#71..#83] of byte=
 (119,72,132,74,115,76,116,78,117,80,118,4,6);
begin
if Is0 then
 begin
 ReadconsoleInput(hConsoleInput,lpBuffer,1,lpNumber);
 Lascii:=char(lpbuffer.Keyevent.wVirtualScanCode);

 { left ALT }
 if (lpbuffer.Keyevent.dwControlKeystate and Left_Alt_Pressed >0) then
  begin
  { Y <=> Z, deutsche Tastatur }
  If Lascii =#21 then Lascii:=#44  else If Lascii =#44 then Lascii:=#21;

  If Lascii <=#10 then Lascii:=char(byte(Lascii)+118); { ALT + Zahl }
  If Lascii in [#59..#68] then Lascii:=char(byte(Lascii)+45); { ALT+Fknt }
  end;

  {CTRL  left or right}
 if ((lpbuffer.Keyevent.dwControlKeystate and
    (Left_CTRL_Pressed or Right_CTRL_Pressed)) >0) then
   begin
    if Lascii in [#71..#83] then Lascii:=char(byte(CRTLCursor[Lascii])); {CTRL+Curs}
    if Lascii in [#59..#68] then Lascii:=char(byte(Lascii)+35);

   end;

 Is0:=false;
 end
 else
  begin
  While not keypressed do WaitforSingleObject(hConsoleInput,Infinite);
  {Diese Konstruktion ist freundlich zu anderen Tasks }
  is0:=(Lascii=#0);
  if not is0 then ReadconsoleInput(hConsoleInput,lpBuffer,1,lpNumber);
  end;
 Readkey:=Lascii;
end;

{ ******************* Cursor-Routinen ***************** }

Function Wherex:Byte;
begin
 Wherex:=PCONSOLE_SCREEN_BUFFER_INFO.dwCursorPosition.x+1-lo(windmin);
end;

Function Wherey:Byte;
begin
 Wherey:=PCONSOLE_SCREEN_BUFFER_INFO.dwCursorPosition.y+1-hi(windmin);
end;

Procedure SetAktCursor;
begin
 setConsoleCursorPosition(hConsoleOutput,PCONSOLE_SCREEN_BUFFER_INFO.dwCursorPosition);
end;


Procedure Gotoxy (x,y:Byte);
var k:Tcoord;
begin
 if x > 0 then k.x:=x-1+lo(windmin) else k.x:=lo(windmin);
 if y > 0 then k.y:=y-1+hi(windmin) else k.x:=hi(windmin);
 PCONSOLE_SCREEN_BUFFER_INFO.dwCursorPosition:=k;
 setaktCursor;
end;

{************* Terminal-Routinen *********************}

Procedure clrwin (r:Tsmallrect);
var wstart:Tcoord;
var lsize:longint;
var i,anz:longint;
begin
 lsize:=r.right-r.left+1;
 wstart.x:=r.left; wstart.y:=r.top;
 for i:=r.top  to r.bottom do
 begin
  FillConsoleOutputCharacter(hConsoleOutput,' ',lsize,wstart, anz);
  FillConsoleOutputAttribute(hConsoleOutput,TextAttr,lsize,wstart, anz);
  inc (wstart.y);
 end;
end;




Function SetRect (l,t,r,b:word):TSmallRect; { Relativ zu WindowsStart }
begin
With Result do
 begin
 left:=  l-1+lo(windmin);
 top:=   t-1+hi(windmin);
 if r > lo(windmax)  then right:= lo(windmax) else right:= r-1+lo(windmin);
 if b > hi(windmax) then bottom:=hi(windmax) else bottom:= b-1+hi(windmin);
end;
end;

Function SetCoord (rx,ry:word):TCoord; { Relativ zu WindowStart }
begin
With Result do
 begin
 x:=  rx-1+lo(windmin);
 y:=  ry-1+hi(windmin);
 end;
end;

Function SetChar (ch:char;attr:word):TcharInfo;
begin
 Result.AsciiChar:=ch;
 Result.Attributes:=Attr;
end;

Procedure clrscr;
begin
 ClrWin (setRect(1,1,80,25));
 Gotoxy (1,1);
end;


Procedure ClrEOL;
begin
 ClrWin(SetRect(WhereX,WhereY,80,WhereY));
end;

Procedure DeleteLine (line:byte);
var Pchar:TCharInfo;
begin
 Pchar:=SetChar(' ',textattr);
 ScrollConsoleScreenBuffer (hConsoleOutput,setRect(1,line+1,80,25),nil,setCoord(1,line),Pchar);
end;

Procedure InsertLine (line:byte);
var Pchar:TCharInfo;
begin
 Pchar:=SetChar(' ',textattr);
 ScrollConsoleScreenBuffer (hConsoleOutput,setRect(1,line,80,25),nil,setCoord(1,line+1),Pchar);
end;

Procedure Delline;
begin
 Deleteline (wherey);
end;

Procedure insline;
begin
 InsertLine (wherey);
end;


{$ifdef with_textDRV}
 {$I MyTxtDrv.pas}
{$endif}

Procedure AssignCRT (var F:text);
begin
{$ifdef with_textDRV}
 If @F = @mytextDRV then
   begin
   MyTextDrvassign (output);
   exit;
   end;
 {$endif}
 assign (output,TTextrec(F).name);
 rewrite (output);
end;

procedure Window(X1,Y1,X2,Y2: Byte);
begin
 windmin:=(y1-1) shl 8 or (x1-1);
 windmax:=(y2-1) shl 8 or (x2-1);
 {$ifdef with_textDRV}
 if SetDRVonWindow and  (TTextrec(output).inoutfunc <> @MyTextDRVinout) then AssignCRT (myTextDRV);
 if SetDRVonWindow and (windmin=0) and (windmax=Defaultwindmax) then assignCRT (output);
 {$endif}
 gotoxy (1,1);
end;

procedure TextMode(Mode: Integer);
{ startet leider nicht mit Maximized Window !)
{ z.T. auch falsche Font-Gre im Full-Screen (Windows.Bug!) }

var NewScreenSize:longint;
  begin
    if not consoleok then exit;
    if Mode = Font8x8  then CRTCoord:=Font8x8Coord
     else if Mode = CO40 then CRTCoord:=CO40Coord
      else CRTCoord:=CO80Coord;
  Windmin:=0;
  Windmax:=(CRTCoord.Y -1 )shl 8 or (CRTCoord.X -1);
  Defaultwindmax:=Windmax;
  textattr:=normattr;
  normvideo;
  NewScreenSize:= Longint(CRTCoord.X)*Longint(CRTCoord.Y);
  If NewScreenSize = Screensize then exit; // nischt zu tun;
  If NewScreenSize > Screensize then {erst Buffer vergrern }
   begin
   if not SetConsoleScreenBufferSize(hConsoleOutput,CRTCoord)
    then Runerror(16);
   if not SetConsoleWindowInfo (hConsoleOutput,true,setRect(1,1,CRTCOORD.X,CRTCOORD.Y))
    then Runerror (7);
   end
  else                               { sonst anders herum }
   begin
   if not SetConsoleWindowInfo (hConsoleOutput,true,setRect(1,1,CRTCOORD.X,CRTCOORD.Y))
    then  Runerror(8);
   if not SetConsoleScreenBufferSize(hConsoleOutput,CRTCoord)
     then Runerror(9);
   end;

  LastMode := CRTMode;
  CRTMode:=Mode;
  GetConsoleInfo;
end;


procedure CrtInit;
begin
with PCONSOLE_SCREEN_BUFFER_INFO do
 begin
 if dwsize.y > 25 then lastmode:=font8x8
                   else if dwsize.x < 39 then lastmode:=1
                    else lastmode:= 3;
 normattr:=wAttributes;
 CRTmode:=lastmode;
 Textmode(Crtmode);
 end;
end;

Procedure settranslate (tr:boolean);
begin
{$ifdef with_textDRV}
translate:=tr;
if translate then
 begin
 SetDRVonWindow:=false;
 assignCRT(myTextDrv);
 end;
 {$endif}
end;

Procedure settabs (ts:byteset);
begin
 tabset:=ts;
 exectabs:=true;
end;

var StartupInfo:TStartupInfo;
Initialization

GetStartupInfo (StartupInfo); { hier nicht weiter ausgewertet }

GetConsoleInfo;

SetConsoleMode(hConsoleInput,Enable_Line_Input); { keine Mausclicks etc }
SetConsoleMode(hConsoleOutput,Enable_Processed_outPut or Enable_Wrap_at_EOL_Output);

SetConsoleTitle ('CRT-Console aus c''t 23/98 Andreas Stiller V1.0');
FlushConsoleInputBuffer(hConsoleInput);

checkEOF:=false;CheckBreak:=false;
CrtInit;
{$ifdef with_textDRV}
TTExtRec(MyTextDRV).InoutFunc:=NIL;
// assignCRT (MyTextDRV);  { falls immer via MyTextDRV }
// setDRVonWindow:=false;  {    "                     }
{$endif}

Finalization
Nosound;
Textmode (CO80);
end.
