Function bZeit(t#) As Date
    bZeit = TimeSerial(Left(t, 2), Mid(t, 3, 2), Right(t, 2))
End Function


Sub ZuMinus()
    ActiveWorkbook.Date1904 = True
    ActiveCell = ActiveCell * -1
End Sub


Function ZuZeit(N)
Dim nHour%, nMinute%
    nHour = Int(N / 100)
    nMinute = N Mod 100
    ZuZeit = TimeSerial(nHour, nMinute, 0)
End Function


Sub InZeit()
Dim C As Range
Dim lR%, i%
    lR = Cells(Rows.Count, 1).End(xlUp).Row
    For i = 1 To lR
        If IsEmpty(Cells(i, 1)) = False Then
            Set C = Cells(i, 1)
            C.NumberFormat = "hh.mm.ss"
            C = TimeSerial(Left(C, 2), Mid(C, 3, 2), Right(C, 2))
        End If
    Next i
End Sub


Function dinKW(Optional dat As Date) As Integer
Dim a As Integer
    If dat = 0 Then dat = Date
    a = Int((dat - DateSerial(Year(dat), 1, 1) + _
        ((Weekday(DateSerial(Year(dat), 1, 1)) + 1) _
        Mod 7) - 3) / 7) + 1
    If a = 0 Then
        a = dinKW(DateSerial(Year(dat) - 1, 12, 31))
    ElseIf a = 53 And (Weekday(DateSerial(Year(dat), 12, 31)) - 1) _
        Mod 7 <= 3 Then
        a = 1
    End If
    dinKW = a
End Function


Sub auto_open()
    Worksheets(1).OnEntry = "Begrenzung"
End Sub

Sub auto_close()
    Worksheets(1).OnEntry = ""
End Sub


Sub Begrenzung()
Dim AC As Range
    Set AC = Application.Caller
    If AC.Address <> "$A$1" Then Exit Sub
    If AC.Value >= 6.5 / 24 And AC.Value <= 20.5 / 24 Then Exit Sub
    MsgBox "Die Zeiteingabe muss folgende Bedingung erfllen:" _
         & Chr(13) & "vor 06:30h und nach 20:30h" & _
         Chr(13) & "Bitte Neueingabe!"
    AC.ClearContents
End Sub

Sub MonateAnlegen()
Dim i
    For i = 1 To 12
        Worksheets.Add after:=Worksheets(Worksheets.Count)
        ActiveSheet.Name = Format(DateSerial(1998, i, 1), "mmm")
    Next i
End Sub


Sub UnterDatumSpeichern()
Dim dName$
    dName = Format(Date, "yyyymmdd")
    dName = dName & ".xls"
    ActiveWorkbook.SaveAs dName
End Sub


Public Function EasterDate(Yr As Integer) As Date
Dim D As Integer
    D = (((255 - 11 * (Yr Mod 19)) - 21) Mod 30) + 21
    EasterDate = DateSerial(Yr, 3, 1) + D + (D > 48) + _
        6 - ((Yr + Yr \ 4 + D + (D > 48) + 1) Mod 7)
End Function

Sub Sonntage()
Dim Bereich As Range, C As Range

    For Each C In Worksheets(1).Range("A3:N367")
        On Error Resume Next
        If C = "Sonntag" Or Weekday(C) = 1 Then
            C.Interior.ColorIndex = 6
        End If
    Next C

End Sub


Sub JahresKalender()
Dim kJahr$
    Application.ScreenUpdating = False
    kJahr = InputBox("Kalenderjahr:", , Year(Date))
    If kJahr = "" Then Exit Sub
    Worksheets("Feiertage").Range("C1") = CInt(kJahr)
    Call BlattAnlegen(CInt(kJahr))
    Call JahrAnlegen(CInt(kJahr))
    Call Wochenende
    Call Feiertage(ThisWorkbook.Worksheets("Feiertage"))
    Range("A1").Select
End Sub
    
Private Sub BlattAnlegen(kJahr%)
Dim i%
    Workbooks.Add
    Application.DisplayAlerts = False
    For i = 1 To Sheets.Count - 1
        Sheets(1).Delete
    Next i
    Application.DisplayAlerts = True
    Range("A1") = "Datum"
    Range("C1") = "Eintragung"
    With Range("A1:C1")
        With .Font
            .Bold = True
            .Size = 10
            .ColorIndex = 6
        End With
        .Interior.ColorIndex = 11
    End With
    Windows(1).Caption = "Jahreskalender " & kJahr
    ActiveSheet.Name = kJahr
End Sub

Private Sub JahrAnlegen(kJahr%)
Dim n%
    If kJahr Mod 4 = 0 Then n = 367 Else n = 366
    Range("A2") = DateSerial(kJahr, 1, 1)
    Range("A3").Formula = "=A2+1"
    Range("A3:A" & n).FillDown
    Range("A2:A" & n).Copy
    Range("A2:A" & n).PasteSpecial (xlValues)
    Columns(1).Copy Columns(2)
    Range("B2:B" & n).NumberFormat = "dddd"
    Range("B1") = "Tag"
    Range("B1").HorizontalAlignment = xlRight
End Sub

Private Sub Wochenende()
Dim i%
    i = 2
    Do Until IsEmpty(Cells(i, 1))
        If WeekDay(Cells(i, 1)) = 7 Then
            Range(Cells(i, 1), Cells(i, 2)) _
                .Interior.ColorIndex = 40
        ElseIf WeekDay(Cells(i, 1)) = 1 Then
            Range(Cells(i, 1), Cells(i, 2)) _
                .Interior.ColorIndex = 3
        End If
        i = i + 1
    Loop
End Sub

Private Sub Feiertage(TB1 As Worksheet)
Dim gZelle As Range
Dim i%
    i = 1
    Do Until IsEmpty(TB1.Cells(i, 2))
        Set gZelle = Range("A:A").Find(DateValue _
            (TB1.Cells(i, 2)), lookin:=xlFormulas)
        With gZelle
            .Interior.ColorIndex = 4
            .Offset(0, 1).Interior.ColorIndex = 4
            .NoteText TB1.Cells(i, 1)
        End With
        i = i + 1
    Loop
End Sub


Sub Geburtstage()
Dim D As Date
Dim i%
Dim TMP$, AKT$, Msg1$, Msg2$
    Msg1 = "Heutige(r) Geburtstag(e):"
    Msg2 = "Geburtstagsliste:"
    i = 2
    Do Until IsEmpty(Cells(i, 1))
        D = DateValue(Cells(i, 3))
        D = DateSerial(Year(Date), Month(D), Day(D))
        If D = Date Then
            AKT = Cells(i, 2) & " "
            AKT = AKT & Cells(i, 1) & " - "
            AKT = AKT & Cells(i, 3) & Chr(13)
        ElseIf D < Date + 30 And D > Date Then
            TMP = Cells(i, 2) & " "
            TMP = TMP & Cells(i, 1) & " - "
            TMP = TMP & Cells(i, 3) & Chr(13)
        End If
        i = i + 1
    Loop
    If Len(AKT) > 0 Then MsgBox AKT, , Msg1
    If Len(TMP) > 0 Then MsgBox TMP, , Msg2
End Sub


