program UNIC;
(*

(c) by c't magazin und Carsten Meyer, cm@ctmagazin.de
10.11.2011 #1.0b  IO16, Panel PM8, 20 MHz
12.04.2010 #0.92  ADC-Reihenfolge umgekehrt, Param/Frac-Routine aufgerumt
10.03.2010 #0.91  Angepasst auf EDIP 240-7 Display von Electronic Assembly, I2C
20.02.2010 #0.901 Reimport aus FPGA, nicht Bentigtes gestrichen
15.02.2010 #0.900 erste lauffhige Version
22.01.2010 #0.100 Import von ADA-C, HW-Routinen angepasst

*)

//Defines aktivieren durch Entfernen des 1. Leerzeichens!


{$NOSHADOW}
{$W+ Warnings}            {Warnings off}
{$TYPEDCONST OFF}
{$DEBDELAY}
{$OPTI SMARTLINK_ONLY}
{$DEFINE EXTRTC}          // externe RTC DS1302 an Port B
{ $DEFINE EXTDCF}          // externer DCF-Empfnger an Port D4
{ $DEFINE EDIP}        // LCD-Grafik EA eDIP240-7
{$DEFINE FPGA}        // Bridge-Modul FPGA

Device = mega644p, VCC = 5;


Import SysTick, FAT16, IncrPort4, TWImaster, FreqCount,
       SerPort, I2CExpand, RTclock, LCDmultiPort;  // ADCport,
{$IFDEF EXTDCF}
Import DCFclock;
{$ENDIF}

From System Import float, LongWord, LongInt;

Define
  ProcClock      = 20000000;        {Hertz}
  TWIpresc       = TWI_BR400;

  IncrPort4      = PinA, 1, 16; // pin-reg used, channels, 16 or 32bit integer
  IncrScan4      = Timer2, 10; // timer used, scan rate 10 kHz (1..100)

  LCDmultiPort   = I2C_TWI;
  LCDTYPE_M      = 44780; // 44780 oder 66712;
  LCDrows_M      = 2;              //rows
  LCDcolumns_M   = 8;             //chars per line

  SysTick        = 10;              //msec
  SerPort        = 38400, Stop1, timeout;    {Baud, StopBits|Parity}
  RxBuffer       = 255, iData;
  TxBuffer       = 32, iData;

  StackSize      = $0100, iData;
  FrameSize      = $0180, iData;

  FAT16          = MMC_SPI, iData;
  F16_MMCspeed   = fast;
  F16_FileHandles   = 2;
  F16_Dirlevels     = 1;
  
  I2Cexpand = I2C_TWI, $38; {use TWIport, 9554A}
  I2CexpPorts = {Port0,Port1,Port2,Port3,} Port4,Port5,Port6,Port7;

{$IFDEF EXTDCF}
  DCFclock    = iData;
  DCFport     = PinD, 4, negative;        {Port, Pin#}
{$ENDIF}
  RTclock     = iData, DateTime;{Time, DateTime}
  RTCsource   = SysTick;

  FreqTimer = Timer1;
  
{
  ADCchans = [1,2], iData;
  ADCpresc       = 16;
}
USES
  UFAT16;


Implementation

type
  tError = (NoErr, UserReq, BusyErr, FileErr, SyntaxErr, ParamErr, LockedErr,ChecksumErr);
  tMenu = (adjust,adjfine,noadj,select);
  tPage = (display,terminal,files,all,none);
  tresponseType = (rNone, rByte, rInt, rFloat, rString, rStringInBrackets);


{--------------------------------------------------------------}
const
{$TYPEDCONST OFF}

  DDRAinit                   = %01110100;     {PortA dir}
  PortAinit                  = %00001011;     {PortA CDSW, RTC-Reset, IncrGeber}

// SCLK, MISO, MOSI, SD_SS, F_DS, INT2, COUNT T1, F_RS
  DDRBinit                   = %10111001;     {PortB dir }
  DDRBinitRdRTC              = %10011001;     {PortB dir wenn RTC gelesen wird}
  PortBinit                  = %10111101;     {PortB SPI, Trigger und FrequCount}

//JTAG-Fuses disablen, sonst PortC nur teilweise Funktion!
  DDRCinit                   = %11111100;     {PortC dir}
  PortCinit                  = %10011100;     {PortC Strobes DAC und SR, I2C}

{ Jumper und LEDs PortBits }
  DDRDinit                   = %11111100;     {PortD dir}
  PortDinit                  = %00001100;     {PortD Enables/Invert-Bits, LED}

//  ControlBitPort             = @PortB;   {DDS-Port}
//  ControlBitPin              = @PinB;   {DDS-Port}
  StrobeBitPort              = @PortC;
  StrobeBitPin               = @PinC;
  InvertBitPort              = @PortD;
  InvertBitPin               = @PinD;

  ConFPGABitPort             = @PortA;   {FPGA-Config-Port}
  ConFPGABitPin              = @PinA;   {FPGA-Config-Port}
  FPGAport                   = @PortB;   {FPGA-SPI-Port}
  FPGApin                    = @PinB;    {FPGA-SPI-Port}

  a_RTCrst                   = 2; // RTC-Ena/Reset
  a_CDSW                     = 3; // SD-Kartenslot Switch

  b_RTCclk                   = 7; // RTC an Port B, RST = F_AUX!
  b_RTCio                    = 5; // RTC IO-Pin

  b_SCK                      = 7; //Takt fr alle, SPI-Belegung!
  b_MISO                     = 6; //SPI Daten von allen
  b_MOSI                     = 5; //Daten an alle
  b_SS                       = 4; //fr MMC-Karte benutzt, HW-SPI!


  b_INT2                     = 2; //INT2
  b_counter                  = 1; //Counter-Input
  b_AUX                      = 0; //Testpin Trigger LA


  a_DATA                     = 4; //Daten FPGA Configuration
  a_CCLK                     = 5; //Takt FPGA Configuration
  a_PROG                     = 6; //Prog-Leitung FPGA Configuration
  a_DONE                     = 7; //Done-Leitung FPGA Configuration

  a_DATASEL                  = 4; //FPGA SPI-Register bis 32 Bit
  a_REGSEL                   = 5; //FPGA Registerauswahl 16 Bit mit Write Enable Bit 15; auch CCLK!

//Lineal     .----.----.----.----.----.----.----.----.----
  Vers1Str                   = '1.0b [UNIC by CM/c''t 03/2010]';    //Vers1
  VersLCDstr                 = 'UNIC#1.0';    //Vers1
  ErrStrArr      : array[0..7] of String[8] = (
    '[OK]','[SRQUSR]','[BUSY]','[FILERR]','[CMDERR]','[PARERR]',
    '[LOCKED]','[CHKSUM]');

  FaultStrArr : array[0..3] of String[10] = (
    '[NOTFOUND]',
    '[NOCARD]',
    '[CONFERR]',
    '[WRITERR]');

  HeaderStr = 'VAL'+#9+'REG'+#9+'TIME'+#9+'DATE';

  EEnotProgrammedStr         = 'EEPROM EMPTY! ';
  NoneStr                    = '--- ';
  ErrSubCh: Integer          = 255;
  FileNumStr                 = ' file';
  ParamHintStr               = 'Param  ';
  InputHintStr               = 'Value  ';

  CmdStrArr: array[0..56] of String[3] = (
  'STR', // 255
  'VAL', // 0..9999
  
{--------------------------------------------------------------}
// Script-Befehle
  'REG', // 300..309  Load Register 0..9 immediately mit Wert, auch Abfrage
  'ACC', // 300  Load Akku A (Register 0) immediately mit Wert, auch Abfrage
  'MOV', // 310..319  Move Register 0..9 := 0..9
  'DEC', // 320  Decrement Register (0..9), Ergebnis fr Branches merken
  'INC', // 330  Increment Register (0..9), Ergebnis fr Branches merken
  'CPZ', // 340  Compare Register (0..9) mit "0", Inhalt fr Branches merken
  'XCH', // 350  Exchange 0..9 :=: 0..9, ohne Argument: Akku A mit Register (0..9)


  'GET', // 400..409  Warte auf Ergebnis, speichere in Registerinhalt 0..9
  'PUT', // 500..509  Sende Wert in Akku A auf MCM/SCM

  'MUL', // 600  Multiplikation Akku A = Akku A * Register (0..9)
  'DIV', // 610  Division Akku A = Akku A / Register (0..9)
  'ADD', // 620  Addition Akku A = Akku A + Register (0..9)
  'SUB', // 630  Subtraktion Akku A = Akku A - Register (0..9)
  'SQR', // 640  Quadratwurzel Register (0..9) = sqr(Register (0..9))
  'SQU', // 650  Quadrat Register (0..9) = Register (0..9) * Register (0..9)
  'NEG', // 660  Negiere Register (*-1)
  'END', // 999  Setzt TerminateFlag in Skripts
  'LBL', // 1000  Label 0..99 setzen (hier begrenzt auf 0..31)
  'GTO', // 1100  Goto <labelnr>
  'BRA', // 1100  Branch always to <labelnr>, wie GTO
  'BRG', // 1200  Branch if greater 0 to Label <labelnr>, wenn Akku A grer als B
  'BGE', // 1300  Branch if greater or equal 0 to Label <labelnr>, wenn Akku A grer oder gleich B
  'BEQ', // 1400  Branch if equal 0 to Label <labelnr>, wenn Akku A gleich B
  'BLE', // 1500  Branch if lower or equal 0 to Label <labelnr>, wenn Akku A kleiner oder gleich B
  'BRL', // 1600  Branch if lower 0 to Label <labelnr>, wenn Akku A kleiner als B

  'INP', // 2000..2255 Input Akku mit Wert von moduleigener SubCh-Abfrage (SPI-Reg.)
  'OUT', // 2000..2255 Register Output,
         // Ausgabe von Akku oder Reg. 0..9 in moduleigenen SubCh (SPI-Reg.) 0..63

{--------------------------------------------------------------}
  'PIO', // 30 = Ports I/O
  'DDR', // 40 = Ports Datenrichtungen
  'RAW', // 50 = Roh-AD-Werte
  'DSP', // 80 = Display-Parameter
  'UDI', // 89 = FPGA-SPI Update Disable, 1 = Updates OFF
  'DEF', // 100..159 = Defaults, Offsets, Saklierungen

  'CLK', // 90..95, 97 RTC-Register und Befehle
  'ALL', // 98,99 = Alle Werte Ports, ADC, als Liste
  'OPT', // 200..209  Options Init-Werte 0..9
         // 210  IniFileName (INI oder CFG)
         // 211  DataFileName (INI oder CFG)
  'FWR', // 260 FileWriteRegister, FWR=<register0..9> in Datei DatFileName schreiben
  'FWV', // 270 FileWriteValue, FWV <index>=<wert> in Datei DatFileName schreiben

  'WTH', // 290  Wait Tick Hour
  'WTM', // 291  Wait Tick Minute
  'WTS', // 292  Wait Tick Second
  'DLY', // 299  Delay ms

  'CFG', // 240 File Auswahl
  'LST', // 241 Dir Listing
  'DIR', // 241 Dir Listing
  'FNM', // 242 FileNumber, Anzahl der Dateien
  'FNA', // 243 Data FileName (alpha)
  'FDL', // 244 Delete DataFileName (alpha)
  'FQU', // 249 File Query, OK/Exists
  'WEN', // 250 Write enable
  'ERC', // 251 ErrCount seit letztem Reset
  'SBD', // 252 SerBaud UBRR-Register mit U2X=1
  'REM', // 253
  'IDN', // 254
  'NOP');

  Cmd2SubChArr: array[0..56] of integer = (
  255,
  0,
  300,300,
  310,320,330,340,350,
  400,500,
  600,610,620,630,640,650,660,
  999,
  1000,1100,1100,1200,1300,1400,1500,1600,
  2000, 2000,

  30,40,50,80,89,      // Ports, Raw, Display
  100,          // Defines Offsets und Skalierungen,

  90,   //RTC
  98,
  200,
  260,
  270,
  290,291,292,299,
  240, 241, 241, 242, 243, 244,249,
  250, 251, 252, 253, 254, 253);

  cmdAnzahl=56; // letzter Eintrag, statt tCmdwhich
  cmdErr=cmdAnzahl+1; // Error, Statt tCmdwhich

  high: boolean = true;
  low: boolean = false;

  DC1: byte =$11;
  DC2: byte =$12;
  ACK: byte =$06;
  NAK: byte =$15;
  
  FracScale: longInt = 10000;

  initAutoIncReg: byte             = 128;   // hier Konstanten, nicht nderbar
  initAutoIncWidth: byte           = 4;
  initAutoIncSel: byte             = 0;

{
  LCDtoSubChArr: array[0..41] of Integer = (
    240,                      // 0: Filesel
    8,                        // 1: Frequ
    10,11,12,13,14,15,16,17,  // 2..9: ADCs
    20,21,22,23,              // 10..13: DACs
    30,31,32,33,34,35,        // 14..19: Ports
    44,45,                    // 20..21 DDRs Bridge PCA9555A
    60,61,62,63,64,65,66,67,68,69,  // 22..41 DFPGA SPI lesen
    70,71,72,73,74,75,76,77,78,79
  );
}

  
structconst
//Default-EEPROM-Werte:
{$EEPROM}
  dummy:LongInt=0;
  InitADCBaseScale: Float  = 1/409.5;      // 2442 fr FracScale=1000
  InitDACBaseScale: LongInt  = 269541; // bercksichtigt Grundverstrkung

  InitDACvalueArray      : array[0..7] of Float =
  (0,0,0,0,0,0,0,0);

// ADCoffsets, 10..17 AD12  (-2145 fr bipolar Rgnd=10k/Rref=6k8/Rv=30k)
  InitADCOffsetArray      : array[0..7] of Integer =
  (0, 0, 0, 0,
  0, 0, 0, 0);
  
// ADCscales 10..17 (2.1 fr bipolar 10V, Rgnd=10k/Rref=6k8/Rv=30k)
  InitADCscaleArray      : array[0..7] of Float =
  (1.0, 1.0, 1.0, 1.0,
  1.0, 1.0, 1.0, 1.0);

// DAC 0 bis 3 Offsets 20..23, 20..23 negativ
  InitDACOffsetArray      : array[0..7] of Integer =
  (0, 0, 0, 0,
  0, 0, 0, 0);

// DACscales 20..23, 20..23 negativ,
  InitDACscaleArray      : array[0..7] of Float =
  (1.0, 1.0, 1.0, 1.0,       // RPG: Ua, Us, Ug, Uf
   1.0, 1.0, 1.0, 1.0);                    // fr negative Ausgangsspannungen

// IO-Port DDR Datenrichtungsregister; 0..3 immer Ausgang
  InitDDRArray: array [0..7] of byte = ($FF,$FF,$FF,$FF,0,0,0,0);
  InitPortArray: array [0..7] of byte = (0,0,0,0,0,0,0,0);

  EEinitialised:word=$AA55;
  InitEncRast:byte = 4;
  EESerBaudReg:byte= 51;
  EESerBaud: LongInt= 38400;
  InitIntegrateADC:boolean=false;

  OptionArray:Array[0..9] of Integer =  (
  255,  // 0 BIN-File Default, 255=keine
  255,  // 1 INI-File Default
  0,    // 2 --
  0,    // 3 --
  0,    // 4 Result MainCh
  0,    // 5 Result SubCh
  6,    // 6 InitDigits
  0,    // 7 (war InitNachkomma, obsolete)
  8,    // 8 EEMainCh
  500   // 9 EEgetTimeOut
  );

  EEInitFileName:String[15] = 'STARTUP.INI';
  EEDatFileName:String[15] = 'DATAFILE.XLS';


{--------------------------------------------------------------}

var
{$EEPROM}
  EEbinFileNum[@OptionArray+0]:integer;      // BIN-FileNum
  EEiniFileNum[@OptionArray+2]:integer;      // INI-FileNum -1 (kein INI-File)
  EEAutoIncSel[@OptionArray+4]:integer;      // Default AutoIncSel, hier nicht benutzt
  EEAutoIncReg[@OptionArray+6]:integer;      // Default AutoIncReg, hier nicht benutzt

  InitDigits[@OptionArray+12]:integer;
  EEMainCh[@OptionArray+16]:integer;
  EEgettimeout[@OptionArray+18]:integer;


{$DATA} {Schnelle Register-Variablen}
  i,j: Byte;
  TempW: Word;
  TempI[@TempW]: Integer;
  TempW_low[@TempW+0]: byte;
  TempW_high[@TempW+1]: byte;
  c:char; // in serout benutzt
{$IDATA}  {Langsamere SRAM-Variablen}
  MainCh: byte;

  LEDactivity[@PortD, 2]    : bit; {Bit 2 LED Remote-Activity}
//  LEDswitch[@PortD, 3]      : bit; {Bit 3 LED ber dem Display}
  SD_CDSW[@PinA, a_CDSW]: bit;    // Card Insertion Switch, low = inserted

  PA4[@PortA, 4]: bit;   // AUX Portbits fr FPGA-Konfiguration
  PA5[@PortA, 5]: bit;
  PA6[@PortA, 6]: bit;
  PA7[@PortA, 7]: bit;

  PD3[@PinD, 3]: bit;    // PanelBuf Portbits

  I2CslaveAdr:byte; // I2C IO Slave Adresse
  SPIsendbyte, SPIreceivebyte: byte;

  FPGA_present: boolean;
  FPGA_readflags: byte;   // vom FPGA zu lesen
  FPGA_writeflags: byte;  // ins FPGA zu schreiben

  FPGA_PROG[ConFPGABitPort, a_PROG]: bit;  // Prog-Leitung FPGA Configuration
  FPGA_DONE[ConFPGABitPin,  a_DONE]: bit;  // Done-Leitung FPGA Configuration
  
  F_Aux[FPGAport, b_AUX]:bit;    // Testpin f LA-Trigger
  F_Int[FPGAport, b_INT2]:bit;   // Daten-abholen-Interrupt

  ParamLong:LongInt;
  ParamByte, ParamTemp :Byte;
  
  FPGA_lockout: boolean;    // autom. FPGA-Auslesen/Schreiben sperren
  
  FPGA_SendArr: array[0..7] of LongInt;
  FPGA_RecvArr: array[0..7] of LongInt;

  FPGAreg: word;   // FPGA-Registerauswahl
  FPGAsendLong,
  FPGAreceiveLong : LongInt;  // FPGA-Registerwert Langwort

  FPGAsendLong0[@FPGAsendLong+0]:byte;
  FPGAsendLong1[@FPGAsendLong+1]:byte;
  FPGAsendLong2[@FPGAsendLong+2]:byte;
  FPGAsendLong3[@FPGAsendLong+3]:byte;

  FPGAsendWord[@FPGAsendLong+0]:Word;
  FPGAsendWord0[@FPGAsendLong+0]:byte;
  FPGAsendWord1[@FPGAsendLong+1]:byte;
  FPGAsendByte[@FPGAsendLong+0]: byte;  // FPGA-Registerwert Byte

  FPGAreceiveLong0[@FPGAreceiveLong+0]:byte;
  FPGAreceiveLong1[@FPGAreceiveLong+1]:byte;
  FPGAreceiveLong2[@FPGAreceiveLong+2]:byte;
  FPGAreceiveLong3[@FPGAreceiveLong+3]:byte;

  FPGAreceiveInt[@FPGAreceiveLong+0]:Integer;
  FPGAreceiveWord[@FPGAreceiveLong+0]:Word;
  FPGAreceiveByte[@FPGAreceiveLong+0]: byte;  // FPGA-Registerwert Byte

  FPGAbyte, FlashByte: byte;    // fr Konfiguration

  DisplayTimer, ButtonTimer:Systimer8;

  ButtonTemp,RangeTemp: Byte; // invertiert - low=on!
  ButtonDown[@ButtonTemp, 5]  : bit;
  ButtonUp[@ButtonTemp, 4]  : bit;
  ButtonEnter[@ButtonTemp, 3]  : bit;
  ButtonFlag: boolean;

  CmdWhich: byte; // tcmdwhich nicht mehr benutzt
  SubCh: Integer;
  x,y, CurrentCh       : byte;
  verbose: boolean;
  Param          : float;
  ParamFrac: LongInt;
  ParamInt:Integer;
  ParamAlpha     : boolean; // Flag fr Zeichenfolge hinter "="

  SerInpStr : String[63];
  SerInpPtr:byte;

  LCDpresent: boolean;
  Modify: byte;
  IncrValue,OldIncrValue: Integer;
  EncRast:Byte;
  digits, nachkomma:byte;
  ChangedFlag:Boolean;

  MenuSelect: tMenu;
//fr Parser
  ParamStr:string[40]; // auch fr Display
  Request:boolean;
  Status:byte;  // 0..3 Fehlernummer
  BusyFlag[@Status, 7]  : bit;
  UserSRQFlag[@Status, 6]  : bit;
  FileErrorFlag[@Status, 5]  : bit;  //
  EEUnlocked[@Status, 4]  : bit; // EEPROM-unlocked-Flag

{  FaultStrArr : array[0..3] of String[10] = (
    '[READERR]',
    '[NOCARD]',
    '[CONFERR]',
    '[WRITERR]');  }

  FaultFlags, ButtonNumber:byte;
  ReadErr[@FaultFlags, 0]  : bit;
  NoCard[@FaultFlags, 1]  : bit;
  ConfErr[@FaultFlags, 2]  : bit;
  WriteErr[@FaultFlags, 3]  : bit;
  CardOK:boolean;
  ErrCount:integer;
  BitCount: LongInt;
  BitCount3[@BitCount+3]:byte;
  BitCount2[@BitCount+2]:byte;
  BitCount1[@BitCount+1]:byte;
  BitCount0[@BitCount]:byte;

  Pause:word;
  TerminateFlag: boolean; // Abbruch von Skripten wenn True
  
// Script-Register 0..9
  RegisterArray:array[0..9] of Float; // REG-Werte
  AccA[@RegisterArray+0]: Float;      // Akku A (0)

  GetTimeout: Integer;
  CompareParam:Float;
  GETwaitFlag:Boolean;
  LabelArray:array[0..31] of Word;
  LabelValidArray:array[0..31] of boolean;
  DirectoryArray:array[0..31] of string[12];
  DirectoryDone:Boolean;
  BinFile : file of byte;
  InitFile,MemFile,DataFile : file of text;

  FileName,DatFileName: string[12];
  INITfileIsOpen, LabelSeek:Boolean;
  CurrentGotoLabel:byte;
  LastBinFileNum, FileNum, FileAnzahl,FileNumTemp : byte;

  AutoIncReg:byte;         // Auto-Increment-Register, hierhin werden .DAT-Datenblcke geschrieben
  AutoIncSel:byte;         // Auto-Increment-Select
  AutoIncWidth:byte;       // AI Breite in Bytes, 1, 2 oder 4
  AutoIncBlockEnd,AutoIncBlockStart: LongInt;

// Real Time Clock RTC
  tickSeconds, tickMinutes, tickHours: Boolean;
  RTCarray:array[0..5] of byte;
  Hour[@RTCarray+0]:byte;
  Minute[@RTCarray+1]:byte;
  Second[@RTCarray+2]:byte;
  Day[@RTCarray+3]:byte;
  Month[@RTCarray+4]:byte;
  Year[@RTCarray+5]:byte;
  RTCcmd, RTCdata:Byte;    // fr externe RTC DS1302 oder HT1381

  DOStime, DOSdate:Word;

  BlockTable[$f00]:Table[0..255] of byte;
  BlockArray[@BlockTable]:Array[0..255] of byte; // fr FAT16
  BlockArray2[@BlockTable]:Array[0..127] of Word; // fr FAT16
  BlockArray4[@BlockTable]:Array[0..63] of LongInt; // fr FAT16
  BlockStr[@BlockTable]:String[255];

{###########################################################################}

  TRIGIN[@PinB, 0]        : bit; //Trigger-Eingang
  SLAVESEL[@PortB, 4]        : bit;
  STRDAC0[@PortC, 2]      : bit; //Strobe fr MCP4822 0/1
  STRDAC1[@PortC, 3]      : bit; //Strobe fr MCP4822 2/3
  STRDACLOAD[@PortC, 4]      : bit; //LOAD fr beide MCP4822
  STRADC[@PortC, 7]    : bit; //Strobe fr MCP3208
  STRSHIFT[@PortC, 5]   : bit; //Strobe 4094 SR
  ENASHIFT[@PortC, 6]   : bit; //Output Enable 4094 SR

  INVERT0[@PortD, 5]   : bit; //Invert Output DAC 0
  INVERT1[@PortD, 4]   : bit; //Invert Output DAC 1
  INVERT2[@PortD, 7]   : bit; //Invert Output DAC 2
  INVERT3[@PortD, 6]   : bit; //Invert Output DAC 3


      {
  IOPin[@PIn0] : TI2Cport;     // In-Port 9554A auf I/O-Platine
  IOPort[@Port0] : TI2Cport;   // Out-Port 9554A auf I/O-Platine
  IODDR[@DDR0] : TI2Cport;     // Datenrichtung 9554A auf I/O-Platine

  IO0Pin[@PIn0] : TI2Cport;     // Port 9554A auf I/O-Platine
  IO1Pin[@PIn1] : TI2Cport;     // Port 9554A auf I/O-Platine
  IO2Pin[@PIn2] : TI2Cport;     // Port 9554A auf I/O-Platine
  IO3Pin[@PIn3] : TI2Cport;     // Port 9554A auf I/O-Platine
}
  IO4Pin[@PIn4] : TI2Cport;     // Port 9554A auf I/O-Platine
  IO5Pin[@PIn5] : TI2Cport;     // Port 9554A auf I/O-Platine
  IO6Pin[@PIn6] : TI2Cport;     // Port 9554A auf I/O-Platine
  IO7Pin[@PIn7] : TI2Cport;     // Port 9554A auf I/O-Platine
{
  IO0Port[@Port0] : TI2Cport;   // Port 9554A auf I/O-Platine
  IO1Port[@Port1] : TI2Cport;   // Port 9554A auf I/O-Platine
  IO2Port[@Port2] : TI2Cport;   // Port 9554A auf I/O-Platine
  IO3Port[@Port3] : TI2Cport;   // Port 9554A auf I/O-Platine
}
  IO4Port[@Port4] : TI2Cport;   // Port 9554A auf I/O-Platine
  IO6Port[@Port6] : TI2Cport;   // Port 9554A auf I/O-Platine
  IO5Port[@Port5] : TI2Cport;   // Port 9554A auf I/O-Platine
  IO7Port[@Port7] : TI2Cport;   // Port 9554A auf I/O-Platine
{
  IO0DDR[@DDR0] : TI2Cport;
  IO1DDR[@DDR1] : TI2Cport;
  IO2DDR[@DDR2] : TI2Cport;
  IO3DDR[@DDR3] : TI2Cport;
}
  IO4DDR[@DDR4] : TI2Cport;
  IO5DDR[@DDR5] : TI2Cport;
  IO6DDR[@DDR6] : TI2Cport;
  IO7DDR[@DDR7] : TI2Cport;

  PortArray, PinArray, DDRArray: array [0..7] of byte;
  PortSR0[@PortArray+0]: byte;
  PortSR1[@PortArray+1]: byte;
  PortSR2[@PortArray+2]: byte;
  PortSR3[@PortArray+3]: byte;
  PinSR0[@PinArray+0]: byte;
  PinSR1[@PinArray+1]: byte;
  PinSR2[@PinArray+2]: byte;
  PinSR3[@PinArray+3]: byte;

  IO16present: Boolean;

// SubCh 100..119
  ADCoffsets:array[0..7] of Integer;
  DACoffsets:array[0..7] of Integer;
// SubCh 120..149
  ADCscales:array[0..7] of Float;
  DACscales:array[0..7] of LongInt;


//Arrays mit Parametern fr 32 SubChannels
  DACvalues     : Array[0..7] of LongInt;  // in Frac-Darstellung Festkomma
  DACrawArray      : Array[0..7] of Integer;
  ADCrawArray      : Array[0..7] of Integer;
  ParamTextArray: Array[0..9] of String[15];
  UnitArray: Array[0..9] of String[4];
  BarMaxArray:array[0..9] of Integer;
  SubChArray: Array[0..9] of Integer;
  ADCbaseScale   :Float;
  DACbaseScale:   LongInt;
  IntegrateADC: Boolean;

  FreqMode : tFreqCountMode;
  Freq     : word;
  FreqLo[@Freq+0]:byte;
  FreqHi[@Freq+1]:byte;
  FreqLong : LongWord;
  FreqMeasureMode : Byte;
  
  DisplaySwitchSema, SubSelectSema, ModifySema, ButtonSelectSema,
  IncrSema, CardChangeSema, FileSelectSema,
  BarUpdatedSema:  Boolean;
  BarUpdated : byte;  // letzter Auto-Touchbar Nummer und Wert
  ButtonSelect: Byte;
  MainPage,LastMainPage: tPage;
  SubSelect: Byte;
  SanduhrIcon: Byte;
  Bipolar: Boolean;
  OsziCount,EncStep:byte;  // EncRast-Zhler
  EncDiff,EncValue,OldEncValue: Integer;   // Fr Dreh-Encoder
  EncDiffByte[@EncDiff]: Byte;
  EncSema:Boolean;  // Drehknopf bettigt

{###########################################################################}


procedure CheckSer;  forward;
procedure CheckDelay(myDelay:byte);  forward;
procedure ParseSubCh;  forward;


function FracToFloat(myFrac:LongInt):Float;
begin
  return(Float(myFrac)/FracScale);
end;

Procedure ParamFracDivFracScale;
begin
  ParamFrac:=ParamFrac div FracScale;
end;

Procedure ParamToParamFrac;
begin
  ParamFrac:=LongInt(Param*FracScale);
end;

Procedure ParamFracToParam;
begin
  Param:=Float(ParamFrac)/FracScale;
end;

{$I UNIC-HW.pas}
{$I UNIC-fpga.pas}

procedure EncZero;
begin
  SetIncrVal4(0,0);
  OldEncValue:=GetIncrVal4(0);
  EncValue:=GetIncrVal4(0);
  EncStep:=0;
end;


procedure InitVars;
//Frequenz und Settings aus EEPROM holen
begin
  AutoIncReg:= initAutoIncReg;
  AutoIncSel:= initAutoIncSel;
  AutoIncWidth:= initAutoIncWidth;

  digits:=byte(InitDigits);
  ParamStr:='';
  GetTimeout:=EEgetTimeOut;
  DatFileName:=EEDatFileName;
  IntegrateADC:=InitIntegrateADC;
  ADCbaseScale:=InitADCBaseScale;
  DACbaseScale:=InitDACBaseScale;
  for i:=0 to 7 do
    ADCScales[i]:=InitADCScaleArray[i];
    ADCOffsets[i]:=InitADCOffsetArray[i];
    
    Param:=InitDACscaleArray[i];
    ParamToParamFrac;
    DACScales[i]:=ParamFrac;
    DACoffsets[i]:=InitDACoffsetArray[i];
    
    Param:=InitDACvalueArray[i];
    ParamToParamFrac;
    SetDACfrac(i,ParamFrac);
  endfor;
  EncRast:=initEncRast;
  EncZero;
end;


{###########################################################################}

procedure serDummy;
begin
  SerOut(#0);
end;

procedure CheckCard;
begin
  if F16_DiskInit then
    F16_DiskReset;
    CardOK:=true;
    NoCard:=false;
  else
    CardOK:=false;
    NoCard:=true;
  endif;
end;

procedure ClearDirectory;
begin
  for i:=0 to 31 do
    DirectoryArray[i]:='<empty>';
  endfor;
  FileNum:=0;
  FileAnzahl:=0;
  LastBinFileNum:=0;
  DirectoryDone:=false; // einlesen des Directory beim nchsten FileSel
  CardChangeSema:=true;
end;

procedure GetDirectory;
var
SR : TSearchRec;
begin
// search for filename/directory entries, accept wildcards
  i:=0;
  CheckCard;
  FileAnzahl:=0;
  if not CardOK then
    ClearDirectory;
  else
    if (F16_FindFirst ('\', '*.*', [faArchive], SR)) then
      repeat
        DirectoryArray[i]:= SR.Name;
        inc(i);
      until (i=64) or (not F16_FindNext (SR));
    endif;
    FileAnzahl:=i;
    DirectoryDone:=true;
    CardChangeSema:=true;
  endif;
end;

{###########################################################################}

//allg. Men-Prozeduren und Hilfsroutinen

function Checklimits:boolean;
// liefert TRUE wenn "Out of Range"
var myBool: Boolean;
begin
  myBool:=false;
  if FileNum>127 then  // Byte!
    FileNum:=0;
    myBool:=true;
  endif;
  if FileNum>31 then  // Byte!
    FileNum:=31;
    myBool:=true;
  endif;
  if Modify>127 then  // Byte!
    Modify:=41;       // berlauf
    myBool:=true;
  endif;
  if Modify>41 then  // Byte!
    Modify:=0;
    myBool:=true;
  endif;
  return(myBool);
end;

procedure ParamToStr;
begin
  ParamStr:=floatToStr(Param);
// workaround fr fehlerhafte Umwandlung "gerader" Zahlen in AVRco
  ParamStr:=trimleft(ParamStr);
  if pos('.',ParamStr)=0 then
    ParamStr:=ParamStr+'.0';
  endif;
  ParamStr:=padright(ParamStr,10,'0');
  setLength(ParamStr,digits+1); // Dezimalpunkt zhlt nicht, daher +1
end;

procedure IntToParamStr(myInt:Integer);
begin
  ParamStr:=IntToStr(myInt);
end;

function FracRound1000(my_frac:LongInt): LongInt;
var my_long: LongInt;
begin
  my_long:= my_frac div 1000;
  return (my_long * 1000);
end;

{

procedure ParamLongToHex;
//Longin in Hex-String wandeln
begin
  ParamStr:=LongToHex(ParamLong);
end;

procedure ParamIntToHex;
//Longin in Hex-String wandeln
begin
  ParamStr:=IntToHex(ParamInt);
end;
}

procedure ParamFracToPMStr; // String-Wandlung mit Vorzeichen
// var myString:String[10];
begin
{
  if ParamFrac=0 then
    ParamStr:= '0';
  else
    ParamStr:=LongToStr(abs(ParamFrac));
  endif;
  mylen:=length(ParamStr);
  if myLen<5 then
    myString:=padleft(ParamStr,5,'0');
    myLen:=5;
    ParamStr:=myString;
  endif;
  insert('.',ParamStr,mylen-3);
  if sign(ParamFrac) then
    mysign:='+';
  else
    mysign:='-';
  endif;
  insert(mysign,ParamStr,1);
}

  if sign(ParamFrac) then
    Param:=FracToFloat(ParamFrac+1);
    ParamToStr;
    insert('+',ParamStr,1);
  else
    Param:=FracToFloat(ParamFrac-1);
    ParamToStr;
  endif;
  setlength(ParamStr,6);
end;

procedure SerCRLF;
begin
  serout(#$0D);
  serout(#$0A);
end;

procedure WriteChPrefix;
begin
  serout('#');
  serout(char(MainCh+48));
  serout(':');
  write(serout, IntToStr(SubCh));
  serout('=');
end;

procedure WriteSerInp;
begin
  write(serout, SerInpStr);   // Befehl weiterreichen
  SerCRLF;
end;

procedure SerPrompt(myErr:tError);
var myFault, myStatus:Byte;
//Error-Meldung und Status-Request-Antwort,
//Status Bit 7=Busy, 6=UserSRQ, 5=OverLoad, 4=WriteEnable, 3..0=Fault/Error
begin
  SubCh:=ErrSubCh; // Fehler-Kanal
  WriteChPrefix;
  FileErrorFlag:=(FaultFlags<>0);
  if myErr = UserReq then
    myStatus:=Status or ButtonNumber or 64;
  else
    if FileErrorFlag then
      myStatus:=Status or FaultFlags;
    else
      myStatus:=Status or ord(myErr);
      if myErr <> noErr then
        inc(ErrCount);
      endif;
    endif;
  endif;
  write(serout, ByteToStr(myStatus));
  if FileErrorFlag then
    myFault:=FaultFlags;
    for i := 0 to 3 do
      if (myFault and 1) = 1 then
        serout(#32);
        write(serout,FaultStrArr[i]);
      endif;
      myFault:=myFault shr 1;
    endfor;
  endif;
  serout(#32);
  write(serout,ErrStrArr[ord(myErr)]);
  SerCRLF;
end;


{###########################################################################}

procedure SetFreqMeasureMode(myVal:byte); // Frequenzzhler-Modus
begin
  FreqMeasureMode:=myVal;
  SetSema(FreqCountSema,0);
  case myVal of
    0  : SetFreqCountMode(TFreqBase1MHz);
         FreqCountRestart;
          |
    1  : SetFreqCountMode(TFreqBase100kHz);
         FreqCountRestart;
          |
    2  : SetFreqCountMode(TFreqBase10kHz);
         FreqCountRestart;
          |
    3  : SetFreqCountMode(TFreqBase1kHz);
         FreqCountRestart;
          |
    4  : SetFreqCountMode(TFreqBase100Hz);
         FreqCountRestart;
          |
    5  : SetFreqCountMode(TFreqBaseNone);
// Timer/Counter manuell setzen
         TCCR1A:=0;
         TCCR1B:=%00000111; // Rising edge on T1, falling: TCCR1B:=%00000110
         TCNT1H:=0;   // Hi zuerst!
         TCNT1L:=0;
          |
    6  : SetFreqCountMode(TFreqBaseNone);
// Timer/Counter manuell setzen
         TCCR1A:=0;
         TCCR1B:=%00000110; // Falling edge on T1
         TCNT1H:=0;   // Hi zuerst!
         TCNT1L:=0;
          |
  endcase;
end;

procedure FreqToParamStr(myLong:LongWord; myFac:Float; isPulses:boolean);
begin
  Param:=float(myLong)*myFac;
  ParamToStr;
  if isPulses then
    ParamStr:=ParamStr+' [Pulses]';
  else
    ParamStr:=ParamStr+' [Hz]';
  endif;
end;

procedure GetFreqTimerString;
begin
  if GetFreqCountOvrFlow <> 0 then
    ParamStr:= '-1 [OVR]';
    Param:=-1;
  else
    // wait for new result
    if (SemaStat(FreqCountSema) <> 0) or (FreqMode=TFreqBaseNone) then
      FreqMode:= GetFreqCountMode;
      FreqLong:= GetFreqCounterL;
      case FreqMode of
        TFreqBaseNone   :
                        FreqLo:=TCNT1L;  // Low zuerst!
                        FreqHi:=TCNT1H;
                        FreqToParamStr(LongWord(Freq),1,true);
                        |
        TFreqBase100Hz  :
                        FreqToParamStr(FreqLong,0.01,false);
                         |
        TFreqBase1kHz   :
                        FreqToParamStr(FreqLong,0.1,false);
                        |
        TFreqBase10kHz  :
                        FreqToParamStr(FreqLong,1,false);
                        |
        TFreqBase100kHz :
                        FreqToParamStr(FreqLong,10,false);
                        |
        TFreqBase1MHz   :
                        FreqToParamStr(FreqLong,100,false);
                        |
       endcase;
     else
       ParamStr:= '-1 [INV]';
       Param:=-1;
     endif;
  endif;
end;

function GetNewValue(mySubCh:Integer):boolean;
//Werte in Param holen, wenn in SubCh; Raw-Werte in ParamInt
//return-Wert True, wenn Integer
var myResultIsInteger:boolean;
    myIndex:Byte;
begin
  ParamInt:=0;
  Param:=0;
  myResultIsInteger:=true;
  myIndex:=byte(mySubCh mod 10);  // angespr. Register 0..9 errechnen aus SubCh-Rest
  case mySubCh of
    8:
      GetFreqTimerString; // Liefert auch Param
      |
    10..17, 50..57: // aktuellen Wert holen
      ReadADC(myIndex);
      if mySubCh >=50 then
        ParamInt:=ADCrawArray[myIndex];
      else
        ParamToParamFrac;
        myResultIsInteger:=false;
      endif;
      |
    20..23: // aktuellen Wert holen
      ParamFrac:=DACValues[myindex];
      ParamFracToParam;
      myResultIsInteger:=false;
      |
    30..37:
      ParamInt:=Integer(GetPort(myIndex));
      |
    40..47: //DIR Port direction
      ParamInt:=integer(DDRArray[myIndex]);
      |
    60..79:
      ParamLong:=ReceiveFPGA(byte(mySubCh-60));
      ParamInt:=Integer(ParamLong);
      |
    300..309: // Registerwert holen
      Param:=RegisterArray[myIndex];
      ParamToParamFrac;
      myResultIsInteger:=false;
      |
  endcase;
  ParamByte:=lo(ParamInt);
  if myResultIsInteger then
    ParamFrac:=LongInt(ParamInt)*FracScale;  // fr Display
  endif;
  return (myResultIsInteger);
end;


function SubChValueToPMstr(myDisplaySubCh:Integer):boolean;
// wie GetNexValue, wandelt aber gleich in passenden String um
begin
  if GetnewValue(myDisplaySubCh) then // Integer geliefert
    ParamStr:='$'+IntToHex(ParamInt)+' ';
    if myDisplaySubCh in [30..47] then  // Portbits
      ParamStr:='$'+ByteToHex(ParamByte)+' ';
    endif;
    return(true);
  else                                // Float geliefert
    //ParamRound1000;
    ParamFracToPMStr;
    return(false);
  endif;
end;

{###########################################################################}

procedure WriteParamStrSer;
begin
  WriteChPrefix;
  write(serout, ParamStr);
  SerCRLF;
end;


procedure WriteParamSer;
begin
  ParamToStr;
  WriteParamStrSer;
end;


procedure WriteParamIntSer;
begin
  IntToParamStr(ParamInt);
  WriteParamStrSer;
end;

procedure WriteParamByteSer;
begin
  ParamStr:= ByteToStr(ParamByte);
  WriteParamStrSer;
end;

procedure WriteParamLongSer;
begin
  ParamStr:= LongToStr(ParamLong);
  WriteParamStrSer;
end;

procedure WriteParamStrInBrackets(myParamByte:Byte);
begin
  WriteChPrefix;
  write(serout, ByteToStr(myParamByte)+' ['+ParamStr+']');
  SerCRLF;
end;

procedure WriteDirEntry;
//Directory-Eintrag FileNum ausgeben
begin
  SubCh:=240;
  ParamStr:=DirectoryArray[FileNum];
  WriteParamStrInBrackets(FileNum);
  Checkdelay(10);
end;


{###########################################################################}


function ButtonPressed:Boolean;
begin
  if LCDpresent then
    buttonTemp := (LCDportInp_M(LCD_m1) or %11000111);
  else
    buttonTemp := $FF;
  endif;
  if buttonTemp = $FF then
    return(false);
  else
    return(true);
  endif;
end;

procedure RunningMsg;
var mychar:char;
begin
  LEDactivity:= not LEDactivity;
end;

procedure RunningMsgOff;
var mychar:char;
begin
  LEDactivity:= high;
end;

procedure ParamStrOnLCD;
begin
  LCDxy_M(LCD_m1, 0, 0);
  write(lcdout_m,ParamStr);
  LCDclrEOL_m(LCD_m1);
end;

procedure ParamLongToHex;
//Longin in Hex-String wandeln
begin
  ParamStr:=LongToHex(ParamLong);
end;

procedure WriteByteOnLCD(my_byte: byte);
begin
  write(lcdout_m,byteToStr(my_byte:4));
end;

procedure SollWerteOnLCD;
{ Verwendet diese Tabelle zur Umsetzung Anzeige -> SubCh
  LCDtoSubChArr: array[0..41] of Integer = (
    240,                      // 0: Filesel
    8,                        // 1: Frequ
    10,11,12,13,14,15,16,17,  // 2..9: ADCs
    20,21,22,23,              // 10..13: DACs
    30,31,32,33,34,35,        // 14..19: Ports
    44,45,                    // 20..21 DDRs Bridge PCA9555A
    60,61,62,63,64,65,66,67,68,69,  // 22..41 DFPGA SPI lesen
    70,71,72,73,74,75,76,77,78,79
  );
}

begin
  if (not LCDpresent) then
    return;
  endif;
  if (not ChangedFlag) then
    return; // unverndert, nichts zu tun
  endif;
  case Modify of
    0:
      LCDcursor_m(LCD_m1, false, false);
      ParamStr:=ExtractFileName(DirectoryArray[FileNum]);
      ParamStrOnLCD;
      LCDxy_M(LCD_m1, 7, 0);
      lcdout_m(#0);
      LCDxy_M(LCD_m1, 0, 1);
      ParamStr:=ExtractFileExt(DirectoryArray[FileNum]);
      if length(ParamStr)=0 then
        ParamStr:='---';
      endif;
      write(lcdout_m,ParamStr+FileNumStr);
      |
    1:
      LCDxy_M(LCD_m1, 0, 1);
      write(lcdout_m,'Frequenz');
      GetNewValue(8);  // Frequenz
      ParamStrOnLCD;
      |
    2..9:
      LCDxy_M(LCD_m1, 0, 1);
      write(lcdout_m,'ADC ');
      WriteByteOnLCD(modify-2);
      SubChValueToPMstr(integer(modify+8));
      ParamStrOnLCD;
      |
    10..13:
      LCDxy_M(LCD_m1, 0, 1);
      write(lcdout_m,'DAC ');
      WriteByteOnLCD(modify-10);
      SubChValueToPMstr(integer(modify+10));
      ParamStrOnLCD;
      LCDxy_M(LCD_m1, 7, 0);
      lcdout_m(#0);
      |
    14..19:
      LCDxy_M(LCD_m1, 0, 1);
      write(lcdout_m,'PORT');
      WriteByteOnLCD(modify-14);
      SubChValueToPMstr(integer(modify+16));
      ParamStrOnLCD;
      |
    20..21:
      LCDxy_M(LCD_m1, 0, 1);
      write(lcdout_m,'PDIR');
      WriteByteOnLCD(modify-16);
      SubChValueToPMstr(integer(modify+24));
      ParamStrOnLCD;
      |
    22..41:
      LCDxy_M(LCD_m1, 0, 1);
      write(lcdout_m,'FPGA');
      WriteByteOnLCD(modify-22);
      GetNewValue(integer(modify + 38));  // SubCh 60..79
      ParamLongToHex;
      LCDxy_M(LCD_m1, 0, 0);
      write(lcdout_m,ParamStr);
      |
  endcase;
end;


{###########################################################################}

procedure DataWrite(myIndex:byte;isReg:boolean);
// schreibt Messwert aus Reg 0..9, Transfer(Sub)Ch und Zeitpunkt in Datei
var myfileName:String[12];
begin
  WriteErr:=true;
  if CardOK then
    myfileName:=DatFileName;
    if not F16_FileExist ('\', myfileName, faFilesOnly) then
      DateTimeToDOS;
      F16_FileAssign (DataFile, '',myfileName);
      F16_FileReWrite (DataFile,[faArchive],DOStime,DOSdate); // Datei erstellen
      if F16_CheckHandle(Datafile)<>faNone then
        Writeln(Datafile,HeaderStr);
      endif;
      DirectoryDone:=false;
    else
       F16_FileAssign (DataFile, '',myfileName);
       F16_FileAppend (DataFile); // Datei zum Schreiben/Anhngen ffnen
    endif;
    if F16_CheckHandle(Datafile)<>faNone then
      if isReg then
        Param:=RegisterArray[myIndex];
      endif;
      ParamToStr;
      Write(Datafile,ParamStr);
      ParamStr:=#9+ByteToStr(myIndex);
      Write(Datafile,ParamStr);
      GetRTC;
      TimeToParamStr;
      Write(Datafile,#9+ParamStr);
      DateToParamStr;
      WriteLn(Datafile,#9+ParamStr);
      WriteErr:=false;
    endif;
    F16_FileClose (Datafile);
  endif;
  NoCard:=not CardOK;
end;

procedure FileLoad(myLoadfileName:String[12]); forward;
procedure InitLoad(myINITfileName:String[12]); forward;

{$I UNIC-parser.pas}
{$I UNIC-files.pas}


{###########################################################################}


procedure Chores;
var my_shift, my_count: byte; my_int: Integer; my_long: LongInt;
// Regelmig nach Ablauf von DisplayTimer aufgerufen
begin
  if SD_CDSW and DirectoryDone then
    ClearDirectory;
  endif;
  if (not SD_CDSW) and (not DirectoryDone) then
    mdelay(100);
    GetDirectory;
  endif;
  if FPGA_lockout then
    return;
  endif;
  
// Feststellen ob FPGA vorhanden und ggf. Werte bermitteln
  ReceiveFPGA(0);
  if (FPGAreceiveLong3 = $AA) and (FPGAreceiveLong2 = $55) then
    FPGA_present := true;
    FPGA_readflags := FPGAreceiveLong0;   // von FPGA ab DACs/Relais
    FPGA_writeflags := FPGAreceiveLong1;  // von AVR ADCs ins FPGA

// Relais-Ports behandeln
    ReceiveFPGA(2); // 32 Relais-Bits einmal! holen
    if (FPGA_readflags and $0F) <> 0 then
      if (FPGA_readflags and 1) = 1 then
        PortArray[0]:= FPGAreceiveLong0;  // fr SR
      endif;
      if (FPGA_readflags and 2) = 2 then
        PortArray[1]:= FPGAreceiveLong1;  // fr SR
      endif;
      if (FPGA_readflags and 4) = 4 then
        PortArray[2]:= FPGAreceiveLong2;  // fr SR
      endif;
      if (FPGA_readflags and 8) = 8 then
        PortArray[3]:= FPGAreceiveLong3;  // fr SR
      endif;
      ShiftOutSR; // Relais-SR updaten
    endif;
    
// DACs setzen, falls vom FPGA gewnscht
// Wertebereich -10000 bis +10000 (Integer!)
    my_shift:= FPGA_readflags shr 4;
    for my_count:= 0 to 3 do
      if (my_shift and 1) = 1 then
        ReceiveFPGA(my_count + 4); // DAC-Sollwert holen
        ParamFrac:= LongInt(FPGAreceiveInt) * 10;
        SetDACfrac(my_count,ParamFrac);
      endif;
      my_shift:= my_shift shr 1;
    endfor;
// ADCs an FPGA: Wenn Bit gesetzt, ADC-Wert holen und in SPI-Register des FPGA schreiben
// Wertebereich -10000 bis +10000 (Integer!)
    my_shift:= FPGA_writeflags;
    for my_count:= 0 to 7 do
      if (my_shift and 1) = 1 then
        ReadADC(my_count); // liefert Messwert in Param
        ParamToParamFrac;
        ParamFrac:= ParamFrac div 10;
        SendLongToFPGA(ParamFrac, my_count+8);
      endif;
      my_shift:= my_shift shr 1;
    endfor;
  else
    FPGA_present := false;
    FPGA_readflags := 0;   // von FPGA ab DACs/Relais
    FPGA_writeflags := 0;  // von AVR ADCs ins FPGA
  endif;
end;

procedure CheckSer;
var
myChar: char;
begin
  if serStat then //
    myChar:=serInp;
    case myChar of
    #32..#127: // nur 7-Bit-ASCII ohne Controls
      append(myChar,SerInpStr);
      |
    #8: // Backspace
      setlength(SerInpStr, length(SerInpStr)-1);
      |
    #13:
      LEDactivity:=low; // LED aus
      FaultFlags:=0;
      ParseSubCh;               // Befehl interpretieren, wenn fr uns
      SerInpStr:='';
      |
    endcase;
  else
    Chores;
    if isSystimerZero(DisplayTimer) then
      LEDactivity:=high; // LED aus
    endif;
  endif;
end;

procedure CheckEncoder;
// Dreh-Encoder auswerten
begin
  EncValue:=GetIncrVal4(0);
  while EncValue > OldEncValue do
    inc(OldEncValue);
    inc(EncStep);
    if EncStep = EncRast then      // = EncRast
      EncStep:=0;
      inc(EncDiff);
      EncSema:=true;
    endif;
  endwhile;
  while EncValue < OldEncValue do
    dec(OldEncValue);
    dec(EncStep);
    if EncStep = -EncRast then     // -EncRast, 256 - 4
      EncStep:=0;
      dec(EncDiff);
      EncSema:=true;
    endif;
  endwhile;
end;

procedure CheckDelay(myDelay:byte);
// Delay mit serieller Abfrage in 1-ms-Schritten
var mycount:byte;
begin
  for mycount:=1 to mydelay do
    CheckSer;
    CheckEncoder;
  endfor;
end;


{###########################################################################}

procedure initall;
//nach Reset aufgerufen
begin
  DDRA:=  DDRAinit;            {PortA dir}
  PortA:= PortAinit;           {PortA}
  DDRB:=  DDRBinit;            {PortB dir}
  PortB:= PortBinit;           {PortB}
  DDRC:=  DDRCinit;            {PortC dir}
  PortC:= PortCinit;           {PortC}
  DDRD:=  DDRDinit;            {PortD dir}
  PortD:= PortDinit;           {PortD}

  IO16present:=TWIStat($21); // interner PCA9555 auf Bridge

//  SetFreqCountMode(TPulseBase100ms);
  SetFreqMeasureMode(2);  //  SetFreqCountMode(TFreqBase10kHz);

// SPI Control Register: SPIE SPE DORD MSTR CPOL CPHA SPR1 SPR0
  SPCR:= %01010001; // SPI enable, Master, MSB first, CPOL 0.0, fclk/16

// Ports initialisieren
  ENASHIFT:=low;
  for i:=0 to 7 do
    j:=InitDDRArray[i];
    SetDir(i,j);
    j:=InitPortArray[i];
    SetPort(i,j);
  endfor;
  ENASHIFT:=high;
  serBaud(word(EESerbaud));        // nur mit 644

//  ADMUX := ADMUX OR %11000000;  {Internal ADC Reference}
//  EIMSK := EIMSK or %00000100;  // external IRQ F_INT auf INT2
//  EICRA := EICRA or %00100000;  // Bit 4 und 5 = INT2 falling Edge

  if LCDsetup_M(LCD_m1) then
    LCDcursor_M(LCD_m1, false, false);
    LCDCharSet_M(LCD_m1, #0, $01, $03, $07, $0F, $07, $03, $01, $00); {"<" Cursor}
    LCDCharSet_M(LCD_m1, #1, $01, $03, $05, $09, $05, $03, $01, $00); {"<" Cursor hohl}
    LCDCharSet_M(LCD_m1, #2, $01, $02, $05, $0A, $05, $02, $01, $00); {"<" Cursor IncrValeinstellung}
    LCDCharSet_M(LCD_m1, #3, $15, $00, $11, $00, $11, $00, $15, $00); {Kstchen hohl}
    LCDpresent:= true;
    LCDxy_M(LCD_m1, 0, 0);
    write(LCDOut_M, versLCDstr);
    LCDxy_M(LCD_m1, 0, 1);
    write(LCDOut_M, 'cm@ct.de');
  endif;

  InitVars;       // Optionen-Defaults
  MainCh:=byte(EEMainCh);

  LEDactivity:= low;
  mdelay(1000);
  LEDactivity:= high;

{$IFDEF EXTRTC}
  GetExtRTC;
  SetRTC;
{$ENDIF}
  Status:=0;
  EnableInts;
  while serstat do
    i:=SerInp;
  endwhile;

  SubCh:=0;
  CurrentCh:=MainCh; //
  errcount:=0;
  ChangedFlag:=true;

  SubCh:=254;
  ParseGetParam;

  ClearDirectory;
  Chores; // Files ggf. laden

  IncrCount4start;
  SetIncrVal4(0,0);
  SetSystimer(DisplayTimer, 10);
  Modify:=0;
  MenuSelect:=select;
  GetDirectory;
  if CardOK and (EEinitFileName<>'') then
    FileLoad(EEinitFileName);
    if FaultFlags<>0 then
      FileNum:=0;
      serprompt(FileErr);
    else
      WriteDirEntry;
    endif;
  endif;
  PA4:= high;
  PA5:= high;
end;

{###########################################################################}


begin
  Initall;
//Hauptschleife
  loop
    if LCDpresent then
      if EncSema then
        LEDactivity:=low;
        ChangedFlag:=true;
        BusyFlag:=true;
        
// hier nur File-Auswahl
        if modify = 0 then //    filesel:
          FileNum:=FileNum+byte(EncDiff);
          CheckLimits;
        endif;

        if modify in [10..13] then // DAC-Werte mit Rundung
          SetDACfrac(modify-10, FracRound1000(DACvalues[modify-10] + (LongInt(EncDiff)*1000)));
        endif;

        EncDiff:=0; // fr nchsten Durchlauf
        EncSema:=false;
        SollwerteOnLCD;
      endif;

      Checkdelay(40); // wichtig fr Beschleunigungsfunktion

      ButtonFlag:=ButtonPressed;
      if ButtonFlag then
        Checkdelay(10);
        if ButtonPressed then
          ChangedFlag:=true;
          BusyFlag:=true;
          if (not ButtonEnter) then
            ButtonNumber:=3; // Button Enter/Fine
            repeat
              Checkdelay(10);
            until (not ButtonPressed);
            if Modify=0 then
              LEDactivity:=low;
              if CardOK then
                FileLoad(DirectoryArray[FileNum]);
              endif;
            endif;
          endif;
          if not ButtonUp then
            ButtonNumber:=2; // Button Up
            inc(Modify);
            SollwerteOnLCD;
          endif;
          if not ButtonDown then
            ButtonNumber:=1; // Button Down
            dec(Modify);
            SollwerteOnLCD;
          endif;
          repeat
            Checkdelay(10);
          until (not ButtonPressed) or isSystimerZero(ButtonTimer);
          CheckLimits;
        endif;
      endif;
    endif;
    if ButtonFlag then
      SetSystimer(ButtonTimer, 25); // Autorepeat
    else
      SetSystimer(ButtonTimer, 60);
    endif;
    if isSystimerZero(DisplayTimer) and LCDpresent then
      SetSystimer(DisplayTimer, 25);
      BusyFlag:=false;
      SollwerteOnLCD;
//      ChangedFlag:=false;
    endif;

    Checkdelay(1);
  endloop;
end UNIC.

