--------------------------------------------------------------------------------
-- Copyright (c) 1995-2011 Xilinx, Inc.  All rights reserved.
--------------------------------------------------------------------------------
--   ____  ____ 
--  /   /\/   / 
-- /___/  \  /    Vendor: Xilinx 
-- \   \   \/     Version : 13.1
--  \   \         Application : sch2hdl
--  /   /         Filename : pwm.vhf
-- /___/   /\     Timestamp : 11/11/2011 17:17:29
-- \   \  /  \ 
--  \___\/\___\ 
--
--Command: sch2hdl -intstyle ise -family spartan3a -flat -suppress -vhdl E:/Dropbox/UNIC_3A/pwm/pwm.vhf -w E:/Dropbox/UNIC_3A/pwm/source/pwm.sch
--Design Name: pwm
--Device: spartan3a
--Purpose:
--    This vhdl netlist is translated from an ECS schematic. It can be 
--    synthesized and simulated, but it should not be modified. 
--

library ieee;
use ieee.std_logic_1164.ALL;
use ieee.numeric_std.ALL;
library UNISIM;
use UNISIM.Vcomponents.ALL;

entity pwm is
   port ( CLK_50MHZ : in    std_logic; 
          F_DS      : in    std_logic; 
          F_MOSI    : in    std_logic; 
          F_RS      : in    std_logic; 
          F_SCK     : in    std_logic; 
          AUXPORT   : out   std_logic_vector (15 downto 0); 
          F_MISO    : out   std_logic; 
          TestLED   : out   std_logic);
end pwm;

architecture BEHAVIORAL of pwm is
   attribute BOX_TYPE         : string ;
   attribute IOSTANDARD       : string ;
   attribute IBUF_DELAY_VALUE : string ;
   signal auxport_ub : std_logic_vector (15 downto 0);
   signal FROM_ADC0  : std_logic_vector (15 downto 0);
   signal FROM_ADC1  : std_logic_vector (15 downto 0);
   signal FROM_PORT  : std_logic_vector (31 downto 0);
   signal RELAIS     : std_logic_vector (31 downto 0);
   signal TO_DAC0    : std_logic_vector (15 downto 0);
   signal TO_DAC1    : std_logic_vector (15 downto 0);
   signal TO_DAC2    : std_logic_vector (15 downto 0);
   signal TO_DAC3    : std_logic_vector (15 downto 0);
   signal TO_PORT    : std_logic_vector (31 downto 0);
   signal XLXN_759   : std_logic_vector (31 downto 0);
   signal XLXN_765   : std_logic_vector (31 downto 0);
   signal XLXN_771   : std_logic_vector (3 downto 0);
   signal XLXN_773   : std_logic;
   signal XLXN_844   : std_logic;
   signal XLXN_859   : std_logic_vector (31 downto 0);
   signal XLXN_860   : std_logic_vector (31 downto 0);
   component BUF
      port ( I : in    std_logic; 
             O : out   std_logic);
   end component;
   attribute BOX_TYPE of BUF : component is "BLACK_BOX";
   
   component IBUFG
      port ( I : in    std_logic; 
             O : out   std_logic);
   end component;
   attribute IOSTANDARD of IBUFG : component is "DEFAULT";
   attribute IBUF_DELAY_VALUE of IBUFG : component is "0";
   attribute BOX_TYPE of IBUFG : component is "BLACK_BOX";
   
   component Timer
      port ( CLK       : in    std_logic; 
             CLK_TIMER : in    std_logic; 
             D_H       : in    std_logic_vector (31 downto 0); 
             D_L       : in    std_logic_vector (31 downto 0); 
             PULSE_OUT : out   std_logic);
   end component;
   
   component SPI_inout
      port ( SYSCLK : in    std_logic; 
             SCK    : in    std_logic; 
             MOSI   : in    std_logic; 
             DS_N   : in    std_logic; 
             RS_N   : in    std_logic; 
             ADDR   : in    std_logic_vector (3 downto 0); 
             D0     : in    std_logic_vector (31 downto 0); 
             D1     : in    std_logic_vector (31 downto 0); 
             D2     : in    std_logic_vector (31 downto 0); 
             D3     : in    std_logic_vector (31 downto 0); 
             D4     : in    std_logic_vector (15 downto 0); 
             D5     : in    std_logic_vector (15 downto 0); 
             D6     : in    std_logic_vector (15 downto 0); 
             D7     : in    std_logic_vector (15 downto 0); 
             STR0   : out   std_logic; 
             STR1   : out   std_logic; 
             STR2   : out   std_logic; 
             STR3   : out   std_logic; 
             MISO   : out   std_logic; 
             Q8     : out   std_logic_vector (15 downto 0); 
             Q9     : out   std_logic_vector (15 downto 0); 
             Q10    : out   std_logic_vector (15 downto 0); 
             Q11    : out   std_logic_vector (15 downto 0); 
             Q12    : out   std_logic_vector (15 downto 0); 
             Q13    : out   std_logic_vector (15 downto 0); 
             Q14    : out   std_logic_vector (15 downto 0); 
             Q15    : out   std_logic_vector (15 downto 0); 
             Q0     : out   std_logic_vector (31 downto 0); 
             Q1     : out   std_logic_vector (31 downto 0); 
             Q2     : out   std_logic_vector (31 downto 0); 
             Q3     : out   std_logic_vector (31 downto 0));
   end component;
   
   component ledpwm
      port ( SYSCLK : in    std_logic; 
             PWM    : in    std_logic_vector (7 downto 0); 
             LED    : out   std_logic);
   end component;
   
begin
   TO_DAC1(15 downto 0) <= x"1388";
   XLXN_759(31 downto 0) <= x"09112011";
   XLXN_765(31 downto 0) <= x"AA550330";
   XLXN_771(3 downto 0) <= x"0";
   XLXI_186 : BUF
      port map (I=>XLXN_844,
                O=>TestLED);
   
   XLXI_275 : IBUFG
      port map (I=>CLK_50MHZ,
                O=>XLXN_773);
   
   XLXI_321 : Timer
      port map (CLK=>XLXN_773,
                CLK_TIMER=>XLXN_773,
                D_H(31 downto 0)=>XLXN_859(31 downto 0),
                D_L(31 downto 0)=>XLXN_860(31 downto 0),
                PULSE_OUT=>auxport_ub(0));
   
   XLXI_322 : SPI_inout
      port map (ADDR(3 downto 0)=>XLXN_771(3 downto 0),
                DS_N=>F_DS,
                D0(31 downto 0)=>XLXN_765(31 downto 0),
                D1(31 downto 0)=>XLXN_759(31 downto 0),
                D2(31 downto 0)=>RELAIS(31 downto 0),
                D3(31 downto 0)=>TO_PORT(31 downto 0),
                D4(15 downto 0)=>TO_DAC0(15 downto 0),
                D5(15 downto 0)=>TO_DAC1(15 downto 0),
                D6(15 downto 0)=>TO_DAC2(15 downto 0),
                D7(15 downto 0)=>TO_DAC3(15 downto 0),
                MOSI=>F_MOSI,
                RS_N=>F_RS,
                SCK=>F_SCK,
                SYSCLK=>XLXN_773,
                MISO=>F_MISO,
                Q0(31 downto 0)=>XLXN_859(31 downto 0),
                Q1(31 downto 0)=>XLXN_860(31 downto 0),
                Q2=>open,
                Q3(31 downto 0)=>FROM_PORT(31 downto 0),
                Q8(15 downto 0)=>FROM_ADC0(15 downto 0),
                Q9(15 downto 0)=>FROM_ADC1(15 downto 0),
                Q10=>open,
                Q11=>open,
                Q12=>open,
                Q13=>open,
                Q14=>open,
                Q15=>open,
                STR0=>open,
                STR1=>open,
                STR2=>open,
                STR3=>open);
   
   XLXI_328 : ledpwm
      port map (PWM(7 downto 0)=>FROM_ADC0(13 downto 6),
                SYSCLK=>XLXN_773,
                LED=>XLXN_844);
   
   XLXI_331_0 : BUF
      port map (I=>auxport_ub(0),
                O=>AUXPORT(0));
   
   XLXI_331_1 : BUF
      port map (I=>auxport_ub(1),
                O=>AUXPORT(1));
   
   XLXI_331_2 : BUF
      port map (I=>auxport_ub(2),
                O=>AUXPORT(2));
   
   XLXI_331_3 : BUF
      port map (I=>auxport_ub(3),
                O=>AUXPORT(3));
   
   XLXI_331_4 : BUF
      port map (I=>auxport_ub(4),
                O=>AUXPORT(4));
   
   XLXI_331_5 : BUF
      port map (I=>auxport_ub(5),
                O=>AUXPORT(5));
   
   XLXI_331_6 : BUF
      port map (I=>auxport_ub(6),
                O=>AUXPORT(6));
   
   XLXI_331_7 : BUF
      port map (I=>auxport_ub(7),
                O=>AUXPORT(7));
   
   XLXI_331_8 : BUF
      port map (I=>auxport_ub(8),
                O=>AUXPORT(8));
   
   XLXI_331_9 : BUF
      port map (I=>auxport_ub(9),
                O=>AUXPORT(9));
   
   XLXI_331_10 : BUF
      port map (I=>auxport_ub(10),
                O=>AUXPORT(10));
   
   XLXI_331_11 : BUF
      port map (I=>auxport_ub(11),
                O=>AUXPORT(11));
   
   XLXI_331_12 : BUF
      port map (I=>auxport_ub(12),
                O=>AUXPORT(12));
   
   XLXI_331_13 : BUF
      port map (I=>auxport_ub(13),
                O=>AUXPORT(13));
   
   XLXI_331_14 : BUF
      port map (I=>auxport_ub(14),
                O=>AUXPORT(14));
   
   XLXI_331_15 : BUF
      port map (I=>auxport_ub(15),
                O=>AUXPORT(15));
   
   XLXI_336_0 : BUF
      port map (I=>FROM_ADC0(0),
                O=>TO_DAC0(0));
   
   XLXI_336_1 : BUF
      port map (I=>FROM_ADC0(1),
                O=>TO_DAC0(1));
   
   XLXI_336_2 : BUF
      port map (I=>FROM_ADC0(2),
                O=>TO_DAC0(2));
   
   XLXI_336_3 : BUF
      port map (I=>FROM_ADC0(3),
                O=>TO_DAC0(3));
   
   XLXI_336_4 : BUF
      port map (I=>FROM_ADC0(4),
                O=>TO_DAC0(4));
   
   XLXI_336_5 : BUF
      port map (I=>FROM_ADC0(5),
                O=>TO_DAC0(5));
   
   XLXI_336_6 : BUF
      port map (I=>FROM_ADC0(6),
                O=>TO_DAC0(6));
   
   XLXI_336_7 : BUF
      port map (I=>FROM_ADC0(7),
                O=>TO_DAC0(7));
   
   XLXI_336_8 : BUF
      port map (I=>FROM_ADC0(8),
                O=>TO_DAC0(8));
   
   XLXI_336_9 : BUF
      port map (I=>FROM_ADC0(9),
                O=>TO_DAC0(9));
   
   XLXI_336_10 : BUF
      port map (I=>FROM_ADC0(10),
                O=>TO_DAC0(10));
   
   XLXI_336_11 : BUF
      port map (I=>FROM_ADC0(11),
                O=>TO_DAC0(11));
   
   XLXI_336_12 : BUF
      port map (I=>FROM_ADC0(12),
                O=>TO_DAC0(12));
   
   XLXI_336_13 : BUF
      port map (I=>FROM_ADC0(13),
                O=>TO_DAC0(13));
   
   XLXI_336_14 : BUF
      port map (I=>FROM_ADC0(14),
                O=>TO_DAC0(14));
   
   XLXI_336_15 : BUF
      port map (I=>FROM_ADC0(15),
                O=>TO_DAC0(15));
   
end BEHAVIORAL;


