{###########################################################################}
// UNIC-Version!
// je nach MainChInternFlag entweder auf OptoBus oder FPGA-CoreTx

procedure SPIbytetransfer;
//Sende und empfange ein Daten-Byte an den UNIC-Chip ber SPI
begin
  asm;
//    sbi  UNIC.ControlBitPort, UNIC.b_slavesel; SLAVESEL, immer benutzter Testport fr LA
    lds  _ACCA, UNIC.SPIsendbyte
    out SPDR, _ACCA    ; SPI wurde von FAT16-Treiber eingeschaltet!
  SPIwait8_1:
    in _ACCA, SPSR
    sbrs _ACCA,7
    rjmp SPIwait8_1; Warte bis gesendet und empfangen
    in _ACCA, SPDR
    sts  UNIC.SPIreceivebyte, _ACCA  ; Lesewert zurck ins Datenbyte
//    cbi  UNIC.ControlBitPort, UNIC.b_slavesel
  endasm;
end;



procedure ShiftOutDAC(DACraw:Integer; DACchannel:byte; HalfGain,InvPolarity:Boolean);
//Sende DACraw an MCP4822
var DACctrl: byte;
begin
  if ((DACchannel and $01) = 1) then // Kanal B wenn 1 oder 3
    DACctrl:=%10010000;
  else
    DACctrl:=%00010000;
  endif;
  if HalfGain then
    DACctrl := DACctrl or %00100000;
  endif;

// SPI Control Register: SPIE SPE DORD MSTR CPOL CPHA SPR1 SPR0
  SPCR:= %01010000; // SPI enable, Master, MSB first, CPOL 0.0, fclk/4
  if DACchannel > 1 then
    STRDAC1:=low;
  else
    STRDAC0:=low;
  endif;
  SPIsendbyte:=(hi(DACraw) and $0F) or DACctrl;
  SPIbytetransfer;
  SPIsendbyte:=lo(DACraw);
  SPIbytetransfer;
  STRDAC0:=high;
  STRDAC1:=high;
  nop; nop;
  STRDACLOAD:= low;
  nop; nop;
  STRDACLOAD:= high;
  udelay(1);
  case DACchannel  of
    0:
      INVERT0:=InvPolarity;
    |
    1:
      INVERT1:=InvPolarity;
    |
    2:
      INVERT2:=InvPolarity;
    |
    3:
      INVERT3:=InvPolarity;
    |
  endcase;
  SPCR:= %01011100; // SPI enable, Master, MSB first, CPOL 1.1, fclk/4
end;


function ShiftInADC(ADCchannel:byte):Integer;
//Sende Channel an MCP3208, erhalte Raw-Wert
//Achtung: kehrt Reihenfolge 0..7 um wg. Layout
var myCh, myCtrl: byte;
begin
  myCh:=7-ADCchannel;      // Reihenfolge umkehren!
  if ((myCh and $04) = 4) then
    myCtrl:=%00000111;
  else
    myCtrl:=%00000110;
  endif;
// SPI Control Register: SPIE SPE DORD MSTR CPOL CPHA SPR1 SPR0
  SPCR:= %01010001; // SPI enable, Master, MSB first, CPOL 0.0, fclk/16
  STRADC:=low;
  SPIsendbyte:=myCtrl;
  SPIbytetransfer;
  SPIsendbyte:=myCh shl 6;
  SPIbytetransfer;
  TempW_high:=SPIreceivebyte and $0f;
  SPIsendbyte:=0;
  SPIbytetransfer;
  TempW_low:=SPIreceivebyte;
  nop;
  STRADC:=high;
  SPCR:= %01011100; // SPI enable, Master, MSB first, CPOL 1.1, fclk/4
  return(TempI);
end;

{###########################################################################}

procedure ReadADC(myADC:byte);    // liefert Param!
var ADCtemp:Integer;
begin
{
      if IntegrateADC then
        ADCtemp:=ShiftInADC(myIndex);
        ADCtemp:=ADCtemp+ShiftInADC(myIndex);
        ADCtemp:=ADCtemp+ShiftInADC(myIndex);
        ADCtemp:=ADCtemp+ShiftInADC(myIndex);
        ADCtemp:=ADCtemp shr 2;
      else
      endif;
      }
   ADCtemp:=ShiftInADC(myADC);
   ADCrawArray[myADC]:=ADCtemp;
   ADCtemp:=ADCtemp+ADCoffsets[myADC];
   Param:=Float(ADCtemp)*ADCscales[myADC]*ADCbaseScale; //FS/2 Grundskalierung 12 Bit
end;

procedure SetDACfrac(myDAC:Byte;myFrac:LongInt);  // 4 DACs setzen
var
myOffset,myIntVal:Integer;
myInvert,mybool: Boolean;
myIndex:Byte;
myScale:LongInt;

begin
  DACValues[myDAC]:=myFrac;
  if myDAC < 4 then
    myIndex:=myDAC;
    if myFrac < 0 then  // Skalierung und Offset fr negative Ausgangsspannung
      myIndex:=myIndex+4;
    endif;
    myOffset:=DACoffsets[myIndex];
    myScale:=DACScales[myIndex];
// Grundskalierung Eingangswert -10V .. + 10V fr MCP4822
    myIntVal:= integer(myFrac*myScale div DACbaseScale)+myOffset;
    if myIntVal>4095 then
      myIntVal:=4095;
    endif;
    if myIntVal<-4095 then
      myIntVal:=-4095;
    endif;
    myInvert:=not(sign(myIntVal));
// Nulldurchgang? Dann vor dem Polarittswechsel Nullwert ausgeben
    if sign(DACrawArray[myDAC]) = myInvert then  // mit letztem Wert vergleichen
      ShiftOutDAC(0,myDAC,false,myInvert);       // Raw-Wert, Channel, HalfGain, Invert
    endif;
    ShiftOutDAC(abs(myIntVal),myDAC,false,myInvert);   // Raw-Wert, Channel, HalfGain, Invert
    DACrawArray[myDAC]:= myIntVal;
  endif;
end;

{###########################################################################}

procedure RTCtickSecond;      // CallBack from RTCclock
begin
  tickSeconds:=true;
  if INITfileIsOpen then
    LEDactivity:= not LEDactivity;
  endif;
end;

procedure RTCtickMinute;      // CallBack from RTCclock
begin
  tickMinutes:=true;
end;

procedure RTCtickHour;        // CallBack from RTCclock
begin
  tickHours:=true;
end;

{$IFDEF EXTRTC}
procedure ShiftRTCout;  // fr externe RTC DS1302 oder HT1381 an PortB
var SPItemp:byte;
begin
  SPCR:=0; // SPI abklemmen
  asm;
    cbi  PortB, UNIC.b_RTCclk
    sbi  PortA, UNIC.a_RTCrst

    lds  _ACCA, UNIC.RTCcmd
    lsl  _ACCA        // wg. RW-Bit
    andi  _ACCA,$FE   // RW-Bit auf 0
    ori  _ACCA,$80    // MSB auf 1
    ldi  _ACCB, 8

    UNIC.cmdloop1:    ; Cmd-Byte rausschieben
    sbrs _ACCA,0 // Bit low?
    cbi  PortB, UNIC.b_RTCio
    sbrc _ACCA,0 // Bit high?
    sbi  PortB, UNIC.b_RTCio
    sbi  PortB, UNIC.b_RTCclk
    lsr  _ACCA
    nop
    nop
    cbi  PortB, UNIC.b_RTCclk
    dec _ACCB
    brne  UNIC.cmdloop1

    lds  _ACCA, UNIC.RTCdata
    ldi  _ACCB, 8

    UNIC.dataloop1:    ; Data-Byte rausschieben
    sbrs _ACCA,0 // Bit low?
    cbi  PortB, UNIC.b_RTCio
    sbrc _ACCA,0 // Bit high?
    sbi  PortB, UNIC.b_RTCio
    sbi  PortB, UNIC.b_RTCclk
    lsr  _ACCA
    nop
    nop
    cbi  PortB, UNIC.b_RTCclk
    dec  _ACCB
    brne UNIC.dataloop1

    cbi  PortA, UNIC.a_RTCrst
  endasm;
  SPCR:= %01011100; // SPI enable, Master, MSB first, CPOL 1.1, fclk/4
end;

procedure ShiftRTCin;  // fr externe RTC DS1302 oder HT1381
var SPItemp:byte;
begin
  SPCR:=0; // SPI abklemmen
  asm;
    cbi  PortB, UNIC.b_RTCclk
    sbi  PortA, UNIC.a_RTCrst
    lds  _ACCA, UNIC.RTCcmd
    lsl  _ACCA        // wg. RW-Bit Adresse eins nach links
    ori  _ACCA,$81    // MSB auf 1
    ldi  _ACCB, 8
    UNIC.cmdloop2:    ; Cmd-Byte rausschieben
    sbrs _ACCA,0 // Bit low?
    cbi  PortB, UNIC.b_RTCio
    sbrc _ACCA,0 // Bit high?
    sbi  PortB, UNIC.b_RTCio
    sbi  PortB, UNIC.b_RTCclk
    lsr  _ACCA
    nop
    nop
    cbi  PortB, UNIC.b_RTCclk
    dec _ACCB
    brne  UNIC.cmdloop2
  endasm;
  DDRB:=DDRBinitRdRTC;       {PortB dir}
  asm;
    ldi  _ACCB, 7
    UNIC.dataloop2:    ; Data-Byte reinschieben
    clc
    sbic PinB, UNIC.b_RTCio // Bit gesetzt?
    sec
    sbi  PortB, UNIC.b_RTCclk
    nop
    nop
    ror _ACCA  // Carry-Bit einschieben
    cbi  PortB, UNIC.b_RTCclk
    dec _ACCB
    brne  UNIC.dataloop2
    cbi  PortA, UNIC.a_RTCrst
    lsr _ACCA
    sts UNIC.RTCdata,_ACCA ; Daten-Byte
  endasm;
  DDRB:=DDRBinit;       {PortB dir}
  PortB:=PortBinit;           {PortB}
  SPCR:= %01011100; // SPI enable, Master, MSB first, CPOL 1.1, fclk/4
end;

procedure GetExtRTC;
begin
  RTCcmd:=2;
  ShiftRTCin;
  Hour:=BCDtoByte(RTCdata);
  RTCcmd:=1;
  ShiftRTCin;
  Minute:=BCDtoByte(RTCdata);
  RTCcmd:=0;
  ShiftRTCin;
  Second:=BCDtoByte(RTCdata);
  RTCcmd:=3;
  ShiftRTCin;
  Day:=BCDtoByte(RTCdata);
  RTCcmd:=4;
  ShiftRTCin;
  Month:=BCDtoByte(RTCdata);
  RTCcmd:=6;
  ShiftRTCin;
  Year:=BCDtoByte(RTCdata);
end;

procedure SetExtRTC;
begin
  RTCcmd:=7;
  RTCdata:=0;
  ShiftRTCout;
  RTCcmd:=2;
  RTCdata:=ByteToBCD(Hour);
  ShiftRTCout;
  RTCcmd:=1;
  RTCdata:=ByteToBCD(Minute);
  ShiftRTCout;
  RTCcmd:=0;
  RTCdata:=ByteToBCD(Second);
  ShiftRTCout;
  RTCcmd:=3;
  RTCdata:=ByteToBCD(Day);
  ShiftRTCout;
  RTCcmd:=4;
  RTCdata:=ByteToBCD(Month);
  ShiftRTCout;
  RTCcmd:=6;
  RTCdata:=ByteToBCD(Year);
  ShiftRTCout;
  RTCcmd:=7;
  RTCdata:=128;
  ShiftRTCout;
end;
{$ENDIF}

procedure GetRTC;
begin
  disableints;
  Hour:=RTCgethour;
  Minute:=RTCgetminute;
  Second:=RTCgetsecond;
  Day:=RTCgetday;
  Month:=RTCgetmonth;
  Year:=RTCgetyear;
  enableints;
end;

procedure SetRTC;
begin
  disableints;
  RTCsethour(Hour);
  RTCsetminute(Minute);
  RTCsetsecond(Second);
  RTCsetday(Day);
  RTCsetmonth(Month);
  RTCsetyear(Year);
  enableints;
{$IFDEF EXTRTC}
  SetExtRTC;
{$ENDIF}
end;

procedure DateTimeToDOS;
{ DOS time format bits:
DOStime: 15..11=Hours (0-23), 10..5=Minutes (0-59), 4..0=Seconds/2 (0-29)
DOSdate: 15..9=Year (0=1980, 127=2107), 8..5=Month (1=January, 12=December),
4..0=Day (1-31) }
begin
  GetRTC;
  DOStime:=(word(Hour) shl 11) or (word(Minute) shl 5) or (word(Second) shr 1);
  DOSdate:=(word(Year+20) shl 9) or (word(Month) shl 5) or (word(Day));
end;

procedure TimeToParamStr;
begin
  ParamStr:=byteToStr(Hour:2:'0')+':'+byteToStr(Minute:2:'0')+':'+byteToStr(Second:2:'0');
end;

procedure DateToParamStr;
begin
  ParamStr:=byteToStr(Day:2:'0')+'.'+byteToStr(Month:2:'0')+'.'+byteToStr(Year:2:'0');
end;

{###########################################################################}

procedure ShiftOutSR;
//Sende PortArray-Bytes an 4094-SR

begin
// SPI Control Register: SPIE SPE DORD MSTR CPOL CPHA SPR1 SPR0
  SPCR:= %01010001; // SPI enable, Master, MSB first, CPOL 0.0, fclk/16
  STRSHIFT:= low;
  SPIsendbyte:=PortSR3;
  SPIbytetransfer;
  SPIsendbyte:=PortSR2;
  SPIbytetransfer;
  SPIsendbyte:=PortSR1;
  SPIbytetransfer;
  SPIsendbyte:=PortSR0;
  SPIbytetransfer;
  STRSHIFT:= high;
  nop; nop; nop; nop;
  STRSHIFT:= low;
  SPCR:= %01011100; // SPI enable, Master, MSB first, CPOL 1.1, fclk/4
end;


function GetPort(myPort:byte): byte; //IO-Pin-Register setzen
var my_bits: byte;
begin
  my_bits:= PortArray[myPort];
  if IO16present then
// Button-Zustand lesen
    case myport of
      4:
        TWIout($21, $00);
        TWIinp($21, my_bits);
        |
      5:
        TWIout($21, $01);
        TWIinp($21, my_bits);
        |
    endcase;
  endif;
  return(my_bits);
end;

procedure SetPort(myPort,myVal:byte); //IO-Port-Register lt. SubCh setzen
begin
  PortArray[myPort]:= myVal;  // fr SR
  if myPort < 4 then
    ShiftOutSR;
  else
    if IO16present then
      case myport of
        4:
          TWIout($21,$02,myVal);    // OUT0
          |
        5:
          TWIout($21,$03,myVal);    // OUT1
          |
      endcase;
    endif;
  endif;
end;

procedure SetDir(myPort,myVal:byte); //IO-Pin-Directions
begin
  DDRArray[myPort]:=myVal;
  ParamTemp:= not(myVal);
  if IO16present then
    case myport of
      4:
        TWIout($21,$06,ParamTemp);    // DDRs
        ParamTemp:= 0;
        TWIout($21,$04,ParamTemp);    // XORs low
        |
      5:
        TWIout($21,$07,ParamTemp);    // DDRs
        ParamTemp:= 0;
        TWIout($21,$05,ParamTemp);    // XORs low
        |
    endcase;
  endif;
end;


{###########################################################################}


