
{###########################################################################}

{FPGA functions }

procedure SendFPGA8;
//Sende und empfange ein Daten-Byte an den FPGA-Chip ber SPI
begin
  SPCR:= %01011100; // SPI enable, Master, MSB first, CPOL 1.1, fclk/4
  asm;
    lds  _ACCA, UNIC.FPGAsendByte
    cbi  UNIC.ConFPGABitPort, UNIC.a_DATASEL
    out SPDR, _ACCA    ; SPI wurde von FAT16-Treiber eingeschaltet!
  fpga_wait8_1:
    in _ACCA, SPSR
    sbrs _ACCA,7
    rjmp fpga_wait8_1
    in _ACCA, SPDR
    sts  UNIC.FPGAreceiveByte, _ACCA  ;Lesewert zurck ins Datenbyte
    sbi  UNIC.ConFPGABitPort, UNIC.a_DATASEL
  endasm;
end;

procedure SendFPGA16;
//Sende und empfange ein Daten-Wort (16 Bit-Register) an den FPGA-Chip ber SPI
begin
  SPCR:= %01011100; // SPI enable, Master, MSB first, CPOL 1.0, fclk/4
  asm;
    lds  _ACCA, UNIC.FPGAsendWord+1
    cbi  UNIC.ConFPGABitPort, UNIC.a_DATASEL
    out SPDR, _ACCA    ; SPI wurde von FAT16-Treiber eingeschaltet!
  fpga_wait16_3:
    in _ACCA, SPSR
    sbrs _ACCA,7
    rjmp fpga_wait16_3
    in _ACCA, SPDR
    sts  UNIC.FPGAreceiveWord+1, _ACCA

    lds  _ACCA, UNIC.FPGAsendWord+0
    out SPDR, _ACCA
  fpga_wait16_4:
    in _ACCA, SPSR
    sbrs _ACCA,7
    rjmp fpga_wait16_4
    in _ACCA, SPDR
    sts  UNIC.FPGAreceiveWord+0, _ACCA

    sbi  UNIC.ConFPGABitPort, UNIC.a_DATASEL
  endasm;
end;

procedure SendFPGA32;
//Sende und empfange ein Daten-Langwort (32 Bit-Register) an den FPGA-Chip ber SPI
begin
  SPCR:= %01011100; // SPI enable, Master, MSB first, CPOL 1.1, fclk/4
  asm;
    lds  _ACCA, UNIC.FPGAsendLong+3
    cbi  UNIC.ConFPGABitPort, UNIC.a_DATASEL
    out SPDR, _ACCA    ; SPI wurde von FAT16-Treiber eingeschaltet!
  fpga_wait32_1:
    in _ACCA, SPSR
    sbrs _ACCA,7       ; SPIF gesetzt?
    rjmp fpga_wait32_1   ; auf Ende des SPI-Transfer warten
    in _ACCA, SPDR     ; und empfangenes Byte wieder in FPGAsendLong ablegen
    sts  UNIC.FPGAreceiveLong+3, _ACCA

    lds  _ACCA, UNIC.FPGAsendLong+2
    out SPDR, _ACCA     ; SPI von FAT16-Treiber eingeschaltet!
  fpga_wait32_2:
    in _ACCA, SPSR
    sbrs _ACCA,7
    rjmp fpga_wait32_2
    in _ACCA, SPDR
    sts  UNIC.FPGAreceiveLong+2, _ACCA

    lds  _ACCA, UNIC.FPGAsendLong+1
    out SPDR, _ACCA
  fpga_wait32_3:
    in _ACCA, SPSR
    sbrs _ACCA,7
    rjmp fpga_wait32_3
    in _ACCA, SPDR
    sts  UNIC.FPGAreceiveLong+1, _ACCA

    lds  _ACCA, UNIC.FPGAsendLong+0
    out SPDR, _ACCA
  fpga_wait32_4:
    in _ACCA, SPSR
    sbrs _ACCA,7
    rjmp fpga_wait32_4
    in _ACCA, SPDR
    sts  UNIC.FPGAreceiveLong+0, _ACCA

    sbi  UNIC.ConFPGABitPort, UNIC.a_DATASEL
  endasm;
end;


procedure SendFPGAreg;
//Sende ein Byte (Registeradresse) an den FPGA-Chip
begin
  SPCR:= %01011100; // SPI enable, Master, MSB first, CPOL 1.1, fclk/4
  asm;
    lds  _ACCA, UNIC.FPGAreg+1  ; Adresse Word MSB
    cbi  UNIC.ConFPGABitPort, UNIC.a_REGSEL
    out SPDR, _ACCA     ; SPI von FAT16-Treiber eingeschaltet!
  SPIwaitReg_1:
    in _ACCA, SPSR
    sbrs _ACCA,7 ; SPIF?
    rjmp SPIwaitReg_1     ;  auf Ende des SPI-Transfer warten

    lds  _ACCA, UNIC.FPGAreg  ; Adresse Word LSB
    out SPDR, _ACCA     ; SPI von FAT16-Treiber eingeschaltet!
  SPIwaitReg_2:
    in _ACCA, SPSR
    sbrs _ACCA,7 ; SPIF?
    rjmp SPIwaitReg_2     ;  auf Ende des SPI-Transfer warten

    sbi  UNIC.ConFPGABitPort, UNIC.a_REGSEL
  endasm;
end;


procedure ShiftFPGAconf;  //Sende ein Byte an FPGA-Configuration
begin
  asm;
    lds  _ACCA, UNIC.FPGAbyte
    ldi  _ACCB, 8
    UNIC.confloop1:    ; hherwertiges Byte rausschieben
    cbi  UNIC.ConFPGABitPort, UNIC.a_DATA
    sbrc _ACCA,7 // Bit high?
    sbi  UNIC.ConFPGABitPort, UNIC.a_DATA
    sbi  UNIC.ConFPGABitPort, UNIC.a_CCLK
    LSL  _ACCA
    cbi  UNIC.ConFPGABitPort, UNIC.a_CCLK
    dec _ACCB
    brne  UNIC.confloop1
  endasm;
end;


procedure ShiftFPGAconfblock;  //Sende einen Block an FPGA-Configuration
begin
  asm;
    LDI       _ACCCLO, UNIC.BlockTable AND 0FFh  ;Z-Register
    LDI       _ACCCHI, UNIC.BlockTable SHRB 8

    UNIC.shiftFPGAbyte:
   ; Z-Pointer auf Array-Eintrag
    ld   _ACCA, Z
    cbi  UNIC.ConFPGABitPort, UNIC.a_CCLK
    in   _ACCB, UNIC.ConFPGABitPort
   ; schleifenloses, auf Schnelligkeit optimiertes Ausschieben eines Bytes
   ; DATA  __--__--__
   ; CCLK  _---_---_-
   
    bst   _ACCA,7  ; MSBit in T Flag
    bld  _ACCB, UNIC.a_DATA  ; T Flag in Register speichern
    out  UNIC.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  UNIC.ConFPGABitPort, UNIC.a_CCLK  ; CCLK high
    bst   _ACCA,6
    bld  _ACCB, UNIC.a_DATA  ; T Flag in Register speichern
    out  UNIC.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  UNIC.ConFPGABitPort, UNIC.a_CCLK  ; CCLK high
    bst   _ACCA,5
    bld  _ACCB, UNIC.a_DATA  ; T Flag in Register speichern
    out  UNIC.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  UNIC.ConFPGABitPort, UNIC.a_CCLK  ; CCLK high
    bst   _ACCA,4
    bld  _ACCB, UNIC.a_DATA  ; T Flag in Register speichern
    out  UNIC.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  UNIC.ConFPGABitPort, UNIC.a_CCLK  ; CCLK high
    bst   _ACCA,3
    bld  _ACCB, UNIC.a_DATA  ; T Flag in Register speichern
    out  UNIC.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  UNIC.ConFPGABitPort, UNIC.a_CCLK  ; CCLK high
    bst   _ACCA,2
    bld  _ACCB, UNIC.a_DATA  ; T Flag in Register speichern
    out  UNIC.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  UNIC.ConFPGABitPort, UNIC.a_CCLK  ; CCLK high
    bst   _ACCA,1
    bld  _ACCB, UNIC.a_DATA  ; T Flag in Register speichern
    out  UNIC.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  UNIC.ConFPGABitPort, UNIC.a_CCLK  ; CCLK high
    bst   _ACCA,0
    bld  _ACCB, UNIC.a_DATA  ; T Flag in Register speichern
    out  UNIC.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  UNIC.ConFPGABitPort, UNIC.a_CCLK  ; CCLK high

    cbi  UNIC.ConFPGABitPort, UNIC.a_CCLK  ; CCLK wieder low
    inc   _ACCCLO
    brne  UNIC.shiftFPGAbyte  ; wenn 0 => 256 Durchlufe
  endasm;
end;

{###########################################################################}

//FPGA-Funktionen

function ReceiveFPGA(myreg:byte): LongInt;
begin
  lo(FPGAreg):=myreg;     // Schreib-Register
  hi(FPGAreg):=$00;       // ohne Write Enable
  SendFPGAreg;
  SendFPGA32;
  return(FPGAreceiveLong);
end;

procedure SendByteToFPGA(myparam: byte; myreg:byte);
// schreib unskalierten Wert "myparam" nach SPI "myreg"
begin
  lo(FPGAreg):=myreg;     // Schreib-Register
  hi(FPGAreg):=$80;       // mit Write Enable
  SendFPGAreg;
  FPGAsendByte:= myparam;
  SendFPGA8;
end;

procedure SendWordToFPGA(myparam: word; myreg:byte);
// schreib unskalierten Wert "myparam" nach SPI "myreg"
begin
  lo(FPGAreg):=myreg;     // Schreib-Register
  hi(FPGAreg):=$80;       // mit Write Enable
  SendFPGAreg;
  FPGAsendWord := myparam;
  SendFPGA16;
end;

procedure SendLongToFPGA(myparam: LongInt; myreg:byte);
// schreib unskalierten Wert "myparam" nach SPI "myreg"
begin
  lo(FPGAreg):=myreg;     // Schreib-Register
  hi(FPGAreg):=$80;       // mit Write Enable
  SendFPGAreg;
  FPGAsendLong:= myparam;
  SendFPGA32;
end;

