{###########################################################################}
{FPGA functions }

procedure SendFPGA8;
//Sende und empfange ein Daten-Byte an den FPGA-Chip ber SPI
begin
  asm;
    lds  _ACCA, FPGA.FPGAsendByte
    cbi  FPGA.FPGAport, FPGA.b_DATASEL
    out SPDR, _ACCA    ; SPI wurde von FAT16-Treiber eingeschaltet!
  SPIwait8_1:
    in _ACCA, SPSR
    sbrs _ACCA,7
    rjmp SPIwait8_1
    in _ACCA, SPDR
    sts  FPGA.FPGAreceiveByte, _ACCA  ;Lesewert zurck ins Datenbyte
    sbi  FPGA.FPGAport, FPGA.b_DATASEL
  endasm;
end;

procedure SendFPGA16;
//Sende und empfange ein Daten-Wort (16 Bit-Register) an den FPGA-Chip ber SPI
begin
  asm;
    lds  _ACCA, FPGA.FPGAsendWord+1
    cbi  FPGA.FPGAport, FPGA.b_DATASEL
    out SPDR, _ACCA    ; SPI wurde von FAT16-Treiber eingeschaltet!
  SPIwait16_3:
    in _ACCA, SPSR
    sbrs _ACCA,7
    rjmp SPIwait16_3
    in _ACCA, SPDR
    sts  FPGA.FPGAreceiveWord+1, _ACCA

    lds  _ACCA, FPGA.FPGAsendWord+0
    out SPDR, _ACCA
  SPIwait16_4:
    in _ACCA, SPSR
    sbrs _ACCA,7
    rjmp SPIwait16_4
    in _ACCA, SPDR
    sts  FPGA.FPGAreceiveWord+0, _ACCA

    sbi  FPGA.FPGAport, FPGA.b_DATASEL
  endasm;
end;

procedure SendFPGA32;
//Sende und empfange ein Daten-Langwort (32 Bit-Register) an den FPGA-Chip ber SPI
begin
  asm;
    lds  _ACCA, FPGA.FPGAsendLong+3
    cbi  FPGA.FPGAport, FPGA.b_DATASEL
    out SPDR, _ACCA    ; SPI wurde von FAT16-Treiber eingeschaltet!
  SPIwait32_1:
    in _ACCA, SPSR
    sbrs _ACCA,7       ; SPIF gesetzt?
    rjmp SPIwait32_1   ; auf Ende des SPI-Transfer warten
    in _ACCA, SPDR     ; und empfangenes Byte wieder in FPGAsendLong ablegen
    sts  FPGA.FPGAreceiveLong+3, _ACCA

    lds  _ACCA, FPGA.FPGAsendLong+2
    out SPDR, _ACCA     ; SPI von FAT16-Treiber eingeschaltet!
  SPIwait32_2:
    in _ACCA, SPSR
    sbrs _ACCA,7
    rjmp SPIwait32_2
    in _ACCA, SPDR
    sts  FPGA.FPGAreceiveLong+2, _ACCA

    lds  _ACCA, FPGA.FPGAsendLong+1
    out SPDR, _ACCA
  SPIwait32_3:
    in _ACCA, SPSR
    sbrs _ACCA,7
    rjmp SPIwait32_3
    in _ACCA, SPDR
    sts  FPGA.FPGAreceiveLong+1, _ACCA

    lds  _ACCA, FPGA.FPGAsendLong+0
    out SPDR, _ACCA
  SPIwait32_4:
    in _ACCA, SPSR
    sbrs _ACCA,7
    rjmp SPIwait32_4
    in _ACCA, SPDR
    sts  FPGA.FPGAreceiveLong+0, _ACCA

    sbi  FPGA.FPGAport, FPGA.b_DATASEL
  endasm;
end;

{
procedure SendFPGA8block;  //Sende einen Block an FPGA ber SPi
begin
  asm;
    LDI       _ACCCLO, FPGA.BlockTable AND 0FFh  ;Z-Register
    LDI       _ACCCHI, FPGA.BlockTable SHRB 8

    FPGA.sendFPGA8byte:
   ; Z-Pointer auf Array-Eintrag
    ld   _ACCA, Z
    cbi  FPGA.FPGAport, FPGA.b_DATASEL
    out SPDR, _ACCA    ; SPI wurde von FAT16-Treiber eingeschaltet!
  SPIwait8_2:
    in _ACCA, SPSR
    sbrs _ACCA,7
    rjmp SPIwait8_2
    sbi  FPGA.FPGAport, FPGA.b_DATASEL
    nop ; fr QVGA-Screen 1 us Verzgerung, damit Byte geschrieben werden kann
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    nop
    inc   _ACCCLO
    sbi   FPGA.FPGAport, FPGA.b_Aux
    nop
    cbi   FPGA.FPGAport, FPGA.b_Aux
    brne  FPGA.sendFPGA8byte  ; wenn 0 => 256 Durchlufe
  endasm;
end;
}

procedure SendFPGAreg;
//Sende ein Byte (Registeradresse) an den FPGA-Chip
begin
  asm;
    lds  _ACCA, FPGA.FPGAreg
    cbi  FPGA.FPGAport, FPGA.b_REGSEL
    out SPDR, _ACCA     ; SPI von FAT16-Treiber eingeschaltet!
  SPIwaitReg:
    in _ACCA, SPSR
    sbrs _ACCA,7 ; SPIF?
    rjmp SPIwaitReg     ;  auf Ende des SPI-Transfer warten
    sbi  FPGA.FPGAport, FPGA.b_REGSEL
  endasm;
end;

procedure ShiftFPGAconf;  //Sende ein Byte an FPGA-Configuration
begin
  asm;
    lds  _ACCA, FPGA.FPGAbyte
    ldi  _ACCB, 8
    FPGA.confloop1:    ; hherwertiges Byte rausschieben
    cbi  FPGA.ConFPGABitPort, FPGA.c_DATA
    sbrc _ACCA,7 // Bit high?
    sbi  FPGA.ConFPGABitPort, FPGA.c_DATA
    sbi  FPGA.ConFPGABitPort, FPGA.c_CCLK
    LSL  _ACCA
    cbi  FPGA.ConFPGABitPort, FPGA.c_CCLK
    dec _ACCB
    brne  FPGA.confloop1
  endasm;
end;


procedure ShiftFPGAconfblock;  //Sende einen Block an FPGA-Configuration
begin
  asm;
    LDI       _ACCCLO, FPGA.BlockTable AND 0FFh  ;Z-Register
    LDI       _ACCCHI, FPGA.BlockTable SHRB 8

    FPGA.shiftFPGAbyte:
   ; Z-Pointer auf Array-Eintrag
    ld   _ACCA, Z
    cbi  FPGA.ConFPGABitPort, FPGA.c_CCLK
    in   _ACCB, FPGA.ConFPGABitPort
   ; schleifenloses, auf Schnelligkeit optimiertes Ausschieben eines Bytes
   ; DATA  __--__--__
   ; CCLK  _---_---_-
   
    bst   _ACCA,7  ; MSBit in T Flag
    bld  _ACCB, FPGA.c_DATA  ; T Flag in Register speichern
    out  FPGA.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  FPGA.ConFPGABitPort, FPGA.c_CCLK  ; CCLK high
    bst   _ACCA,6
    bld  _ACCB, FPGA.c_DATA  ; T Flag in Register speichern
    out  FPGA.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  FPGA.ConFPGABitPort, FPGA.c_CCLK  ; CCLK high
    bst   _ACCA,5
    bld  _ACCB, FPGA.c_DATA  ; T Flag in Register speichern
    out  FPGA.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  FPGA.ConFPGABitPort, FPGA.c_CCLK  ; CCLK high
    bst   _ACCA,4
    bld  _ACCB, FPGA.c_DATA  ; T Flag in Register speichern
    out  FPGA.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  FPGA.ConFPGABitPort, FPGA.c_CCLK  ; CCLK high
    bst   _ACCA,3
    bld  _ACCB, FPGA.c_DATA  ; T Flag in Register speichern
    out  FPGA.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  FPGA.ConFPGABitPort, FPGA.c_CCLK  ; CCLK high
    bst   _ACCA,2
    bld  _ACCB, FPGA.c_DATA  ; T Flag in Register speichern
    out  FPGA.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  FPGA.ConFPGABitPort, FPGA.c_CCLK  ; CCLK high
    bst   _ACCA,1
    bld  _ACCB, FPGA.c_DATA  ; T Flag in Register speichern
    out  FPGA.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  FPGA.ConFPGABitPort, FPGA.c_CCLK  ; CCLK high
    bst   _ACCA,0
    bld  _ACCB, FPGA.c_DATA  ; T Flag in Register speichern
    out  FPGA.ConFPGABitPort, _ACCB ; mit CCLK auf low
    sbi  FPGA.ConFPGABitPort, FPGA.c_CCLK  ; CCLK high

    cbi  FPGA.ConFPGABitPort, FPGA.c_CCLK  ; CCLK wieder low
    inc   _ACCCLO
    brne  FPGA.shiftFPGAbyte  ; wenn 0 => 256 Durchlufe
  endasm;
end;

{###########################################################################}

//FPGA-Funktionen

procedure ExchangeFPGA(myreg:byte);
// Kompketter Datenaustauch von vier 32-Bit-Registern ber SPI
begin
    FPGAreg:=myreg;     // Schreib-Register
    SendFPGAreg;
    FPGAsendLong:=ParamLongArray[myreg]; // ans FPGA
    SendFPGA32;
    InputLongArray[myreg]:=FPGAreceiveLong; // kommt ohnehin gleichzeitig an
end;


procedure ExchangeFPGA4;
// Kompletter Datenaustauch von vier 32-Bit-Registern ber SPI
begin
  for i:=0 to 3 do
    ExchangeFPGA(i);
  endfor;
end;

procedure RTCtickSecond;      // CallBack from RTCclock
begin
  tickSeconds:=true;
  if INITfileIsOpen then
    LEDactivity:= not LEDactivity;
  endif;
end;

procedure RTCtickMinute;      // CallBack from RTCclock
begin
  tickMinutes:=true;
end;

procedure RTCtickHour;        // CallBack from RTCclock
begin
  tickHours:=true;
end;

procedure GetRTC;
begin
  disableints;
  Hour:=RTCgethour;
  Minute:=RTCgetminute;
  Second:=RTCgetsecond;
  Day:=RTCgetday;
  Month:=RTCgetmonth;
  Year:=RTCgetyear;
  enableints;
end;

procedure SetRTC;
begin
  disableints;
  RTCsethour(Hour);
  RTCsetminute(Minute);
  RTCsetsecond(Second);
  RTCsetday(Day);
  RTCsetmonth(Month);
  RTCsetyear(Year);
  enableints;
{$IFDEF EXTRTC}
  SetExtRTC;
{$ENDIF}
end;

procedure DateTimeToDOS;
{ DOS time format bits:
DOStime: 15..11=Hours (0-23), 10..5=Minutes (0-59), 4..0=Seconds/2 (0-29)
DOSdate: 15..9=Year (0=1980, 127=2107), 8..5=Month (1=January, 12=December),
4..0=Day (1-31) }
begin
  GetRTC;
  DOStime:=(word(Hour) shl 11) or (word(Minute) shl 5) or (word(Second) shr 1);
  DOSdate:=(word(Year+20) shl 9) or (word(Month) shl 5) or (word(Day));
end;

procedure TimeToParamStr;
begin
  ParamStr:=byteToStr(Hour:2:'0')+':'+byteToStr(Minute:2:'0')+':'+byteToStr(Second:2:'0');
end;

procedure DateToParamStr;
begin
  ParamStr:=byteToStr(Day:2:'0')+'.'+byteToStr(Month:2:'0')+'.'+byteToStr(Year:2:'0');
end;

